{ +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ }
{                                                                           }
{    Procedure : GETCMDLN                 Copyright 1984  by  Jim Boardman  }
{    File      : GETCMDLN.INC             PUBLIC DOMAIN SOFTWARE - may not  }
{    Language  : Turbo PASCAL             be used for profit.   All copies  }
{    Author    : Jim Boardman             must contain this notice. Please  }
{    Date      : 22 Sept 84                        and thanks...            }
{    Version   : 1.00                                                       }
{                                                                           }
{ +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ }
{                                                                           }
{ GETCMDLN parses user typed program invocation line arguments.   File name }
{ and default filename extensions, option switch  variables  and acceptable }
{ switch values are passed as arguments to this routine.                    }
{                                                                           }
{ File name variables are filled sequentially with filenames and extensions }
{ entered by the user on the program invocation line. Specified default ex- }
{ tensions are added if they were not present.  Option switch variables are }
{ set to TRUE if the specified switch values were typed by the user and set }
{ to FALSE otherwise.                                                       }
{                                                                           }
{ +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ }

{ USAGE EXAMPLE:                                                            }

  PROGRAM TEST( input, output );

  TYPE STRING4  = string[  4 ];                { *** NOTE REQUIRED TYPE *** }
       STRING14 = string[ 14 ];                { ***    DEFINITIONS     *** }

  VAR  FIRST_FILE, SECND_FILE : STRING14;
       SWITCH_ONE, SWITCH_TWO : boolean;

{ BEGIN                                                                     }
{ GETCMDLN( FIRST_FILE, 'PAS', SECND_FILE, 'COM',                           }
{           SWITCH_ONE, 'XYZ', SWITCH_TWO, 'BCD' );                         }
{ END.                                                                      }
{                          *************                                    }
{                                                                           }
{ With the above example, invoking TEST by typing:                          }
{                                                                           }
{                       TEST ABC/XYZ                                        }
{                                                                           }
{ would result in FIRST_FILE containing  the  string  'ABC.PAS', SECND_FILE }
{ containing a null string, SWITCH_ONE = TRUE and SWITCH_TWO = FALSE.  With }
{                                                                           }
{                       TEST DEFGHIJK.-BCD,README.DOC                       }
{                                                                           }
{ FIRST_FILE would contain the  string 'DEFGHIJK.', SECND_FILE  would  con- }
{ tain 'README.DOC', SWITCH_ONE = FALSE and SWITCH_TWO = TRUE.              }
{                                                                           }
{ Option switches are detected by parsing either a '/' or '-' .             }
{                                                                           }
{ +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ }


{ +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ }
{                                       }
{ Library procedure  GETCMDLN - Heading }
{                                       }
{ +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ }

PROCEDURE GETCMDLN( var fil1 : STRING14; def_ext1 : STRING4;
                    var fil2 : STRING14; def_ext2 : STRING4;
                    var swt1 : boolean;  swt_val1 : STRING4;
                    var swt2 : boolean;  swt_val2 : STRING4 );
CONST
  max_cmd_len = 80; { Max characters that will be parsed in a cmnd  }

VAR
  cmd_end_ch : set of char;
  cmd_lin    : array [1..80] of char absolute DSEG:$81; { CP/M - 86 }
{ cmd_lin    : array [1..80] of char absolute      $81; { CP/M - 80 }
  cur_chr    : char;         { The curent cmnd line char   }
  cmd_ptr    : integer;      { Pointer to command line     }
  end_lin    : boolean;      { Set TRUE at end of cmd line }
  ext_beg    : boolean;      { Set TRUE if extension seen  }
  fname      : STRING14;     { Accumulating file-name      }
  nam_end_ch : set of char;  { Chrs which end a file name  }
  nam_ptr    : integer;      { Points at file name vars    }
  nam_beg    : boolean;      { TRUE if parsing a file name }
  nam_beg_ch : set of char;  { Chrs which start file names }
  swt_nam    : STRING4;      { Accumulating switch name    }
  swt_mid_ch : set of char;  { Chrs allowed in a switch    }
  swt_ptr    : integer;
  swt_beg    : boolean;      { TRUE if parsing a switch    }
  swt_beg_ch : set of char;  { Chrs which start a switch   }

{ +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ }
{                                       }
{  Routine sub-procedure GETCMDLN_CHR   }
{                                       }
{ +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ }

  PROCEDURE getcmdln_chr;           { Gets characters from command line }
  BEGIN
  cmd_ptr := cmd_ptr + 1;
  IF cmd_ptr <= max_cmd_len             { Accepts up to  80  characters }
    THEN BEGIN                          { on a program invocation line. }
         cur_chr := cmd_lin[ cmd_ptr ]; { Get next character from cmnd. }
         IF cur_chr IN cmd_end_ch
           THEN BEGIN                   { Indicate end when nonprinting }
                end_lin := true;        { character seen (usually ^M).  }
                cur_chr := '`';
                END
         END
    ELSE BEGIN
         end_lin := true;               { Mark end if more than 80 chrs }
         cur_chr := '`';
         END;

  END; { procedure GET_CHAR }


{ +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ }
{                                       }
{   Library procedure  GETCMDLN - Body  }
{                                       }
{ +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ }

BEGIN               { Initialize character sets     }

cmd_end_ch := [ chr( $00 )..chr( $17 ) ]; { chrs that end a command line }
swt_beg_ch := [ '/', '-'               ]; { chrs that start a switch     }
swt_mid_ch := [ 'A'..'Z'               ]; { chrs that may be in a switch }
nam_beg_ch := [ 'A'..'Z', '0'..'9'     ]; { chrs that start names        }
nam_end_ch := [ ' ', '`', ',', '=' ] + swt_beg_ch; { chrs that end names }

swt1 := false;      { Initialize variable arguments }
swt2 := false;
fil1 := '';
fil2 := '';
cmd_ptr := 0;
end_lin := false;
nam_ptr := 0;       { names are ordered             }
REPEAT              { REPEAT for all cmnd line chrs }
  nam_beg := false;
  swt_beg := false;
  fname   := '';
  swt_nam := '';
  getcmdln_chr;
  IF cur_chr IN nam_beg_ch
    THEN BEGIN
         nam_beg := true;
         ext_beg := false;
         END

    ELSE IF cur_chr IN swt_beg_ch THEN swt_beg := true;

  WHILE nam_beg DO BEGIN                 { Parse a file name }
    fname := fname + cur_chr;
    getcmdln_chr;
    IF ( cur_chr = '.' ) THEN ext_beg := true;
    IF cur_chr IN nam_end_ch
      THEN BEGIN
           nam_ptr := nam_ptr + 1;
           CASE nam_ptr OF
             1 : IF ext_beg
                   THEN fil1 := fname
                   ELSE fil1 := fname + '.' + def_ext1;

             2 : IF ext_beg
                   THEN fil2 := fname
                   ELSE fil2 := fname + '.' + def_ext2;

             END; { CASE nam_ptr OF }

           nam_beg := false;
           IF cur_chr IN swt_beg_ch THEN swt_beg := true
           END { IF cur_chr IN nam_end_ch }

    END; { WHILE nam_beg DO BEGIN }

  WHILE swt_beg DO BEGIN                 { Parse a switch }
    getcmdln_chr;
    IF cur_chr IN swt_mid_ch
      THEN swt_nam := swt_nam + cur_chr
      ELSE BEGIN
           swt_ptr := 0;        { switches are un-ordered }
           REPEAT
             swt_ptr := swt_ptr + 1;
             CASE swt_ptr OF
               1 : IF swt_nam = swt_val1 THEN swt1 := true;
               2 : IF swt_nam = swt_val2 THEN swt2 := true;
               ELSE swt_ptr := 0;
               END; { CASE SWT_PTR OF }

             UNTIL ( swt_ptr = 0 );

           swt_nam := '';
           IF not( cur_chr IN swt_beg_ch ) THEN swt_beg := false;
           END { IF cur_chr IN swt_mid_ch THEN ... ELSE }

    END; { WHILE swt_beg DO BEGIN }

  UNTIL end_lin;
END; { PROCEDURE GETCMDLN }


{ Program to test GETCMDLN - Main }

BEGIN

GETCMDLN( FIRST_FILE, 'PAS', SECND_FILE, 'COM',
          SWITCH_ONE, 'HEX', SWITCH_TWO, 'LIST' );

IF length( FIRST_FILE ) > 0 THEN writeln( 'First  file: ', FIRST_FILE );
IF length( SECND_FILE ) > 0 THEN writeln( 'Second file: ', SECND_FILE );
IF SWITCH_ONE THEN writeln( 'Switch HEX TRUE' )
              ELSE writeln( 'Switch HEX FALSE' );
IF SWITCH_TWO THEN writeln( 'Switch LIST TRUE' )
              ELSE writeln( 'Switch LIST FALSE' );
END.
 