Program Test_PagedArray;
Uses PgRA_LRU,Crt;

Const
  TestSize = 5000;

Var
  Test : LRUPagedArray;
  Dupe : LRUPagedArray;
  R,S  : Real;
  I,J  : LongInt;

Begin
  ClrScr;
  WriteLn ('LEAST RECENTLY USED REPLACEMENT DEMO');
  WriteLn ('(PMAN_LRU) -- 5,000 Real Numbers.');
  WriteLn ('Memory Available before Initialization = ',MemAvail);

  Test.Init (TestSize,SizeOf(Real),MemAvail Div 2,'test.dat');
  WriteLn ('Memory Available after Initialization = ',MemAvail);

(*
  Test.Load ('test.dat',SizeOf(Real),0);
  WriteLn ('Memory Available after Loading = ',MemAvail);
*)
  {Use this block when testing INIT}

  For I := 0 to TestSize - 1 do
    Begin
      R := I;
      Test.Accept (R,I,SizeOf(Real));
      GoToXY (1,10);
      Write ('Loading Element # ',I:10)
    End;

  GoToXY (1,6);
  Write ('Copying PArray1 to PArray2. Please Wait...');
  Dupe.Init (1,SizeOf(Real),0,'dupe.dat');  {MUST initialize FIRST!}
  Dupe.Copy (Test);

  GoToXY (1,7);
  Write ('Memory Available after Copy operation = ',MemAvail);
  GoToXY (1,8);
  Write ('1000 Random Comparisons between both.');

  Randomize;
  For I := 0 to 999 do
    Begin
      J := Trunc (Random * Dupe.MaxSize);
      Dupe.Retrieve (S,J,SizeOf(Real));
      Test.Retrieve (R,J,SizeOf(Real));
      If (S = R) and (R = J) Then
        Begin
          GoToXY (1,14);
          Write ('Reading Value ',R:10:4);
          Write (' at Index = ',J:10)
        End
      Else
        Begin
          WriteLn;
          Write ('DATA ERROR DETECTED AT INDEX = ',J);
          Exit
        End
    End;

  GoToXY (1,25);
  Write ('Press Return to Exit. ');
  ReadLn;

  Test.Store;
  Dupe.Store;
  ClrScr;
End.