Unit PHeaps;
{$R-,S-,O+}

{ Demonstrates the definition of a Buffered Generic Heap instantiated }
{ to 6 byte real numbers.                                             }

INTERFACE
Uses PGenHeap,SrtFuncs;

{ All Heaps additionally inherit the following Methods:

  (* BufferedArray Methods *)
                             Procedure Create;
                             Procedure Store;

                             Procedure Destroy;

                             Function MaxSize;
                             Function ElemSize;

  (* PGenericHeap Methods *)
                             Procedure Swap (I,J : LongInt);
                             Procedure SiftDown (I,J : LongInt);
                             Procedure BuidHeap;
                             Procedure ChangeSort (NewSort : SortFunc);
                             Procedure Sort;
                             Procedure HeapSort;
}

Type
  RealHeap = Object (PGenericHeap)

                   { Re-Defining these methods re-introduces Types and }
                   { most importantly, Type-Checking to the Generic    }
                   { (typeless) Heap, as well as making the calls more }
                   { "natural" for the actual applications Heaps.      }

                   { Follow this pattern when defining your descendant Heaps }

                   Procedure Init (MaxElements,MaxBuffSize : LongInt;
                                   FileName : String);

                   Procedure Load (FileName : String; MaxBuffSize : LongInt);

                   Procedure Accept (I : Real; Index : LongInt);

                   Function Retrieve (Index : LongInt) : Real;

                            { Retrieve will nead to be a procedure for
                              records or objects. }

                   Procedure SiftUp (I : Real; Index : LongInt);

                   Procedure Copy (From : RealHeap);
            End;

IMPLEMENTATION

Procedure RealHeap.Init;
Begin
  PGenericHeap.Init (MaxElements,SizeOf(Real),MaxBuffSize,FileName,SortReal)
End;

Procedure RealHeap.Load (FileName : String; MaxBuffSize : LongInt);
Begin
  PGenericHeap.Load (FileName,SizeOf(Real),MaxBuffSize)
End;

Procedure RealHeap.Accept;
Var
  J : Real;
Begin
  J := I;
  PGenericHeap.Accept (J,Index,SizeOf(Real))
End;

Function RealHeap.Retrieve;
Var
  J : Real;
Begin
  PGenericHeap.Retrieve (J,Index,SizeOf(Real));
  Retrieve := J
End;

Procedure RealHeap.SiftUp;
Var
  J : Real;
Begin
  J := I;
  PGenericHeap.SiftUp (J,Index,SizeOf(Real))
End;

Procedure RealHeap.Copy (From : RealHeap);
Begin
  PGenericHeap.Copy (From)
End;

BEGIN
END.