Unit SrtFuncs; {Introduces some sample SortFuncs for use with GenHeaps
                of the MaxArray variety.}

INTERFACE
Uses FlexPntr;

Type
  SortFunc = Function (Var El1,El2) : Boolean;

             { SortFuncs *MUST* be defined so that they return the }
             { truth value of the statement El1 > El2 }

Var
  SortReal,SortInteger {SortRecord} : SortFunc;

IMPLEMENTATION
{$F+}

Function SortR (Var El1,El2) : Boolean;
Var
  T1 : Real Absolute El1;
  T2 : Real Absolute El2;
Begin
  SortR := T1 > T2
End;

Function SortI (Var El1,El2) : Boolean;
Var
  T1 : Integer Absolute El1;
  T2 : Integer Absolute El2;
Begin
  SortI := T1 > T2
End;

{
Function SortRec (Var El1,El2) : Boolean;
Var
  T1 : RecordType Absolute El1;
  T2 : RecordType Absolute El2;
Begin
  SortRec := T1.DesiredField > T2.DesiredField
End;
}

{$F-}
BEGIN
  SortReal := SortR;
  SortInteger := SortI;

  {SortRecord := SortRec}

END.