Unit ColorBtn;

{ 3 August 94 }

{ This unit demonstates how to create an owner draw button. To use this unit
  in your program, you must:

     1. Add DrawButton to your list of includes.
     2. Create an owner draw button in your program.
     3. Initialize a DrawButton button in your init method. }

interface

uses Objects,
     OWindows,
     ODialogs,
     WinTypes,
     WinProcs,
     strings,
     windos;

type aButtonType = (recessed,normal);

type pColorButton = ^tColorButton;
     TColorButton = object(TButton)
     border    : AButtonType;
     r         : trect;
     Name      : string;
     background: tcolorref;
     function    GetClassName: PChar; virtual;
     procedure   WMPaint (var Msg: TMessage); virtual wm_First + wm_Paint;
     procedure   Draw;
     constructor InitResource(AParent: PWindowsObject; ResourceID:Word);
     destructor  Done; virtual;
     procedure   setup(s: pchar; color: tcolorref; buttonType: AButtonType);
     procedure   settext(s: pchar);
     end;


implementation

destructor tColorButton.Done;
begin
TControl.Done;
end;


constructor tColorButton.InitResource(AParent: PWindowsObject; ResourceID:Word);
begin
tbutton.InitResource(AParent, ResourceID);
end;

procedure tColorButton.setup(s: pchar; color: tcolorref;buttonType: AButtonType);
begin
border:= buttonType;
name:= strpas(s);
background:= color;
getclientrect(hwindow,r);
draw;
end;

procedure tColorButton.setText(s: pchar);
begin
name:= strpas(s);
draw;
end;

function tColorButton.GetClassName: PChar;
begin
getclassname:= 'COLORBUTTON';
end;

procedure tColorButton.Draw;
var oldbitmap,
    copybitmap: hbitmap;
    dc,
    memdc      : hdc;
    oldpen     : hpen;
    oldbrush   : hbrush;
    backgroundbrush : hbrush;
    s: array[0..255] of char;
    OldFont,mosaicfont:Hfont;
    mosaicFontRec: TLogFont;

begin
{ set up tools for drawing }
dc       := getdc(hwindow);
MemDC    := CreateCompatibleDC(DC);
oldpen   := selectobject(memdc,getstockobject(Black_pen));
backgroundbrush  := createsolidbrush(background);
oldbrush := selectobject(memdc,backgroundbrush);
{ set up metrics for drawing }
CopyBitmap := CreateCompatibleBitmap(DC, r.right, r.bottom);
oldbitmap:= selectobject(memdc,copybitmap);
(***************)
{ prepare fonts }
(***************)
FillChar(mosaicFontRec, SizeOf(mosaicFontRec), 0);
with mosaicFontRec do
  begin
  lfHeight := -9 { Points } * GetDeviceCaps(memDC, LogPixelsY) div 72;  ;
  StrpCopy(lfFaceName,'Arial');
  lfWeight := fw_Bold;
  end;
mosaicFont:= CreateFontIndirect(mosaicFontRec);
oldfont:= SelectObject(memdc, mosaicfont);

{ do the drawing }
if border = normal then selectobject(memdc,getStockObject(black_pen))
else selectobject(memdc,getStockObject(null_pen));
with r do rectangle(memdc,left,top,right,bottom);
if border = normal then with r do
  begin
  {
  selectobject(memdc,getstockobject(black_pen));
  moveto(memdc,left  + 1, bottom -2);
  lineto(memdc,right - 2, bottom -2);
  lineto(memdc,right - 2, top  + 1);
  }
  moveto(memdc,right - 2, top  + 1);
  selectobject(memdc,getstockobject(white_pen));
  lineto(memdc,left  + 1, top  + 1);
  lineto(memdc,left  + 1, bottom -2);
  end;
strpcopy(s,name);
setbkmode(memdc,transparent);
drawtext(memdc,s,strlen(s),r,dt_center or dt_vcenter or dt_singleline);
BitBlt(DC, 0, 0, r.right, r.bottom, memDC, 0, 0, srcCopy);
{ clean up }
selectobject(memdc,oldpen);
selectobject(memdc,oldbitmap);
selectobject(memdc,oldbrush);
selectobject(memdc,oldfont);
deleteobject(mosaicFont);
deleteobject(copybitmap);
deleteobject(backgroundbrush);
releasedc(hwindow,dc);
deletedc(memdc);
end;

procedure tColorButton.WMPaint(var Msg: TMessage);
begin
draw;
defchildproc(msg);
end;

begin
end.