program OWLFile;

{$R OWLFile.res}

uses WinTypes, WinProcs, OWindows, ODialogs, BWCC, Strings;

{$I OWLFile.inc}

const
  MaxBuff = 128;

type

  MLApplication = object(TApplication)
    procedure InitMainWindow; virtual;
  end;

  PMLWindow = ^MLWindow;
  MLWindow = object(TDlgWindow)
    Editor : PEdit;
    constructor Init(AParent: PWindowsObject; ATitle: PChar);
    procedure GetWindowClass(var AWndClass: TWndClass); virtual;
    procedure IDLoad(var MSG: TMessage);
      virtual id_First + id_Load;
    procedure IDSave(var MSG: TMessage);
      virtual id_First + id_Save;
  end;

constructor MLWindow.Init(AParent: PWindowsObject; ATitle: PChar);
  var
    AControl : PControl;
  begin
    TDlgWindow.Init(AParent, ATitle);
    AControl := New(PEdit, InitResource(@Self, id_Editbox, MaxBuff));
    SendDlgItemMessage(HWindow, id_Editbox, em_LimitText, MaxBuff, 0);
  end;

procedure MLWindow.GetWindowClass(var AWndClass: TWndClass);
begin
  TDlgWindow.GetWindowClass(AWndClass);
  AWndClass.lpszClassName := 'bordlg';
end;

procedure MLWindow.IDLoad(var MSG: TMessage);
  var
    FBuff : TOFStruct;
    PStrngBuff : PChar;
    Hand : integer;
  begin
    GetMem(PStrngBuff, MaxBuff);
    Hand := OpenFile('TEXT.TXT', FBuff, of_Prompt OR of_Read);
    _lread(Hand, PStrngBuff, MaxBuff);
    SendDlgItemMessage(HWindow, id_Editbox, wm_SetText, 0,
                       Longint(PStrngBuff));
    _lclose(Hand);
    FreeMem(PStrngBuff, MaxBuff);
  end;

procedure MLWindow.IDSave(var MSG: TMessage);
  var
    FBuff : TOFStruct;
    PStrngBuff : PChar;
    Hand : integer;
  begin
    GetMem(PStrngBuff, MaxBuff);
    Hand := OpenFile('TEXT.TXT', FBuff, of_Create OR of_Write);
    SendDlgItemMessage(HWindow, id_Editbox, wm_GetText, MaxBuff,
                       Longint(PStrngBuff));
    _lwrite(Hand, PStrngBuff, StrLen(PStrngBuff));
    _lclose(Hand);
    FreeMem(PStrngBuff, MaxBuff);
  end;

procedure MLApplication.InitMainWindow;
  begin
    MainWindow := New(PMLWindow, Init(nil, PChar(id_Dialog)))
  end;

var
  MLApp : MLApplication;

begin
  MLApp.Init('MLDlg');
  MLApp.Run;
  MLApp.Done;
end.
