{ Writtem by Marc Perkel * From Directory Master III

This is a piece of one of my programs that demonstrates how to move
the overlay buffer to high memory. This allows it to be released so that
when you EXEC a program, you have the maximum space available for dos.

This code example is public domian}


Unit DM33;

{DM3 Init Code}

Interface

Procedure ExecDos3 (var Cmd,Tail : String);

Implementation

uses
   Overlay,
   Dos;

Var OvrName : String[80];

Procedure SetBlock (var Paragraphs : Word);
  {-Change size of DOS memory block allocated to this program}
var
  Regs : Registers;
begin
  with Regs do begin
    AH := $4A;
    ES := PrefixSeg;
    BX := Paragraphs;
    MsDos(Regs);
    Paragraphs := BX;
  end;
end;

Procedure OpenOvr;
{This moves all the variables to put the overlay buffer on top end of ram}
begin
   {Allocates 4800 paragraphs at end of ram}
   OvrClearBuf;
   OvrHeapOrg := PrefixSeg + MemW[pred(PrefixSeg):3] - 4800;
   OvrHeapPtr := OvrHeapOrg;
   OvrHeapEnd := OvrHeapOrg + 4800;
   HeapEnd := Ptr(OvrHeapOrg,0);
   OvrSetRetry(20000);
end;

Procedure ExecDos3 (var PathName, CommandTail : string);
  var
    ParasToKeep,
    ParasWeHave : Word;
  begin

    OvrClearBuf;

    {Current DOS memory allocation read from memory control block}
    ParasWeHave := MemW[Pred(PrefixSeg):3];

    ParasToKeep := succ(seg(HeapPtr^) - PreFixSeg);

    {Deallocate memory for DOS}
    SetBlock(ParasToKeep);

    SwapVectors;
    Exec(PathName, CommandTail);
    SwapVectors;

    {Reallocate memory from DOS}
    SetBlock(ParasWeHave);
    OpenOvr;
  end;

begin
   {Move the heap down where the overlay buffer was}
   HeapOrg := Ptr(OvrHeapOrg,0);
   HeapPtr := HeapOrg;
   FreeList := HeapPtr;
   OpenOvr;
   OvrFileMode := $A0;      {Read Sharable for Networks}
   OvrName := ParamStr(0);
   dec(OvrName[0],3);
   OvrName := FExpand(OvrName + 'OVR');
   OvrInit(OvrName);
end.

