{$F+,O+}
program LockDemo;

{  This program demonstrates the use of the OverLock unit.
   To run the demo, compile to disk to create the EXE and
   OVR files and then execute LOCKDEMO.  Redirecting the
   output to a disk file is recommended since the output
   will scroll off the top of the screen.  }

uses
  Overlay, Demo1, Demo2, Demo3, Demo4, OverLock;

{$O Demo1}
{$O Demo2}
{$O Demo3}
{$O Demo4}

var
  I,OvrLockResult : Integer;
  SaveReadBuf : OvrReadFunc;

function MyOvrRead (OvrSeg : Word) : Integer;
{ Display name of overlaid unit loaded }
var
  E : Integer;
begin
  E := SaveReadBuf (OvrSeg);
  MyOvrRead := E;
  if OvrSeg = Seg(Write1) then
    Writeln ('Demo1 loaded')
  else if OvrSeg = Seg(Write2) then
    Writeln ('Demo2 loaded')
  else if OvrSeg = Seg(Write3) then
    Writeln ('Demo3 loaded')
  else if OvrSeg = Seg(Write4) then
    Writeln ('Demo4 loaded')
  else
    Writeln ('??? loaded');
end;

procedure OvrLockCheck;
{ Call OvrLock and check result }
begin
  OvrLockResult := OvrLock;
  if OvrLockResult <> 0 then begin
    Writeln ('OvrLock failed: ', OvrLockResult);
    Halt(1);
  end;
end;

procedure OvrUnlockCheck;
{ Call OvrUnlock and check result }
begin
  OvrLockResult := OvrUnlock;
  if OvrLockResult <> 0 then begin
    Writeln ('OvrUnlock failed: ', OvrLockResult);
    Halt(1);
  end;
end;

begin
  OvrInit('LOCKDEMO.OVR');       { Initialize overlay system }
  if OvrResult <> 0 then
  begin
    Writeln('Overlay error: ', OvrResult);
    Halt(1);
  end;
  OvrSetBuf(OvrGetBuf*3);        { Set buffer to appropriate size for testing }
  SaveReadBuf := OvrReadBuf;     { Set up to monitor overlay manager actions }
  OvrReadBuf := MyOvrRead;

  Write1;                        { Load Demo1 }
  OvrLockCheck;                  { Lock it in }
  Writeln ('-- Demo1 locked in --');

  for I := 1 to 2 do begin       { Exercise overlay manager }
    Write1;
    Write2;
    Write3;
    Write4;
  end;

  OvrUnlockCheck;                { Remove lock }

  Write2;                        { Load Demo2 on top of Demo1 }
  OvrLockCheck;                  { Lock 'em up }
  Writeln ('-- Demo1 and Demo2 both locked in --');

  for I := 1 to 2 do begin       { Exercise overlay manager }
    Write1;
    Write2;
    Write3;
    Write4;
  end;

  OvrUnlockCheck;                { Remove lock }
  Writeln ('-- No locks --');

  for I := 1 to 2 do begin       { Freedom for all }
    Write1;
    Write2;
    Write3;
    Write4;
  end;
end.
