unit overinit;
INTERFACE

var
  ovrminbuf: longint;

procedure rob_overlay(var mem_size: word);

IMPLEMENTATION

uses overlay;

procedure rob_overlay(var mem_size: word);

type
  freerec = record
    orgptr,endptr: pointer;
  end;
  freelist = array[0..8190] of freerec;
  freelistp = ^freelist;

begin
  {check to make sure minimum overlay buffer is maintained}
  if ovrgetbuf - mem_size < ovrminbuf then
    mem_size := ovrgetbuf - ovrminbuf;

  {round to even page size}
  mem_size := mem_size - (mem_size mod 16);

  {check to make sure a heap free list entry is available}
  if ofs(freeptr^) = 8 then
    mem_size := 0;

  if mem_size > 0 then
  begin
    {clear the overlay buffer}
    ovrclearbuf;

    {move the free list down one entry}
    if ofs(freeptr) = 0 then
      freeptr := ptr(seg(freeptr^),8191 * 8)
    else
      freeptr := ptr(seg(freeptr^),ofs(freeptr^)-8);

    {assign memory from overlay buffer to heap's free list}
    with freelistp(freeptr)^[0] do
    begin
      endptr := heaporg;

      {reset the boundary between overlay buffer and heap}
      ovrheapend := ovrheapend - (mem_size div 16);
      heaporg := ptr(seg(heaporg^)-(mem_size div 16),ofs(heaporg^));

      orgptr := heaporg;
    end;
  end;
end;


begin
  {Sample overlay initialization.  Replace with your own.}
  ovrinit('uts89.ovr');
  if ovrresult <> ovrok then
  begin
    if ovrresult = ovrnotfound then
      writeln('Could not find overlay file.')
    else
      writeln('Error reading overlay file.');
    halt
  end;
  {Initialize swap buffer in EMS.}
  ovrinitems;
  case ovrresult of
    ovrioerror:
      writeln('Overlay file I/O error.  Cannot use expanded memory.');
    ovrnoemsdriver:
      writeln('EMS driver not installed.  Cannot use expanded memory.');
    ovrnoemsmemory:
      writeln('No expanded memory or not enough expanded memory to use.');
    ovrok:
      writeln('Using expanded memory.')
    else
      writeln('Could not use expanded memory.')
  end;
  {Set minimum overlay buffer size depending on whether EMS is available.}
  if ovrresult <> ovrok then
    ovrminbuf := ovrgetbuf + $e000
  else
    ovrminbuf := ovrgetbuf + $8000;
  {Expand overlay buffer to maximum size.}
  ovrsetbuf(ovrgetbuf + $20000);
  ovrsetretry(ovrgetbuf div 3);
end.