{ ========================================================================= }
{ OutFilt v1.0, Robert Rothenburg Walking-Owl 1994 (in the Public Domain)   }
{ ========================================================================= }
{ This unit is provided as is with no guarantees or warrantees of any kind. }


unit OutFilt;

interface

var
  DuplicateFile:   file;                          { file to "tee" output to }
  DuplicateHandle: Word absolute DuplicateFile;   { file handle(?)          }
    { Note: at least for Turbo Pascal 7.0, the file's "handle" is the first }
    {       word in the file.                                               }

const
  PauseBetweenScreens: Boolean = False;  { if true, pause between screens   }
  CopyOutputToFile:    Boolean = False;  { if true, tee output to Duplicate }

procedure fWrite(Str: String);           { Write string                     }
procedure fWriteLn(Str: String);         { WriteLn string                   }

procedure fPrint(Handle: Word; Str: String);
                                         { Write string to handle...        }

implementation


const
  StdOut = 01;                           { Handle for standard output (CON) }
  StdErr = 02;                           { Handle for error messages        }


procedure WritePause(Str: String); far;  { The actual routine               }
 external;
 {$L OutFilt.Obj }

procedure fWrite(Str: String);           { Redundant...?                    }
begin
  WritePause(Str)
end;

procedure fWriteLn(Str: String);         { Writes with CR and LF           }
begin
  WritePause(Str+#13+#10)
end;

procedure fPrint(Handle: Word; Str: String); assembler;
{ Writes string to handle (no error-checking!) }
asm
        push    ds
        mov     ah,  40h
        mov     bx,  handle
        lds     si,  str
        mov     dx,  si
        inc     dx
        mov     cl,  ds: [ si ]
        xor     ch,  ch
        int     21h
        pop     ds
end;


end.
