UNIT O110User; { Opus 1.10+ user file/lastuser structures in Turbo Pascal }

INTERFACE

Uses Dos; { For DateTime Structure }

 (*  #define STRFRE(str) (sizeof(str)-strlen(str)-1)  Space left in string *)


(*-------------------------------------------------------------------------*)
(* Access privilege level definitions                                      *)
(*-------------------------------------------------------------------------*)
(*                                                                         *)
(* These 'privileges' represent the amount of access or usage rights given *)
(* to a user and are compared against the minimum privilege associated     *)
(* with System Areas, Menu Commands, Session Limits and OEC text commands. *)
(*                                                                         *)
(* Each privilege level has a traditional name associated with it and a    *)
(* numeric value that is actually used for comparisons.  Any reference to  *)
(* a given level should be made with the some form of the traditional name *)
(* as Opus uses them in its documentation, logging, and srceen prompts.    *)
(*                                                                         *)
(* Although the sequence of numeric values may imply that interim values   *)
(* are possible, that is not the case: Only the values shown will work.    *)
(*                                                                         *)
(* NOTES:                                                                  *)
(*                                                                         *)
(* - The privilege levels are shown in their ascending order of access.    *)
(* - TWIT is the lowest level and gives a user the minimum access.         *)
(* - SYSOP is the highest level and gives a user the greatest powers!      *)
(* - Privileges are stored and treated as unsigned, 1-byte objects.        *)
(* - The last, descriptive field is suggestive only.  Use is up to Sysop!  *)
(* - HIDDEN has a special meaning and should never be assigned to a user   *)
(*   or Sysop.  It is reserved to completely HIDE or disable features!     *)
(*                                                                         *)
(*-------------------------------------------------------------------------*)

CONST

     TOTPRIVS  = 12;

     TWIT      = 16; {0x10} (* Twit .......... Minimum access. Eg, Problems *)
     DISGRACE  = 48; {0x30} (* Disgraced ..... Eg, 1st time callers         *)
     LIMITED   = 64; {0x40} (* Limited ....... Eg, 1st time callers         *)
     NORMAL    = 80; {0x50} (* Normal ........ Eg, Regular callers          *)
     WORTHY    = 96; {0x60} (* Worthy ........ Eg, Approved callers         *)
     PRIVEL    = 112; {0x70} (* Privileged .... Eg, Full access callers      *)
     FAVORED   = 128; {0x80} (* Favored ....... Eg, Friends or Helpers       *)
     EXTRA     = 144; {0x90} (* Extra ......... Eg, Friends or Helpers       *)
     CLERK     = 160; {0xA0} (* Clerk ......... Eg, Occasioanal helper       *)
     ASSTSYSOP = 176; {0xB0} (* Assistant Sysop High access. Eg, Co-Sysops   *)
     SYSOP     = 208; {0xD0} (* Sysop ......... HIGHEST ACCESS. #1 Sysop     *)

     HIDDEN    = 224; {0xE0} (* Hidden ........ HIDES THINGS ) NOT FOR USERS *)

   (* The following special privilege value is only used in the default    *)
   (* logon privilege field of the PRM file to indicate that access to the *)
   (* system is for preregistered users only.  That is, users must already *)
   (* be in the user file before they are admitted.  It is not a normal    *)
   (* privilege and is not valid in any other case.                        *)

     NO_PRIV   = 255; {0xFF} (* PreRegistered   Signals private systems.     *)


(**)
(*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*)
(*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*)
(*%                                                                       %*)
(*%                     U S E R   D A T A B A S E                         %*)
(*%                                                                       %*)
(*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*)
(*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*)
(*                                                                         *)
(* The user data base consists of two files: a data file )USER.DAT) and a  *)
(* matching index file (USER.IDX).  The data file is a direct access file  *)
(* with fixed length, 1 kb records, one for each user.  The index contains *)
(* one computed, 4-byte CRC value for each user name.                      *)
(*                                                                         *)
(* Access to the user database can be done sequentially on the main data   *)
(* file or by keyed access by computing the special CRC value of the       *)
(* desired user name, looking up that value in the index file, and then    *)
(* by seeking the positionally correspondent record in the main file.      *)
(*                                                                         *)
(* WARNING:                                                                *)
(*                                                                         *)
(* Any changes made to user names or the number, or order, of user records *)
(* will put the index into an unsynchronized state that may result in      *)
(* undefined and potentially dangerous problems unless the index is        *)
(* updated or rebuilt by the utility.  One way of doing this is to run     *)
(* the oIndex program after such changes to properly rebuild the index.    *)
(*                                                                         *)
(* WARNING:                                                                *)
(*                                                                         *)
(* Any changes to a user record made by an external utility that is        *)
(* operating independently in another partition or work-station while      *)
(* that user is online will be overwritten when Opus updates the user      *)
(* record with its own working copy of it.                                 *)
(*                                                                         *)
(*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*)
(*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*)


   MAXLREAD = 256;  (* Number of msg area pointers to maintain      *)

Type
   Usr = Record
      Name      : array[1..36] of char; (* Caller's first and last names                *)
      City      : array[1..36] of char; (* Caller's location                            *)
      Pwd       : array[1..16] of char; (* Password                                     *)
      Usrtel    : array[1..16] of char; (* User Tel# for ref or future callback         *)
      Alias     : array[1..32] of char; (* User alias if ID is not it                   *)
      Times     : word;         (* Number of previous calls to this system      *)
      ClassPriv : byte;         (* User Access Privilege                        *)
      Help      : byte;         (* Help level (see below)                       *)
      Tabs      : byte;         (* 0=transmit <sp> instead of <tab>             *)
      Language  : byte;         (* Lang set no. (1-6) as defined in .PRM file.  *)
      Nulls     : word;         (* Number of Nulls (delays) after <cr>          *)
      Msg       : word;         (* Last message area accessed                   *)
      Bits      : word;         (* User option flags (See Below)                *)

      (* Each of the 32 bits within the following 4-byte (long) item       *)
      (* represents a single user 'key'.   To have access to any Opus      *)
      (* function that has any of 32 'lock' bits set for it, there has to  *)
      (* be at least the matching key bits set in this item.  Having other *)
      (* key bits sit does not matter.                                     *)
      (*                                                                   *)
      (* For maintenance and discussion, key and lock bits are referred to *)
      (* by the characters A-Z and 0-5 where 'A' is bit 0 (least           *)
      (* significant) and '5' refers to bit 31 (most significant).         *)

      ClassLock : longint;  (* 32 User 'Keys'                               *)
                            (* Each bit of this long object corresponds to  *)
                            (* each of 32 possible user 'keys' which are    *)
                            (* referred to by the character (A-Z,0-5) where *)
                            (* the least significant) bit is called 'A' and *)
                            (* the most significant nit is called '5'.      *)

      LuDate    : longint;  (* Date of user's Last Call to system expressed *)
                            (* as seconds since 01-Jan-70 in GMT(UTC time.  *)

      Time      : integer;  (* Time on-line so-far today                    *)

      flag      : word;     (* User file management flags (see below)       *)

      Upld      : longint;  (* Total kilobytes uploaded to date.            *)
      Dnld      : longint;  (* Total kilobytes downloaded to date.          *)
      Dnldl     : integer;  (* Total kilobytes downloaded last(current call *)
      Files     : word;     (* Last file area accessed                      *)
      Width     : byte;     (* Width of the caller's monitor                *)
      Len       : byte;     (* Height of the caller's                       *)
      Credit    : word;     (* FidoNet usage credit in cents                *)
      Debit     : word;     (* FidoNet usage in cents                       *)

      Spcoec: array[1..8] of char; (* Special OECC to show after logon             *)
                                   (* Good for clubs, stores, user groups          *)
                                   (* Eg, "Welcome to the dBase User Group"        *)

      Saccnt: array[1..5] of char; (* Array of 5 counters which correspond to the  *)
                                   (* files SPANN#.BBS which reside on the path    *)
                                   (* given by 'spcldir' in the .PRM file. If any  *)
                                   (* is > 0 than the user is shown the matching   *)
                                   (* announcement and is decremented.  When 0, it *)
                                   (* is no longer displayed.                      *)

      ExFlag: byte;        (* Expiration behavior flags (see below)        *)

      XDate : longint;     (* Expiry date always rounded to (0000 hrs) and *)
                           (* as secs since 01-Jan-70 in *LOCAL* time for  *)
                           (* reasons of cross-zone accounting equivelnce. *)

      CrMin : longint;     (* Total minutes given to user                  *)
      DbMin : longint;     (* Total minutes used  by user                  *)

      ULikes : array[1..32] of char;   (* Reserved for future feature            *)
      FUdate : longint;                (* First Call Date(secs since 01-Jan-70   UTC(GMT)*)

      Reserved: array[1..16] of byte;  (* Filler, reserved.     *)

      (* The following item contains for each of the 256 possible areas,   *)
      (* the last message number that the user read in that area.  A value *)
      (* of zero means the area was not accessed by the user yet.          *)

      LastMsg: array[1..MAXLREAD] of word;


      OPIS_Id: longint;       (* Opus Record ID ... Must always be 'OPUS'  *)


      (* The next 7 sets of 'id' and 'inf' data are for external utilities *)
      (* that have been registered with OpusInfo to use for the storage    *)
      (* and independent maintenance of auxiliary information.  The first  *)
      (* (long) array of 7 items holds the registered ID's of utilities    *)
      (* that make use of the 7 matching 32-byte data blocks that follow.  *)
      (*                                                                   *)
      (* Any utility may make use of any of the 7 data blocks providing    *)
      (* they ensure that the desired blocks are not already used as would *)
      (* be indicated by an ID in the matching ID positions.  If free,     *)
      (* then the utility claims them by writing its registered ID in the  *)
      (* matching ID positions.  It is up to the utility to ensure that    *)
      (* enough positions are free in all of the user records that would   *)
      (* potentially be accessed by it.                                    *)
      (*                                                                   *)
      (* Currently registered ID's ........................................*)
      (*                                                                   *)
      (* 0x57555646 .. FVIEW ... File viewing utility by Doug Boone        *)
      (* 0x4F4D414E .. OMAN  ... Opus system manager by Tom Kashuba        *)


      Extern_Id: array[1..7] of longint;      (* LONG ID number for external programs      *)
                                              (* Must be registered with OpusInfo          *)

      Extern_inf: array[1..7, 1..32] of byte; (* 7 32-byte external util data blocks       *)

   end;


(*-------------------------------------------------------------------------*)
(* 'Bits' -- User Option Flag Meanings                                     *)
(*-------------------------------------------------------------------------*)

  CONST

      NO_IBMCHAR  = 4;   {0x0004} (* Cannot receive IBM textmode graphics     *)
      USE_LORE    = 8;   {0x0008} (* Wants LORE editor instead of OPed        *)
      MORE_PROMPT = 16;  {0x0010} (* Wants the page break "MORE?" question    *)
      ANSI        = 32;  {0x0020} (* Can handle ANSI video                    *)
      CONFIG_SET  = 64;  {0x0040} (* OPUS logon questions answered            *)
      FORMFEED    = 128; {0x0080} (* SET=xmit clearscreen, CLEAR=eat formfeed *)
      AVATAR      = 256; {0x0100} (* Can handle AVATAR (aka "oANSI") video    *)

      USE_PHONE   = 1024; {0x0400} (* User Modem Tel# to Call Back    (future) *)
      USE_ALIAS   = 2048; {0x0800} (* Use ALIAS in var user functions (future) *)

      NO_NAME     = 4096;  {0x1000} (* Don't List User's Name in User List      *)
      NO_TIME     = 8192;  {0x2000} (* Don't List User's Last-On in User List   *)
      NO_CITY     = 16384; {0x4000} (* Don't List User's City in User List      *)

      { Not sure if this one is correct.. C version was like this: }
               { #define CURSOR_CONTROL (ANSI#AVATAR) }
  VAR
      CURSOR_CONTROL : WORD;  (* ANSI or AVATAR *)



(*-------------------------------------------------------------------------*)
(* 'flag' -- User file management flags                                    *)
(*                                                                         *)
(* These flags are used by the user file manager within oMan to control    *)
(* the reuse and deletion of user records.  External utilities may use     *)
(* then as long as they folow the conventions established by oMan.         *)
(*                                                                         *)
(*-------------------------------------------------------------------------*)

CONST
     REUSE    =  1; {0x0001}  (* Re-use rec for next new caller         *)
     PURGE    =  2; {0x0002}  (* Remove record in next OMAN Pack        *)
                              (* All other bits currently reserved      *)

(* The following value is used as a mask to cover all of the 8 separate    *)
(* bit values in range 0x0100-0x8000.  They each represent a 'group tag'   *)
(* as implemented in the Opus user manager, oMan, and are referred to by   *)
(* the letters 'A' (0x0100) through 'H' (0x8000).  Group tags are benign   *)
(* markers that are for the covenience of user record maintenance and are  *)
(* used by the user manager only.                                          *)

     GRPTAGS  =  65280; {0xFF00}


(*-------------------------------------------------------------------------*)
(* 'help' -- User help levels (menu style)                                 *)
(*-------------------------------------------------------------------------*)

     TOTMDL   =     4;     (* Total menu detail levels               *)

     HITECH   =  1; {0x00}  (* 1-line, top-of-screen, bar-style menus *)
     EXPERT   =  2; {0x02}  (* No text at all, just a prompt          *)
     REGULAR  =  4; {0x04}  (* Lists menu option letters only.        *)
     NOVICE   =  6; {0x06}  (* Full menu command titles listed.       *)

 (*   USING_FTB  = 0xFF    ( Old mode.  Not supported in 1.10. )     *)


(*-------------------------------------------------------------------------*)
(*  'exflag' -- Flags dealing with user expiration control                 *)
(*-------------------------------------------------------------------------*)
(* These definitions are the bit values of the 'exflag' flags item which   *)
(* determine the type and handling of user expiration.  The values of      *)
(* ExpByDate and ExpByDate set the type of expiration, if any.  The values *)
(* of ExpDemote and ExpAxe determine how to handle expired users.          *)
(*-------------------------------------------------------------------------*)

     EXPBYDATE =  1; {0x01}  (* Expire user by date.  That is, consider    *)
                             (* them as expired when they log on AFTER the *)
                             (* date stored in 'xdate'.                    *)

     EXPBYMINS =  2; {0x02}  (* Expire user by minutes of usage.  That is, *)
                             (* consider them as expired when the minutes  *)
                             (* they have used thus far (crmin) exceeds    *)
                             (* the minutes they were alotted (dbmin).     *)

     EXPDEMOTE =  16; {0x10} (* If user is expired, reduce their privilege *)
                             (* to TWIT or, if set, to the demote value    *)
                             (* set in the PRM file.                       *)

     EXPAXE    =  32; {0x20} (* If user is expired, disconnect them.       *)


(**)
(*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*)
(*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*)
(*%                                                                       %*)
(*%                  L A S T   U S E R   R E C O R D                      %*)
(*%                                                                       %*)
(*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*)
(*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*)
(*%                                                                       %*)
(*%  The "LASTUSER" record is a single record file that is written to     %*)
(*%  disk after a user logs off and just prior to every time that Opus    %*)
(*%  does an external exit.  The file contains a copy of the user's       %*)
(*%  record (in its entirety) along with an extended data block that      %*)
(*%  contains additional environmental information that is useful to      %*)
(*%  external programs.                                                   %*)
(*%                                                                       %*)
(*%  A new option in the PRM file optionally allows the user record       %*)
(*%  portion of the file to read back into Opus, overlaying the live      %*)
(*%  copy in memory.  This is extremely powerful and DANGEROUS in that    %*)
(*%  the user's profile can be updated (or damaged) dynamically!          %*)
(*%                                                                       %*)
(*%  The last user file name is formatted as LASTUS##.DAT where '##'      %*)
(*%  is the task number (expressed as hexadecimal) of the running Opus.   %*)
(*%  The task number, being one of several arguments passed to the        %*)
(*%  program, allows it to properly compose the LASTUSER file name so it  %*)
(*%  can open and process it.  Once accessed, all of its data is          %*)
(*%  available for use by the program.                                    %*)
(*%                                                                       %*)
(*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*)
(*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*)

Type

 Lu_file = Record
      UserRec  : Usr;      (* Copy of user record                          *)
      Baud,                (* Current user's baud (0 == keyboard!)         *)
      Port,                (* Current port #                               *)
      Task,                (* Active task number                           *)
      Mins,                (* User's minutes remaining                     *)
      MsgArea,             (* Which message area user is in                *)
      FileArea : word;     (* Which file area user is in                   *)

      TimeOff  : longint;  (* Date(Time that caller's session must end by. *)
                           (* As secs since 01-Jan-70 UTC(GMT              *)

(*                    Not sure how to convert this one...                  *)
(*    struct tm tmoff;      MS-C 'tm' struct of above but as local time    *)

      TmOff  : DateTime;

      LastOn : array[1..25] of char; (* Orig Last Call Date as ASCIIZ string because *)
                                     (* same field in user rec is curr logon time    *)
 end;

 Long =  String[10];

Function PToString(privnum: integer): long;

IMPLEMENTATION

Function PToString(privnum: integer): long;
begin
   case privnum of
      TWIT      : PToString := 'TWIT';
      DISGRACE  : PToString := 'DISGRACE';
      LIMITED   : PToString := 'LIMITED';
      NORMAL    : PToString := 'NORMAL';
      WORTHY    : PToString := 'WORTHY';
      PRIVEL    : PToString := 'PRIVEL';
      FAVORED   : PToString := 'FAVORED';
      EXTRA     : PToString := 'EXTRA';
      CLERK     : PToString := 'CLERK';
      ASSTSYSOP : PToString := 'ASSTSYSOP';
      SYSOP     : PToString := 'SYSOP';
      HIDDEN    : PToString := 'HIDDEN';
   end;
end;

END.
