UNIT OOPXW;
                     (**************************************)
                     (*         OOPX  Version 1.00         *)
                     (* Object-Oriented Interface for the  *)
                     (*    Paradox Engine Version 2.0      *)
                     (*    and Turbo Pascal Version 6.0    *)
                     (*     Copyright 1991 Brian Corll     *)
                     (**************************************)
                     (*    Portions Copyright 1990-1991    *)
                     (*        Borland International       *)
                     (**************************************)
                     (* Ported to Turbo Pascal for Windows *)
                     (*         by Albert Howard           *)
                     (**************************************)


INTERFACE

Uses WinTypes, Strings, PXEngine;



const
     PXError : Integer = PXSUCCESS;
     VarLong  = 1;
     VarInt   = 2;
     VarDate  = 3;
     VarDoub  = 4;
     VarAlpha = 5;
     VarShort = 6;

type
   DateRec = record
      M,D,Y : Integer;
      end;

   pFieldArray = ^tFieldArray;
   tFieldArray = Array[1..256] of pChar;

   FieldHandleArray = Array [1..256] of FieldHandle;

type
   TXObject = ^PXObject;
   PXObject = object
      ErrCode : Integer;
      Password : Array[0..15] of Char;
      THandle : TableHandle;
      RHandle : RecordHandle;
      LHandles: Array[1..32] of LockHandle;
      SearchBuf : RecordHandle;
      LastLock: Byte;
      Name    : Array[0..79] of Char;
      RecNo   : RecordNumber;
      Locked  : Boolean;
      UnLocked: Boolean;
      Opened  : Boolean;
      Protected: Bool;
      IndexID : Integer;
      NFields : Integer;
      SaveEachChange: Boolean;
      FieldArray : tFieldArray;
      TypeArray  : tFieldArray;
      constructor Init(TblName : pChar;
                       IndexIDx : Integer;
                       NbrFields : Integer;
                       Var Fields; Var Types;
                       SaveEveryChange : Boolean);
      procedure CheckProtect;
      procedure PutPassword (PW : pChar);
      procedure DropPassword;
      procedure OpenTable;
      procedure CreateTable;
      destructor Done;
      procedure  ClearErrors;
      procedure  LockRecord;
      procedure  LockTable(LockType : Integer);
      procedure  UnLockRecord;
      procedure  UnLockTable(LockType : Integer);
      procedure  RenameTable(FromName,ToName : pChar);
      procedure  AddTable(AddTableName : pChar);
      procedure  CopyTable(CopyName : pChar);
      procedure  CreateIndex(NFlds : Integer;
                 FldHandles : FieldHandleArray;
                 Mode : Integer);
      procedure  CloseTable;
      procedure  Encrypt(Pw : pChar);
      procedure  Decrypt;
      procedure  DeleteIndex(IndexIDx : Integer);
      procedure  EmptyTable;
      procedure  EmptyRecord;
      procedure  ReadRecord;
      procedure  InsertRecord;
      procedure  AddRecord;
      procedure  UpdateRecord;
      procedure  DeleteRecord;
      procedure  NextRecord;
      procedure  PrevRecord;
      procedure  GotoRecord(R : RecordNumber);
      procedure  Flush;
      procedure  SearchField(FHandle : FieldHandle;Mode : Integer);
      procedure  SearchKey(NFlds : Integer;Mode : Integer);
      procedure  InitSearchBuf(FldName : pChar; var Variable;VarType : Byte);
      procedure  PutField(FldName : pChar;var Variable);
      procedure  PutLongField(FldName : pChar;var L : Longint);
      procedure  GetField(FldName : pChar;var Variable);
      procedure  GetLongField(FldName : pChar;var L : Longint);
      function   FieldNumber(FldName : pChar) : Integer;
      function   FieldName(FHandle : FieldHandle) : pChar;
      function   FieldType(FHandle : FieldHandle) : pChar;
      function   IsBlank(FldName : pChar) : Boolean;
      function   TableChanged : Boolean;
      procedure  Refresh;
      procedure  Top;
      procedure  Bottom;
      function   GetRecordNumber : Longint;
      end;


function PXOk : Boolean;

IMPLEMENTATION

   function GetAlphaSize(FType : pChar) : Integer;
     Var
       TSize : pChar;
       TInt  : Integer;
       Err   : Integer;

     Begin
       TSize := FType + 1;
       Val(TSize,TInt,Err);
       GetAlphaSize := TInt;
     End;

   function PXOk : Boolean;
   begin
      PXOk := (PXError = PXSUCCESS);
   end;

   constructor PXObject.Init(TblName : pChar;
                       IndexIDx : Integer;
                       NbrFields : Integer;
                       Var Fields; Var Types;
                       SaveEveryChange : Boolean);
   Var
     tPtr : pFieldArray;
     i : Integer;

   begin
      StrCopy(Name,TblName);
      THandle := 0;
      Protected := False;
      Opened := False;
      IndexID := IndexIDx;
      NFields := NbrFields;
      SaveEachChange := SaveEveryChange;
      tPtr := @Fields;
      For i := 1 to NFields Do
        FieldArray[i] := tPtr^[i];
      tPtr := @Types;
      For i := 1 to NFields Do
        TypeArray[i] := tPtr^[i];
      ErrCode := 0;
      FillChar(Password,SizeOf(Password),0);
      LastLock := 0;
      RecNo := 0;
      Locked := False;
      Unlocked := False;
   end;

   procedure PXObject.CheckProtect;
     Begin
       ErrCode := PXTblProtected(Name, Protected);
       PXError := ErrCode;
     End;

   procedure PXObject.PutPassword (PW : pChar);
     Begin
       FillChar(Password,SizeOf(Password),0);
       StrCopy(Password,PW);
       PXError := 0;
     End;

   Procedure PXObject.DropPassword;
     Begin
       ErrCode := PXPswDel(Password);
       PXError := ErrCode;
       FillChar(Password,SizeOf(Password),0);
     End;

   procedure PXObject.OpenTable;
   begin
      If Protected Then Begin
        ErrCode := PXPswAdd(Password);
        If ErrCode <> PXSuccess Then
          PXError := ErrCode;
          Exit;
          End;
      ErrCode := PXTblOpen(Name,
                          THandle,
                          IndexID,
                          SaveEachChange);
      If ErrCode = PXSUCCESS then begin
        ErrCode := PXRecBufOpen(THandle,RHandle);
        ErrCode := PXRecBufOpen(THandle,SearchBuf);
        Locked := False;
        UnLocked := False;
        Opened := True;
        LastLock := 0;
        FillChar(LHandles,32,0);
        End;
      If Protected Then
        ErrCode := PXPswDel(Password);
      PXError := ErrCode;
   end;

   procedure PXObject.CreateTable;
   begin
      ErrCode := PXTblCreate(Name,NFields,FieldArray,TypeArray);
      PXError := ErrCode;
   end;

   Procedure PXObject.CloseTable;
   begin
      ErrCode := PXTblClose(tHandle);
      Locked := False;
      Unlocked := False;
      Opened := False;
   End;

   procedure  PXObject.Encrypt(PW : pChar);
   begin
      PutPassword(PW);
      CloseTable;
      ErrCode := PXTblEncrypt(Name,Password);
      If ((ErrCode = PXERR_TABLEBUSY) and (Opened))
      or (ErrCode = PXERR_TABLEOPEN) then begin
         ErrCode := PXTblClose(THandle);
         If ErrCode = PXSUCCESS then
           ErrCode := PXTblEncrypt(Name,Password);
         end;
      If ErrCode = PXSuccess Then Begin
        Protected := True;
        OpenTable;
        End;
      PXError := ErrCode;
   end;

   procedure PXObject.ClearErrors;
   begin
      ErrCode := 0;
      PXError := 0;
   end;

   procedure  PXObject.Decrypt;
   begin
     ErrCode := PXPswAdd(Password);
     If ErrCode <> PXSuccess Then Begin
       PXError := ErrCode;
       Exit;
       End;
     ErrCode := PXTblDecrypt(Name);
     If ((ErrCode = PXERR_TABLEBUSY) and (Opened))
     or (ErrCode = PXERR_TABLEOPEN) then begin
         ErrCode := PXTblClose(THandle);
         If ErrCode = PXSUCCESS then
         ErrCode := PXTblDecrypt(Name);
         end;
     If ErrCode = PXSuccess Then Begin
        Protected := False;
        ErrCode := PXPswDel(Password);
        ErrCode := PXTblOpen(Name,
                          THandle,
                          IndexID,
                          SaveEachChange);
        End;
     PXError := ErrCode;
   end;

   procedure PXObject.CreateIndex(NFlds : Integer;
                FldHandles : FieldHandleArray;
                Mode : Integer);
   begin
      ErrCode := PXKeyAdd(Name,NFlds,FldHandles,Mode);
      PXError := ErrCode;
   end;

   procedure PXObject.DeleteIndex;
   begin
      ErrCode := PXKeyDrop(Name,IndexIDx);
      PXError := ErrCode;
   end;

   procedure PXObject.Flush;
   begin
      ErrCode := PXSave;
      PXError := ErrCode;
   end;

   procedure PXObject.LockRecord;
   var LockTest : Bool;
   begin
      Locked := False;
      Inc(LastLock);
      ErrCode := PXNetRecLock(THandle,LHandles[LastLock]);
      ErrCode := PXNetRecLocked(THandle,LockTest);
      Locked := (ErrCode = PXSUCCESS)
         and LockTest;
      If not Locked then Dec(LastLock);
      PXError := ErrCode;
   end;

   procedure PXObject.LockTable;
   begin
      Locked := False;
      ErrCode := PXNetTblLock(THandle,LockType);
      Locked := (ErrCode = PXSUCCESS);
      PXError := ErrCode;
   end;

   procedure  PXObject.UnLockRecord;
   begin
      UnLocked := False;
      ErrCode := PXNetRecUnlock(THandle,LHandles[LastLock]);
      If (ErrCode = PXSUCCESS) then
      begin
         UnLocked := True;
         LHandles[LastLock] := 0;
         Dec(LastLock);
      end;
   end;

   procedure  PXObject.UnLockTable(LockType : Integer);
   begin
      UnLocked := False;
      ErrCode := PXNetTblUnlock(THandle,LockType);
      PXError := ErrCode;
      UnLocked := (PXError = PXSUCCESS);
   end;

   procedure PXObject.RenameTable(FromName,ToName : pChar);
   begin
      ErrCode := PXTblRename(FromName,ToName);
      PXError := ErrCode;
   end;

   procedure PXObject.AddTable(AddTableName : pChar);
   begin
      ErrCode := PXTblAdd(AddTableName,Name);
      PXError := ErrCode;
   end;

   procedure PXObject.CopyTable(CopyName : pChar);
   begin
      ErrCode := PXTblCopy(Name,CopyName);
      PXError := ErrCode;
   end;

   procedure PXObject.EmptyTable;
   begin
      ErrCode := PXTblEmpty(Name);
      PXError := ErrCode;
   end;

   procedure PXObject.EmptyRecord;
   begin
      ErrCode := PXRecBufEmpty(RHandle);
      PXError := ErrCode;
   end;

   procedure PXObject.ReadRecord;
   begin
      ErrCode := PXRecGet(THandle,RHandle);
      PXError := ErrCode;
   end;

   procedure PXObject.InsertRecord;
   begin
      ErrCode := PXRecInsert(THandle,RHandle);
      PXError := ErrCode;
   end;

   procedure PXObject.AddRecord;
   begin
      ErrCode := PXRecAppend(THandle,RHandle);
      PXError := ErrCode;
   end;

   procedure PXObject.UpdateRecord;
   begin
      ErrCode := PXRecUpdate(THandle,RHandle);
      PXError := ErrCode;
   end;

   procedure PXObject.DeleteRecord;
   begin
      ErrCode := PXRecDelete(THandle);
      PXError := ErrCode;
   end;

   procedure PXObject.NextRecord;
   begin
      ErrCode := PXRecNext(THandle);
      PXError := ErrCode;
   end;

   procedure PXObject.PrevRecord;
   begin
      ErrCode := PXRecPrev(THandle);
      PXError:= ErrCode;
   end;

   procedure PXObject.GotoRecord(R : RecordNumber);
   begin
      ErrCode:= PXRecGoto(THandle,R);
      PXError := ErrCode;
   end;

   procedure PXObject.PutField(FldName : pChar;var Variable);
   var FType : pChar;
       FirstChar : Char;
       FHandle : FieldHandle;
   begin
      FHandle := FieldNumber(FldName);
      If (PXError <> PXSUCCESS) then Exit;
      ErrCode := PXFldType(THandle,FHandle,255,FType);
      FirstChar := FType[1];
      case FirstChar of
      'D' : ErrCode := PXPutDate(RHandle,FHandle,Date(Variable));
      'A' : ErrCode := PXPutAlpha(RHandle,FHandle,pChar(Variable));
      '$','N'
          : ErrCode := PXPutDoub(RHandle,FHandle,Double(Variable));
      'S' : ErrCode := PXPutShort(RHandle,FHandle,Integer(Variable));
      end;
      PXError := ErrCode;
   end;

   procedure PXObject.InitSearchBuf(FldName : pChar;var Variable;VarType : Byte);
   var FHandle : FieldHandle;
   begin
      FHandle := FieldNumber(FldName);
      If (PXError <> PXSUCCESS) then Exit;
      case VarType of
      VarDate  : ErrCode := PXPutDate(SearchBuf,FHandle,Date(Variable));
      VarAlpha : ErrCode := PXPutAlpha(SearchBuf,FHandle,pChar(Variable));
      VarDoub  : ErrCode := PXPutDoub(SearchBuf,FHandle,Double(Variable));
      VarShort : ErrCode := PXPutShort(SearchBuf,FHandle,Integer(Variable));
      VarLong  : ErrCode := PXPutLong(SearchBuf,FHandle,Longint(Variable));
      end;
      PXError := ErrCode;
   end;

   procedure PXObject.PutLongField(FldName : pChar;var L : Longint);
   var FHandle : FieldHandle;
   begin
      FHandle := FieldNumber(FldName);
      If (PXError <> PXSUCCESS) then Exit;
      ErrCode := PXPutLong(RHandle,FHandle,L);
      PXError := ErrCode;
   end;

   procedure PXObject.GetField(FldName : pChar;var Variable);
   var FType : Array[0..255] of char;
       FirstChar : Char;
       FHandle : FieldHandle;
   begin
      FHandle := FieldNumber(FldName);
      If (PXError <> PXSUCCESS) then Exit;
      ErrCode := PXFldType(THandle,FHandle,255,FType);
      FirstChar := FType[1];
      case FirstChar of
      'D' : ErrCode := PXGetDate(RHandle,FHandle,Date(Variable));
      'A' : ErrCode := PXGetAlpha(RHandle,FHandle,255,pChar(Variable));
      '$','N'
          : ErrCode := PXGetDoub(RHandle,FHandle,Double(Variable));
      'S' : ErrCode := PXGetShort(RHandle,FHandle,Integer(Variable));
      end;
      PXError := ErrCode;
   end;

   procedure  PXObject.GetLongField(FldName : pChar;var L : Longint);
   var FHandle : FieldHandle;
   begin
      FHandle := FieldNumber(FldName);
      If (PXError <> PXSUCCESS) then Exit;
      ErrCode := PXGetLong(RHandle,FHandle,L);
      PXError := ErrCode;
   end;

   function PXObject.GetRecordNumber : Longint;
   begin
      ErrCode := PXRecNum(THandle,RecNo);
      If (ErrCode = PXSUCCESS) then
         GetRecordNumber := RecNo;
      PXError := ErrCode;
   end;

   function PXObject.FieldNumber(FldName : pChar) : Integer;
   var FldHandle : FieldHandle;
   begin
      ErrCode := PXFldHandle(THandle,FldName,FldHandle);
      If (ErrCode = PXSUCCESS) then FieldNumber := FldHandle
      else FieldNumber := 0;
      PXError := ErrCode;
   end;

   function PXObject.IsBlank(FldName : pChar) : Boolean;
   var Blank : Bool;
       FHandle : FieldHandle;
   begin
      FHandle := FieldNumber(FldName);
      If (ErrCode <> PXSUCCESS) then PXErrMsg(PXError);
      IsBlank := False;
      ErrCode := PXFldBlank(RHandle,FHandle,Blank);
      If ErrCode = PXSUCCESS then IsBlank := Blank;
      PXError := ErrCode;
   end;

   function PXObject.TableChanged : Boolean;
   var Changed : Bool;
   begin
      TableChanged := False;
      ErrCode := PXNetTblChanged(THandle,Changed);
      If ErrCode = PXSUCCESS then
         TableChanged := Changed;
      PXError := ErrCode;
   end;

   procedure PXObject.Refresh;
   begin
      ErrCode := PXNetTblRefresh(THandle);
      PXError := ErrCode;
   end;

   function  PXObject.FieldName(FHandle : FieldHandle) : pChar;
   var FName : pChar;
   begin
      ErrCode := PXFldName(THandle,FHandle,255,FName);
      If ErrCode = PXSUCCESS then
         FieldName := FName
      else
         FIeldName := '';
      PXError := ErrCode;
   end;

   procedure PXObject.SearchField(FHandle : FieldHandle;Mode : Integer);
   begin
      ErrCode := PXSrchFld(THandle,SearchBuf,FHandle,Mode);
      PXError := ErrCode;
   end;

   procedure PXObject.SearchKey(NFlds : Integer;Mode : Integer);
   begin
      ErrCode := PXSrchKey(THandle,SearchBuf,NFlds,Mode);
      PXError := ErrCode;
   end;

   function  PXObject.FieldType(FHandle : FieldHandle) : pChar;
   var FType : pChar;
   begin
      FieldType := '';
      ErrCode := PXFldType(THandle,FHandle,255,FType);
      If ErrCode = PXSUCCESS then FieldType := FType;
      PXError := ErrCode;
   end;

   procedure PXObject.Top;
   begin
      ErrCode := PXRecFirst(THandle);
      PXError := ErrCode;
   end;

   procedure PXObject.Bottom;
   begin
      ErrCode := PXRecLast(THandle);
      PXError := ErrCode;
   end;


   destructor PXObject.Done;
   begin
      ErrCode := PXRecBufClose(RHandle);
      ErrCode := PXRecBufClose(SearchBuf);
      ErrCode := PXTblClose(THandle);
      PXError := ErrCode;
   end;

begin
end.
