
{                          Version 2.00                        87/09/19

                     OOF! (Object Oriented Fudge)

       Utilities for Object Oriented Programming in TURBO Pascal.


COPYRIGHT NOTICE:

  These utilities are COPYRIGHT (c) 1987 by Mike Babulic. They may be used
  as if they were in the public domain so long as the following conditions are
  met:
         1) This notice of copyright must be included in full unless the
            copyright owner's permission is obtained.

         2) Commercial publishers must obtain the copyright owner's permission
            before physically publishing this work. Anyone may publish this
            work in a non-physical form.
                - some examples of non-physical publication (allowed):
                    - Electronic Bulletin Boards, Compuserve
                - some examples of physical publication (prohibited):
                    - Books, Magazines, Floppy Disks
                - Computer clubs are NOT considered to be commercial publishers

AUTHOR:     Mike Babulic
            3827 Charleswood Drive N.W.
            Calgary, Alberta
            CANADA
            T2L 2C7

            Compuserve Id.:  72307,314
}
{----------------------------------------------------------------------------}

TYPE Class = Integer;

{----------------------------------------------------------------------------}

PROCEDURE Message(MethodTimes3:Integer);  EXTERNAL  'Message.bin';

PROCEDURE DoMethod(MethodOffset:Integer); EXTERNAL  'DoMethod.bin';

PROCEDURE DoParent(MethodOffset:Integer); EXTERNAL  'DoParent.bin';

{----------------------------------------------------------------------------}


TYPE TObject = record
       dispatcher: Class;
       end;


{MESSAGES}

    FUNCTION GetParent(var class):Integer;      BEGIN  Message(0)  END;


{METHODS}  PROCEDURE CObject(message,no:integer);  FORWARD;

    FUNCTION TObject_GetParent(var classFunction):Class;  FORWARD;

{IMPLEMENTATION}

    FUNCTION TObject_GetParent{var classFunction):Class};
      BEGIN
        TObject_GetParent := ofs(CObject);
      END;


{DISPATCHER}

    PROCEDURE CObject{message,no:integer};
      BEGIN
        IF message = ofs(GetParent) then DoMethod(ofs(TObject_GetParent));
      END;


{----------------------------------------------------------------------------}


PROCEDURE SetClass(var self; c:Class);
  VAR my : TObject  ABSOLUTE  self;
  BEGIN
    my.dispatcher := c;
  END;

FUNCTION GetClass(var self):Class;
  VAR my : TObject  ABSOLUTE  self;
  BEGIN
    GetClass := my.dispatcher;
  END;

FUNCTION Member(var anObject; c:Class):Boolean;
  {True if anObject is a descendant of c}
  VAR  me  : class;
  BEGIN
    me := GetClass(anObject);
    while (me<>c) and (me<>ofs(CObject)) do
      me := GetParent(me);
    Member := (me = c);
  END;