UNIT OMENU;
{ DEFINE FGI}                   {Define FGI if using the Fastgraph
                                 routines from Ted Gruber Software.
                                 Otherwise, use the Borland BGI }
{$A+     + Align Data on}
{$B-     - Boolean Eval short}
{$D+     + Debug info on}
{$E+     + 8087 Emulation on}
{$F+     + Force far calls on}
{$G+     + Generate 286 code}
{$I+     + IO checking on}
{$L+     + Local symbols on}
{$N-     - Numeric Processing off}
{$O-     - Overlays off}
{$R+     + Range checks on}
{$S+     + Stack checks on}
{$V-     - Relaxed String checks}
{$X+     + Extended Syntax on}

interface
const
    MaxItems              = 25;                 { max items on a menu }
    ParseDelimiter        : char    = '|';
    ShadowOn              = true;               { use shadow booleans }
    ShadowOff             = false;
    UserShadWt            : integer =  5;       { default shadow width }
    BorderOn              = true;               { use border booleans }
    BorderOff             = false;
    black                 : integer =  0;
    blue                  : integer =  1;
    green                 : integer =  2;
    cyan                  : integer =  3;
    red                   : integer =  4;
    magenta               : integer =  5;
    brown                 : integer =  6;
    gray                  : integer =  7;
    dgray                 : integer =  8;
    lblue                 : integer =  9;
    lgreen                : integer = 10;
    lcyan                 : integer = 11;
    lred                  : integer = 12;
    lmagenta              : integer = 13;
    yellow                : integer = 14;
    white                 : integer = 15;


{The following 8 procedures are not objects ! }
  procedure GraphInit;                { init graphics environment }
  procedure GraphDone;                { return to text mode }
  procedure GGotoxy(x,y:integer);     { gotoxy }
  procedure GWriteXy(x,y:integer;s:string;bg,fg:integer);
            {write at xy using text coordinates}
  procedure GWritePXy(x,y:integer;s:string;bg,fg:integer);
            {Write at xy using pixel coordinates (640x480}
  procedure GWriteXyClip(x,y:integer;s:string;Bg,Fg,clp:integer);
            {write at text-xy and truncate string to fit }
  procedure GClrScr(color:integer);
            { clear the screen in any color }

type
   TMenuParms = record                  { record to hold parms for }
     Menu,x1,y1,x2,y2,Nbg,NFg,HBg,HFg,  { each menu you set up }
          px1,px2,py1,py2,
       Border,shadow,NumItems,Highlight: integer;
     BordOn,ShadOn                     : boolean;
     AStr                              : string;
     end;

  Ohmenu = object
    onscreen                           : boolean;  {is menu now on screen?}
    MenuNumber                         : integer;
    MenuParms                          : TMenuParms;
    TArray : array[1..MaxItems] of string[105];    {up to 25 items}
    Buffer                             : pointer;  {ptr to hold image buffer}
    Buffersize                         : longint;  {size of image buffer}
    Result                             : integer;  {user keypress Result }
    Choice                             : integer;  {user menu choice }
    BuffW,BuffH                        : integer;  {buffersize}
    EraseOK                            : boolean;  {can erase menu?}
    ShadWt                             : integer;  {shadow width}

    constructor Init;
    destructor  Done;
    procedure   ParseText;                         { get the menu items }
    procedure   UseMenu(m:integer);    virtual;    { items delimited by '|' }
    procedure   ShowMenu;              virtual;    { called from UseMenu }
    procedure   EraseMenu;                         { erase, free buffer }
    procedure   MakeBuffer;                        { save screen on heap }
    function    GetChoice : integer;               { returns user choice }
    end;
  OVMenu =  object (OHMenu)
    constructor Init;
    procedure   UseMenu(m:integer);   virtual;
    procedure   ShowMenu;             virtual;
   end;


  OHVMenu = object
    HVResult    : longint;
    HResult     : shortint;
    VResult     : shortint;
    VertMenus   : shortint;
    MenuArray   : array[0..25] of TMenuparms;
    HMenu       : OHMenu;
    VMenu       : OVMenu;
    constructor Init;
    destructor  done;
    procedure   SetHorItems(
                x1,y1,x2,y2,Nbg,NFg,HBg,HFg,
                Border,shadow,NumItems,Highlight:integer;
                BordOn,ShadOn:boolean;
                AStr:string);
    procedure   PutHParms(num:integer);
    procedure   SetVerItems(
                menu,x1,y1,x2,y2,Nbg,NFg,HBg,HFg,
                Border,shadow,NumItems,Highlight:integer;
                BordOn,ShadOn:boolean;
                AStr:string);
    procedure   PutVParms(num:integer);
    function    GetHResult:shortint;               virtual;
    function    GetVResult:shortint;               virtual;
    function    GetHVResult:longint;               virtual;
    function    GetHChoice:shortint;               virtual;
    function    GetVChoice:shortint;               virtual;
    function    GetHVChoice:longint;               virtual;
    procedure   UseMenu;                           virtual;
    function    MenuResult(EraseH,EraseV:boolean):integer;
    end;

{****************************** implementation *************************}
implementation
{$IFDEF FGI}
uses fgmain, fgbitmap, fgmisc;
{$ELSE}
uses graph,crt;
{$ENDIF}
const
    Hidden = 1;                                 { vga hidden page (partial) }
    Active = 0;                                 { vga active visual page }
    MonoGraphicMode       = 17;                 { 640x480, mono   }
    ColorGraphicMode      = 18;                 { 640x480, color  }
    NoGoodGraphicMode     = 15;
    CurrentGraphicMode    : integer =   0;
    CellHt                : integer =  16;      { Cell height, VGA modes 17,18 }
    CellWt                : integer =   8;      { Cell width,  VGA modes 17,18 }
    UpArrow               = 72;
    DnArrow               = 80;
    LfArrow               = 75;
    RtArrow               = 77;
    Enter                 = 13;
    Escape                = 27;
    Backspace             = 08;
    Tab                   = 09;

    oldmode               : integer = 0;
    UsingColor            : boolean = false;
    GraphInitialized      : boolean = false;

  procedure J_SetColor(x:word);
  begin
    {$IFDEF FGI} fg_setcolor(x);
    {$ELSE}      setcolor(x);
                 SetFillStyle(solidfill,x);
    {$ENDIF}
    end;
  function  J_GetColor:integer;
  begin
    {$IFDEF FGI} J_GetColor:=fg_GetColor;
    {$ELSE} j_GetColor:=GetColor;
    {$ENDIF}
    end;
  procedure J_Box(x1,x2,y1,y2:integer);
  begin
    {$IFDEF FGI}
    fg_box(x1,x2,y1,y2);
    {$ELSE}
    rectangle(x1,y1,x2,y2);
    {$ENDIF}
    end;
  procedure J_Rect(x1,x2,y1,y2:integer);
  begin
    {$IFDEF FGI}
    fg_rect(x1,x2,y1,y2);
    {$ELSE}
    bar(x1,y1,x2,y2);
    {$ENDIF}
    end;
  procedure J_GetKey(var bt1,bt2:byte);
  begin
    {$IFDEF FGI}
    fg_getkey(bt1,bt2);
    {$ELSE}
    bt1:=0;
    bt2:=0;
    while not keypressed do;
    bt1:=byte(readkey);
    if bt1=0 then bt2:=byte(readkey);
    {$ENDIF}
    end;
  procedure J_move(xx,yy:integer);
  begin
    {$IFDEF FGI} fg_move(xx,yy);
    {$ELSE}      moveto(xx,yy);
    {$ENDIF}
    end;
  procedure J_DrawX(xx,yy:integer);
  begin
    {$IFDEF FGI} fg_drawx(xx,yy);
    {$ELSE}
    SetWriteMode(XORPut);
    LineTo(xx,yy);
    SetWriteMode(CopyPut);
    {$ENDIF}
    end;
    procedure j_locate(yy,xx:integer);
    begin
      {$IFDEF FGI}
      fg_locate(yy,xx);
      {$ELSE}
      gotoxy(xx+1,yy+1);
      {$ENDIF}
      end;

  function HighX:integer;
    begin
    {$IFDEF FGI}
    HighX:=fg_GetMaxx;
    {$ELSE}
    HighX:=GetMaxx;
    {$ENDIF}
    end;

  function HighY:integer;
    begin
    {$IFDEF FGI}
    HighY:=fg_GetMaxy;
    {$ELSE}
    HighY:=GetMaxy;
    {$ENDIF}
    end;

  constructor OHmenu.Init;
    var i:integer;
    begin
      GraphInit;
      with menuparms do begin
        x1:=0;   x2:=80;   y1:=0;   y2:=1;
        NBg      := white; NFg      := black;
        HBg      := black; HFg      := white;
        Border   := black; Shadow   := white;
        BordOn := true;  ShadOn := false;
        BufferSize:=0;
        NumItems :=0;
        Highlight:=0;
        EraseOK:=true;
        ShadWt:=UserShadWt;
        end;
      Result     :=0;      onscreen := false;
      for i := 1 to MaxItems do TArray[i]:='';
    end;
  constructor OVMenu.Init;
    begin
      inherited init;
      MenuParms.ShadOn:=true;
    end;

  destructor OHmenu.done;
    var x:integer;
    begin
      Erasemenu;
    end;

  procedure OHmenu.UseMenu(M:integer);
    var
      tx1,tx2,ty1,ty2 : integer;
      bg,fg,i,j,k,L,old : integer;
      b1,b2 : byte;
    label loop;
    begin
      if onscreen then EraseMenu;
      MenuNumber:=m;
      ParseText;
      showmenu;
      old:=j_GetColor;
      Loop:
        if MenuParms.Highlight<1 then
           MenuParms.Highlight:=MenuParms.NumItems;
        if MenuParms.Highlight>MenuParms.NumItems then
           MenuParms.Highlight:=1;
      for i := 1 to MenuParms.NumItems do
      begin
        if MenuParms.Highlight=i
          then begin bg:=MenuParms.HBg;fg:=MenuParms.HFg; end
          else begin bg:=MenuParms.NBg;fg:=MenuParms.NFg; end;

        k:=0;
        for j:= 1 to i do begin
          L:=length(tarray[j]);
          k:=k+L;
          end;
        tx1:=   (MenuParms.x1+k-length(tarray[i]))*CellWt;
        tx2:=   (MenuParms.x1+k)*CellWt;
        ty1:=   MenuParms.y1*CellHt+2;
        ty2:=   MenuParms.y2*CellHt-2;
        J_SetColor(Bg);
        J_Rect(tx1,tx2,ty1,ty2);
        GWriteXY(tx1 div CellWt,MenuParms.y1 div cellht, tarray[i],bg,fg);
        j_setcolor(Old);
        end;
      j_Getkey(b1,b2);
      if b2 = LfArrow then dec(MenuParms.highlight);
      if b2 = RtArrow then inc(MenuParms.highlight);
      if b2 in [Rtarrow,Lfarrow] then goto loop;
      Result:=0;
      Choice:=0;
      if b1 = Enter then begin
        Choice:=MenuParms.Highlight;
        Result:=Enter;
        end;
      if b2 = DnArrow then begin
        Result:=DnArrow;
        Choice:=MenuParms.Highlight;
        end;
      if b1 = Escape  then Result:=Escape;
    end;

procedure OVMenu.UseMenu(m:integer);
    var
      bg,fg,i,old : integer;
      b1,b2 : byte;
    label loop;
    begin
      if onscreen then EraseMenu;
      MenuNumber:=m;
      ParseText;
      showmenu;
      old:=j_getcolor;
      Loop:
        if MenuParms.Highlight<1 then MenuParms.Highlight:=MenuParms.NumItems;
        if MenuParms.Highlight>MenuParms.NumItems then MenuParms.Highlight:=1;
      for i := 1 to MenuParms.NumItems do
      begin
        if MenuParms.Highlight=i
          then begin bg:=MenuParms.HBg;fg:=MenuParms.HFg; end
          else begin bg:=MenuParms.NBg;fg:=MenuParms.NFg; end;

        j_SetColor(Bg);
        j_rect(MenuParms.px1,
               MenuParms.px2,
               i*CellHt  ,
               i*CellHt+CellHt-1);
        GWriteXYClip(MenuParms.x1,MenuParms.y1+i-1,tarray[i],bg,fg,MenuParms.x2-MenuParms.x1);
        j_setcolor(old);
        end;
        j_GetKey(b1,b2);
      if b2 = UpArrow then dec(MenuParms.highlight);
      if b2 = DnArrow then inc(MenuParms.highlight);
      if b2 in [Uparrow,Dnarrow] then goto loop;
      Result:=0;
      Choice:=0;
      if b1 = Enter then begin
        Result:=Enter;
        Choice:=MenuParms.Highlight;
        end;
      if b2 = LfArrow then Result:=LfArrow;
      if b2 = RtArrow then Result:=RtArrow;
      if b1 = Escape  then Result:=Escape;
    end;


  procedure OHmenu.ShowMenu;
    var
      old,i,x  : integer;
    begin
      MakeBuffer;
      old:=j_GetColor;
      With MenuParms do begin
        j_setcolor(NBg);
        j_rect(px1,px2,py1,py2);
        if BordOn then begin
          j_setcolor(Border);
          j_Box(px1,px2,py1,py2);
          end;

      {xor a shadow}
        if ShadOn then begin
          j_setcolor(Shadow);
          for i := 1 to ShadWt do begin
            if (px2+ShadWt) <=HighX then
            if (py2+ShadWt) <=HighY then
            begin
              j_move(px2+i,py1+i);
              j_drawx(px2+i, py2+i);
              j_move(px1+i, py2+i);
              j_drawx(px2+i-1,py2+i);
              end; {if px2+shad...}
            end; {for i}
          end; {if shadon }
        end; { with menuparms do }
      j_setcolor(old);
      onscreen:=true;
      end;

    procedure OHMenu.EraseMenu;
      var x:integer;
      begin
      if not onscreen then exit;
      {$IFDEF FGI}
      fg_putblock(Buffer,
        MenuParms.px1,
        MenuParms.px2+ShadWt,
        MenuParms.py1,
        MenuParms.py2+ShadWt);
      {$ELSE}
      putimage(MenuParms.px1,MenuParms.py1,buffer^,copyput);
      {$ENDIF}
      FreeMem(buffer,BufferSize);
      onscreen:=false;
      end; {proc}
  procedure GraphInit;
    var i, result, Trymode,
    BGIDriver, BGIMode : integer;
    begin
      if GraphInitialized then exit;
      CurrentGraphicMode:=0;
      {$IFDEF FGI}
      oldmode:=fg_getmode;
      for TryMode:=ColorGraphicMode downto NoGoodGraphicMode do
      begin
        Result:=Fg_Testmode(TryMode,1);
        if Result=1 then break;                         { 1 means success }
        end;
      CurrentGraphicMode:=TryMode;
      if CurrentGraphicMode=NoGoodGraphicMode then
      begin
        writeln;
        writeln('Could not initialize graphic mode ',ColorGraphicMode,' or ',
                 MonoGraphicMode,'.  A 640x480 VGA mode is required.');
        end;
      UsingColor:=(CurrentGraphicMode=ColorGraphicMode);
      Fg_Setmode(CurrentGraphicMode);
      fg_setpage(active);
      fg_sethpage(hidden);
      {$ELSE}
      BGIDriver:=Detect;
      InitGraph(BgiDriver,BgiMode,'');
      UsingColor:=true;
      directvideo:=false;
      {$ENDIF}
      if not UsingColor then
      begin
        dgray    :=  0;
        white    :=  1;
        blue     :=  0;
        green    :=  0;
        cyan     :=  0;
        red      :=  0;
        magenta  :=  0;
        brown    :=  0;
        gray     :=  0;
        lblue    :=  0;
        lgreen   :=  0;
        lcyan    :=  0;
        lred     :=  0;
        lmagenta :=  0;
        yellow   :=  1;
        end;
    GraphInitialized:=true;
    end; { proc }


  procedure GraphDone;
    begin
      {$IFDEF FGI}
      fg_setmode(oldmode);
      fg_reset;
      {$ELSE}
      Closegraph;
      RestoreCRTMode;
      {$ENDIF}
    end;

  procedure GGotoxy(x,y:integer);
    begin
      {$IFDEF FGI}
      fg_move(x*CellWt,y*CellHt+CellHt);
      {$ELSE}
      moveto(x*CellWt,Y*CellHt+CellHt);
      {$ENDIF}
    end;
  procedure GWriteXy(x,y:integer;s:string;bg,fg:integer);
    begin
      J_locate(y,x);
      j_setcolor(fg);
      {$IFDEF FGI}
      fg_text(s,length(s));
      {$ELSE}
      J_setcolor(bg);
      {bar(x*CellWt,y*CellHt,(x+length(s))*CellWt,y*CellHt+CellHt);}
      textattr:=textattr or $80;
      J_setcolor(fg);
      j_locate(y,x);
      write(s);
      textattr:=textattr or $7f;
      {$ENDIF}
      end;
  procedure GWritePXy(x,y:integer;s:string;bg,fg:integer);
    begin
      {$IFDEF FGI}
      fg_move(x,y);
      j_setcolor(fg);
      fg_text(s,length(s));
      {$ELSE}
      moveto(x,y);
      gotoxy(x*CellWt,y*CellHt);
      j_setcolor(fg);
      textattr:=textattr or $80;
      Write(s);
      textattr:=textattr or $7f;
      {$ENDIF}
      end;
  procedure GWriteXyClip(x,y:integer;s:string;bg,fg,clp:integer);
    begin
      j_locate(y,x);
      j_setcolor(fg);
      if length(s)<clp then clp:=length(s);
      {$IFDEF FGI}
      fg_text(s,clp);
      {$ELSE}
      s:=copy(s,1,clp);
      textattr:=textattr or $80;
      setcolor(bg);
      {bar(x*CellWt,y*CellHt,(x+clp)*CellWt,y*CellHt+CellHt);}
      setcolor(fg);
      write(s);
      textattr:=textattr or $7f;
      {$ENDIF}
      end;
  procedure GClrScr(color:integer);
    var old : integer;
    begin
      old:=j_getcolor;
      j_setcolor(color);
      j_rect(0,HighX,0,HighY);

      j_setcolor(old);
      GGotoxy(0,0);
      end;

  procedure OHmenu.ParseText;
    var i,j,index: integer;
        Bstr,Cstr,DStr: string[105];
    begin
      {parses from ParmStr[0]}
      CStr:=MenuParms.AStr; index:=0; DStr:='';
      if CStr[length(Cstr)]<>ParseDelimiter then CStr:=CStr+ParseDelimiter;
      for i := 1 to length(MenuParms.AStr) do
        if MenuParms.AStr[i]<>ParseDelimiter then DStr:=DStr+MenuParms.AStr[i];
      for i := 1 to MaxItems do begin
        {parse text }
        j:=pos(ParseDelimiter,CStr);
        if j>0 then begin
          BStr:=copy(Cstr,1,j-1);
          CStr:=copy(Cstr,j+1,length(CStr)-j);
          inc(index);
          TArray[index]:=BStr;
          MenuParms.NumItems:=Index;
          end;
        end;
      end; {proc}

  procedure OHmenu.MakeBuffer;
    begin
      BuffW:=MenuParms.pX2+ShadWt -MenuParms.px1 +1;
      BuffH:=MenuParms.py2+ShadWt -MenuParms.py1 +1;
      {$IFDEF FGI}
      if BuffW>(HighX+1) then BuffW:=(HighX+1);
      if BuffH>(HighY+1) then BuffH:=(HighY+1);
      Buffersize :=fg_imagesiz(BuffW,BuffH);
      {$ELSE}
      Buffersize :=imagesize(MenuParms.px1,Menuparms.py1,
                             MenuParms.px2,MenuParms.py2);
      {$ENDIF}

      if MaxAvail < Buffersize then begin
        GraphDone;
        writeln('Couldnt allocate memory for image buffer.');
        end;
      GetMem(buffer,Buffersize);
      {$IFDEF FGI}
      fg_getblock(Buffer,
        MenuParms.px1,
        MenuParms.px2+ShadWt,
        MenuParms.py1,
        MenuParms.py2+ShadWt);
      {$ELSE}
      GetImage(MenuParms.px1,
               MenuParms.py1,
               MenuParms.px2+ShadWt,
               MenuParms.py2+ShadWt, buffer^);
      {$ENDIF}
      end; {proc}

  function    OHMenu.GetChoice : integer;
    begin
      GetChoice:=choice;
    end;

  procedure OVMenu.ShowMenu;
    var
      old,i  : integer;
    begin
      MakeBuffer;
      old:=j_getcolor;
      With MenuParms do begin
        j_setcolor(NBg);
        j_rect(px1,px2,py1,py2);
        if BordOn then begin
          j_setcolor(Border);
          j_box(px1,px2,py1,py2);
          end;
        j_setcolor(shadow);
        {xor a shadow}
        if ShadOn then for i := 1 to ShadWt do begin
          j_move(px2+i,py1+i);
          j_drawx(px2+i, py2+i);
          j_move(px1+i,  py2+i);
          j_drawx(px2+i-1, py2+i);
          end;
        end; { With menuparms do }
      j_setcolor(old);
      onscreen:=true;
      end;

    constructor OHVMenu.Init;
      var i:integer;
      begin
        HMenu.Init;
        VMenu.Init;
        {for i := 1 to MaxItems do VMenu.TArray[i]:='';}
        HVResult := 0;
        HResult  := 0;
        VResult  := 0;
        end; {contructor}

    destructor  OHVMenu.Done;
      begin
        HMenu.done;
        VMenu.done;
        end; {Destructor}

    procedure   OHVMenu.SetHorItems(
      x1,y1,x2,y2,Nbg,NFg,HBg,HFg,Border,shadow,NumItems,Highlight:integer;
      BordOn,ShadOn:boolean;AStr:string);
      var menu:integer;
      begin
        menu:=0;
        MenuArray[menu].menu:=0;
        MenuArray[menu].x1:=x1;
        MenuArray[menu].x2:=x2;
        MenuArray[menu].y1:=y1;
        MenuArray[menu].y2:=y2;
        MenuArray[menu].NBg := NBg;
        MenuArray[menu].NFg := NFg;
        MenuArray[menu].HBg := HBg;
        MenuArray[menu].HFg := HFg;
        MenuArray[menu].Border:=Border;
        MenuArray[menu].Shadow:=Shadow;
        MenuArray[menu].BordOn:=BordOn;
        MenuArray[menu].ShadOn:=ShadOn;
        MenuArray[menu].AStr:=AStr;
        end; {proc}

    procedure   OHVMenu.PutHParms(num:integer);
      begin
      with HMenu.MenuParms do begin
        menu  := MenuArray[num].menu;
        x1    := MenuArray[num].x1;
        x2    := MenuArray[num].x2;
        y1    := MenuArray[num].y1;
        y2    := MenuArray[num].y2;
        NBg   := MenuArray[num].NBg;
        NFg   := MenuArray[num].NFg;
        HBg   := MenuArray[num].HBg;
        HFg   := MenuArray[num].HFg;
        Border:= MenuArray[num].Border;
        Shadow:= MenuArray[num].Shadow;
        BordOn:= MenuArray[num].BordOn;
        ShadOn:= MenuArray[num].ShadOn;
        AStr  := MenuArray[num].AStr;

        px1   := MenuArray[num].x1 *CellWt-1;
        px2   := MenuArray[num].x2 *CellWt-1;
        py1   := MenuArray[num].y1 *CellHt-1;
        py2   := MenuArray[num].y2 *CellHt-1;
        if px1<0 then px1:=0;
        if py1<0 then py1:=0;
        if px2>HighX then px2:=HighX;
        if py2>HighY then py2:=HighY;

        if px2+HMenu.ShadWt>HighX then HMenu.ShadWt:=HighX-px2;
        if py2+HMenu.ShadWt>HighY then HMenu.ShadWt:=HighY-py2;
        end;

      end;

    procedure   OHVMenu.SetVerItems(
      menu,x1,y1,x2,y2,Nbg,NFg,HBg,HFg,Border,shadow,NumItems,Highlight:integer;
      BordOn,ShadOn:boolean;AStr:string);
      begin
        MenuArray[menu].menu      :=menu;
        MenuArray[menu].x1        :=x1;
        MenuArray[menu].x2        :=x2;
        MenuArray[menu].y1        :=y1;
        MenuArray[menu].y2        :=y2;
        MenuArray[menu].NBg       := NBg;
        MenuArray[menu].NFg       := NFg;
        MenuArray[menu].HBg       := HBg;
        MenuArray[menu].HFg       := HFg;
        MenuArray[menu].Border    :=Border;
        MenuArray[menu].Shadow    :=Shadow;
        MenuArray[menu].BordOn    :=BordOn;
        MenuArray[menu].ShadOn    :=ShadOn;
        MenuArray[menu].AStr      :=AStr;
        end; {proc}

    procedure   OHVMenu.PutVParms(Num:integer);
      begin
      With VMenu.Menuparms do begin
        menu     := MenuArray[num].menu;
        x1       := MenuArray[num].x1;
        x2       := MenuArray[num].x2;
        y1       := MenuArray[num].y1;
        y2       := MenuArray[num].y2;
        NBg      := MenuArray[num].NBg;
        NFg      := MenuArray[num].NFg;
        HBg      := MenuArray[num].HBg;
        HFg      := MenuArray[num].HFg;
        Border   := MenuArray[num].Border;
        Shadow   := MenuArray[num].Shadow;
        BordOn   := MenuArray[num].BordOn;
        ShadOn   := MenuArray[num].ShadOn;
        AStr     := MenuArray[num].AStr;
        px1   := MenuArray[num].x1 *CellWt-1;
        px2   := MenuArray[num].x2 *CellWt-1;
        py1   := MenuArray[num].y1 *CellHt-1;
        py2   := MenuArray[num].y2 *CellHt-1;
        if px1<0 then px1:=0;
        if py1<0 then py1:=0;
        if px2>HighX then px2:=HighX;
        if py2>HighY then py2:=HighY;

        if px2+VMenu.ShadWt>HighX then VMenu.ShadWt:=HighX-px2;
        if py2+VMenu.ShadWt>HighY then VMenu.ShadWt:=HighY-py2;
        end;
      end;
    function    OHVMenu.GetHResult:shortint;
      begin
        GetHResult:=HMenu.Result;
        end; {proc}

    function    OHVMenu.GetVResult:shortint;
      begin
        GetVResult:=VMenu.Result;
        end; {proc}

    function    OHVMenu.GetHVResult:longint;
      begin
        GetHVResult:=
          HMenu.Result * 100 + HMenu.Result;
        end; {proc}

    function    OHVMenu.GetHChoice:shortint;
      begin
        GetHChoice:=hmenu.GetChoice;
        end; {proc}

    function    OHVMenu.GetVChoice:shortint;
      begin
        GetVChoice:=vmenu.GetChoice;
        end; {proc}

    function    OHVMenu.GetHVChoice:longint;
      begin
        GetHVChoice:=
          hmenu.GetChoice * 100 + VMenu.GetChoice;
        end; {proc}

    procedure  OHVMenu.UseMenu;
      var Quit : boolean;
      begin
        Quit:=false;
        PutHParms(0);
        While (not quit) or (Vmenu.GetChoice<1)   do begin
          if HMenu.Menuparms.Highlight <1 then
            HMenu.Menuparms.Highlight := HMenu.MenuParms.NumItems;
          if HMenu.Menuparms.Highlight > HMenu.MenuParms.NumItems then
            HMenu.Menuparms.Highlight:=1;
          HMenu.Result:=0;
          while HMenu.Result in [0,LfArrow,RtArrow] do
            HMenu.UseMenu(1);
          Quit:=(HMenu.Result=Escape);
          if not quit then begin
            VMenu.Result:=0;
            while VMenu.Result in [0,DnArrow,UpArrow] do begin
              putVParms(HMenu.GetChoice);
              VMenu.UseMenu(HMenu.GetChoice);
              VMenu.EraseMenu;
              end; {while vmenu}
            Quit:=(VMenu.Result=Escape)or(VMenu.Result=Enter);
            end; {if not quit}
          if not quit then begin
            if VMenu.Result=LfArrow then dec(HMenu.Menuparms.Highlight);
            if VMenu.Result=RtArrow then inc(HMenu.Menuparms.Highlight);
            end; {if not quit}
          end; {while not quit or vemenu.getchoice<1 }
        if VMenu.Eraseok then VMenu.Erasemenu;
        if HMenu.Eraseok then HMenu.Erasemenu;
        {VMenu.done;
        HMenu.done;}
        end; {proc}
    function OHVMenu.MenuResult(EraseH,EraseV:boolean):integer;
      var Quit : boolean;
      begin
        Quit:=false;
        PutHParms(0);
        While not quit do begin
          {((not quit) or (Vmenu.GetChoice<1))}
          if HMenu.Menuparms.Highlight <1 then
            HMenu.Menuparms.Highlight := HMenu.MenuParms.NumItems;
          if HMenu.Menuparms.Highlight > HMenu.MenuParms.NumItems then
            HMenu.Menuparms.Highlight:=1;
          HMenu.Result:=0;
          while HMenu.Result in [0,LfArrow,RtArrow] do
            HMenu.UseMenu(1);
          Quit:=(HMenu.Result=Escape);
          if not quit then begin
            VMenu.Result:=0;
            while VMenu.Result in [0,DnArrow,UpArrow] do begin
              putVParms(HMenu.GetChoice);
              VMenu.UseMenu(HMenu.GetChoice);
              VMenu.EraseMenu;
              end; {while vmenu}
            Quit:=(VMenu.Result=Escape)or(VMenu.Result=Enter);
            end; {if not quit}
          if not quit then begin
            if VMenu.Result=LfArrow then dec(HMenu.Menuparms.Highlight);
            if VMenu.Result=RtArrow then inc(HMenu.Menuparms.Highlight);
            end; {if not quit}
          end; {while not quit}
        if EraseV then VMenu.Erasemenu;
        if EraseH then HMenu.Erasemenu;
        MenuResult:=VMenu.GetChoice + (HMenu.GetChoice*100);
        end; {proc}
end.
