program NWWinPas;

{

   This program demonstrates the usage of the NetWare DLLs from
   Turbo Pascal for Windows applications;  the DLLs can be found in the
   latest WINUPx.ZIP on NovLib/NetWire and must be locatable by Windows
   during execution time of the application.

   The Novell documentation "NetWare C for Windows (SDK)" contains all
   needed info about the hundreds of NetWare functions available in the
   NW*.DLL files.

   Conversion to Pascal syntax is rather simple.

   This sample code contains all 3 functions that use password encryption.
   All other NetWare functions can be accessed via normal DOS interrupts,
   but the DLL method is easier and should normally be preferred.

   Written by Wolfgang Schreiber as demonstration only.

}




uses winCrt;

function ChangeBinderyObjectPassword(ObjectName: PChar; ObjectType: Word; OldPassword, NewPassword: PChar): Word; far;
external 'NWCONN' index 6;

function VerifyBinderyObjectPassword(ObjectName: PChar; ObjectType: Word; Password: PChar): Word; far;
external 'NWCONN' index 17;

function LoginToFileServer(ObjectName: PChar; ObjectType: Word; Password: PChar): Word; far;
external 'NWCONN' index 14;


VAR ccode  : Word;
    User, oldPWD, newPWD : PChar;

BEGIN
  User   := 'GUEST';
  oldPWD := 'SECRET';
  newPWD := 'ABCDEF';

  ccode := VerifyBinderyObjectPassword(User, 1, oldPWD);
  WriteLn('Verify: ', ccode );

  if ccode = 0 THEN BEGIN

     ccode := ChangeBinderyObjectPassword(User, 1, oldPWD, newPWD);
     WriteLn('Change: ', ccode );

     if ccode = 0 THEN BEGIN
        ccode := VerifyBinderyObjectPassword(User, 1, oldPWD); {error}
        WriteLn('Verify: ', ccode );

        ccode := VerifyBinderyObjectPassword(User, 1, newPWD);
        WriteLn('Verify: ', ccode );

        ccode := ChangeBinderyObjectPassword(User, 1, newPWD, oldPWD);
        WriteLn('Change: ', ccode )
        END
     end

END.