(**********************************************)
(*                                            *)
(*  Unit of Novell Specific variables         *)
(*  (c) CSM Limited. 1992 All rights reserved *)
(*                                            *)
(**********************************************)

Unit NvllVars;
Interface
Uses
  Strings;

Const
  { Banner Enable }
  prBanner = 1;

  { Bindary Types }
  byUser : Word = $0001;
  byUserGroup : Word = $0002;
  byPrinter : Word = $0003;
  byWild : Word = $FFFF;

  DPMINovellIntr = $60;

Type
  { Connection ID Structures }

  tLogin_Information = Record
    ID_Number : LongInt;
    Name      : Array[0..47] of Char;
    LoginTime : Array[0..6] of Byte;
  end;

  tConnectionIdRec = record
    SlotInUse : Byte;
    ServerOrderNumber : Byte;
    ServerNetNumber : LongInt;
    PhysicalNodeAddress : Real;
    SocketNumber : Word;
    ReceiveTimeOut : Word;
    RouterPhysicalNodeAddress : Real;
    PacketSequenceNum : Byte;
    ConnectionNumber : Byte;
    ConnectionStatus : Byte;
    MaxTimeOut : Word;
    Filler : array[1..5] of byte;
  end;

  pConnectionIDTable = ^tConnectionIDTable;
  tConnectionIDTable = Array[1..8] of tConnectionIDRec;

  { Internal Printer Queue Chain Record }

  PPrinterQueue = ^TPrinterQueue;
  TPrinterQueue = record
    Name : Array[0..100] of Char;
    ServerConnection : Byte;
    ConnectionID : LongInt;
    Next : PPrinterQueue;
    Prev : PPrinterQueue;
  end;

  { Internal User List Chain }

  PUserList = ^TUserList;
  TUserList = record
    Server : Array[0..32] of Char;
    Name : Array[0..47] of Char;
    ServerConnection : Byte;
    ConnectionID : LongInt;
    Next : PUserList;
    Prev : PUserList;
  end;

  { General Buffer Type for DPMI calls }

  PBufferArray = ^TBufferArray;
  TBufferArray = Array[0..300] of Byte;

  { DPMI DOSALLOC return record }

  tDosAlloc = record
    Case boolean of
      TRUE: (Addresses : LongInt);
      FALSE: (Selector : Word;
              Segment : Word;);
  end;

  { Array of the file server Names }

  pFileServerNames   = ^tFileServerNames;
  tFileServerNames   = Array[1..8] of Array[0..47] of Char;

  { Type buffer for semaphores }

  tSemaphore = Array[0..100] of Char;

  { Make it easy to split LongInts into hi and lo words }

  LongRec = record
     Lo, Hi: Word;
  end;

var
  ConnectionID : LongInt; { Used to hold connection ID number  }
  FirstUser : Array[1..8] of PUserList; { User list for each server }
  FirstPrinter : PPrinterQueue; { Top of printer queue }
  NetWareDriversPresent : Boolean; { Used in programs }
  Call_IPX : Procedure; { IPX central call }
  NumberOfServers : Byte;

  { Bindary call buffers etc }
  RequestBuffer,
  Replybuffer : tBufferArray;

  RequestPtr,
  ReplyPtr : pBufferArray;

  RequestSelector,
  ReplySelector,
  RequestSeg,
  ReplySeg : Word;

Implementation
end.