unit EndWait;
(*====================================================================*\
|| MODULE NAME:  EndWait                                              ||
|| DEPENDENCIES: System                                               ||
|| LAST MOD ON:  9006.04                                              ||
|| PROGRAMMER:   Naoto Kimura                                         ||
||                                                                    ||
||     This unit was developed because of the "feature" of the Turbo  ||
|| Pascal (version 5.0) integrated environment which causes it to     ||
|| immediately flip back to the edit screen after the program exits.  ||
|| Hopefully, this will simplify the usage of Turbo Pascal for the    ||
|| Comp 182 students for which this unit was developed.               ||
||                                                                    ||
|| REFERENCE                                                          ||
|| MATERIALS:    Turbo Pascal User's Manual                           ||
||                     Borland International                          ||
||                                                                    ||
|| MODIFICATION HISTORY:                                              ||
|| 8905.31       Naoto Kimura                                         ||
||               Original release                                     ||
|| 9004.08       Naoto Kimura                                         ||
||               Rewrote parts in assembler to reduce size of TPU.    ||
|| 9004.10       Naoto Kimura                                         ||
||               Rewrote same parts as inline statements to eliminate ||
||               separate assembler file to generate OBJ.             ||
|| 9006.04       Naoto Kimura                                         ||
||               Made minor fix to make code smaller and better.      ||
\*====================================================================*)
{$D-}	{No debug information}
{$R-}	{No range checking}
{$O-}	{Overlay disallowed}
{$S-}	{No stack checking}

interface

implementation

var
    OldExitProc	: Pointer;

const
    Msg	: array [0..95] of byte
	= ( $0D,$0A,$2D,$2D, $20,$50,$72,$65, $73,$73,$20,$61,
	    $6E,$79,$20,$6B, $65,$79,$20,$74, $6F,$20,$63,$6F,
	    $6E,$74,$69,$6E, $75,$65,$20,$2D, $2D,$0D,$0A,$0D,
	    $0A,$45,$4E,$44, $57,$41,$49,$54, $2E,$54,$50,$55,
	    $20,$20,$20,$20, $20,$20,$20,$20, $20,$20,$20,$20,
	    $20,$20,$20,$63, $6F,$70,$79,$72, $69,$67,$68,$74,
	    $20,$4E,$61,$6F, $74,$6F,$20,$4B, $69,$6D,$75,$72,
	    $61,$20,$28,$30, $34,$2F,$30,$38, $2F,$39,$30,$29 );

{$F+}
{static far} procedure Sleep;
    begin
	inline(			{;---- ExitProc := OldExitProc	}
		$8C/$D8/	{  mov  ax,ds			}
		$8E/$C0/	{  mov  es,ax			}
		$BF/ExitProc/	{  mov  di,OFFSET ExitProc	}
		$BE/OldExitProc/{  mov  si,OFFSET OldExitProc	}
		$FC/		{  cld				}
		$A5/		{  movsw			}
		$A5/		{  movsw			}
				{;---- output prompt		}
		$B8/$4000/	{  mov  ax,4000H		}
		$BB/$02/$00/	{  mov  bx,StdErr		}
		$B9/$25/$00/	{  mov  cx,MsgLen		}
		$BA/Msg/	{  mov  dx,OFFSET Msg		}
		$CD/$21/	{  int  21h			}
				{;---- clear input buffer	}
		$B8/$0C00/	{  mov  ax,0C00H		}
		$CD/$21/	{  int  21h			}
				{;---- wait for key		}
		$B4/$00/	{  mov  ah,00H			}
		$CD/$16)	{  int  16h			}
    end;    (* Sleep *)

begin
    OldExitProc := ExitProc;
    ExitProc := @Sleep
end.
