{***********************************************************************}
{ Turbo Pascal 6.0                                                      }
{ Program Base                                                          }
{ Copyright (c) 1991 B. Plagge                                          }
{ This is a demo program which demonstrates how to make use of all      }
{ the different functions fo NinBase the universal OOP database program.}
{ Modifications                                                         }
{ (Error, Correction, Initials, Date, What?                             }
{***********************************************************************}

program Base;

{$X+,F+,S-,D-}

{Program to test the database unit Stdbase}

uses Drivers, Objects, Views, App, Menus, Dialogs, Memory, Dos, Printer,
     BpCtv, BpMsg, BpApp, BpUtil,
     BaseOvr, BaseDlg, StdBase, ExImBase, Ninbase;

{$O StdBase}
{$O NinBase}



{define application object}
type
 PBaseApp = ^TBaseApp;
 TBaseApp = object(TStdApp)
   procedure HandleEvent(var Event: TEvent); virtual;
   constructor Init;
   procedure InitMenuBar; virtual;
   procedure InitStatusLine; virtual;
   destructor Done; virtual;
 end;


var
  D       : PDialog;
  Control : Word;
  VBase   : TBaseApp;
  Doit    : Boolean;

{TBaseApp methods}
procedure TBaseApp.HandleEvent(var Event: TEvent);
var
  M      : Word;
  RecKey : String;


{specify new or existing database and corresponding settings}
procedure StartDialog;
var
  R : TRect;
  B : PView;
  DF: PathStr;
begin
  Str(Co^.Lang, ResId);
  ResId := ResId + 'STARTDLG';
  D     := PDialog(LRez.Get(ResId));

  StRec.Mode := 0;

  D^.SetData(StRec);
  Doit    := (ValidView(D) <> nil) and
             (DeskTop^.ExecView(D) = cmYes);
  D^.GetData(StRec);

{new fixed length rec database}
  DF := 'Test.dbf';

  if (StRec.Mode = 1) then
    Message(@Self, evBroadcast, cmNewDb, nil)
  else
    begin
      BaseFile := New(PNinBase, Init(DF, stOpen,'TEST', 0));
      BaseIdx  := New(PBaseKey, Init('TEST.IDX', stOpen, 'TEST',
                                   StringKey, ' '));
      {use RamDisk 'D'}
  {   BaseIdx  := New(PBaseKey, Init('TEST.IDX', stOpen, 'TEST',
                                   StringKey, 'D'));                 }
      N := nil;
      BaseFile^.Assign(BaseIdx);

      if (BaseFile^.Status <> fiOk) or
         (BaseIdx^.Status <> keyOk) then
           begin
             Done;
             Halt(1);
           end;

      FillChar(NeRec, SizeOf(NeRec), ' ');
      if (BaseFile^.RecType = FixedLength) then
        NeRec.RType := 0
      else
        NeRec.RType := 1;
      if (BaseIdx^.KeyType = StringKey) then
        NeRec.KType := 0
      else
        NeRec.KType := 1;
    end;
  Dispose(D, Done);
end;


procedure NewDatabase;
var
  DF   : PathStr;
  Code : Integer;
begin
  Str(Co^.Lang, ResId);
  ResId := ResId + 'NEWDB';
  D     := PBaseDlg(LRez.Get(ResId));

  with NeRec do
    begin
      RType := 1;
      dbOpt := 3;
      KType := 0;
      keOpt := 1;
      Order := '1';
    end;

  D^.SetData(NeRec);
  Doit    := (ValidView(D) <> nil) and
             (DeskTop^.ExecView(D) = cmYes);
  D^.GetData(NeRec);

  DF := 'Test.dbf';

  N := nil;
  if (NeRec.RType = 0) then            {fixed length records}
    BaseFile := New(PNinBase, Init(DF, stCreate, 'TEST', 48))
  else
    BaseFile := New(PNinBase, Init(DF, stCreate, 'TEST', 0));

  if (NeRec.KType = 0) then            {stringkey}
    BaseIdx  := New(PBaseKey, Init('TEST.IDX', stCreate, 'TEST',
                                 StringKey, ' '))
  else
    BaseIdx  := New(PBaseKey, Init('TEST.IDX', stCreate, 'TEST',
                                 LongIntKey, ' '));
    {use RamDisk 'D'}
{   BaseIdx  := New(PBaseKey, Init('TEST.IDX', stCreate, 'TEST',
                                 StringKey, 'D'))
  else
    BaseIdx  := New(PBaseKey, Init('TEST.IDX', stCreate, 'TEST',
                                 LongIntKey, 'D'));                  }

  Val(NeRec.Order, BaseIdx^.Order, Code);
  BaseFile^.Assign(BaseIdx);           {assign index file to database}

  if (BaseFile^.Status <> fiOk) or
     (BaseIdx^.Status <> keyOk) then
       begin
         Done;
         Halt(1);
       end;

  if (NeRec.dbOpt and 1 = 1) then
    begin
      BaseFile^.BackFile := 'TEST.BAK';
      BaseFile^.SetOption(dbBackup);
    end;

  if (NeRec.dbOpt and 2 = 2) then
    begin
      BaseFile^.LogFile := 'TEST.LOG';
      BaseFile^.SetOption(dbLogging);
    end;

  if (NeRec.keOpt and 1 = 1) then
    BaseIdx^.SetOption(keyUpShift);

  if (NeRec.keOpt and 2 = 2) then
    BaseIdx^.SetOption(keyDuplicates);
{ Dispose(D, Done);  }
end;



procedure BuildListBox;
var
  R     : TRect;
  S     : PScrollBar;
  L     : PRecListBox;

begin
  Str(Co^.Lang, ResId);
  ResId := ResId + 'LIST';
  D := PDialog(LRez.Get(ResId));

  with D^ do
    begin
      R.Assign(75,2,76,16);
      S := New(PScrollBar, Init(R));
      Insert(S);
      R.Assign(2,3,75,15);
      L := New(PRecListBox, Init(R, 1, S));
      Insert(L);
      if QList <> nil then
        L^.NewList(QList);
    end;
end;



procedure QueryRange;
var
  Query : PCollection;
  R     : TRect;
  S     : PScrollBar;
  L     : PRecListBox;
  FKey,
  TKey  : Pointer;
  FKeyInt,
  TKeyInt : LongInt;
  Code  : Word;
begin
  Str(Co^.Lang, ResId);
  ResId := ResId + 'QUERYRANGE';
  D     := PBaseDlg(LRez.Get(ResId));
  FillChar(QRec, SizeOf(QRec), ' ');
  QRec.FKey[0] := Chr(0);
  QRec.TKey[0] := Chr(0);

  D^.SetData(QRec);
  Doit    := (ValidView(D) <> nil) and
             (DeskTop^.ExecView(D) = cmYes);
  D^.GetData(QRec);

  BaseIdx^.Reset;                {ensure status is keyOk}

  if (NeRec.KType = 0) then
    begin
      FKey := @QRec.FKey;
      TKey := @QRec.TKey;
    end
  else
    begin
      Val(QRec.FKey, FKeyInt, Code);
      Val(QRec.TKey, TKeyInt, Code);
      FKey := @FKeyInt;
      TKey := @TKeyInt;
    end;

  BaseFile^.QueryRecords(FKey, TKey, Query);

  if (Query <> nil) then
  begin
    QList := New(PCollection, Init(Query^.Count, 0));
    GetAllRecs(Query);
    Dispose(Query, Done);
  end;

  BuildListBox;

  Doit    := (ValidView(D) <> nil) and
             (DeskTop^.ExecView(D) = cmYes);
  if (QList <> nil) then
    begin
      Dispose(QList, Done);
      QList := nil;
    end;
  Dispose(D, Done);
end;


procedure QueryPattern;
var
  Query : PCollection;
  SKey  : Pointer;
begin
  Str(Co^.Lang, ResId);
  ResId := ResId + 'QUERYPHONE';
  D     := PBaseDlg(LRez.Get(ResId));
  FillChar(PRec, SizeOf(PRec), ' ');
  PRec.SKey[0] := Chr(0);

  D^.SetData(PRec);
  Doit    := (ValidView(D) <> nil) and
             (DeskTop^.ExecView(D) = cmYes);
  D^.GetData(PRec);

  BaseIdx^.Reset;                {ensure status is keyOk}

  if (NeRec.KType = 0) then
    SKey := @PRec.SKey
  else
    Exit;

  BaseFile^.QueryPattern(SKey, Query);

  if (Query <> nil) then
  begin
    QList := New(PCollection, Init(Query^.Count, 0));
    GetAllRecs(Query);
    Dispose(Query, Done);
  end;

  BuildListBox;

  Doit    := (ValidView(D) <> nil) and
             (DeskTop^.ExecView(D) = cmYes);

  if (QList <> nil) then
    begin
      Dispose(QList, Done);
      QList := nil;
    end;
  Dispose(D, Done);
end;


procedure QueryPhonetic;
var
  Query : PCollection;
  SKey  : Pointer;
begin
  Str(Co^.Lang, ResId);
  ResId := ResId + 'QUERYPHONE';
  D     := PBaseDlg(LRez.Get(ResId));
  FillChar(PRec, SizeOf(PRec), ' ');
  PRec.SKey[0] := Chr(0);

  D^.SetData(PRec);
  Doit    := (ValidView(D) <> nil) and
             (DeskTop^.ExecView(D) = cmYes);
  D^.GetData(PRec);

  BaseIdx^.Reset;                {ensure status is keyOk}

  if (NeRec.KType = 0) then
    SKey := @PRec.SKey
  else
    Exit;

  BaseFile^.QuerySoundex(SKey, Query);

  if (Query <> nil) then
  begin
    QList := New(PCollection, Init(Query^.Count, 0));
    GetAllRecs(Query);
    Dispose(Query, Done);
  end;

  BuildListBox;

  Doit    := (ValidView(D) <> nil) and
             (DeskTop^.ExecView(D) = cmYes);

  if (QList <> nil) then
    begin
      Dispose(QList, Done);
      QList := nil;
    end;
  Dispose(D, Done);
end;


procedure ExportFile;
var
  List : PFieldList;
  A    : PAsciiFile;
  B    : PdBase;
  FName: String[12];
  SFlag: Boolean;
begin
  Str(Co^.Lang, ResId);
  ResId := ResId + 'EXPORT';
  D     := PBaseDlg(LRez.Get(ResId));
  FillChar(ERec, SizeOf(ERec), ' ');
  ERec.Name[0] := Chr(0);
  ERec.SDF     := 0;            {false}
  ERec.Delimit := '"';
  D^.SetData(ERec);

  Doit    := (ValidView(D) <> nil) and
             (DeskTop^.ExecView(D) = cmYes);
  D^.GetData(ERec);

  {collection to hold the field records}
  List := New(PFieldList, Init(5, 0));

  with List^do
  if (NeRec.RType = 0) then            {fixed length records}
    begin
      Insert(New(PFieldRec, Init('NUMBER', Long, 0, 3, 'N', 5, 0)));
      Insert(New(PFieldRec, Init('NAME', Strg, 10, 1, 'C', 10, 0)));
      Insert(New(PFieldRec, Init('FNAME', Strg, 10, 2, 'C', 10, 0)));
      Insert(New(PFieldRec, Init('TOWN', Strg, 10, 4, 'C', 10, 0)));
      Insert(New(PFieldRec, Init('TELEPHONE', Strg, 0, 5, 'N', 10, 0)));
    end
  else
    begin
      Insert(New(PFieldRec, Init('NUMBER', Long, 0, 3, 'N', 5, 0)));
      Insert(New(PFieldRec, Init('NAME', PStr, 0, 1, 'C', 10, 0)));
      Insert(New(PFieldRec, Init('FNAME', PStr, 0, 2, 'C', 10, 0)));
      Insert(New(PFieldRec, Init('TOWN', PStr, 0, 4, 'C', 10, 0)));
      Insert(New(PFieldRec, Init('TELEPHONE', PStr, 0, 5, 'N', 10, 0)));
    end;

  FName := ERec.Name + '.TXT';

  {Ascii export}
  if (ERec.SDF = 1) then
    SFlag  := true              {SDF file}
  else
    SFlag  := false;
  A := New(PAsciiFile, Init(FName, stCreate, List, SFlag));
  A^.Delimit := ERec.Delimit[1];
  BaseFile^.ExportFile(A);
  Dispose(A, Done);

  {dbase export}
{ B := New(PdBase, Init(FName, stCreate, List));
  BaseFile^.ExportFile(B);
  Dispose(B, Done);    }

  Dispose(D, Done);
end;


procedure ImportFile;
var
  List : PFieldList;
  A    : PAsciiFile;
  B    : PdBase;
  FName: String[12];
  i    : Integer;
  FR   : PFieldRec;
  SFlag: Boolean;
begin
  Str(Co^.Lang, ResId);
  ResId := ResId + 'IMPORT';
  D     := PBaseDlg(LRez.Get(ResId));
  FillChar(ERec, SizeOf(ERec), ' ');
  ERec.Name[0] := Chr(0);
  ERec.SDF     := 0;            {false}
  ERec.Delimit := '"';
  D^.SetData(ERec);

  Doit    := (ValidView(D) <> nil) and
             (DeskTop^.ExecView(D) = cmYes);
  D^.GetData(ERec);

  {collection to hold the field records}
  List := New(PFieldList, Init(5, 0));

  with List^do
  if (NeRec.RType = 0) then            {fixed length records}
    begin
      Insert(New(PFieldRec, Init('NAME', Strg, 10, 2, 'C', 10, 0)));
      Insert(New(PFieldRec, Init('FNAME', Strg, 10, 3, 'C', 10, 0)));
      Insert(New(PFieldRec, Init('NUMBER', Long, 0, 1, 'N', 5, 0)));
      Insert(New(PFieldRec, Init('TOWN', Strg, 10, 4, 'C', 10, 0)));
      Insert(New(PFieldRec, Init('TELEPHONE', Strg, 10, 5, 'N', 10, 0)));
    end
  else
    begin
      Insert(New(PFieldRec, Init('NAME', PStr, 0, 2, 'C', 10, 0)));
      Insert(New(PFieldRec, Init('FNAME', PStr, 0, 3, 'C', 10, 0)));
      Insert(New(PFieldRec, Init('NUMBER', Long, 0, 1, 'N', 5, 0)));
      Insert(New(PFieldRec, Init('TOWN', PStr, 0, 4, 'C', 10, 0)));
      Insert(New(PFieldRec, Init('TELEPHONE', PStr, 10, 5, 'N', 10, 0)));
    end;

  FName := ERec.Name + '.TXT';

  N := New(PName, Init(0, '', '', '', ''));    {new object for var length recs}
  {Ascii import}
  if (ERec.SDF = 1) then
    SFlag  := true              {SDF format}
  else
    SFlag  := false;
  A := New(PAsciiFile, Init(FName, stOpenRead, List, SFlag));
  A^.Delimit := ERec.Delimit[1];
  BaseFile^.ImportFile(A, N);
  Dispose(A, Done);

  {dBase import}
{ Dispose(List, Done);           }      {will be read from dBase file}
{ B := New(PdBase, Init(FName, stOpenRead, nil));

  if (B^.Fields <> nil) then
    begin
      if (NeRec.RType = 0) then
        begin
          FR := PFieldRec(B^.Fields^.At(0));
          FR^.PType := Strg; FR^.PLength := 10; FR^.SelField := 2;
          FR := PFieldRec(B^.Fields^.At(1));
          FR^.PType := Strg; FR^.PLength := 10; FR^.SelField := 3;
          FR := PFieldRec(B^.Fields^.At(2));
          FR^.PType := Long; FR^.PLength := 0;  FR^.SelField := 1;
          FR := PFieldRec(B^.Fields^.At(3));
          FR^.PType := Strg; FR^.PLength := 10; FR^.SelField := 4;
          FR := PFieldRec(B^.Fields^.At(4));
          FR^.PType := Strg; FR^.PLength := 10; FR^.SelField := 5;
        end
      else
        begin
          FR := PFieldRec(B^.Fields^.At(0));
          FR^.PType := PStr; FR^.PLength := 0; FR^.SelField := 2;
          FR := PFieldRec(B^.Fields^.At(1));
          FR^.PType := PStr; FR^.PLength := 0;  FR^.SelField := 3;
          FR := PFieldRec(B^.Fields^.At(2));
          FR^.PType := Long; FR^.PLength := 0; FR^.SelField := 1;
          FR := PFieldRec(B^.Fields^.At(3));
          FR^.PType := PStr; FR^.PLength := 0; FR^.SelField := 4;
          FR := PFieldRec(B^.Fields^.At(4));
          FR^.PType := PStr; FR^.PLength := 10; FR^.SelField := 5;
        end;
    end;

  BaseFile^.ImportFile(B, N);
  Dispose(B, Done);     }

  Dispose(N, Done);
  N := nil;
  Dispose(D, Done);
end;



procedure DatabaseOptions;
begin
  Str(Co^.Lang, ResId);
  ResId := ResId + 'DBOPTIONS';
  D     := PBaseDlg(LRez.Get(ResId));

  OpRec.dbOpt := 3;

  D^.SetData(OpRec);
  Control := DeskTop^.ExecView(D);
  D^.GetData(OpRec);

  if (OpRec.dbOpt and 1 = 1) then
    begin
      BaseFile^.BackFile := 'TEST.BAK';
      BaseFile^.SetOption(dbBackup);
    end;

  if (OpRec.dbOpt and 2 = 2) then
    begin
      BaseFile^.LogFile := 'TEST.LOG';
      BaseFile^.SetOption(dbLogging);
    end;
end;


procedure PackDatabase;
begin
  BaseFile^.PackFile('TEST.$$$');
end;



procedure IndexDatabase;
begin
  BaseFile^.IndexFile;
end;



procedure InitDialog;
begin
  Str(Co^.Lang, ResId);
  ResId := ResId + 'INITDLG';
  D     := PBaseDlg(LRez.Get(ResId));

  ClearDisplay;
  SetStatus;
  D^.SetData(SRec);
  Control := DeskTop^.ExecView(D);
end;



procedure DatabaseInfo;
begin
  Str(Co^.Lang, ResId);
  ResId := ResId + 'DBINFO';
  D     := PBaseDlg(LRez.Get(ResId));

  with InRec do
    begin
      dbOpt  := 0; keOpt := 0;
      NinId  := BaseFile^.NinId^;
      NinVer := BaseFile^.NinVer^;
      if (BaseFile^.RecType = fixedLength) then RType := 0 else RType := 1;
      if (BaseFile^.fiOptions and dbBackup = dbBackup) then
        dbOpt := dbOpt or 1;
      if (BaseFile^.fiOptions and dbLogging = dbLogging) then
        dbOpt := dbOpt or 2;
      if (BaseIdx^.KeyType = StringKey) then KType := 0 else KType := 1;
      if (BaseIdx^.keyOptions and keyUpShift = keyUpShift) then
        keOpt := keOpt or 1;
      if (BaseIdx^.keyOptions and keyDuplicates = keyDuplicates) then
        keOpt := keOpt or 2;
      Str(BaseIdx^.Order:1, Order);
      Str(BaseFile^.NoRecs:4, NoRecs);
      Str(BaseFile^.NoDels:4, NoDels);
    end;

  D^.SetData(InRec);
  Control := DeskTop^.ExecView(D);
end;


procedure PrintRegister;
const
  REGFILE = 'REGISTER.TXT';
var
  Stat   : Byte;
  RFile  : Text;
  RLine  : String;
begin
{  144 : OK
    10 : paper loaded, printer offline
    24 : printer offline
    56 : out of paper
   200 : printer switched off   }

  Stat := PrinterStat;
  if (Stat = 144) and FileExists(REGFILE) then
  begin
    Assign(RFile, REGFILE);
    Reset(RFile);
    while not Eof(RFile) do
    begin
      ReadLn(RFile, RLine);
      WriteLn(Lst, RLine);
    end;
  end;
end;


begin    {HandleEvent}
  if (Event.What = evBroadcast) then
    case Event.Command of
      cmStart    : StartDialog;
      cmNewDb    : NewDatabase;
      cmInitDlg  : InitDialog;
    end;

   if (Event.What = evCommand) then
     case Event.Command of
       cmOptions    : DatabaseOptions;
       cmPackDb     : PackDatabase;
       cmReIndex    : IndexDatabase;
       cmInitDlg    : InitDialog;
       cmQueryRange : QueryRange;
       cmQueryPat   : QueryPattern;
       cmQueryPhone : QueryPhonetic;
       cmExportFile : ExportFile;
       cmImportFile : ImportFile;
       cmDBInfo     : DatabaseInfo;
       cmRegister   : PrintRegister;
     end;

   TApplication.HandleEvent(Event);
end;


constructor TBaseApp.Init;

var
  M   : Word;
  H   : PathStr;
begin
  TStdApp.Init('BASE');
  RegisterNinBase;
  RegisterBaseDlg;
  if Sy^.ProgId^ <> 'BASE' then
  begin
    {Wrong resource file}
    M := MessageBox(20, nil, mfError + mfOkButton);
    Halt(4);
  end;

  Message(@Self, evBroadcast, cmStart, nil);
  Message(@Self, evBroadcast, cmInitDlg, nil);
end;


procedure TBaseApp.InitMenuBar;
begin
  Str(Co^.Lang, ResId);
  ResId := ResId + 'MENUBAR';
  MenuBar := PMenuBar(LRez.Get(ResId));
end;


procedure TBaseApp.InitStatusLine;
begin
  Str(Co^.Lang, ResId);
  ResId := ResId + 'STATUSLINE';
  StatusLine := PStatusLine(LRez.Get(ResId));
end;


destructor TBaseApp.Done;
begin
  Dispose(BaseFile, Done);
  TStdApp.Done;
end;

begin
  VBase.Init;
  VBase.Run;
  VBase.Done;
end.


