{***********************************************************************}
{ Turbo Pascal 6.0                                                      }
{ Program BaseDlg                                                       }
{ Copyright (c) 1991 B. Plagge                                          }
{ This is a demo program which demonstrates how to make use of all      }
{ the different functions fo NinBase the universal OOP database program.}
{ Modifications                                                         }
{ (Error, Correction, Initials, Date, What?                             }
{***********************************************************************}

unit BaseDlg;

{$O+,F+,S-,D-}

interface

uses Drivers, Objects, Views, App, Menus, Dialogs, Memory, Dos,
     BpCtv, BpMsg, BpApp,
     StdBase, Ninbase;



{used for the start dialog - new or existing file}
type
  StartRec = record
    Mode  : Word;
  end;


type
  NewRec  = record
    RType : Word;                 {fixed length or var length}
    dbOpt : Word;                 {dbLogging, dbBackup}
    KType : Word;                 {StringKey or LongIntKey}
    keOpt : Word;                 {keyDuplicates}
    Order : String[1];            {size of pages - 1 - 8}
  end;


type
  OptRec  = record
    dbOpt : Word;
  end;


{data record is wirtten to the file}
type
  DataRec = record
    Number : LongInt;
    Name   : String[10];
    FName  : String[10];
    Ort    : String[10];
    Tel    : String[10];
  end;


{the screen record includes the status and error type fields}
type
  ScrRec = record
    Number    : String[5];
    Name      : String[10];
    FName     : String[10];
    Ort       : String[10];
    Tel       : String[10];
    Status    : String[2];
    EType     : String[4];
  end;


{Object for testing variable length records}
type
  PName = ^TName;
  TName = object(TObject)
    Number : LongInt;
    Name   : PString;
    FName  : PString;
    Ort    : PString;
    Tel    : PString;
    constructor Init(ANumber: Integer; AName, AFName, AOrt, ATel: String);
    destructor Done; virtual;
    constructor Load(var S: TStream);
    procedure Store(var S: TStream);
  end;


{Object for listing variable length records}
type
  PQName = ^TQName;
  TQName = object(TObject)
    Rang   : Integer;
    Number : LongInt;
    Name   : PString;
    FName  : PString;
    Ort    : PString;
    Tel    : PString;
    constructor Init(ANumber, ARang: Integer; AName, AFName, AOrt, ATel: String);
    destructor Done; virtual;
  end;


type
  QueryRec = record
    FKey   : String[10];               {from key}
    TKey   : String[10];               {to key}
  end;


type
  QueryPhone = record
    SKey   : String[10];                {search key}
  end;


type
 ExImRec = record
   Name    : String[8];
   SDF     : Word;
   Delimit : String[1];
 end;


{record to display database options currently selected}
type
  InfoRec  = record
    NinId : String[35];           {database info}
    NinVer: String[4];            {version number}
    RType : Word;                 {fixed length or var length}
    dbOpt : Word;                 {dbLogging, dbBackup}
    KType : Word;                 {StringKey or LongIntKey}
    keOpt : Word;                 {keyDuplicates}
    Order : String[1];            {size of pages - 1 - 8}
    NoRecs: String[4];            {number of recs in database}
    NoDels: String[4];            {number of deleted recs in database}
  end;



{RecListBox is a list box containing all records                }
{retrieved and held by the Query collection                     }
const
  MaxLen = 80;

type
  PRecListBox = ^TRecListBox;
  TRecListBox = object(TListBox)
    function GetText(Item: Integer; MaxLen: Integer): String; virtual;
  end;



{define descendent object adding a field to remember the last record }
{number used.                                                        }
type
  PNinBase = ^TNinBase;
  TNinBase = object(TNinFile)
    LastRecNo : Integer;
    constructor Init(DFile: PathStr; AMode: Integer;
                     AFileId : NameStr; AnItemSize: Integer);
    constructor Load(var S: TStream);
    procedure Store(var S: TStream);
    procedure AddKeyRec(var Buffer); virtual;
  end;


{define new index files which overwrites the default Key function}
type
  PBaseKey = ^TBaseKey;
  TBaseKey = object(TNinKey)
    function Key(var Buffer): Pointer; virtual;
  end;


{define data entry dialog}
type
  PBaseDlg = ^TBaseDlg;
  TBaseDlg = object(TDialog)
    procedure HandleEvent(var Event: TEvent); virtual;
    constructor Load(var S: TStream);
    procedure Store(var S: TStream);
  end;

const
 cmInitDlg    = 1000;
 cmAddRec     = 1010;
 cmGetRec     = 1011;
 cmNextRec    = 1012;
 cmPrevRec    = 1013;
 cmFirstRec   = 1014;
 cmLastRec    = 1015;
 cmPutRec     = 1016;
 cmDeleteRec  = 1017;
 cmUnDelRec   = 1018;
 cmStart      = 1019;
 cmNewDb      = 1020;
 cmOptions    = 1021;
 cmIndex      = 1022;
 cmQueryRange = 1023;
 cmQueryPat   = 1024;
 cmQueryPhone = 1025;
 cmExportFile = 1026;
 cmImportFile = 1027;
 cmPackDB     = 1028;
 cmPackIndex  = 1029;
 cmReIndex    = 1030;
 cmDBInfo     = 1031;
 cmRegister   = 1032;


const
  RName     : TStreamRec = (
     ObjType: 2600;
     VmtLink: Ofs(TypeOf(TName)^);
     Load   : @TName.Load;
     Store  : @TName.Store
  );


const
  RNinBase  : TStreamRec = (
     ObjType: 2601;
     VmtLink: Ofs(TypeOf(TNinBase)^);
     Load   : @TNinBase.Load;
     Store  : @TNinBase.Store
  );


const
  RBaseKey  : TStreamRec = (
     ObjType: 2602;
     VmtLink: Ofs(TypeOf(TBaseKey)^);
     Load   : @TBaseKey.Load;
     Store  : @TBaseKey.Store
  );


const
  RBaseDlg  : TStreamRec = (
     ObjType: 2603;
     VmtLink: Ofs(TypeOf(TBaseDlg)^);
     Load   : @TBaseDlg.Load;
     Store  : @TBaseDlg.Store
  );


procedure RegisterBaseDlg;
function Ok: Boolean;
procedure ClearDisplay;
procedure SetStatus;
procedure GetAllRecs(C: PCollection);


var
  BaseFile : PNinBase;
  BaseIdx  : PBaseKey;
  DRec     : DataRec;
  SRec     : ScrRec;
  StRec    : StartRec;
  NeRec    : NewRec;
  OpRec    : OptRec;
  QRec     : QueryRec;
  PRec     : QueryPhone;
  ERec     : ExImRec;
  InRec    : InfoRec;
  N        : PName;
  D        : PDialog;
  QList    : PCollection;


implementation

uses BpUtil;

{Register objects}
procedure RegisterBaseDlg;
begin
  RegisterType(RNinBase);
  RegisterType(RBaseKey);
  RegisterType(RName);
  RegisterType(RBaseDlg);
end;


function Ok: Boolean;
begin
  Ok := true;
  if (BaseFile^.Status <> 0) or (BaseFile^.KeyDat^.Status <> 0) then
    Ok := false;
end;



procedure ClearDisplay;
begin
  FillChar(SRec.Number, 5, ' ');
  FillChar(SRec.Name, 10, ' ');
  FillChar(SRec.FName, 10, ' ');
  FillChar(SRec.Ort, 10, ' ');
  FillChar(SRec.Tel, 10, ' ');
  Str(BaseFile^.LastRecNo, SRec.Number);
  SRec.Name[0]   := Chr(0);
  SRec.FName[0]  := Chr(0);
  SRec.Ort[0]    := Chr(0);
  SRec.Tel[0]    := Chr(0);
end;


procedure SetStatus;
begin
  Str(BaseFile^.Status, SRec.Status);
  SRec.Status := Copy('00', 1, 2 - Length(SRec.Status)) + SRec.Status;
  case BaseFile^.EType of
    Strm  : SRec.EType := 'Strm';
    Dat   : SRec.EType := 'Dat ';
    Ind   : SRec.EType := 'Ind ';
  else
    SRec.EType := '    ';
  end;

  if not Ok then
    begin
      ClearDisplay;
      BaseFile^.Reset;
    end;
end;


procedure GetAllRecs(C: PCollection);

procedure GetQueryRec(Q: PQueryItem); far;
var
  N1 : Integer;
  S1,
  S2,
  S3,
  S4 : String[10];

procedure AssignFixedFields;
begin
  with DRec do
    begin
      N1 := Number;
      S1 := Name;
      S2 := FName;
      S3 := Ort;
      S4 := Tel;
    end;
end;

procedure AssignVarFields;
begin
  N1 := N^.Number;
  if (N^.Name <> nil) then
    S1 := N^.Name^;
  if (N^.FName <> nil) then
    S2 := N^.FName^;
  if (N^.Ort <> nil) then
    S3 := N^.Ort^;
  if (N^.Tel <> nil) then
    S4 := N^.Tel^;
end;

begin  {GetQueryRec}
  if LowMemory then             {prevent out of memory run time error}
    Exit;

  S1[0] := Chr(0); S2[0] := Chr(0);
  S3[0] := Chr(0); S4[0] := Chr(0);
  if (NeRec.RType = 0) then
    begin
      BaseFile^.GetRecord(DRec, Q^.Position);
      AssignFixedFields;
    end
  else
    begin
      BaseFile^.GetRecord(N, Q^.Position);
      AssignVarFields;
    end;

  if (BaseFile^.Status = fiOk) then
    QList^.Insert(New(PQName,
             Init(N1, Q^.Rank, S1, S2, S3, S4)))
  else
    BaseFile^.Reset;

end;

begin {GetAllRecs}
  if (C <> nil) and
     (C^.Count > 0) then
    C^.ForEach(@GetQueryRec);
end;


{TName methods}
constructor TName.Init(ANumber: Integer; AName, AFName, AOrt, ATel: String);
begin
  Number := ANumber;
  Name   := NewStr(AName);
  FName  := NewStr(AFName);
  Ort    := NewStr(AOrt);
  Tel    := NewStr(ATel);
end;


destructor TName.Done;
begin
  DisposeStr(Name);
  DisposeStr(FName);
  DisposeStr(Ort);
  DisposeStr(Tel);
end;


constructor TName.Load(var S: TStream);
begin
  S.Read(Number, SizeOf(Number));
  Name  := S.ReadStr;
  FName := S.ReadStr;
  Ort   := S.ReadStr;
  Tel   := S.ReadStr;
end;


procedure TName.Store(var S: TStream);
begin
  S.Write(Number, SizeOf(Number));
  S.WriteStr(Name);
  S.WriteStr(FName);
  S.WriteStr(Ort);
  S.WriteStr(Tel);
end;


{TQName methods}
constructor TQName.Init(ANumber, ARang: Integer;
                        AName, AFName, AOrt, ATel: String);
begin
  Number := ANumber;
  Rang   := ARang;
  Name   := NewStr(AName);
  FName  := NewStr(AFName);
  Ort    := NewStr(AOrt);
  Tel    := NewStr(ATel);
end;


destructor TQName.Done;
begin
  DisposeStr(Name);
  DisposeStr(FName);
  DisposeStr(Ort);
  DisposeStr(Tel);
end;



{TRecListBox methods}

function TRecListBox.GetText(Item: Integer;MaxLen: Integer): String;
var
  S  :  String[80];
  P1,
  P2 :  String[5];
  P3,
  P4,
  P5,
  P6 :  String[10];
  QN :  PQName;
begin
  if (List <> nil) then
    if (List^.Count <> 0) then
  begin
    FillChar(S, SizeOf(S), ' ');         {initialize string}
    S[0]  := Chr(0);
    P3[0] := Chr(0); P4[0] := Chr(0);
    P5[0] := Chr(0); P6[0] := Chr(0);
    QN   := PQName(List^.At(Item));
    if (QN <> nil) then
    begin
      Str(QN^.Number, P1);
      Str(QN^.Rang, P2);
      if (QN^.Name <> nil) then P3 := QN^.Name^;
      if (QN^.FName <> nil) then P4 := QN^.FName^;
      if (QN^.Ort <> nil) then P5 := QN^.Ort^;
      if (QN^.Tel <> nil) then P6 := QN^.Tel^;
      S  := P1;             S[0] := Chr(7);  {insert number}
      S  := S + P2;         S[0] := Chr(14); {insert rang}
      S  := S + P3;         S[0] := Chr(26); {insert name}
      S  := S + P4;         S[0] := Chr(38); {insert first name}
      S  := S + P5;         S[0] := Chr(50); {insert town}
      S  := S + P6;                          {insert telephone}
      GetText := S;
    end;
  end;
end;



{TNinBase methods}
constructor TNinBase.Init(DFile: PathStr; AMode: Integer;
                          AFileId : NameStr; AnItemSize: Integer);
begin
  TNinFile.Init(DFile, AMode, AFileId, AnItemSize);
  LastRecNo := 0;
end;

constructor TNinBase.Load(var S: TStream);
begin
  TNinFile.Load(S);
  S.Read(LastRecNo, SizeOf(LastRecNo));
end;

procedure TNinBase.Store(var S: TStream);
begin
  TNinFile.Store(S);
  S.Write(LastRecNo, SizeOf(LastRecNo));
end;


procedure TNinBase.AddKeyRec(var Buffer);
begin
  TNinFile.AddKeyRec(Buffer);
  Inc(LastRecNo);
end;



{TBaseKey method}
function TBaseKey.Key(var Buffer): Pointer;
begin
  if (NeRec.RType = 0) then
    if (NeRec.KType = 0) then               {StringKey}
      Key := @DataRec(Buffer).Name
    else
      Key := @DataRec(Buffer).Number
  else
    if (NeRec.KType = 0) then               {StringKey}
      Key := PName(Buffer)^.Name
    else
      Key := @PName(Buffer)^.Number;
end;


{TBaseDlg methods}
constructor TBaseDlg.Load(var S: TStream);
begin
  TDialog.Load(S);
end;


procedure TBaseDlg.Store(var S: TStream);
begin
  TDialog.Store(S);
end;


procedure TBaseDlg.HandleEvent(var Event: TEvent);
var
  M      : Word;
  RecKey : String;




procedure SetScreenRec;
begin
  if (NeRec.RType = 0) then
    begin
      Str(DRec.Number : 5, SRec.Number);
      SRec.Name      := DRec.Name;
      SRec.FName     := DRec.FName;
      SRec.Ort       := DRec.Ort;
      SRec.Tel       := DRec.Tel;
    end
  else
    if (N = nil) then
      ClearDisplay
    else
      with SRec do
        begin
          FillChar(SRec, SizeOf(SRec), ' ');
          Str(N^.Number : 5, Number);
          if N^.Name <> nil  then Name  := N^.Name^  else Name[0]  := Chr(0);
          if N^.FName <> nil then FName := N^.FName^ else FName[0] := Chr(0);
          if N^.Ort <> nil   then Ort   := N^.Ort^   else Ort[0]   := Chr(0);
          if N^.Tel <> nil   then Tel   := N^.Tel^   else Tel[0]   := Chr(0);
        end;
end;


procedure SetDataRec;
var
  Code : Integer;
  No   : Integer;
begin
  if (NeRec.RType = 0) then
    begin
      if (SRec.Number = ' ') then
        No := BaseFile^.LastRecNo
      else
        Val(SRec.Number, No, Code);
      DRec.Number := No;
      DRec.Name   := SRec.Name;
      DRec.FName  := SRec.FName;
      DRec.Ort    := SRec.Ort;
      DRec.Tel    := SRec.Tel;
    end
  else
    begin
      if (N <> nil) then
        begin
          Dispose(N, Done);
          N := nil;
        end;
      if (SRec.Number = ' ') then
        No := BaseFile^.LastRecNo
      else
        Val(SRec.Number, No, Code);
      N := New(PName, Init(No, SRec.Name, SRec.FName, SRec.Ort, SRec.Tel))
    end;
end;


procedure AddRecord;
begin
  GetData(SRec);
  SetDataRec;
  if (NeRec.RType = 0) then
    BaseFile^.AddKeyRec(DRec)
  else
    BaseFile^.AddKeyRec(N);
  SetStatus;
  SetData(SRec);
  SelectNext(true);
  SelectNext(true);
  SelectNext(true);
  SelectNext(true);
  SelectNext(true);
end;


procedure GetRecord;
begin
  GetData(SRec);
  SetDataRec;
  if (NeRec.RType = 0) then
    BaseFile^.GetKeyRec(DRec)
  else
    BaseFile^.GetKeyRec(N);
  SetScreenRec;
  SetStatus;
  SetData(SRec);
  SelectNext(true);
  SelectNext(true);
  SelectNext(true);
  SelectNext(true);
  SelectNext(true);
  SelectNext(true);
end;


procedure NextRecord;
var
  Stop : Boolean;
begin
  if (NeRec.RType = 0) then
    BaseFile^.NextKeyRec(DRec)
  else
    BaseFile^.NextKeyRec(N);
  SetScreenRec;
  Stop := BaseFile^.eof;
  SetStatus;
  if Stop then
    begin
      BaseFile^.eof := Stop;        {don't override eof}
      BaseFile^.Error(keyEndErr, Ind);
    end;
  SetData(SRec);
end;


procedure PrevRecord;
var
  CurStatus : Word;
begin
  if (NeRec.RType = 0) then
    BaseFile^.PrevKeyRec(DRec)
  else
    BaseFile^.PrevKeyRec(N);
  SetScreenRec;
  CurStatus := BaseFile^.Status;
  SetStatus;
  if (CurStatus = keyTopErr) then
    BaseFile^.Error(keyTopErr, Ind);

  SetData(SRec);
end;


procedure FirstRecord;
begin
  SetStatus;                            {reset Status to 0 if required}
  if (NeRec.RType = 0) then
    BaseFile^.FirstKeyRec(DRec)
  else
    BaseFile^.FirstKeyRec(N);
  SetScreenRec;
  SetStatus;
  SetData(SRec);
end;


procedure LastRecord;
begin
  SetStatus;                            {reset Status to 0 if required}
  if (NeRec.RType = 0) then
    BaseFile^.LastKeyRec(DRec)
  else
    BaseFile^.LastKeyRec(N);
  SetScreenRec;
  SetStatus;
  SetData(SRec);
end;


procedure UpdateRecord;
begin
  GetData(SRec);
  SetDataRec;
  if (NeRec.RType = 0) then
    BaseFile^.PutKeyRec(DRec)
  else
    BaseFile^.PutKeyRec(N);
  SetStatus;
  SetData(SRec);
  SelectNext(false);
  SelectNext(false);
  SelectNext(false);
end;

procedure DeleteRecord;
begin
  GetData(SRec);
  SetDataRec;
  if (NeRec.RType = 0) then
{   BaseFile^.DeleteRecord(DRec)} {'Overwrite' protection on}
    BaseFile^.DeleteKeyRec(DRec)  {record is internally retrieved first}
  else
{   BaseFile^.DeleteRecord(N);  } {'Overwrite' protection on}
    BaseFile^.DeleteKeyRec(N);    {record is internally retrieved first}
  ClearDisplay;
  SetStatus;
  SetData(SRec);
  SelectNext(false);
  SelectNext(false);
end;


procedure UnDeleteRecord;
begin
  GetData(SRec);
  SetDataRec;
  if (NeRec.RType = 0) then
    BaseFile^.UnDeleteKeyRec(DRec)
  else
    BaseFile^.UnDeleteKeyRec(N);
  SetScreenRec;
  SetStatus;
  SetData(SRec);
  SelectNext(false);
end;



begin    {HandleEvent}
  if (Event.What = evCommand) and
     (State and sfSelected <> 0) then
  begin
    case Event.KeyCode of
      cmAddRec   : AddRecord;
      cmGetRec   : GetRecord;
      cmNextRec  : NextRecord;
      cmPrevRec  : PrevRecord;
      cmFirstRec : FirstRecord;
      cmLastRec  : LastRecord;
      cmPutRec   : UpdateRecord;
      cmDeleteRec: DeleteRecord;
      cmUnDelRec : UnDeleteRecord;
    end;
  end;
  TDialog .HandleEvent(Event);    
end;


end.


