{ FILE:  editpkg.pas }



unit EditPkg;



{ ************************************************************************* }
{                                                                           }
{ NOTICE:  Most of the following code was written by Borland International. }
{          The code is for use by TP6.0 users.  Keep the copyright notice   }
{          intact!                                                          }
{                                                                           }
{          Turbo Pascal 6.0                                                 }
{          Turbo Vision Demo                                                }
{          Copyright (c) 1990 by Borland International                      }
{                                                                           }
{ This unit provides an interface to the NEWEDIT unit.  Specifically,       }
{ it initializes the buffers, contains all the editor dialogs, handles all  }
{ allocation and deallocation of the clipboard, and of course opens up      }
{ the appropriate edit window when requested.                               }
{                                                                           }
{ The major item I've changed here is how the "heap" is set up for          }
{ use by the editor buffers.  You can search for it using the HEAP          }
{ shown below.                                                              }
{                                                                           }
{ In addition, I've added a procedure to show how to close editor windows   }
{ for external file processing and then reopen them to continue editing.    }
{ Look for the CHKSPL label.  This label is also defined in NEDEMO and      }
{ NEWEDIT, for it requires coding through all three units.                  }
{                                                                           }
{ All other labels in this unit are defined in the NEWEDIT                  }
{ unit, they being mostly for dialog boxes and error messages.              }
{                                                                           }
{ There are additional minor things, like how to use typecasting to set     }
{ editor defaults when opening a window.  These aren't labeled.             }
{                                                                           }
{ Search   Description:                                                     }
{ ------   ------------                                                     }
{                                                                           }
{ HEAP   - Added a feature to allow maximum or minimum heap allocation      }
{          for use by the editors buffers.                                  }
{                                                                           }
{ SPLCHK - Shows how to close an edit window to process a file              }
{          (such as spell checking) and reopen the window when done.        }
{                                                                           }
{ Al Andersen - 10/31/93.                                                   }
{                                                                           }
{ ************************************************************************* }


{$O+,F+,X+,S-,D-}



interface



uses

  Objects,
  Drivers,
  Views,
  Dialogs,
  StdDlg,
  MsgBox,
  App,
  Memory,
  CmdFile,
  NewEdit;


VAR

  Clip_Window : NewEdit.PEditWindow;      { Object to hold the clip board. }

  { SPLCHK - Start. }

  procedure SpellIt;

  { SPLCHK - Stop. }

  procedure Deallocate_The_Clipboard;
  procedure Deallocate_The_Editor;

  procedure Initialize_The_Clipboard;
  procedure Initialize_The_Editor;

  function  Open_Editor (File_Name : Objects.FNameStr;
                         Visible   : Boolean) : NewEdit.PEditWindow;

  procedure Run_The_Editor;
  procedure Show_ClipBoard;



implementation



{ -------------------------------------------------------------------------- }



{ SPLCHK - Start. }



Procedure SpellIt;


  { ---------------------------------------------------------------------- }
  {                                                                        }
  { This procedure demonstrates how to close an editor window for external }
  { file processing, and then reopen the window to continue editing.  The  }
  { procedure assumes an external spell checking program will be used.     }
  {                                                                        }
  { ---------------------------------------------------------------------- }


VAR

  SpellFileName : Objects.FNameStr; { Determines what the filename is. }

begin


  { ----------------------------------------------------------- }
  {                                                             }
  { First we check to make sure that the current window is in   }
  { fact an editor window.  We need to do this so you don't run }
  { the spelling checker unless an edit window is being used.   }
  {                                                             }
  { ----------------------------------------------------------- }


  if typeof (Desktop^.Current^) = typeof (TEditWindow) then
    begin


      { --------------------------------------------------------- }
      {                                                           }
      { OK, now get the filename associated with the current edit }
      { window.  Then send a message to NewEdit.TFileEditor's     }
      { HandleEvent method to write the data to disk and close    }
      { the window.  You need to *REMOVE* the dialog and insert   }
      { your spell checking code in its place.  Last of all you   }
      { call Open_Editor to reopen your edit window.              }
      {                                                           }
      { --------------------------------------------------------- }


      SpellFileName := NewEdit.PEditWindow (Desktop^.Current)^.Editor^.FileName;

      Message (Desktop^.Current,
               Drivers.evCommand,
               NewEdit.cmSaveDone,
               nil);

      Msgbox.MessageBox (^C'Now your spellchecker does its thing.',
                         nil, MsgBox.mfInformation + MsgBox.mfOKButton);

      Open_Editor (SpellFileName, True);

    end;


end; { SpellIt }



{ SPLCHK - Stop. }



{ -------------------------------------------------------------------------- }



function Execute_Dialog (P : Dialogs.PDialog; Data : Pointer) : Word;


  { -------------------------------------------------------- }
  {                                                          }
  { This function places the editor dialogs on the desktop   }
  { and takes care of seting/getting data options from them. }
  {                                                          }
  { -------------------------------------------------------- }


VAR

  Result : Word; { Holds result of trying to ExecView onto Desktop. }

begin

  Result := Views.cmCancel;

  P := PDialog (App.Application^.ValidView (P));

  if P <> nil then
  begin

    if Data <> nil then
      P^.SetData (Data^);

    Result := App.DeskTop^.ExecView (P);

    if (Result <> Views.cmCancel) and (Data <> nil) then
      P^.GetData (Data^);

    Dispose (P, Done);

  end;

  Execute_Dialog := Result;


end; { Execute_Dialog }



{ -------------------------------------------------------------------------- }



function Do_Edit_Dialog (Dialog : Integer; Info : Pointer) : Word; far;


  { ---------------------------------------------------------- }
  {                                                            }
  { This function creates the appropriate editor dialog boxes. }
  {                                                            }
  { ---------------------------------------------------------- }


VAR

  Y_Position : Word; { Local variable to ensure ALL dialogs start in same spot. }



  { ------------------------------------------------------------------------ }



  function Create_Find_Dialog : Dialogs.PDialog;


    { ----------------------------------------------------------- }
    {                                                             }
    { This is a local procedure that creates the FIND dialog box. }
    {                                                             }
    { ----------------------------------------------------------- }


  VAR

    D        : Dialogs.PDialog;
    R        : TRect;
    Sub_View : Views.PView;

  begin

    R.Assign (21, Y_Position, 58, Y_Position + 11);
    D := New (Dialogs.PDialog, Init (R, 'Find'));

    with D^ do
    begin

      R.Assign (3, 3, 32, 4);
      Sub_View := New (Dialogs.PInputLine, Init (R, 80));
      Sub_View^.HelpCtx := CmdFile.hcDFindText;
      Insert (Sub_View);

      R.Assign (2, 2, 15, 3);
      Insert (New (Dialogs.PLabel, Init (R, '~T~ext to find', Sub_View)));
      R.Assign (32, 3, 35, 4);
      Insert (New (Dialogs.PHistory, Init (R, Dialogs.PInputLine (Sub_View), 10)));

      R.Assign (3, 5, 35, 7);
      Sub_View := New (Dialogs.PCheckBoxes, Init (R,
        NewSItem ('~C~ase sensitive',
        NewSItem ('~W~hole words only',
      nil))));
      Sub_View^.HelpCtx := CmdFile.hcCCaseSensitive;
      Insert (Sub_View);

      R.Assign (7, 8, 17, 10);
      Sub_View := New (Dialogs.PButton, Init (R, 'O~K~', Views.cmOk, Dialogs.bfDefault));
      Sub_View^.HelpCtx := CmdFile.hcDOk;
      Insert (Sub_View);

      Inc (R.A.X, 13);
      Inc (R.B.X, 13);
      Sub_View := New (Dialogs.PButton, Init (R, 'Cancel', Views.cmCancel, Dialogs.bfNormal));
      Sub_View^.HelpCtx := CmdFile.hcDCancel;
      Insert (Sub_View);

      SelectNext (False);

    end;

    Create_Find_Dialog := D;


  end; { Create_Find_Dialog }



  { ------------------------------------------------------------------------ }



  function Create_Replace_Dialog : Dialogs.PDialog;


    { --------------------------------------------------------------------- }
    {                                                                       }
    { This is a local procedure that creates the SEARCH/REPLACE dialog box. }
    {                                                                       }
    { --------------------------------------------------------------------- }


  VAR

    D        : Dialogs.PDialog;
    R        : TRect;
    Sub_View : Views.PView;

  begin

    R.Assign (20, Y_Position, 60, Y_Position + 16);
    D := New (Dialogs.PDialog, Init (R, 'Replace'));

    with D^ do
    begin

      R.Assign (2, 2, 15, 3);
      Insert (New (Dialogs.PLabel, Init (R, '~T~ext to find', Sub_View)));

      R.Assign (3, 3, 34, 4);
      Sub_View := New (Dialogs.PInputLine, Init (R, 80));
      Sub_View^.HelpCtx := CmdFile.hcDFindText;
      Insert (Sub_View);

      R.Assign (34, 3, 37, 4);
      Insert (New (Dialogs.PHistory, Init (R, Dialogs.PInputLine (Sub_View), 10)));

      R.Assign (2, 5, 12, 6);
      Insert (New (Dialogs.PLabel, Init (R, '~N~ew text', Sub_View)));

      R.Assign (3, 6, 34, 7);
      Sub_View := New (Dialogs.PInputLine, Init (R, 80));
      Sub_View^.HelpCtx := CmdFile.hcDReplaceText;
      Insert (Sub_View);

      R.Assign (34, 6, 37, 7);
      Insert (New (Dialogs.PHistory, Init (R, Dialogs.PInputLine (Sub_View), 11)));

      R.Assign (3, 8, 37, 12);
      Sub_View := New (Dialogs.PCheckBoxes, Init (R,
        NewSItem ('~C~ase sensitive',
        NewSItem ('~W~hole words only',
        NewSItem ('~P~rompt on replace',
        NewSItem ('~R~eplace all',
      nil))))));
      Sub_View^.HelpCtx := CmdFile.hcCCaseSensitive;
      Insert (Sub_View);

      R.Assign (8, 13, 18, 15);
      Sub_View := New (Dialogs.PButton, Init (R, 'O~K~', Views.cmOk, Dialogs.bfDefault));
      Sub_View^.HelpCtx := CmdFile.hcDOk;
      Insert (Sub_View);

      R.Assign (22, 13, 32, 15);
      Sub_View := New (Dialogs.PButton, Init (R, 'Cancel', Views.cmCancel, Dialogs.bfNormal));
      Sub_View^.HelpCtx := CmdFile.hcDCancel;
      Insert (Sub_View);

      SelectNext (False);

    end;

    Create_Replace_Dialog := D;


  end; { Create_Replace_Dialog }



  { ------------------------------------------------------------------------ }



  { JLINE - Start. }

  function Jump_Line_Dialog : Dialogs.PDialog;


    { ---------------------------------------------------- }
    {                                                      }
    { This is a local function that brings up a dialog box }
    { that asks the user which line number to jump to.     }
    {                                                      }
    { ---------------------------------------------------- }


  VAR

    Line_Dialog : Dialogs.PDialog;
    R           : TRect;
    Sub_View    : Views.PView;

  Begin

    R.Assign (27, Y_Position, 53, Y_Position + 8);
    Line_Dialog := New (Dialogs.PDialog, Init (R, 'Jump To'));

    with Line_Dialog^ do
      begin

        R.Assign (3, 2, 15, 3);
        Sub_View := New (Dialogs.PStaticText, Init (R, 'Line Number:'));
        Insert (Sub_View);

        R.Assign (15, 2, 21, 3);
        Sub_View := New (Dialogs.PInputLine, Init (R, 4));
        Sub_View^.HelpCtx := CmdFile.hcDLineNumber;
        Insert (Sub_View);

        R.Assign (21, 2, 24, 3);
        Insert (New (Dialogs.PHistory, Init (R, Dialogs.PInputLine (Sub_View), 12)));

        R.Assign (2, 5, 12, 7);
        Sub_View := New (Dialogs.PButton, Init (R, '~O~K', Views.cmOK, Dialogs.bfDefault));
        Sub_View^.HelpCtx := CmdFile.hcDOk;
        Insert (Sub_View);

        R.Assign (14, 5, 24, 7);
        Sub_View := New (Dialogs.PButton, Init (R, '~C~ancel', Views.cmCancel, Dialogs.bfNormal));
        Sub_View^.HelpCtx := CmdFile.hcDCancel;
        Insert (Sub_View);

        SelectNext (False);

      end;

    Jump_Line_Dialog := Line_Dialog;

  end; { Jump_Line_Dialog; } { Added dialog to allow user to jump to line number. }

  { JLINE - Stop. }



  { ------------------------------------------------------------------------ }



  { REFDOC - Start. }

  function Reform_Doc_Dialog : Dialogs.PDialog;


    { ----------------------------------------------------- }
    {                                                       }
    { This is a local function that brings up a dialog box  }
    { that asks where to start reformatting the document.   }
    {                                                       }
    { ----------------------------------------------------- }


  VAR

    R             : TRect;
    Reform_Dialog : Dialogs.PDialog;
    Sub_View      : Views.PView;

  Begin

    R.Assign (24, Y_Position, 56, Y_Position + 11);
    Reform_Dialog := New (Dialogs.PDialog, Init (R, 'Reformat Document'));

    with Reform_Dialog^ do
      begin

        R.Assign (2, 2, 30, 3);
        Sub_View := New (Dialogs.PStaticText, Init (R, 'Please select where to begin'));
        Insert (Sub_View);

        R.Assign (3, 3, 29, 4);
        Sub_View := New (Dialogs.PStaticText, Init (R, 'reformatting the document:'));
        Insert (Sub_View);

        R.Assign (50, 5, 68, 6);
        Sub_View := New (Dialogs.PLabel, Init (R, 'Reformat Document', Sub_View));
        Insert (Sub_View);

        R.Assign (5, 5, 26, 7);
        Sub_View := New (Dialogs.PRadioButtons, Init (R,
          NewSItem ('Current Line',
          NewSItem ('Entire Document',
        Nil))));
        Sub_View^.HelpCtx := CmdFile.hcDReformDoc;
        Insert (Sub_View);

        R.Assign (4, 8, 14, 10);
        Sub_View := New (Dialogs.PButton, Init (R, '~O~K', Views.cmOK, Dialogs.bfDefault));
        Sub_View^.HelpCtx := CmdFile.hcDOk;
        Insert (Sub_View);

        R.Assign (17, 8, 27, 10);
        Sub_View := New (Dialogs.PButton, Init (R, '~C~ancel', Views.cmCancel, Dialogs.bfNormal));
        Sub_View^.HelpCtx := CmdFile.hcDCancel;
        Insert (Sub_View);

        SelectNext (False);

      end;

      Reform_Doc_Dialog := Reform_Dialog;


  end; { Reform_Doc_Dialog }

  { REFDOC - Stop. }



  { ------------------------------------------------------------------------ }



  { RMSET - Start. }
  { WRAP  - Start. }

  function Right_Margin_Dialog : Dialogs.PDialog;


    { ---------------------------------------------------- }
    {                                                      }
    { This is a local function that brings up a dialog box }
    { that allows the user to change the Right_Margin.     }
    {                                                      }
    { ---------------------------------------------------- }


  VAR

    R         : TRect;
    RM_Dialog : Dialogs.PDialog;
    Sub_View  : Views.PView;

  Begin

    R.Assign (27, Y_Position, 53, Y_Position + 8);
    RM_Dialog := New (Dialogs.PDialog, Init (R, 'Right Margin'));

    with RM_Dialog^ do
      begin

        R.Assign (5, 2, 13, 3);
        Sub_View := New (Dialogs.PStaticText, Init (R, 'Setting:'));
        Insert (Sub_View);

        R.Assign (13, 2, 18, 3);
        Sub_View := New (Dialogs.PInputLine, Init (R, 3));
        Sub_View^.HelpCtx := CmdFile.hcDRightMargin;
        Insert (Sub_View);

        R.Assign (18, 2, 21, 3);
        Insert (New (Dialogs.PHistory, Init (R, Dialogs.PInputLine (Sub_View), 13)));

        R.Assign (2, 5, 12, 7);
        Sub_View := New (Dialogs.PButton, Init (R, 'OK', Views.cmOK, Dialogs.bfDefault));
        Sub_View^.HelpCtx := CmdFile.hcDOk;
        Insert (Sub_View);

        R.Assign (14, 5, 24, 7);
        Sub_View := New (Dialogs.PButton, Init (R, '~C~ancel', Views.cmCancel, Dialogs.bfNormal));
        Sub_View^.HelpCtx := CmdFile.hcDCancel;
        Insert (Sub_View);

        SelectNext (False);

      end;

    Right_Margin_Dialog := RM_Dialog;

  end; { Right_Margin_Dialog; }

  { WRAP  - Stop. }
  { RMSET - Stop. } { Added dialog to adjust right margin position. }



  { ------------------------------------------------------------------------ }



  { PRETAB - Start. }

  function Tab_Stop_Dialog : Dialogs.PDialog;


    { ---------------------------------------------------- }
    {                                                      }
    { This is a local function that brings up a dialog box }
    { that allows the user to set their own tab stops.     }
    {                                                      }
    { ---------------------------------------------------- }


  VAR

    Index      : Integer;          { Local Indexing variable.                 }
    R          : TRect;
    Tab_Dialog : Dialogs.PDialog;
    Sub_View   : Views.PView;
    Tab_Stop   : String[2];        { Local string to print tab column number. }

  Begin

    R.Assign (0, Y_Position, 80, Y_Position + 8);
    Tab_Dialog := New (Dialogs.PDialog, Init (R, 'Tab Settings'));

    with Tab_Dialog^ do
      begin

        R.Assign (2, 2, 77, 3);
        Sub_View := New (Dialogs.PStaticText, Init (R,
                    ' ....|....|....|....|....|....|....|....|....|....|....|....|....|....|....'));
        Insert (Sub_View);

        for Index := 1 to 7 do
          begin
            R.Assign (Index * 10 + 1, 1, Index * 10 + 3, 2);
            Str (Index * 10, Tab_Stop);
            Sub_View := New (Dialogs.PStaticText, Init (R, Tab_Stop));
            Insert (Sub_View);
          end;

        R.Assign (2, 3, 78, 4);
        Sub_View := New (Dialogs.PInputLine, Init (R, 74));
        Sub_View^.HelpCtx := CmdFile.hcDTabStops;
        Insert (Sub_View);

        R.Assign (38, 5, 41, 6);
        Insert (New (Dialogs.PHistory, Init (R, Dialogs.PInputLine (Sub_View), 14)));

        R.Assign (27, 5, 37, 7);
        Sub_View := New (Dialogs.PButton, Init (R, '~O~K', Views.cmOK, Dialogs.bfDefault));
        Sub_View^.HelpCtx := CmdFile.hcDOk;
        Insert (Sub_View);

        R.Assign (42, 5, 52, 7);
        Sub_View := New (Dialogs.PButton, Init (R, '~C~ancel', Views.cmCancel, Dialogs.bfNormal));
        Sub_View^.HelpCtx := CmdFile.hcDCancel;
        Insert (Sub_View);

        SelectNext (False);

      end;

    Tab_Stop_Dialog := Tab_Dialog;

  end { Tab_Stop_Dialog };

  { PRETAB - Stop. } { Added dialog to allow re-setting tab stops. }



  { ------------------------------------------------------------------------ }



VAR

  R : TRect;
  T : TPoint;


begin { Do_Edit_Dialog }



  { --------------------------------------------------------------------- }
  {                                                                       }
  { I want the dialog boxes to appear in relatively the same screen area, }
  { regardless if the user is in normal or 43/50 line screen mode.        }
  {                                                                       }
  { --------------------------------------------------------------------- }


  if Drivers.ScreenMode >= Drivers.smFont8x8 then
    Y_Position := 7
  else
    Y_Position := 3;



  { ------------------------------------------------------ }
  {                                                        }
  { Figure out which dialog we want to put on the desktop. }
  {                                                        }
  { ------------------------------------------------------ }


  case Dialog of

    edCreateError:
      Do_Edit_Dialog := MsgBox.MessageBox ('Error creating file %s.',
                        @Info, MsgBox.mfError + MsgBox.mfOkButton);

    edFind:
      Do_Edit_Dialog := Execute_Dialog (Create_Find_Dialog, Info);

    edOutOfMemory:
      Do_Edit_Dialog := MsgBox.MessageBox (^C'Not enough memory available.',
                        nil, MsgBox.mfError + MsgBox.mfOkButton);

    edReadError:
      Do_Edit_Dialog := MsgBox.MessageBox ('Error reading file %s.',
                        @Info, MsgBox.mfError + MsgBox.mfOkButton);

    edReplace:
      Do_Edit_Dialog := Execute_Dialog (Create_Replace_Dialog, Info);

    edSaveAs:
      Do_Edit_Dialog := Execute_Dialog (New (StdDlg.PFileDialog, Init ('*.*',
                       'Save file as', '~N~ame', StdDlg.fdOkButton, 101)), Info);

    edSaveModify:
      Do_Edit_Dialog := MsgBox.MessageBox ('%s has been modified. Save?',
                        @Info, MsgBox.mfInformation + MsgBox.mfYesNoCancel);

    edSaveUntitled:
      Do_Edit_Dialog := Msgbox.MessageBox (^C'Save untitled file?',
                        nil, MsgBox.mfInformation + MsgBox.mfYesNoCancel);

    edSearchFailed:
      Do_Edit_Dialog := MsgBox.MessageBox (^C'Search string not found.',
                        nil, MsgBox.mfError + MsgBox.mfOkButton);

    edWriteError:
      Do_Edit_Dialog := MsgBox.MessageBox ('Error writing file %s.',
                        @Info, MsgBox.mfError + MsgBox.mfOkButton);

    edReplacePrompt:
      begin

        { Avoid placing the dialog on the same line as the cursor }

        R.Assign (0, 1, 40, 8);
        R.Move ((App.Desktop^.Size.X - R.B.X) div 2, 0);
        Desktop^.MakeGlobal (R.B, T);
        Inc (T.Y);

        if TPoint (Info).Y <= T.Y then
          R.Move (0, Desktop^.Size.Y - R.B.Y - 2);

        Do_Edit_Dialog := Msgbox.MessageBoxRect (R, ^C'Replace this occurence?',
                          nil, MsgBox.mfYesNoCancel + MsgBox.mfInformation);

      end;



    { JLINE - Start. }

    edJumpToLine:
      Do_Edit_Dialog := Execute_Dialog (Jump_Line_Dialog, Info);

    { JLINE - Stop. } { Added new cases to allow jumping to a line number. }



    { PRETAB - Start. }

    edSetTabStops:
      Do_Edit_Dialog := Execute_Dialog (Tab_Stop_Dialog, Info);

    { PRETAB - Stop. } { Added new cases to support re-setting tab stops. }



    { WRAP - Start. }



    edPasteNotPossible:
      Do_Edit_Dialog := MsgBox.MessageBox (^C'WORDWRAP ON:  Paste not possible' + #13
                                           + ' in current margins when at end'  + #13
                                           + ' of line.',
                        nil, MsgBox.mfError + MsgBox.mfOkButton);



    { REFDOC - Start. }

    edReformatDocument:
      Do_Edit_Dialog := Execute_Dialog (Reform_Doc_Dialog, Info);

    { REFDOC - Stop. }



    edReformatNotAllowed:
      Do_Edit_Dialog := MsgBox.MessageBox (^C'You must turn on wordwrap' + #13
                                          +^C'before you can reformat.',
                        nil, MsgBox.mfError + MsgBox.mfOkButton);

    edReformNotPossible:
      Do_Edit_Dialog := MsgBox.MessageBox (^C'Paragraph reformat not possible.'   + #13
                                           + ' while trying to wrap current line' + #13
                                           + ' with current margins.',
                        nil, MsgBox.mfError + MsgBox.mfOkButton);

    edReplaceNotPossible:
      Do_Edit_Dialog := MsgBox.MessageBox (^C'WORDWRAP ON:  Replace not possible' + #13
                                           + ' in current margins when at end of' + #13
                                           + ' line.',
                        nil, MsgBox.mfError + MsgBox.mfOkButton);



    { RMSET- Start. }

    edRightMargin:
      Do_Edit_Dialog := Execute_Dialog (Right_Margin_Dialog, Info);

    { RMSET - STOP. } { Added new cases to support right margin settings. }



    edWrapNotPossible:
      Do_Edit_Dialog := MsgBox.MessageBox (^C'WORDWRAP ON:  Wordwrap not possible' + #13
                                           + ' in current margins with continuous' + #13
                                           + ' line.',
                         nil, MsgBox.mfError + MsgBox.mfOKButton);



    { WRAP - Stop. } { Added new cases to support wordwrap and paragraph reformatting. }


  else

    MsgBox.MessageBox (^C'Unknown dialog requested!', nil,
                       MsgBox.mfError + MsgBox.mfOkButton);

  end;


end; { Do_Edit_Dialog }



{ -------------------------------------------------------------------------- }



procedure Deallocate_The_Clipboard;


  { ----------------------------------------------------- }
  {                                                       }
  { This procedure disposes of the clipboard.  It is used }
  { by the NEDEMO program when saving a desktop file.     }
  {                                                       }
  { ----------------------------------------------------- }


begin

  if Clip_Window = nil then
    Exit;

  Dispose (NewEdit.Clipboard, Done);
  NewEdit.Clipboard := nil;
  Dispose (Clip_Window, Done);


end; { Deallocate_The_Clipboard }



{ -------------------------------------------------------------------------- }



procedure Deallocate_The_Editor;


  { --------------------------------------------------------- }
  {                                                           }
  { This procedure deallocates the editor buffer from memory. }
  {                                                           }
  { --------------------------------------------------------- }


begin

  MaxHeapSize := 0;
  EditorDialog := Nil;


end; { Deallocate_The_Editor }



{ -------------------------------------------------------------------------- }



procedure Initialize_The_Clipboard;



  { ----------------------------------------------------- }
  {                                                       }
  { Set up a clipboard so editor can cut and paste text.  }
  { We place this here because we also need to reallocate }
  { a new clipboard everytime we save a desktop to disk.  }
  {                                                       }
  { ----------------------------------------------------- }


begin

  Clip_Window := Open_Editor('', False);

  if Clip_Window <> nil then
    begin
      NewEdit.Clipboard := Clip_Window^.Editor;
      NewEdit.Clipboard^.CanUndo := False;
      Clip_Window^.HelpCtx := CmdFile.hcClipBoard;
    end;


end; { Initialize_The_Clipboard }



{ -------------------------------------------------------------------------- }



procedure Initialize_The_Editor;



  { ----------------------------------------------------------------- }
  {                                                                   }
  { This procedure sets aside a bit of memory for the editor buffers. }
  { MaxHeapSize must be the first thing you do prior to using any     }
  { heap.  This is stressed in the BP TV docs on the editor.          }
  {                                                                   }
  { ----------------------------------------------------------------- }


Begin

  MaxHeapSize := 32 * (1024 div 16);

end; { Initialize_The_Editor }



{ -------------------------------------------------------------------------- }



function Open_Editor (File_Name : Objects.FNameStr; Visible : Boolean) : NewEdit.PEditWindow;


  { ------------------------------------------------------- }
  {                                                         }
  { This is the actual function that opens up the edit view }
  { and places it on the desktop.                           }
  {                                                         }
  { ------------------------------------------------------- }


VAR

  P : Views.PView;
  R : TRect;

begin

  DeskTop^.GetExtent (R);
  P := Application^.ValidView (New (NewEdit.PEditWindow,
       Init (R, File_Name, wnNoNumber)));

  if P <> nil then
    begin

      if not Visible then
        begin
          P^.Hide;
          P^.Options := P^.Options and not Views.ofTileable;
        end
      else



        { ------------------------------------------------------------- }
        {                                                               }
        { This is a demonstration on how you can type cast variables    }
        { and thereby override their NEWEDIT defaults.  If you really   }
        { wanted to get fancy, you could add the appropriate parameters }
        { to the Open_Editor function call and thereby have different   }
        { defaults for each window.                                     }
        {                                                               }
        { ------------------------------------------------------------- }


        with NewEdit.PEditWindow (P)^ do
          begin
            Editor^.AutoIndent := True;
            Editor^.Word_Wrap := True;
            Editor^.Right_Margin := 76;
          end;

        Desktop^.Insert (P);

        Message (P, Drivers.evBroadcast, NewEdit.cmBludgeonStats, nil);

      end;

  Open_Editor := NewEdit.PEditWindow (P);


end; { Open_Editor }



{ -------------------------------------------------------------------------- }



procedure Run_The_Editor;


  { --------------------------------------------------------------- }
  {                                                                 }
  { This procedure is a "front end" to the Open_Editor function.    }
  { It brings up a dialog box that asks the user which file to use. }
  {                                                                 }
  { --------------------------------------------------------------- }


VAR

  D        : Dialogs.PDialog;
  FileName : Objects.FNameStr;

begin

  FileName := '*.*';

  D := new (StdDlg.PFileDialog, Init ('*.*', 'Edit A File',
            '~N~ame', StdDlg.fdOpenButton, 100));

  D^.HelpCtx := CmdFile.hcDName;

  if Execute_Dialog (D, @FileName) <> Views.cmCancel then
    Open_Editor (FileName, True);


end; { Run_The_Editor }



{ -------------------------------------------------------------------------- }



procedure Show_ClipBoard;

begin

  Clip_Window^.Select;
  Clip_Window^.Show;


end; { Show_ClipBoard }



{ -------------------------------------------------------------------------- }



begin { EditPkg }



  { --------------------------------------------- }
  {                                               }
  { Instantiate NewEdit.EditorDialog immediately. }
  { If you don't do it here, desktops loaded at   }
  { runtime will not have access to dialogs.      }
  {                                               }
  { --------------------------------------------- }


  NewEdit.EditorDialog := Do_Edit_Dialog;


end. { Unit EditPkg }
