{$X+,O+,F+,R+}

{ Unit X_Dialog                                                 }
{   Extended Dialog Boxes                                       }
{                                                               }
{ Donn Aiken, 71150,2011                                        }
{ May 17, 1991                                                  }

{ Small example program to show how to create what functions as }
{ a dialog box that scrolls.                                    }
{ Look at TMyListBox object to see how it's done.               }
{                                                               }
{ Based somewhat upon the ListBox example without a scrollbar   }
{ by Mike Savage, 71121,3137.                                   }
{                                                               }


unit x_dialog;

interface

uses Objects, Views, Dialogs, Drivers;

const
  TBoxMaxSize = 63;

type
  PStringO = ^TStringO;
  TStringO = object (TObject)
    Item : PString;
    constructor Init (s : string);
    destructor  Done; virtual;
  end;


  PBoxData   = ^TBoxData;
  TBoxData   = object (TObject)
    PList : PCollection;
    Sel   : array [0..TBoxMaxSize] of boolean;
    constructor init;
    procedure   clear;  virtual;
    function    empty : boolean; virtual;
  end;


  PMyListBox = ^TMyListBox;
  TMyListBox = object(TListBox)
    Selected  : array [0..TBoxMaxSize] of boolean;
    CheckChar : Char;

    constructor Init     (var Bounds      : TRect;
                              CChar       : Char;
                              Cols        : Byte;
                              AVScrollBar : PScrollBar);

    destructor Done; virtual;

    function  DataSize : Word; virtual;
    procedure GetData     (var Rec); virtual;
    procedure HandleEvent (var Event: TEvent); virtual;
    procedure SetData     (var Rec); virtual;
    function  GetText     (Item: Integer; MaxLen: Integer): String; virtual;
    procedure SelectItem  (item : integer); virtual;
  end;

var
  TC : PCollection;

implementation

constructor TStringO.Init (S : String);

begin
  TObject.Init;
  Item := NewStr(S);
end;

destructor TStringO.Done;

begin
  DisposeStr (Item);
  TObject.Done;
end;


constructor TBoxData.Init;

var
  i : integer;

begin
  TObject.Init;
  PList := Nil;
  TBoxData.Clear;
end;

procedure TBoxData.Clear;

var
  i : integer;

begin
  for i := 0 to TBoxMaxSize do
    Sel[i] := False;
end;

function TBoxData.Empty : boolean;

var
  i : integer;
  b : boolean;

begin
  b := true;
  for i := 0 to TBoxMaxSize do
    if (sel[i]) then b := false;
  Empty := b;
end;

{ TMyListBox }
constructor TMyListBox.Init (var  Bounds : TRect;
                                   CChar : Char;
                                   Cols  : Byte;
                             AVScrollBar : PScrollBar);

var
  i   : byte;
  R   : TRect;
  mw,
  ml  : Byte;

begin
  TListBox.Init (Bounds, Cols, AVScrollBar);
  CheckChar := CChar;
  GrowMode  := gfGrowHiX or gfGrowHiY;
  for i := 0 to TBoxMaxSize do
    Selected[i] := false;
end;

destructor TMyListBox.Done;

begin
  TListBox.Done;
end;

function  TMyListBox.DataSize: Word;

begin
  DataSize := Sizeof(TBoxData);
end;

procedure TMyListBox.GetData (var Rec);

begin
  PBoxData(Rec)^.PList := List;
  Move(Selected, PBoxData(Rec)^.Sel, sizeof(Selected));
end;

procedure TMyListBox.HandleEvent (var Event: TEvent);

var
  p : TPoint;
  r : TRect;
  current_column : byte;
  i : byte;

begin
  if (Event.What = evMouseDown) then
    begin
      GetBounds (R);
      MakeLocal(Event.Where, P);
      current_column := P.X * NumCols div Size.X;
      if (P.Y + Current_Column * Size.Y = Focused - TopItem) then
        begin
          selected[Focused] := not(Selected[Focused]);
          drawview;
          ClearEvent (Event);
        end
    end;
  TListBox.HandleEvent (Event);
  Drawview;
end;


procedure TMyListBox.SetData (var Rec);

begin
  move (PBoxData(Rec)^.Sel, Selected, Sizeof(Selected));
  TListBox.NewList(PBoxData(Rec)^.PList);
end;


function  TMyListBox.GetText (Item: Integer; MaxLen: Integer): String;

var
  s : string;

begin
  if (List = Nil) then
    GetText := ''
  else
    begin
      s := Copy (PStringO(List^.At(Item))^.Item^, 1, MaxLen-5);
      if (Selected[Item]) then
        GetText := '[' + CheckChar + '] ' + s
      else
        GetText := '[ ] ' + s;
    end;
end;


procedure TMyListBox.SelectItem(Item : integer);

begin
  TListBox.SelectItem(Item);
  Selected[item] := not(Selected[item]);
  Drawview;
end;

end.