Unit  DMX_WIND;

{$V- }

(*
  This unit contains some pretty cheap setup procedures for making windows.
  By "pretty cheap", I mean that this is not meant to be very fancy.

  My actual intention is to demonstrate the various uses for the DMX unit.
  I am working from the premise that programmers may already have windowing
  procedures and prefer not to use redundant code.

  These procedures allow for one window-layer to be over the current text.

 *)

interface


uses   Crt, DMX2;


       procedure SaveWindow;
       procedure RestoreWindow;


implementation


type   screentype  =  array [0..3999] of char;
       screenunit  =  record
                        Scr                 : screentype;
                        x,y,Attr,wmin,wmax  : word;
                      end;

var    screencage  :  screenunit;
       ScreenPtr   : ^screentype;


  {  }


procedure SaveWindow;
begin
  With screencage do
    begin
    x    := WhereX;
    y    := WhereY;
    Attr := TextAttr;
    wmin := WindMin;
    wmax := WindMax;
    Move (ScreenPtr^, Scr, sizeof (Scr));  { move video memory }
    end;
end;


procedure RestoreWindow;
begin
  With screencage do
    begin
    TextAttr := Attr;
    WindMin  := wmin;
    WindMax  := wmax;
    Move (Scr, ScreenPtr^, sizeof (Scr));  { move video memory }
    GotoXY (x,y);
    end;
end;


  {  }


Begin
  ScreenPtr := ptr (VSeg,0);  { VSeg is an internal DMX variable }
End.

