{**********************************************************************}
{*                                                                    *}
{* 		 Microworks Sample Application                           	     	*}
{*                                                                    *}
{*		 for Borland Pascal v7.0 and Turbo Pascal for Windows v1.5   		*}
{*                                                                    *}
{*     Copyright 1992-93 Jeff Franks (Microworks) Sydney, Australia.  *}
{*                                                                    *}
{*		 You are free to use, modify, reproduce and distribute the      *}
{*		 Sample Files (and/or any modified version) in any way you      *}
{*		 find useful.						                                        *}
{*                                                                    *}
{**********************************************************************}

{*** Introduction

	Application    := Basic MWCC DlgWindow

	Files          := MWCCDlgW.pas and MWCCDlgW.res

	Units Required := MObjects and MWCC.dll

	Tabs           := 2

	Screen         := 800 * 600

	Date           := August, 1993.

	The TMWCCDlgWindow object is a very versatile window. The least thing it does is draw
	a raised border around the client area. By changing the bitmap name or the boolean
	values in the InitMainWindow method you can give the client area a BWCC or MWCC pattern,
	add an SFX style frame or prevent the window from being resized. The resource file
	template has a thick frame. If you don't plan to add an SFX style frame you could give
	the template a modal frame or no frame.

	Warning - Don't overide any inherited methods (not listed here) without first consulting
	          the documentation.

***}

program MWCCDlgW;

{$R MWCCDlgW.res}

uses WinTypes, WinProcs, MObjects,
		 {$IFDEF Ver15}
			 WObjects;
		 {$ELSE}
			 Objects, OWindows, ODialogs;
		 {$ENDIF}

const

	AppName : PChar = 'NewMWCCDlgWindow';

type

	PNewMWCCApplication = ^TNewMWCCApplication;
	TNewMWCCApplication = object(TApplication)
		procedure InitMainWindow; virtual;
	end;

	PNewMWCCDlgWindow = ^TNewMWCCDlgWindow;
	TNewMWCCDlgWindow = object(TMWCCDlgWindow)
		constructor Init(AParent: PWindowsObject; AName, ABmp: PChar);
	  destructor Done; virtual;
		function  GetClassName : PChar; virtual;
		procedure GetWindowClass(var AWndClass: TWndClass); virtual;
		procedure SetUpWindow; virtual;
		procedure WMCtlColor (var Msg: TMessage); virtual wm_First + wm_CtlColor;
		procedure WMPaint (var Msg: TMessage); virtual wm_First + wm_Paint;
		procedure WMNCPaint (var Msg: TMessage); virtual wm_First + wm_NCPaint;
		procedure WMActivate (var Msg: TMessage); virtual wm_First + wm_Activate;
		procedure WMNCActivate (var Msg: TMessage); virtual wm_First + wm_NCActivate;
		procedure WMActivateApp (var Msg: TMessage); virtual wm_First + wm_ActivateApp;
		procedure WMGetMinMaxInfo (var Msg: TMessage); virtual wm_First + wm_GetMinMaxInfo;
	end;

{********** TNewMWCCApplication **********}

procedure TNewMWCCApplication.InitMainWindow;
begin
	MainWindow := New(PNewMWCCDlgWindow, Init(nil, 'DlgWindow', nil));
end;

{********** TNewMWCCDlgWindow **********}

constructor TNewMWCCDlgWindow.Init(AParent: PWindowsObject; AName, ABmp: PChar);
begin
	TMWCCDlgWindow.Init(AParent, AName, ABmp);
	{IsSizeable := False;}
	{SFXFrame := True;}
end;

destructor TNewMWCCDlgWindow.Done;
begin
	TMWCCDlgWindow.Done;
end;

function TNewMWCCDlgWindow.GetClassName;
begin
  GetClassName := AppName;
end;

procedure TNewMWCCDlgWindow.GetWindowClass(var AWndClass: TWndClass);
begin
	TMWCCDlgWindow.GetWindowClass(AWndClass);
end;

procedure TNewMWCCDlgWindow.SetUpWindow;
var
	X, Y, W, H: Integer;
begin
	TMWCCDlgWindow.SetUpWindow;
	X := GetSystemMetrics(sm_CXScreen) div 4;
	Y := GetSystemMetrics(sm_CYScreen) div 4;
	W := GetSystemMetrics(sm_CXScreen) div 2;
	H := GetSystemMetrics(sm_CYScreen) div 2;
	MoveWindow(HWindow, X, Y, W, H, True);
	SetWindowText(Hwindow, 'MWCC DlgWindow');
end;

procedure TNewMWCCDlgWindow.WMCtlColor (var Msg: TMessage);
begin
	TMWCCDlgWindow.WMCtlColor(Msg);
end;

procedure TNewMWCCDlgWindow.WMPaint (var Msg: TMessage);
begin
	TMWCCDlgWindow.WMPaint(Msg);
end;

procedure TNewMWCCDlgWindow.WMNCPaint (var Msg: TMessage);
begin
	TMWCCDlgWindow.WMNCPaint(Msg);
end;

procedure TNewMWCCDlgWindow.WMActivate (var Msg: TMessage);
begin
	TMWCCDlgWindow.WMActivate(Msg);
end;

procedure TNewMWCCDlgWindow.WMNCActivate (var Msg: TMessage);
begin
	TMWCCDlgWindow.WMNCActivate(Msg);
end;

procedure TNewMWCCDlgWindow.WMActivateApp (var Msg: TMessage);
begin
	TMWCCDlgWindow.WMActivateApp(Msg);
end;

procedure TNewMWCCDlgWindow.WMGetMinMaxInfo (var Msg: TMessage);
begin
	TMWCCDlgWindow.WMGetMinMaxInfo(Msg);
end;

{********** Main program **********}

var
	MWCCApp: TNewMWCCApplication;
begin
  MWCCApp.Init(AppName);
  MWCCApp.Run;
  MWCCApp.Done;
end.
