{**********************************************************************}
{*                                                                    *}
{* 		 Microworks Custom Control Object Library                    		*}
{*                                                                    *}
{*		 Version 1.03                                                 	*}
{*                                                                    *}
{*     Object Windows Library Extension for Borland Pascal v7.0       *}
{*                                                                    *}
{*     and Turbo Pascal for Windows v 1.5                             *}
{*                                                                    *}
{*		 MCommDlg : Common Dialog Unit                      		        *}
{*                                                                    *}
{*     Copyright 1992-93 Microworks (Jeff Franks) Sydney, Australia.  *}
{*                                                                    *}
{**********************************************************************}

unit MCommDlg;

{$C MOVEABLE DEMANDLOAD DISCARDABLE}

interface

uses Wintypes, WinProcs, CommDlg, MObjects,
		 {$IFDEF Ver15}
			 WObjects;
		 {$ELSE}
			 Objects, OWindows, ODialogs;
		 {$ENDIF}

type

	{********** Font Dialog **********}

	PFontStatic = ^TFontStatic;
	TFontStatic = object(TStatic)
		CRect : TRect;
		function  GetColor (Color: PChar): LongInt; virtual;
		function  CheckRect: Integer; virtual;
		procedure WMPaint (var Msg: TMessage); virtual wm_First + wm_Paint;
	end;

	PFontGroupBox = ^TFontGroupBox;
	TFontGroupBox = object(TGroupBox)
		constructor InitResource (AParent: PWindowsObject; AnId: Integer; AText: PChar);
		procedure SetupWindow; virtual;
		procedure WMCtlColor (var Msg: TMessage); virtual wm_First + wm_CtlColor;
		procedure WMPaint (var Msg: TMessage); virtual wm_First + wm_Paint;
	private
		Stat1 : PMWCCStatic;
		Stat2 : PFontStatic;
		CRect : TRect;
	end;

	PFontComboBox = ^TFontComboBox;
	TFontComboBox = object(TMWCCComboBox)
		procedure WMCommand (var Msg: TMessage); virtual wm_First + wm_Command;
	end;

	PFontCheckBox = ^TFontCheckBox;
	TFontCheckBox = object(TMWCCCheckBox)
		procedure BMSetCheck (var Msg: TMessage); virtual wm_First + bm_SetCheck;
	end;

	PChooseFontDlg = ^TChooseFontDlg;
	TChooseFontDlg = object(TDialog)
		OkBtn, CancelBtn : PMWCCBmpButton;
		constructor Init (AParent: PWindowsObject; AName: PChar; FData: PChooseFont);
		function  Create: Boolean; virtual;
		function  Execute: Integer; virtual;
		procedure SetUpWindow; virtual;
		procedure PrepareFontData; virtual;
		procedure WMCtlColor (var Msg: TMessage); virtual wm_First + wm_CtlColor;
		procedure WMDrawItem (var msg :TMessage); virtual wm_First + wm_DrawItem;
		procedure Ok (var msg :TMessage); virtual id_First + id_Ok;
		procedure Cancel (var msg :TMessage); virtual id_First + id_Cancel;
	private
		BMP, BkBrush       : HBitmap;
		CRect              : TRect;
		CB1, CB2, CB3, CB4 : PFontComboBox;
		GB1                : PMWCCGroupBox;
		GB2                : PFontGroupBox;
		Check1, Check2     : PFontCheckBox;
	end;

	PMWCCFontDlg = ^TMWCCFontDlg;
	TMWCCFontDlg = object(TChooseFontDlg)
		constructor Init (AParent: PWindowsObject; AName: PChar; FData: PChooseFont; ABmp: PChar);
		destructor Done; virtual;
		function 	GetClassName : PChar; virtual;
		procedure WMPaint (var Msg: TMessage); virtual wm_First + wm_Paint;
	end;

	PSFXFontDlg = ^TSFXFontDlg;
	TSFXFontDlg = object(TChooseFontDlg)
		constructor Init (AParent: PWindowsObject; AName: PChar; FData: PChooseFont);
		destructor Done; virtual;
		function 	GetClassName : PChar; virtual;
		procedure SetUpWindow; virtual;
		procedure WMPaint (var Msg: TMessage); virtual wm_First + wm_Paint;
		procedure WMNCPaint (var Msg: TMessage); virtual wm_First + wm_NCPaint;
		procedure WMNCCalcSize (var Msg: TMessage); virtual wm_First + wm_NCCalcSize;
		procedure WMActivate (var Msg: TMessage); virtual wm_First + wm_Activate;
		procedure WMNCActivate (var Msg: TMessage); virtual wm_First + wm_NCActivate;
		procedure WMActivateApp (var Msg: TMessage); virtual wm_First + wm_ActivateApp;
		procedure WMGetMinMaxInfo (var Msg: TMessage); virtual wm_First + wm_GetMinMaxInfo;
	private
		WinRect : TRect;
		szTitle : array[0..144] of char;
	end;

	{********** Filename Dialog **********}

	PFileNameDlg = ^TFileNameDlg;
	TFileNameDlg = object(TDialog)
		FilePath         : array[0..255] of Char;
		FileTitle        : array[0..12] of Char;
		OpenFileName     : TOpenFileName;
		OkBtn, CancelBtn : PMWCCBmpButton;
		constructor Init(AParent: PWindowsObject; AName: PChar; IsOpen: Boolean);
		function Create: Boolean; virtual;
		function Execute: Integer; virtual;
		function DlgTitle: PChar; virtual;
		function DefSpec: PChar; virtual;
    function DefExt: PChar; virtual;
    function DefSpecPos: Byte; virtual;
		function OpenFlags: Longint; virtual;
		function DoExec: Boolean; virtual;
		procedure WMCtlColor (var Msg: TMessage); virtual wm_First + wm_CtlColor;
		procedure WMDrawItem (var msg :TMessage); virtual wm_First + wm_DrawItem;
		procedure Ok(var msg :TMessage); virtual id_First + id_Ok;
		procedure Cancel(var msg :TMessage); virtual id_First + id_Cancel;
	private
		BMP, BkBrush : HBitmap;
		CBox         : PMWCCCheckBox;
		CB1, CB2     : PMWCCComboBox;
		EC           : PMWCCEdit;
		LB1, LB2   	 : PMWCCListBox;
		Open         : Boolean;
	end;

	PMWCCFileNameDlg = ^TMWCCFileNameDlg;
	TMWCCFileNameDlg = object(TFileNameDlg)
		constructor Init (AParent: PWindowsObject; AName, ABmp: PChar; IsOpen: Boolean);
		destructor Done; virtual;
		function 	GetClassName : PChar; virtual;
		procedure WMPaint (var Msg: TMessage); virtual wm_First + wm_Paint;
	private
		CRect : TRect;
		ST    : PMWCCEdit;
	end;

	PSFXFileNameDlg = ^TSFXFileNameDlg;
	TSFXFileNameDlg = object(TFileNameDlg)
		constructor Init (AParent: PWindowsObject; AName: PChar; IsOpen: Boolean);
		destructor Done; virtual;
		function 	GetClassName : PChar; virtual;
		procedure SetUpWindow; virtual;
		procedure WMPaint (var Msg: TMessage); virtual wm_First + wm_Paint;
		procedure WMNCPaint (var Msg: TMessage); virtual wm_First + wm_NCPaint;
		procedure WMNCCalcSize (var Msg: TMessage); virtual wm_First + wm_NCCalcSize;
		procedure WMActivate (var Msg: TMessage); virtual wm_First + wm_Activate;
		procedure WMNCActivate (var Msg: TMessage); virtual wm_First + wm_NCActivate;
		procedure WMActivateApp (var Msg: TMessage); virtual wm_First + wm_ActivateApp;
		procedure WMGetMinMaxInfo (var Msg: TMessage); virtual wm_First + wm_GetMinMaxInfo;
	private
		WinRect : TRect;
		szTitle : array[0..144] of char;
	end;

implementation

const

	idw_Stat1      = 56;
	idw_Stat2      = 57;
	HLib : THandle = 0;

var

	ColorRef : TColorRef;
	FontData : PChooseFont;
	FontText : PChar;

{********** TChooseFontDlg **********}

constructor TChooseFontDlg.Init(AParent: PWindowsObject; AName: PChar; Fdata: PChooseFont);
begin
	TDialog.Init(AParent, AName);
	DisableTransfer;
	FontData  := FData;
	CB1       := New(PFontComboBox, InitResource(@Self, 1136, 21));
	CB2       := New(PFontComboBox, InitResource(@Self, 1137, 21));
	CB3       := New(PFontComboBox, InitResource(@Self, 1138, 21));
	CB4       := New(PFontComboBox, InitResource(@Self, 1139, 21));
	GB1       := New(PMWCCGroupBox, InitResource(@Self, 1072, ' Effects'));
	GB2       := New(PFontGroupBox, InitResource(@Self, 1073, ' Sample'));
	Check1    := New(PFontCheckBox, InitResource(@Self, 1040));
	Check2    := New(PFontCheckBox, InitResource(@Self, 1041));
	if GetSystemMetrics(sm_CYSize) = 26 then
	begin
		OkBtn := New(PMWCCBmpButton, Init(@Self, id_Ok, 556, 34, False, 1, ctl_Flush));
		CancelBtn := New(PMWCCBmpButton, Init(@Self, id_Cancel, 556, 126, False, 2, ctl_Flush));
	end
	else
	begin
		OkBtn := New(PMWCCBmpButton, Init(@Self, id_ok, 424, 28, False, 1, ctl_Flush));
		CancelBtn := New(PMWCCBmpButton, Init(@Self, id_cancel, 424, 104, False, 2, ctl_Flush));
	end;
	with FData^ do
	begin
		ColorRef := rgbColors;
		if lCustData <> 0 then
			LongInt(FontText) := lCustData
		else
			FontText := 'AaBbYyZz';
	end;
end;

procedure TChooseFontDlg.PrepareFontData;
begin
	with FontData^ do
	begin
		lStructSize := sizeof(FontData^);
		HInstance   := System.HInstance;
		if Parent <> nil then
			 HWndOwner := Parent^.HWindow
		else
			 HWndOwner := 0;
		lpTemplateName := attr.Name;
		lCustData := Longint(@Self);
		if (lpTemplateName <> nil) then
			Flags := Flags or cf_EnableTemplate;
		Move(Self.Instance, lpfnHook, sizeOf(lpfnHook));
		Flags := Flags or cf_EnableHook
	end;
end;

function TChooseFontDlg.Create :Boolean;
begin
	Abstract;
end;

function TChooseFontDlg.Execute: Integer;
var
	Result       : Integer;
	OldKBHandler : PWindowsObject;
begin
	PrepareFontData;
	OldKbHandler := Application^.KBHandlerWnd;
	IsModal := TRUE;
	if CommDlg.ChooseFont(FontData^) then
		Execute := id_Ok
	else
	begin
		Result := CommDlgExtendedError;
		if Result = 0 then
			Execute := id_Cancel
		else
		begin
			Execute := -Result;
			Status  := em_InvalidWindow
		end;
	end;
	with fontData^ do
	begin
		@lpfnHook := nil;
		lpTemplateName := nil;
		Flags := Flags and not (cf_EnableTemplate or cf_EnableHook);
	end;
	HWindow := 0;
	IsModal := False;
	Application^.KBHandlerWnd := OldKbHandler;
end;

procedure TChooseFontDlg.SetUpWindow;
begin
	TDialog.SetUpWindow;
	ShowWindow(GetDlgItem(HWindow, 1093), sw_Hide);
end;

procedure TChooseFontDlg.WMCtlColor (var Msg: TMessage);
begin
	case Msg.LParamHi of
		CtlColor_Dlg:
		begin
			SetBkMode(Msg.WParam, Transparent);
			if Bmp <> 0 then
				Msg.Result := BkBrush
			else
				Msg.Result := GetStockObject(LtGray_Brush);
		end;
		CtlColor_Btn, CtlColor_Static:
		begin
			SetBkMode(Msg.WParam, Transparent);
			Msg.Result := GetStockObject(LtGray_Brush);
		end;
	else
		TDialog.DefWndProc(Msg);
	end;
end;

procedure TChooseFontDlg.WMDrawItem(var Msg:tMessage);
begin
	with PDrawItemStruct(Msg.lParam)^ do
		case CtlType of
			odt_Button:
				case CtlID of
					id_ok : OkBtn^.DrawItem(Msg);
					id_cancel : CancelBtn^.DrawItem(Msg);
				end;
		else
			TDialog.DefWndProc(Msg);
		end;
end;

procedure TChooseFontDlg.Ok(var msg :TMessage);
begin
	Msg.Result := Word(not CanClose)
end;

procedure TChooseFontDlg.Cancel(var msg :TMessage);
begin
  Msg.Result := 0
end;

{********** TMWCCFontDlg **********}

constructor TMWCCFontDlg.Init (AParent: PWindowsObject; AName: PChar;
															 FData: PChooseFont; ABmp: PChar);
begin
	TChooseFontDlg.Init(AParent, AName, FData);
	HLib := LoadLibrary ('MWCC.dll');
	if HLib >= 32 then Bmp := LoadBitmap(HLib, ABmp);
	if Bmp <> 0 then BkBrush := CreatePatternBrush(Bmp);
end;

destructor TMWCCFontDlg.Done;
begin
	if Bmp <> 0 then
	begin
		DeleteObject(Bmp);
		DeleteObject(BkBrush);
	end;
	if HLib >= 32 then FreeLibrary(HLib);
	TChooseFontDlg.Done;
end;

function TMWCCFontDlg.GetClassName;
begin
	GetClassName := 'MWCCFontDlg';
end;

procedure TMWCCFontDlg.WMPaint (var Msg: TMessage);
var
	PS   : TPaintStruct;
	W, H : Integer;
begin
	GetClientRect (HWindow, CRect);
	W := CRect.Right;
	H := CRect.Bottom;
	BeginPaint(HWindow, PS);
	Draw3DBorder(HWindow, 1, 1, W-2, H-2, ctl_Raised);
	EndPaint(HWindow, PS);
	TChooseFontDlg.DefWndProc(Msg);
end;

{********** TSFXFontDlg **********}

constructor TSFXFontDlg.Init (AParent: PWindowsObject; AName: PChar; FData: PChooseFont);
begin
	TChooseFontDlg.Init(AParent, AName, FData);
	HLib := LoadLibrary ('MWCC.dll');
	Bmp := 0;
end;

destructor TSFXFontDlg.Done;
begin
	if HLib >= 32 then FreeLibrary(HLib);
	TChooseFontDlg.Done;
end;

function TSFXFontDlg.GetClassName;
begin
	GetClassName := 'SFXFontDlg';
end;

procedure TSFXFontDlg.SetUpWindow;
var
	SysMenu : HMenu;
begin
	TChooseFontDlg.SetUpWindow;
	SysMenu := GetSystemMenu(HWindow, False);
	RemoveMenu(SysMenu, 0, mf_ByPosition);
	RemoveMenu(SysMenu, 1, mf_ByPosition);
	RemoveMenu(SysMenu, 1, mf_ByPosition);
	RemoveMenu(SysMenu, 1, mf_ByPosition);
	RemoveMenu(SysMenu, 1, mf_ByPosition);
	RemoveMenu(SysMenu, 2, mf_ByPosition);
	RemoveMenu(SysMenu, 2, mf_ByPosition);
	if GetSystemMetrics(sm_CYSize) = 26 then
	begin
		SetWindowPos(OkBtn^.HWindow, 0, 556, 34, 0, 0, swp_NoZOrder or swp_NoSize);
		SetWindowPos(CancelBtn^.HWindow, 0, 556, 126, 0, 0, swp_NoZOrder or swp_NoSize);
	end
	else
	begin
		SetWindowPos(OkBtn^.HWindow, 0, 420, 26, 0, 0, swp_NoZOrder or swp_NoSize);
		SetWindowPos(CancelBtn^.HWindow, 0, 420, 102, 0, 0, swp_NoZOrder or swp_NoSize);
	end;
end;

procedure TSFXFontDlg.WMPaint (var Msg: TMessage);
begin
	DrawSFXFrame(HWindow);
	TChooseFontDlg.DefWndProc(Msg);
end;

procedure TSFXFontDlg.WMNCPaint (var Msg: TMessage);
begin
	DrawSFXFrame(HWindow);
	GetWindowText(HWindow, szTitle, sizeof(szTitle));
	SetWindowText(HWindow, szTitle);
	Msg.Result := 1;
end;

procedure TSFXFontDlg.WMNCCalcSize (var Msg: TMessage);
type
	NCRect = array[0..2] of TRect;
	PRect = ^NCRect;
begin
	Inc(PRect(Msg.lParam)^[0].Top, 1);
	DefWindowProc(HWindow, wm_NCCalcSize, Msg.wParam, Msg.lParam);
end;

procedure TSFXFontDlg.WMActivate (var Msg: TMessage);
begin
	DrawSFXFrame(HWindow);
	TChooseFontDlg.DefWndProc(Msg);
end;

procedure TSFXFontDlg.WMNCActivate (var Msg: TMessage);
begin
	DrawSFXFrame(HWindow);
	TChooseFontDlg.DefWndProc(Msg);
end;

procedure TSFXFontDlg.WMActivateApp (var Msg: TMessage);
begin
	DrawSFXFrame(HWindow);
	TChooseFontDlg.DefWndProc(Msg);
end;

procedure TSFXFontDlg.WMGetMinMaxInfo (var Msg: TMessage);
type
	TMinMaxInfo = array [0..4] of TPoint;
	PMinMaxInfo = ^TMinMaxInfo;
var
	MinMaxInfo : PMinMaxInfo;
	buf : array [0..10] of Char;
begin
	longInt(MinMaxInfo) := Msg.lParam;
	GetWindowRect(HWindow, WinRect);
	if ((WinRect.Right-WinRect.Left) > 36) and ((WinRect.Bottom-WinRect.Top) > 36) then
	begin
		MinMaxInfo^[1].X :=  WinRect.Right - WinRect.Left;
		MinMaxInfo^[1].Y :=  WinRect.Bottom - WinRect.Top;
		MinMaxInfo^[3].X :=  WinRect.Right - WinRect.Left;
		MinMaxInfo^[3].Y :=  WinRect.Bottom - WinRect.Top;
		MinMaxInfo^[4].X :=  WinRect.Right - WinRect.Left;
		MinMaxInfo^[4].Y :=  WinRect.Bottom - WinRect.Top;
	end;
end;

{********** TFontGroupBox **********}

constructor TFontGroupBox.InitResource (AParent: PWindowsObject; AnId: Integer; AText: PChar);
begin
	TGroupBox.InitResource(AParent, AnID);
	Stat1 :=	New(PMWCCStatic, Init(@Self, idw_Stat1, AText, 0, 0, 0, 0, 50, ctl_Static, True));
	Stat2 :=	New(PFontStatic, Init(@Self, idw_Stat2, nil, 0, 0, 0, 0, 0));
end;

procedure TFontGroupBox.SetupWindow;
var
	W, H:Integer;
	lstyle : longInt;
begin
	TGroupBox.SetupWindow;
	SetCaption(nil);
	GetClientRect (HWindow, CRect);
	W := CRect.Right;
	H := CRect.Bottom;
	SetWindowPos(Stat1^.HWindow, 0, 3, 9, W-6, 16, swp_NoZOrder);
	SetWindowPos(Stat2^.HWindow, 0, 3, 25, W-6, H-28, swp_NoZOrder);
end;

procedure TFontGroupBox.WMCtlColor (var Msg: TMessage);
begin
	case Msg.LParamHi of
		CtlColor_Static:
		begin
			SetBkMode(Msg.WParam, Transparent);
			Msg.Result := GetStockObject(LtGray_Brush);
		end
		else
			TGroupBox.DefWndProc(Msg);
	end;
end;

procedure TFontGroupBox.WMPaint (var Msg: TMessage);
var
	PS   : TPaintStruct;
	W, H : Integer;
begin
	TGroupBox.WMPaint(Msg);
	GetClientRect (HWindow, CRect);
	W := CRect.Right;
	H := CRect.Bottom;
	BeginPaint(HWindow, PS);
	Draw3DBorder(HWindow, 2, 8, W-4, H-10, ctl_Recessed);
	EndPaint(HWindow, PS);
	if not  IsWindowVisible(GetDlgItem(Parent^.HWindow, 1093)) then
		ShowWindow(GetDlgItem(Parent^.HWindow, 1093), sw_ShowNA);
end;

{********** TFontStatic **********}

function TFontStatic.GetColor (Color: PChar): LongInt;
begin
	if lstrcmpi(Color, 'Black') = 0 then
		GetColor := RGB(0, 0, 0);
	if lstrcmpi(Color, 'Maroon') = 0 then
		GetColor := RGB(128, 0, 0);
	if lstrcmpi(Color, 'Green') = 0 then
		GetColor := RGB(0, 128, 0);
	if lstrcmpi(Color, 'Olive') = 0 then
		GetColor := RGB(128, 128, 0);
	if lstrcmpi(Color, 'Navy') = 0 then
		GetColor := RGB(0, 0, 128);
	if lstrcmpi(Color, 'Purple') = 0 then
		GetColor := RGB(128, 0, 128);
	if lstrcmpi(Color, 'Teal') = 0 then
		GetColor := RGB(0, 128, 128);
	if lstrcmpi(Color, 'Gray') = 0 then
		GetColor := RGB(128, 128, 128);
	if lstrcmpi(Color, 'Silver') = 0 then
		GetColor := RGB(192, 192, 192);
	if lstrcmpi(Color, 'Red') = 0 then
		GetColor := RGB(255, 0, 0);
	if lstrcmpi(Color, 'Lime') = 0 then
		GetColor := RGB(0, 255, 0);
	if lstrcmpi(Color, 'Yellow') = 0 then
		GetColor := RGB(255, 255, 0);
	if lstrcmpi(Color, 'Blue') = 0 then
		GetColor := RGB(0, 0, 255);
	if lstrcmpi(Color, 'Fuschia') = 0 then
		GetColor := RGB(255, 0, 255);
	if lstrcmpi(Color, 'Aqua') = 0 then
		GetColor := RGB(0, 255, 255);
	if lstrcmpi(Color, 'White') = 0 then
		GetColor := RGB(255, 255, 255);
end;

function TFontStatic.CheckRect: Integer;
var
	R1, R2, R3 : TRect;
begin
	GetWindowRect(Parent^.HWindow, R1);
	GetWindowRect(GetDlgItem(Parent^.Parent^.HWindow, 1093), R2);
	IntersectRect(R3, R1, R2);
	if EqualRect(R2, R3) then
	begin
		GetClientRect(GetDlgItem(Parent^.Parent^.HWindow, 1093), R2);
		CheckRect := R2.Bottom;
	end
	else
		CheckRect := 0;
end;

procedure TFontStatic.WMPaint (var Msg: TMessage);
var
	PS         : TPaintStruct;
	PaintDC    : HDC;
	OldObject  : THandle;
	TheFont    : HFont;
	LogFont    : TLogFont;
	Code, W, H : Integer;
	FontSize   : LongInt;
	TextRect   : TRect;
	szText     : array[0..100] of Char;
begin
	TStatic.WMPaint(Msg);
	GetClientRect (HWindow, CRect);
	BeginPaint(HWindow, PS);
	PaintDC := GetDC(HWindow);
	with LogFont do
	begin
		GetWindowText(GetDlgItem(Parent^.Parent^.HWindow, 1136), szText, sizeof(szText));
		lstrcpy(lfFaceName, szText);
		GetWindowText(GetDlgItem(Parent^.Parent^.HWindow, 1137), szText, sizeof(szText));
		if (lstrcmpi(szText, 'Bold') = 0) or (lstrcmpi(szText, 'Bold Italic') = 0) then
			lfWeight := 700
		else
			lfWeight := 400;
		if (lstrcmpi(szText, 'Italic') = 0) or (lstrcmpi(szText, 'Bold Italic') = 0) then
			lfItalic := 1
		else
			lfItalic := 0;
		GetWindowText(GetDlgItem(Parent^.Parent^.HWindow, 1138), szText, sizeof(szText));
		Val(szText, FontSize, Code);
		lfHeight := -(FontSize * GetDeviceCaps(PaintDC, LogPixelsY)) div 72;
		if SendMessage(GetDlgItem(Parent^.Parent^.HWindow, 1040), bm_GetCheck, 0, 0) = 1 then
			lfStrikeout := 1
		else
			lfStrikeOut := 0;
		if SendMessage(GetDlgItem(Parent^.Parent^.HWindow, 1041), bm_GetCheck, 0, 0) = 1 then
			lfUnderline := 1
		else
			lfUnderline := 0;
		lfWidth := 0;
		lfEscapement := 0;
		lfOrientation := 0;
		lfCharSet := 1;
		lfOutPrecision := Out_Default_Precis;
		lfClipPrecision := Clip_Default_Precis;
		lfQuality := Proof_Quality;
		lfPitchAndFamily := Variable_Pitch;
	end;
	SetBkMode(PaintDC, Transparent);
	if FontData^.Flags = FontData^.Flags or cf_Effects then
	begin
		GetWindowText(GetDlgItem(Parent^.Parent^.HWindow, 1139), szText, sizeof(szText));
		SetTextColor(PaintDC, GetColor(szText));
	end
	else
		SetTextColor(PaintDC, ColorRef);
	if ((FontData^.Flags = FontData^.Flags or cf_PrinterFonts) or
			(FontData^.Flags = FontData^.Flags or cf_Both)) and (CheckRect <> 0) then
		Inc(CRect.Bottom, - CheckRect);
	TheFont := CreateFontIndirect(LogFont);
	OldObject := SelectObject(PaintDC, TheFont);
	FillRect(PaintDC, CRect, GetStockObject(LtGray_Brush));
	DrawText(PaintDC, FontText, -1, CRect, dt_Center or dt_vCenter or dt_Singleline);
	SelectObject(PaintDC, OldObject);
	DeleteObject(TheFont);
	ReleaseDC(HWindow, PaintDC);
	EndPaint(HWindow, PS);
end;

{********** TFontCombobox **********}

procedure TFontComboBox.WMCommand (var Msg: TMessage);
begin
	TMWCCComboBox.WMCommand(Msg);
	if Msg.lParamHi = cbn_SelChange then
		SendMessage(GetDlgItem(GetDlgItem(Parent^.HWindow, 1073), 57), wm_Paint, 0, 0);
end;

{********** TFontCheckbox **********}

procedure TFontCheckBox.BMSetCheck (var Msg: TMessage);
begin
	TMWCCCheckBox.BMSetCheck(Msg);
	SendMessage(GetDlgItem(GetDlgItem(Parent^.HWindow, 1073), 57), wm_Paint, 0, 0);
end;

{********** TFileNameDlg **********}

constructor TFileNameDlg.Init(AParent: PWindowsObject; AName: PChar; IsOpen: Boolean);
begin
	TDialog.Init(AParent, AName);
	EC := New(PMWCCEdit, InitResource(@Self, 1152, 21));
	LB1 := New(PMWCCListBox, InitResource(@Self, 1120));
	LB2 := New(PMWCCListBox, InitResource(@Self, 1121));
	CB1 := New(PMWCCComboBox, InitResource(@Self, 1136, 21));
	CB2 := New(PMWCCComboBox, InitResource(@Self, 1137, 21));
	CBox := New(PMWCCCheckBox, InitResource(@Self, 1040));
	if GetSystemMetrics(sm_CYSize) = 26 then
	begin
		OkBtn := New(PMWCCBmpButton, Init(@Self, id_Ok, 510, 40, False, 1, ctl_Flush));
		CancelBtn := New(PMWCCBmpButton, Init(@Self, id_Cancel, 510, 133, False, 2, ctl_Flush));
	end
	else
	begin
		OkBtn := New(PMWCCBmpButton, Init(@Self, id_Ok, 389, 33, False, 1, ctl_Flush));
		CancelBtn := New(PMWCCBmpButton, Init(@Self, id_Cancel, 389, 108, False, 2, ctl_Flush));
	end;
	FillChar(FilePath, sizeOf(FilePath), #0);
	FillChar(FileTitle, sizeOf(FileTitle), #0);
	FillChar(OpenFileName, SizeOf(TOpenFileName), #0);
	DisableTransfer;
	Open := IsOpen;
end;

function TFileNameDlg.Create :Boolean;
begin
	Abstract;
end;

function TFileNameDlg.Execute: Integer;
var
	Result       : Integer;
	OldKBHandler : PWindowsObject;
begin
	with OpenFileName do
  begin
		lStructSize := sizeof(OpenFileName);
		HInstance := System.HInstance;
		if Parent <> nil then
			HWndOwner := Parent^.HWindow
		else
			HWndOwner := 0;
		lpstrTitle := DlgTitle;
		lpTemplateName := Attr.Name;
		lpstrFilter := DefSpec;
		nFilterIndex := DefSpecPos;
		lpstrDefExt := DefExt;
		lpstrFile := FilePath;
		lpstrFileTitle := FileTitle;
		Flags := OpenFlags;
		if (lpTemplateName <> nil) then
			Flags := Flags or ofn_EnableTemplate
		else
			lpTemplateName := nil;
		nMaxFile := sizeOf(FilePath);
		nMaxFileTitle := sizeOf(FileTitle);
		lCustData := Longint(@Self);
		Move(Self.Instance, lpfnHook, sizeOf(lpfnHook));
		Flags := Flags or ofn_EnableHook;
	end;
	OldKbHandler := Application^.KBHandlerWnd;
	IsModal := True;
	if DoExec then
		Execute := id_Ok
	else
	begin
		Result := CommDlgExtendedError;
		if Result = 0 then
			Execute := id_Cancel
		else
		begin
			Execute := -Result;
			Status := em_InvalidWindow;
		end;
	end;
	HWindow := 0;
	IsModal := False;
	Application^.KBHandlerWnd := OldKbHandler;
end;

function TFileNameDlg.DefSpec: PChar;
begin
	DefSpec := 'All Files (*.*)'#0'*.*'#0
end;

function TFileNameDlg.DefSpecPos: Byte;
begin
  DefSpecPos := 1;
end;

function TFileNameDlg.DefExt: PChar;
begin
	DefExt := '*'
end;

function TFileNameDlg.OpenFlags: Longint;
begin
	if Open then
		OpenFlags := ofn_PathMustExist or ofn_HideReadOnly
  else
		OpenFlags := ofn_PathMustExist or ofn_HideReadOnly or ofn_NoReadOnlyReturn;
end;

function TFileNameDlg.DlgTitle :PChar;
begin
	if Open then
		DlgTitle := 'File Open'
	else
		DlgTitle := 'File Save As';
end;

function TFileNameDlg.DoExec: Boolean;
begin
	if Open then
    DoExec := GetOpenFileName(OpenFileName)
  else
		DoExec := GetSaveFileName(OpenFileName);
end;

procedure TFileNameDlg.WMCtlColor (var Msg: TMessage);
begin
	case Msg.LParamHi of
		CtlColor_Dlg:
		begin
			SetBkMode(Msg.WParam, Transparent);
			if Bmp <> 0 then
				Msg.Result := BkBrush
			else
				Msg.Result := GetStockObject(LtGray_Brush);
		end;
		CtlColor_Btn, CtlColor_Static:
		begin
			SetBkMode(Msg.WParam, Transparent);
			Msg.Result := GetStockObject(LtGray_Brush);
		end;
	else
		TDialog.DefWndProc(Msg);
	end;
end;

procedure TFileNameDlg.WMDrawItem(var Msg:tMessage);
begin
	with PDrawItemStruct(Msg.lParam)^ do
    case CtlType of
      odt_Button:
				case CtlID of
					id_Ok : OkBtn^.DrawItem(Msg);
					id_Cancel : CancelBtn^.DrawItem(Msg);
				end;
		else
			TDialog.DefWndProc(Msg);
		end;
end;

procedure TFileNameDlg.Ok(var msg :TMessage);
begin
	Msg.Result := Word(not CanClose)
end;

procedure TFileNameDlg.Cancel(var msg :TMessage);
begin
  Msg.Result := 0
end;

{********** TMWCCFileNameDlg **********}

constructor TMWCCFileNameDlg.Init (AParent: PWindowsObject; AName, ABmp: PChar; IsOpen: Boolean);
begin
	TFileNameDlg.Init(AParent, AName, IsOpen);
	HLib := LoadLibrary ('MWCC.dll');
	if HLib >= 32 then Bmp := LoadBitmap(HLib, ABmp);
	if Bmp <> 0 then BkBrush := CreatePatternBrush(Bmp);
	ST := New(PMWCCEdit, InitResource(@Self, 1088, 50));
end;

destructor TMWCCFileNameDlg.Done;
begin
	if Bmp <> 0 then
	begin
		DeleteObject(Bmp);
		DeleteObject(BkBrush);
	end;
	if HLib >= 32 then FreeLibrary(HLib);
	TFileNameDlg.Done;
end;

function TMWCCFileNameDlg.GetClassName;
begin
	GetClassName := 'MWCCFileNameDlg';
end;

procedure TMWCCFileNameDlg.WMPaint (var Msg: TMessage);
var
	PS   : TPaintStruct;
	W, H : Integer;
begin
	GetClientRect (HWindow, CRect);
	W := CRect.Right;
	H := CRect.Bottom;
	BeginPaint(HWindow, PS);
	Draw3DBorder(HWindow, 1, 1, W-2, H-2, ctl_Raised);
	EndPaint(HWindow, PS);
end;

{********** TSFXFileNameDlg **********}

constructor TSFXFileNameDlg.Init (AParent: PWindowsObject; AName: PChar; IsOpen: Boolean);
begin
	TFileNameDlg.Init(AParent, AName, IsOpen);
	HLib := LoadLibrary ('MWCC.dll');
	Bmp := 0;
end;

destructor TSFXFileNameDlg.Done;
begin
	if HLib >= 32 then FreeLibrary(HLib);
	TFileNameDlg.Done;
end;

function TSFXFileNameDlg.GetClassName;
begin
	GetClassName := 'SFXFileNameDlg';
end;

procedure TSFXFileNameDlg.SetUpWindow;
var
	SysMenu : HMenu;
begin
	TFileNameDlg.SetUpWindow;
	SysMenu := GetSystemMenu(HWindow, False);
	RemoveMenu(SysMenu, 0, mf_ByPosition);
	RemoveMenu(SysMenu, 1, mf_ByPosition);
	RemoveMenu(SysMenu, 1, mf_ByPosition);
	RemoveMenu(SysMenu, 1, mf_ByPosition);
	RemoveMenu(SysMenu, 1, mf_ByPosition);
	RemoveMenu(SysMenu, 2, mf_ByPosition);
	RemoveMenu(SysMenu, 2, mf_ByPosition);
	if GetSystemMetrics(sm_CYSize) = 26 then
	begin
		SetWindowPos(OkBtn^.HWindow, 0, 508, 32, 0, 0, swp_NoZOrder or swp_NoSize);
		SetWindowPos(CancelBtn^.HWindow, 0, 508, 130, 0, 0, swp_NoZOrder or swp_NoSize);
	end
	else
	begin
		SetWindowPos(OkBtn^.HWindow, 0, 387, 26, 0, 0, swp_NoZOrder or swp_NoSize);
		SetWindowPos(CancelBtn^.HWindow, 0, 387, 103, 0, 0, swp_NoZOrder or swp_NoSize);
	end;
end;

procedure TSFXFileNameDlg.WMPaint (var Msg: TMessage);
begin
	DrawSFXFrame(HWindow);
	TFileNameDlg.DefWndProc(Msg);
end;

procedure TSFXFileNameDlg.WMNCPaint (var Msg: TMessage);
begin
	DrawSFXFrame(HWindow);
	GetWindowText(HWindow, szTitle, sizeof(szTitle));
	SetWindowText(HWindow, szTitle);
	Msg.Result := 1;
end;

procedure TSFXFileNameDlg.WMNCCalcSize (var Msg: TMessage);
type
	NCRect = array[0..2] of TRect;
	PRect = ^NCRect;
begin
	Inc(PRect(Msg.lParam)^[0].Top, 1);
	DefWindowProc(HWindow, wm_NCCalcSize, Msg.wParam, Msg.lParam);
end;

procedure TSFXFileNameDlg.WMActivate (var Msg: TMessage);
begin
	DrawSFXFrame(HWindow);
	TFileNameDlg.DefWndProc(Msg);
end;

procedure TSFXFileNameDlg.WMNCActivate (var Msg: TMessage);
begin
	DrawSFXFrame(HWindow);
	TFileNameDlg.DefWndProc(Msg);
end;

procedure TSFXFileNameDlg.WMActivateApp (var Msg: TMessage);
begin
	DrawSFXFrame(HWindow);
	TFileNameDlg.DefWndProc(Msg);
end;

procedure TSFXFileNameDlg.WMGetMinMaxInfo (var Msg: TMessage);
type
	TMinMaxInfo = array [0..4] of TPoint;
	PMinMaxInfo = ^TMinMaxInfo;
var
	MinMaxInfo : PMinMaxInfo;
	buf : array [0..10] of Char;
begin
	longInt(MinMaxInfo) := Msg.lParam;
	GetWindowRect(HWindow, WinRect);
	if ((WinRect.Right-WinRect.Left) > 36) and ((WinRect.Bottom-WinRect.Top) > 36) then
	begin
		MinMaxInfo^[1].X :=  WinRect.Right - WinRect.Left;
		MinMaxInfo^[1].Y :=  WinRect.Bottom - WinRect.Top;
		MinMaxInfo^[3].X :=  WinRect.Right - WinRect.Left;
		MinMaxInfo^[3].Y :=  WinRect.Bottom - WinRect.Top;
		MinMaxInfo^[4].X :=  WinRect.Right - WinRect.Left;
		MinMaxInfo^[4].Y :=  WinRect.Bottom - WinRect.Top;
	end;
end;

end.