{**********************************************************************}
{*                                                                    *}
{* 		 Microworks Custom Control Object Library                    		*}
{*                                                                    *}
{*		 Version 1.03                                                 	*}
{*                                                                    *}
{*     Object Windows Library Extension for Borland Pascal v7.0       *}
{*                                                                    *}
{*     and Turbo Pascal for Windows v 1.5                             *}
{*                                                                    *}
{*		 MMsgBox : Message Box Unit                         		        *}
{*                                                                    *}
{*     Copyright 1992-93 Microworks (Jeff Franks) Sydney, Australia.  *}
{*                                                                    *}
{**********************************************************************}

unit MMsgBox;

interface

uses WinProcs, WinTypes;

type

	TMinMaxInfo = array [0..4] of TPoint;
	PMinMaxInfo = ^TMinMaxInfo;

	function  MWCCMsgBox (WndParent: HWnd; ATxt, ACaption: PChar; ATextType: Word;
												ABmp: PChar): Integer;

	function  SFXMsgBox (WndParent: HWnd; ATxt, ACaption: PChar; ATextType: Word): Integer;

	function  CreateDefaultFont (IsBold: Boolean): HFont;

	procedure Draw3DBorder (Wnd: HWnd; X, Y, W, H: Integer; Shade: Word);

	procedure DrawSFXFrame (Wnd: HWnd);

	procedure DrawMsgBoxButton (Wnd: HWnd; lParam: LongInt);

	procedure MsgBoxKeyDown (ParentWnd, Wnd: HWnd; wParam: Word);

	procedure PaintMsgBox (Wnd: HWnd; AText: PChar; Ofs1, Ofs2, Ofs3: Integer;
												 MsgBmp: HBitmap; SFXStyle: Boolean);

implementation

const

	ctl_Recessed = 51;

var

	Default1    : Boolean;
	Default2    : Boolean;
	Default3    : Boolean;
	SFXStyle    : Boolean;
	BkBmp       : HBitmap;
	MsgBmp      : HBitmap;
	UpBmp1      : HBitmap;
	UpBmp2      : HBitmap;
	UpBmp3      : HBitmap;
	BkBrush     : HBrush;
	LastWnd     : HWnd;
	MsgBoxWnd   : HWnd;
	WndButton1  : HWnd;
	WndButton2  : HWnd;
	WndButton3  : HWnd;
	ID1         : Integer;
	ID2         : Integer;
	ID3         : Integer;
	a           : Integer;
	b           : Integer;
	c           : Integer;
	d           : Integer;
	e           : Integer;
	f           : Integer;
	Reply       : Integer;
	ButtonProc1 : TFarProc;
	ButtonProc2 : TFarProc;
	ButtonProc3 : TFarProc;
	OldProc1    : TFarProc;
	OldProc2    : TFarProc;
	OldProc3    : TFarProc;
	HLib        : THandle;
	MWCCWndHdl  : THandle;
	SFXWndHdl   : THandle;
	WinRect     : TRect;
	TextType    : Word;
	szText      : array[0..255] of Char;
	szTitle     : array[0..50] of Char;

{********** External functions and procedures **********}

function  CreateDefaultFont; external 'MWCC' Index 1;

procedure Draw3DBorder; external 'MWCC' Index 5;

procedure DrawSFXFrame; external 'MWCC' Index 10;

procedure DrawMsgBoxButton; external 'MWCC' Index 11;

procedure MsgBoxKeyDown; external 'MWCC' Index 12;

procedure PaintMsgBox; external 'MWCC' Index 13;

{********** MWCCMsgBox and SFXMsgBox **********}

procedure InitializeData;
begin
	Default1    := False;
	Default2    := False;
	Default3    := False;
	SFXStyle    := False;
	BkBmp       := 0;
	MsgBmp      := 0;
	UpBmp1      := 0;
	UpBmp2      := 0;
	UpBmp3      := 0;
	BkBrush     := 0;
	LastWnd     := 0;
	MsgBoxWnd   := 0;
	WndButton1  := 0;
	WndButton2  := 0;
	WndButton3  := 0;
	ID1         := 0;
	ID2         := 0;
	ID3         := 0;
	a           := 0;
	b           := 0;
	c           := 0;
	d           := 0;
	e           := 0;
	f           := 0;
	ButtonProc1 := nil;
	ButtonProc2 := nil;
	ButtonProc3 := nil;
	OldProc1    := nil;
	OldProc2    := nil;
	OldProc3    := nil;
	HLib        := 0;
	MWCCWndHdl  := 0;
	SFXWndHdl   := 0;
end;

function MsgBoxButton1Proc (Wnd: HWnd; Message, wParam: Word; lParam: Longint): Longint; export;
begin
	MsgBoxButton1Proc := 0;
	case Message of
		wm_KeyDown : MsgboxKeyDown(MsgBoxWnd, Wnd, wParam);
	end;
	MsgBoxButton1Proc :=	CallWindowProc (OldProc1, Wnd, Message, wParam, lParam);
end;

function MsgBoxButton2Proc (Wnd: HWnd; Message, wParam: Word; lParam: Longint): Longint; export;
begin
	MsgBoxButton2Proc := 0;
	case Message of
		wm_KeyDown : MsgboxKeyDown(MsgBoxWnd, Wnd, wParam);
	end;
	MsgBoxButton2Proc :=	CallWindowProc (OldProc2, Wnd, Message, wParam, lParam);
end;

function MsgBoxButton3Proc (Wnd: HWnd; Message, wParam: Word; lParam: Longint): Longint; export;
begin
	MsgBoxButton3Proc := 0;
	case Message of
		wm_KeyDown : MsgboxKeyDown(MsgBoxWnd, Wnd, wParam);
	end;
	MsgBoxButton3Proc :=	CallWindowProc (OldProc3, Wnd, Message, wParam, lParam);
end;

function MsgBoxProc(Wnd: HWnd; Message, wParam: Word; lParam: Longint): Longint; export;
type
	NCRect = array[0..2] of TRect;
	PRect  = ^NCRect;
var
	MinMaxInfo : PMinMaxInfo;
begin
	MsgBoxProc := 0;
	case Message of
		wm_Destroy:
		begin
			if HLib >= 32 then FreeLibrary(HLib);
			if BkBmp <> 0 then
			begin
				DeleteObject(BkBmp);
				DeleteObject(BkBrush);
			end;
			if MsgBmp <> 0 then DeleteObject(MsgBmp);
			if UpBmp1 <> 0 then DeleteObject(UpBmp1);
			if UpBmp2 <> 0 then DeleteObject(UpBmp2);
			if UpBmp3 <> 0 then DeleteObject(UpBmp3);
			PostQuitMessage(0);
			Exit;
		end;
		wm_Paint:
		begin
			PaintMsgBox (Wnd, szText, a, e, f, MsgBmp, SFXStyle);
			if SFXStyle then DrawSFXFrame(Wnd);
		end;
		wm_DrawItem: DrawMsgBoxButton(Wnd, lParam);
		wm_Command:
		begin
			if HiWord(lParam) = bn_Clicked then
			begin
				Reply := wParam;
				EnableWindow(LastWnd, True);
				SetFocus(LastWnd);
				DestroyWindow(Wnd);
				if SFXStyle  then
					UnregisterClass('SFXMsgBoxWindow', SFXWndHdl)
				else
					UnregisterClass('MWCCMsgBoxWindow', MWCCWndHdl);
			end;
		end;
		wm_NCPaint:
		begin
			if SFXStyle then
			begin
				DrawSFXFrame(Wnd);
				GetWindowText(Wnd, szTitle, sizeof(szTitle));
				SetWindowText(Wnd, szTitle);
				MsgBoxProc := 1;
				Exit;
			end;
		end;
		wm_NCCalcSize: if SFXStyle then Inc(PRect(lParam)^[0].Top, 1);
		wm_Activate: if SFXStyle then DrawSFXFrame(Wnd);
		wm_NCActivate: if SFXStyle then DrawSFXFrame(Wnd);
		wm_ActivateApp: if SFXStyle then DrawSFXFrame(Wnd);
		wm_GetMinMaxInfo:
		begin
			longInt(MinMaxInfo) := lParam;
			GetWindowRect(Wnd, WinRect);
			if ((WinRect.Right-WinRect.Left) > 36) and ((WinRect.Bottom-WinRect.Top) > 36) then
			begin
				MinMaxInfo^[1].X :=  WinRect.Right - WinRect.Left;
				MinMaxInfo^[1].Y :=  WinRect.Bottom - WinRect.Top;
				MinMaxInfo^[3].X :=  WinRect.Right - WinRect.Left;
				MinMaxInfo^[3].Y :=  WinRect.Bottom - WinRect.Top;
				MinMaxInfo^[4].X :=  WinRect.Right - WinRect.Left;
				MinMaxInfo^[4].Y :=  WinRect.Bottom - WinRect.Top;
			end;
		end;
	end;
	MsgBoxProc := DefWindowProc(Wnd, Message, wParam, lParam);
end;

procedure MsgBoxWinMain (WndParent: HWnd; ATxt, ACaption: PChar; ATextType: Word; ABmp: PChar);
label
	CaseExit;
const
	MWCCWndClass : TWndClass = (style         : 0;
															lpfnWndProc   : @MsgBoxProc;
															cbClsExtra    : 0;
															cbWndExtra    : 0;
															hInstance     : 0;
															hIcon         : 0;
															hCursor       : 0;
															hbrBackground : 0;
															lpszMenuName  : nil;
															lpszClassName : 'MWCCMsgBoxWindow');

	SFXWndClass : TWndClass = (style         : 0;
														 lpfnWndProc   : @MsgBoxProc;
														 cbClsExtra    : 0;
														 cbWndExtra    : 0;
														 hInstance     : 0;
														 hIcon         : 0;
														 hCursor       : 0;
														 hbrBackground : 0;
														 lpszMenuName  : nil;
														 lpszClassName : 'SFXMsgBoxWindow');
var
	SysMenu  : HMenu;
	FocusWnd : HWnd;
	W        : Integer;
	H        : Integer;
	XScreen  : Integer;
	YScreen  : Integer;
	Msg      : TMsg;

	procedure LoadBmp (wBmp: Word);
	begin
		if wBmp = 0  then MsgBmp := 0;
		if wBmp = 16 then MsgBmp := LoadBitmap(HLib, PChar(1901));
		if wBmp = 32 then MsgBmp := LoadBitmap(HLib, PChar(1902));
		if wBmp = 48 then MsgBmp := LoadBitmap(HLib, PChar(1903));
		if wBmp = 64 then MsgBmp := LoadBitmap(HLib, PChar(1904));
	end;

begin
	HLib := LoadLibrary('MWCC.dll');
	if HPrevInst = 0 then
	begin
		if SFXStyle then
		begin
			SFXWndClass.hInstance      := HInstance;
			SFXWndClass.hCursor        := LoadCursor(0, idc_Arrow);
			SFXWndClass.hbrBackground  := GetStockObject(LtGray_Brush);
			SFXWndHdl                  := HInstance;
			if not RegisterClass(SFXWndClass) then Halt(255);
		end
		else
		begin
			MWCCWndClass.hInstance := HInstance;
			MWCCWndClass.hCursor   := LoadCursor(0, idc_Arrow);
			if ABmp <> nil then
			begin
				BkBmp := LoadBitmap(HLib, ABmp);
				BkBrush := CreatePatternBrush(BkBmp);
				MWCCWndClass.hbrBackground := BkBrush;
			end
			else
				MWCCWndClass.hbrBackground := GetStockObject(LtGray_Brush);
			MWCCWndHdl                   := HInstance;
			if not RegisterClass(MWCCWndClass) then Halt(255);
		end;
	end;
	if (ATextType >= 4096) and (ATextType < 8192) then
	begin
		MessageBox(0, ATxt, ACaption, ATextType);
		Halt;
	end;
	if GetSystemMetrics(sm_CYSize) = 26 then
	begin
		a := 80; b := 40; c := 27; d := 20;
	end;
	LastWnd := WndParent;
	lstrCpy(szText, ATxt);
	if ATextType >= 8192 then
		ATextType := ATextType - 8192
	else
	if (ATextType >= 512) and (ATextType < 4096) then
	begin
		Default3 := True;
		ATextType := ATextType - 512;
	end
	else
	if (ATextType >= 256) and (ATextType < 512) then
	begin
		Default2 := True;
		ATextType := ATextType - 256;
	end
	else
		Default1 := True;
	case ATextType of
		0, 64, 48, 16, 32:
		begin
			ID1 := id_Ok;
			LoadBmp(ATextType);
			goto CaseExit;
		end;
		1, 65, 49, 17, 33:
		begin
			ID1 := id_Ok; ID2 := id_Cancel;
			LoadBmp(ATextType - 1);
			goto CaseExit;
		end;
		5, 69, 53, 21, 37:
		begin
			ID1 := id_Retry; ID2 := id_Cancel;
			LoadBmp(ATextType - 5);
			goto CaseExit;
		end;
		4, 68, 52, 20, 36:
		begin
			ID1 := id_Yes; ID2 := id_No;
			LoadBmp(ATextType - 4);
			goto CaseExit;
		end;
		3, 67, 51, 19, 35:
		begin
			ID1 := id_Yes; ID2 := id_No; ID3 := id_Cancel;
			LoadBmp(ATextType - 3);
			goto CaseExit;
		end;
		2, 66, 50, 18, 34:
		begin
			ID1 := id_Abort; ID2 := id_Retry; ID3 := id_Ignore;
			LoadBmp(ATextType - 2);
			goto CaseExit;
		end;
	end;
	CaseExit:
	if ID1 <> 0 then if not Default1 then
		UpBmp1 := LoadBitmap(HLib, PChar(1000 + ID1))
	else
		UpBmp1 := LoadBitmap(HLib, PChar(5000 + ID1));
	if ID2 <> 0 then if not Default2 then
		UpBmp2 := LoadBitmap(HLib, PChar(1000 + ID1))
	else
		UpBmp2 := LoadBitmap(HLib, PChar(5000 + ID1));
	if ID3 <> 0 then if not Default3 then
		UpBmp3 := LoadBitmap(HLib, PChar(1000 + ID1))
	else
		UpBmp3 := LoadBitmap(HLib, PChar(5000 + ID1));
	XScreen := GetSystemMetrics(sm_CXScreen);
	YScreen := GetSystemMetrics(sm_CYScreen);
	W := 388 + GetSystemMetrics(sm_CXFrame) + a - e;
	H := 220 + GetSystemMetrics(sm_CYCaption) + GetSystemMetrics(sm_CYFrame) - f;
	if SFXStyle then
		MsgBoxWnd := CreateWindow('SFXMsgBoxWindow',
															ACaption,
															ws_Popup or ws_Caption or ws_SysMenu or ws_ThickFrame,
															(XScreen - W) div 2,
															(YScreen - H) div 2,
															W, H, 0, 0,
															HInstance,
															nil)
	else
		MsgBoxWnd := CreateWindowEx(ws_Ex_DlgModalFrame,
																'MWCCMsgBoxWindow',
																ACaption,
																ws_Popup or ws_Caption or ws_SysMenu,
																(XScreen - W) div 2,
																(YScreen - H) div 2,
																W, H, 0, 0,
																HInstance,
																nil);
	if ID1 <> 0 then
		ButtonProc1 := MakeProcInstance(@MsgBoxButton1Proc, HInstance);
	if ID2 <> 0 then
		ButtonProc2 := MakeProcInstance(@MsgBoxButton2Proc, HInstance);
	if ID3 <> 0 then
		ButtonProc3 := MakeProcInstance(@MsgBoxButton3Proc, HInstance);
	if (ID1 <> 0) and (ID2 = 0) and (ID3 = 0) then
	begin
		WndButton1 := CreateWindow('Button', nil, ws_Child or ws_Visible or ws_TabStop or
																bs_OwnerDraw, 156 + b - (e div 2), 142, 74, 54, MsgBoxWnd, ID1,
																HInstance, nil);
	end
	else
	if (ID1 <> 0) and (ID2 <> 0) and (ID3 = 0) then
	begin
		WndButton1 := CreateWindow('Button', nil, ws_Child or ws_Visible or ws_TabStop or
																bs_OwnerDraw, 78 + c - (e div 2), 142, 74, 54, MsgBoxWnd, ID1,
																HInstance, nil);
		WndButton2 := CreateWindow('Button', nil, ws_Child or ws_Visible or ws_TabStop or
																bs_OwnerDraw, 232 + c * 2 - (e div 2), 142, 74, 54, MsgBoxWnd,
																ID2, HInstance, nil);
	end
	else
	if (ID1 <> 0) and (ID2 <> 0) and (ID3 <> 0) then
	begin
		WndButton1 := CreateWindow('Button', nil, ws_Child or ws_Visible or ws_TabStop or
																bs_OwnerDraw, 39 + d - (e div 2), 142, 74, 54, MsgBoxWnd, ID1,
																HInstance, nil);
		WndButton2 := CreateWindow('Button', nil, ws_Child or ws_Visible or ws_TabStop or
																bs_OwnerDraw, 155 + d * 2 - (e div 2), 142, 74, 54, MsgBoxWnd,
																ID2, HInstance, nil);
		WndButton3 := CreateWindow('Button', nil, ws_Child or ws_Visible or ws_TabStop or
																bs_OwnerDraw, 270 + d * 3 - (e div 2), 142, 74, 54, MsgBoxWnd,
																ID3, HInstance, nil);
	end;
	if ID1 <> 0 then
		LongInt(OldProc1) := SetWindowLong(WndButton1, gwl_WndProc, LongInt(ButtonProc1));
	if ID2 <> 0 then
		LongInt(OldProc2) := SetWindowLong(WndButton2, gwl_WndProc, LongInt(ButtonProc2));
	if ID3 <> 0 then
		LongInt(OldProc3) := SetWindowLong(WndButton3, gwl_WndProc, LongInt(ButtonProc3));
	if Default1 = True then
		FocusWnd := WndButton1
	else
	if Default2 = True then
		FocusWnd := WndButton2
	else
	if Default3 = True then
		FocusWnd := WndButton3;
	SetFocus(FocusWnd);
	InvalidateRect(FocusWnd, nil, True);
	SysMenu := GetSystemMenu(MsgBoxWnd, False);
	DeleteMenu(SysMenu, 0, mf_ByPosition);
	DeleteMenu(SysMenu, 1, mf_ByPosition);
	DeleteMenu(SysMenu, 1, mf_ByPosition);
	DeleteMenu(SysMenu, 1, mf_ByPosition);
	DeleteMenu(SysMenu, 1, mf_ByPosition);
	DeleteMenu(SysMenu, 2, mf_ByPosition);
	DeleteMenu(SysMenu, 2, mf_ByPosition);
	DeleteMenu(SysMenu, 1, mf_ByPosition);
	ShowWindow(MsgBoxWnd, sw_ShowNormal);
	UpdateWindow(MsgBoxWnd);
	EnableWindow(LastWnd, False);
	while GetMessage(Msg, 0, 0, 0) do
  begin
		TranslateMessage(Msg);
		DispatchMessage(Msg);
	end;
end;

function MWCCMsgBox (WndParent: HWnd; ATxt, ACaption: PChar; ATextType: Word;
										 ABmp: PChar): Integer;
begin
	InitializeData;
	MsgBoxWinMain (WndParent, ATxt, ACaption, ATextType, ABmp);
	MWCCMsgBox := Reply;
	InitializeData;
end;

function SFXMsgBox (WndParent: HWnd; ATxt, ACaption: PChar; ATextType: Word): Integer;
begin
	InitializeData;
	SFXStyle := True;
	e := 12; f := 1;
	MsgBoxWinMain (WndParent, ATxt, ACaption, ATextType, nil);
	SFXMsgBox := Reply;
	InitializeData;
end;

end.