{**********************************************************************}
{*                                                                    *}
{* 		 Microworks Custom Control Object Library                    		*}
{*                                                                    *}
{*		 Version 1.03                                                 	*}
{*                                                                    *}
{*     Object Windows Library Extension for Borland Pascal v7.0       *}
{*                                                                    *}
{*     and Turbo Pascal for Windows v 1.5                             *}
{*                                                                    *}
{*		 FileDlg.pas : Common File Dialog access unit                   *}
{*                                                                    *}
{*     Copyright 1992-93 Jeff Franks (Microworks) Sydney, Australia.  *}
{*                                                                    *}
{**********************************************************************}

{*** Introduction

	FileDlg.pas is a customizable unit that gives you access to the file open and
	file save as objects in the MWCC.tpw(tpu) object unit. The dialogs are all set up
	and ready to go. All you need to do is change the fields below (or add fields to
	suit your application, include the unit in your uses clause and add the dialog
	template from MCommDlg.res to your resource file.

	There are two different common dialog file objects, TSFXFileNameDlg and
	TMWCCFileNameDlg. These dialogs match the other 'SFX' and 'MWCC' Window/Dialog
	objects in the object unit.

	There are two examples at the end that show you how easy it is to add these dialogs to
	your application.


{*** TSFXFileDlg fields

	constructor Init(AParent: PWindowsObject; AName: PChar; IsOpen: Boolean);

		AName         := 'SFXFileDlg'

		IsOpen        := True (File Open dialog)

		IsOpen        := False (File Save As dialog);

{*** TMWCCFileDlg fields

	constructor Init(AParent: PWindowsObject; AName, ABmp: PChar; IsOpen: Boolean);

		AName         := 'MWCCFileDlg'

		ABmp          := 'BWCC' (BWCC style dialogs for the faithful)

									:= 'MWCC' (My own snazzy Glazed dialogs)

									:= nil (Conservative Light gray dialogs for the less adventurous)

		IsOpen        := True (File Open dialog)

		IsOpen        := False (File Save As dialog);

{*** Common dialog fields

		ADlg^.Execute := Returns - Filepath (Dir, Name and Ext)

														 - FileTitle (Name and Ext)

										 if Ok button clicked. (See examples below)

		DefSpec       := Default file specifications

										 eg. 'All Files (*.*)'#0'*.*'#0'Text Files (*.TXT)'#0'*.TXT'#0

		DefExt        := Default file extension to display when dialog first opens ( eg. '*.TXT')

		DefSpecPos    := Postion of default file specifcations (eg. above *.TXT would be '2')

		OpenFlags     := T(SFX/MWCC)FileNameDlg.OpenFlags are the default. They are ->

										 if IsOpen is True -> ofn_PathMustExist or ofn_HideReadOnly

										 if IsOpen is False -> ofn_PathMustExist or ofn_HideReadOnly or ofn_NoReadOnlyReturn;

										 To change the default do something like this ->

										 OpenFlags := TMWCCFileNameDlg.Open Flags and not ofn_HideReadOnly;

		CanClose      := You can change this if you want.

		DlgTitle      := The defaults are 'File Open' for file open dialogs and 'File Save As' for
										 file save as dialogs. You can overide these if you want.

										 eg. DlgTitle := 'Program Browse';

{*** TSFXFileDlg Example

	procedure OpenFile (var Msg: TMessage);
	var
		Dir, Name, Ext: array[0..fsPathName] of Char;
		ADlg : PSFXFileDlg;
	begin
		ADlg := (New(PSFXFileDlg, Init(@Self, 'SFXFileDlg', True)));
		if ADlg <> nil then
		begin
			if ADlg^.Execute = idOk then
			with ADlg^, OpenFileName do
			begin
				FileSplit(FilePath, Dir, Name, Ext);
				?
				?   fill in this bit!
				?
				?
			end;
			ADlg^.free
		end;
	end;

{*** TMWCCFileDlg Example

	procedure OpenFile(var Msg: TMessage);
	var
		Dir, Name, Ext : array[0..fsPathName] of Char;
		ADlg : PFileDlg;
	begin
		ADlg := (New(PFileDlg, Init(@Self, 'MWCCFileDlg', 'BWCC', True)));
		if ADlg <> nil then
		begin
			if (ADlg^.Execute = idOk) then
			with ADlg^, OpenFileName do
			begin
				FileSplit(FilePath, Dir, Name, Ext);
				?
				?   fill in this bit!
				?
				?
			end;
			ADlg^.free
		end;
	end;

***}

unit FileDlg;

{$R MCommDlg.Res}
{$C Moveable DemandLoad Discardable}

interface

uses Wintypes, WinProcs, Strings, MObjects, MCommDlg,
		 {$IFDEF Ver15}
			 WObjects;
		 {$ELSE}
			 Objects, OWindows, ODialogs;
		 {$ENDIF}

type

	PSFXFileDlg = ^TSFXFileDlg;
	TSFXFileDlg = object(TSFXFileNameDlg)
		constructor Init(AParent: PWindowsObject; AName: PChar; IsOpen: Boolean);
		destructor Done; virtual;
    function DefSpec: PChar; virtual;
    function DefExt: PChar; virtual;
    function DefSpecPos: Byte; virtual;
    function OpenFlags: Longint; virtual;
    function CanClose: Boolean; virtual;
    function DlgTitle: PChar; virtual;
	private
		Open : Boolean;
	end;

	PMWCCFileDlg = ^TMWCCFileDlg;
	TMWCCFileDlg = object(TMWCCFileNameDlg)
		constructor Init(AParent: PWindowsObject; AName, ABmp: PChar; IsOpen: Boolean);
		destructor Done; virtual;
    function DefSpec: PChar; virtual;
    function DefExt: PChar; virtual;
    function DefSpecPos: Byte; virtual;
    function OpenFlags: Longint; virtual;
    function CanClose: Boolean; virtual;
    function DlgTitle: PChar; virtual;
	private
		Open : Boolean;
	end;
implementation

{********** TSFXFileDlg **********}

constructor TSFXFileDlg.Init(AParent: PWindowsObject; AName: PChar; IsOpen: Boolean);
begin
	TSFXFileNameDlg.Init(AParent, AName, IsOpen);
	Open := IsOpen;
end;

destructor TSFXFileDlg.Done;
begin
	TSFXFileNameDlg.Done;
end;

function TSFXFileDlg.DefSpec: PChar;
begin
	DefSpec := 'All Files (*.*)'#0'*.*'#0;
end;

function TSFXFileDlg.DefExt: PChar;
begin
	DefExt := '*';
end;

function TSFXFileDlg.DefSpecPos: Byte;
begin
	DefSpecPos := 1;
end;

function TSFXFileDlg.OpenFlags: Longint;
begin
	OpenFlags := TSFXFileNameDlg.OpenFlags;
end;

function TSFXFileDlg.CanClose: Boolean;
begin
	CanClose := TSFXFileNameDlg.CanClose;
end;

function TSFXFileDlg.DlgTitle :PChar;
begin
	DlgTitle := TSFXFileNameDlg.DlgTitle;
end;

{********** TMWCCFileDlg **********}

constructor TMWCCFileDlg.Init(AParent: PWindowsObject; AName, ABmp: PChar; IsOpen: Boolean);
begin
	TMWCCFileNameDlg.Init(AParent, AName, ABmp, IsOpen);
	Open := IsOpen;
end;

destructor TMWCCFileDlg.Done;
begin
	TMWCCFileNameDlg.Done;
end;

function TMWCCFileDlg.DefSpec: PChar;
begin
	DefSpec := 'All Files (*.*)'#0'*.*'#0;
end;

function TMWCCFileDlg.DefExt: PChar;
begin
	DefExt := '*';
end;

function TMWCCFileDlg.DefSpecPos: Byte;
begin
	DefSpecPos := 1;
end;

function TMWCCFileDlg.OpenFlags: Longint;
begin
	OpenFlags := TMWCCFileNameDlg.OpenFlags;
end;

function TMWCCFileDlg.CanClose: Boolean;
begin
	CanClose := TMWCCFileNameDlg.CanClose;
end;

function TMWCCFileDlg.DlgTitle :PChar;
begin
	DlgTitle := TMWCCFileNameDlg.DlgTitle;
end;

end.
