{**********************************************************************}
{*                                                                    *}
{* 		 Microworks Sample Application                           	     	*}
{*                                                                    *}
{*		 for Borland Pascal v7.0 and Turbo Pascal for Windows v1.5   		*}
{*                                                                    *}
{*     Copyright 1992-93 Jeff Franks (Microworks) Sydney, Australia.  *}
{*                                                                    *}
{*		 You are free to use, modify, reproduce and distribute the      *}
{*		 Sample Files (and/or any modified version) in any way you      *}
{*		 find useful.						                                        *}
{*                                                                    *}
{**********************************************************************}

{*** Introduction

	Application := Winmenu 3D Menu Demonstration

	Files       := Winmenu.exe, Winmenu.pas, Winmenu.res

	Requires    := MWCC, Wintools and MWCC.dll

	Purpose     := Winmenu shows you how to,

								 1. Set up a 3D Menu bar using popup menus.

								 2. Use CreatePopupMenu and TrackPopupMenu.

								 3. Use the wh_Keyboard Hook from HotKey1 example.

								 4. Use some of the objects and custom controls
										in the MWCC unit and library.

								 5. Use the SFXMsgBox and MWCCMsgBox functions instead of
										the Windows API MessageBox function.

	Tabs        := 2

	Screen      := 800 * 600

	Date        := June 1993.

	The TMWCCWindow object works differently depending on how you set it up. One of the main
	things you should be aware of is the way it uses normal menus and ws_VScroll and ws_HScroll
	scroll bars. This is only of concern if you give your window an SFX style frame by setting
	SFXFrame := True in the constructor.

	The TMWCCWindow and TMWCCDlgWindow objects intercept the wm_NCPaint message to paint their
	frame and title bar. After painting, if you pass the message along to DefWndProc it then
	draws the normal frame as well. What you would see when you ran the program would be a
	quick flash of normal frame colour before my NCPaint routine paints the SFX style frame.
	It is reasonably fast and most noticeable when you resize the window. This is how the
	Microsoft Ctl3d.dll paints its frames. It just paints over the existing colours.

	Well, I wasn't satisfied with that. I don't like seeing flashing colours. The
	only alternative was to draw the non-client area myself(What a pain!!!). It was easy to
	draw the frame and the title	bar but I couldn't get the menu bar or scroll bars to
	display properly. If your window doesn't use menu's or scroll bars then its Ok.
	You don't pass the wm_NCPaint message onto DefWndProc, you draw the frame yourself and you
	don't see any flashing colours. Unfortunaletly, most windows need atleast a menu and
	often a scroll bar.

	My solution was to optionally pass wm_NCPaint along to DefWndProc. If the Attr.Style
	includes ws_VScroll or ws_HScroll or if your window has a class menu then wm_NCPaint
	is passed to DefWndProc and the non-client area is drawn normally. If you use an
	SFX style frame it just gets drawn over the top. When your window doesn't use a class
	menu and/or doesn't have ws_VScroll or ws_HScroll in its Attr.Style field then the wm_NCPaint
	message is not get passed along to DefWndProc.

	(This is a the way SFX objects work (TSFXWindow etc) except they don't pass wm_NCPaint
	on at all. Thats why you can't use menus etc with them. If you add a menu or scroll bar
	the object destroys them before displaying the window/dialog.)

	I think its important to try and give your program classy interface. Thats where 'Winmenu'
	comes in. It shows you an alternative way to institute a (3D) menu bar using buttons and
	popup menus. It also shows you whats needed to make the separate buttons and menus function
	together as a single unit like a normal menu bar. And there's more! It matches the
	design on the window, you don't see any colour flashes around the frame and it looks great!

	P.S. When you get time please browse through Help.zip and read the 'readme.txt' file.

***}

program WinMenu;

{$R WinMenu.res}

uses WinTypes, WinProcs, WinDos, Win31, Strings, MWCC, Wintools,
		 {$IFDEF Ver15}
			 WObjects;
		 {$ELSE}
			 Objects, OWindows, ODialogs;
		 {$ENDIF}

const

	{*** Menu Button ID's ***}
	idm_But1        						 = 201;
	idm_But2        						 = 202;
	idm_But3        						 = 203;
	idm_But4        						 = 204;
	idm_But5        						 = 205;

	{*** Window Static ID ***}
	idw_Stat1       						 = 401;

	{*** About Dialog ID's ***}
	idd_OkBut                    = 402;

	{*** Menu Item ID's ***}
	idm_Item1       						 = 701;
	idm_Item2       						 = 702;
	idm_Item3                    = 703;
	idm_Item4                    = 704;
	idm_About                    = 705;
	pToHotKeyHookProc : TFarProc = nil;
	wm_HotKey                    = wm_User + 76;
	AppName : PChar              = 'WinMenu';

type

	PAboutDialog = ^TAboutDialog;
	TAboutDialog = object(TMWCCDialog)
		{***

			TMWCCBmpButton is a BWCC style bitmap button object. TMWCCStatic is a static object
			that displays either raised, recessed or normal static controls. WMDrawItem is required
			to draw the TMWCCBmpButton ownerdraw button object.

		***}
		OkBut    : PMWCCBmpButton;
		ST1, ST2 : PMWCCStatic;
		constructor Init (AParent: PWindowsObject; AName, ABmp: PChar);
		procedure SetUpWindow; virtual;
		procedure WMDrawItem (var Msg: TMessage); virtual wm_First + wm_DrawItem;
	end;

	PMenuWindow = ^TMenuWindow;
	TMenuWindow = object(TMWCCWindow)
		{***

			The TMWCCButton object draws a button displaying either Text or a single Bitmap.
			MWCCButtons don't support the 'default' field. Thats so you can draw recessed (etc)
			buttons without thick black borders spoiling the 3D effect.

		***}
		But1, But2, But3, But4, But5      : PMWCCButton;
		CRect                             : TRect;
		Stat                              : PMWCCStatic;
		MenuPt                            : TPoint;
		Menu1, Menu2, Menu3, Menu4, Menu5 : HMenu;
		ShowMenu1, ShowMenu2, ShowMenu3, ShowMenu4, ShowMenu5 : Boolean;
		constructor Init (AParent: PWindowsObject; AName, ABmp: PChar);
		destructor Done; virtual;
		function  GetClassName: PChar; virtual;
		procedure GetWindowClass (var AWndClass: TWndClass); virtual;
		procedure SetUpWindow; virtual;
		procedure Paint(PaintDC : hDC; var PS : TPaintStruct); virtual;
		procedure WMDrawItem (var Msg: TMessage); virtual wm_First + wm_DrawItem;
		procedure WMCommand (var Msg: TMessage); virtual wm_First + wm_Command;
		procedure WMSize (var Msg: TMessage); virtual wm_First + wm_Size;
		procedure WMMouseMove (var Msg: TMessage); virtual wm_First + wm_MouseMove;
		procedure WMKeyUp (var Msg: TMessage); virtual wm_First + wm_KeyUp;
		procedure WMHotKey (var Msg: TMessage); virtual wm_First + wm_Hotkey;
		procedure ResetMenus; virtual;
		procedure IDMBut1 (var Msg: TMessage); virtual id_First + idm_But1;
		procedure IDMBut2 (var Msg: TMessage); virtual id_First + idm_But2;
		procedure IDMBut3 (var Msg: TMessage); virtual id_First + idm_But3;
		procedure IDMBut4 (var Msg: TMessage); virtual id_First + idm_But4;
		procedure IDMBut5 (var Msg: TMessage); virtual id_First + idm_But5;
		procedure IDMItem1 (var Msg: TMessage); virtual cm_First + idm_Item1;
		procedure IDMItem2 (var Msg: TMessage); virtual cm_First + idm_Item2;
		procedure IDMItem3 (var Msg: TMessage); virtual cm_First + idm_Item3;
		procedure IDMItem4 (var Msg: TMessage); virtual cm_First + idm_Item4;
	end;

	PMenuApplication = ^TMenuApplication;
	TMenuApplication = object(TApplication)
		procedure InitMainWindow; virtual;
	end;

var

	HHotKeyHook : HHook;

{********** Task Hook's Callback function **********}

function HotKeyHookProc (nCode: Integer; wParam: Word; lParam: LongInt): LongInt; export;
{***

	When a key is pressed this callback function checks to see that the Alt (vk_Menu)
	key is down and that wParam (the pressed Key number) is within range. It it is its passed
	to the main window in the private message wm_HotKey.

	CallNexthookEx ensures that any unwanted trapped information gets passed onto the
	the next hook in the system;

***}
label
	Exit;
var
	HotKeyWnd : HWnd;
	Msg : Tmessage;
	Key : Word;
begin
	Key := wParam;
	if (nCode = hc_Action) and (wParam <> vk_Menu) and (wParam <> vk_Return) then
	begin
		{*** Exits if the Key was released or if it's a repeat ***}
		if (lParam = $80000000) or (lParam = $40000000) then
			goto Exit;
		if (HI(GetKeyState(vk_Menu)) <> 0) and (wParam > 48) and (wParam < 73) then
		begin
			 HotKeyWnd := FindWindow('WinMenu', nil);
			 PostMessage(HotKeyWnd, wm_HotKey, wParam, 0);
		end;
	end;

	Exit:
		HotKeyHookProc := CallNextHookEx(HHotKeyHook, nCode, WParam, Longint(@LParam));
end;

{********** TMenuApplication **********}

procedure TMenuApplication.InitMainWindow;
begin
	MainWindow := New(PMenuWindow, Init(nil, 'WinMenu', nil));
end;

{********** TMenuWindow **********}

constructor TMenuWindow.Init (AParent: PWindowsObject; AName, ABmp: PChar);
begin
	TMWCCWindow.Init(AParent, AName, ABmp);
	{*** Set the window to a reasonable size ***}
	Attr.X := GetSystemMetrics(sm_CXScreen) div 8;
	Attr.Y := GetSystemMetrics(sm_CYScreen) div 8;
	Attr.W := (GetSystemMetrics(sm_CXScreen) div 8)*6;
	Attr.H := (GetSystemMetrics(sm_CYScreen) div 8)*5;
	{*** Initialize Buttons - Their size  and  position gets set in wm_Size ***}
	But1 := New(PMWCCButton, Init(@Self, idm_But1, 'Menu&1', 0, 0, 0, 0, nil, 0));
	But2 := New(PMWCCButton, Init(@Self, idm_But2, 'Menu&2', 0, 0, 0, 0, nil, 0));
	But3 := New(PMWCCButton, Init(@Self, idm_But3, 'Menu&3', 0, 0, 0, 0, nil, 0));
	But4 := New(PMWCCButton, Init(@Self, idm_But4, 'Menu&4', 0, 0, 0, 0, nil, 0));
	But5 := New(PMWCCButton, Init(@Self, idm_But5, '&Help', 0, 0, 0, 0, nil, 0));
	{*** Raised static to fill gaps between menu buttons ***}
	Stat := New(PMWCCStatic, Init(@Self, idw_Stat1, '', 0, 0, 0, 0, 0, ctl_Raised, False));
	{*** Sets Hook handle to zero ***}
	HHotKeyHook := 0;
	{*** Setting the inherited SFXFrame field to true gives the Window an SFX style frame ***}
	SFXFrame := True;
	{***	The Showmenu fields track the display state of each menu ***}
	ShowMenu1 := True;
	ShowMenu2 := True;
	ShowMenu3 := True;
	ShowMenu4 := True;
	ShowMenu5 := True;
end;

destructor TMenuWindow.Done;
begin
	{*** Unhook the Hook before exiting ***}
	if HHotKeyHook <> 0 then
	begin
		UnhookWindowsHookEx(HHotKeyHook);
		HHotKeyHook := 0;
	end;
	{*** Destroy menu handles before exiting ***}
	if Menu1 <> 0 then DestroyMenu(Menu1);
	if Menu2 <> 0 then DestroyMenu(Menu2);
	if Menu3 <> 0 then DestroyMenu(Menu3);
	if Menu4 <> 0 then DestroyMenu(Menu4);
	if Menu5 <> 0 then DestroyMenu(Menu5);
	TMWCCWindow.Done;
end;

function TMenuWindow.GetClassName;
begin
  GetClassName := AppName;
end;

procedure TMenuWindow.GetWindowClass (var AWndClass: TWndClass);
begin
	TMWCCWindow.GetWindowClass(AWndClass);
	AWndClass.HIcon := LoadIcon(HInstance, 'WinMenu');
	AWndClass.HBrBackground := GetStockObject(LtGray_Brush);
	{***

	This is part of the routine to stop the buttons flickering when the window is
	resized. This part just stops the client area being repainted when the window's
	resized.

	***}
	AWndClass.Style := AWndClass.Style and (not cs_VRedraw) and (not cs_HRedraw);
end;

procedure TMenuWindow.SetUpWindow;
begin
	TMWCCWindow.SetUpWindow;
	{***

		Installs the wh_Keyboard Task Hook used to trap the menu button Hot keys that
		launch the popup menus.

	***}
	if HHotKeyHook = 0 then
	begin
		pToHotKeyHookProc := TFarProc(@HotKeyHookProc);
		HHotKeyHook := SetWindowsHookEx(wh_Keyboard, THookProc(pToHotKeyHookProc),
																									HInstance, GetCurrentTask);
	end;
end;

procedure TMenuWindow.Paint (PaintDC : HDC; var PS: TPaintStruct);
{***

	The inherited Paint method draws a raised border around the entire client area.
	Here I don't want to do that so I override the inherited paint method and redraw the raised
	border, using the  Draw3DBorder function, offsetting the border along the top just enough
	to squeeze the buttons and static in. This makes them appear recessed.

***}
var
	W, H: Integer;
begin
	GetClientRect (HWindow, CRect);
	W := CRect.Right;
	H := CRect.Bottom;
	Draw3DBorder(HWindow, 1, 26, W-2, H-27, ctl_Raised);
end;

procedure TMenuWindow.WMDrawItem (var Msg:tMessage);
{*** Draws the ownerdraw menu buttons ***}
begin
	with PDrawItemStruct(Msg.lParam)^ do
		case CtlType of
      odt_Button:
				case CtlID of
					idm_But1 : But1^.DrawItem(Msg);
					idm_But2 : But2^.DrawItem(Msg);
					idm_But3 : But3^.DrawItem(Msg);
					idm_But4 : But4^.DrawItem(Msg);
					idm_But5 : But5^.DrawItem(Msg);
				end;
    end;
end;

procedure TMenuWindow.WMCommand (var Msg: TMessage);
{***

	with Msg.lParamLo = 0 the message is from a menu item.
	wm_Command is used for popup menus. Here the MWCC style about dialog is launched using
	the MWCC bitmap for the background brush. You could use 'BWCC' or nil (light grey).

***}
begin
	TMWCCWindow.WMcommand(Msg);
	if Msg.lParamLo = 0 then
	case Msg.wParam of
		idm_About: Application^.ExecDialog(New(PAboutDialog, Init(@Self, 'AboutDialog', 'BWCC')));
	end;
end;

procedure TMenuWindow.WMSize (var Msg: TMessage);
{***

	The wm_Size message is used to postion and size the buttons and static and set their
	'repaint field' to false. The fifth button, the help button, is positioned depending on
	the width of the client area. The Static and Help button need to be invalidated to
	display properly (they're usually effected by any resizing). Below a certain width
	the static is not displayed.

	The Inc function shrinks the client area rectangle to just below the button line.
	This Client area (minus the button area) is then updated everytime the window is resized.

	This is the rest of the routine that prevents the buttons from flickering everytime
	the window's client area is resized.

***}
var
	W, H : Integer;
begin
	GetClientRect(HWindow, CRect);
	with CRect do
	begin
		W := Right;
		H := Bottom;
	end;
	Inc(CRect.Top, 26);
	InvalidateRect(HWindow, @CRect, True);
	if not IsIconic(HWindow) then
	begin
		MoveWindow(But1^.HWindow, -1, -1, 74, 26, False);
		MoveWindow(But2^.HWindow, 72, -1, 74, 26, False);
		MoveWindow(But3^.HWindow, 145, -1, 74, 26, False);
		MoveWindow(But4^.HWindow, 218, -1, 74, 26, False);
		if W > 362 then
		begin
			MoveWindow(But5^.HWindow, W-73, -1, 74, 26, False);
			MoveWindow(Stat^.HWindow, 291, -1, W-363, 26, False);
			InvalidateRect(Stat^.HWindow, nil, True);
			InvalidateRect(But5^.HWindow, nil, True);
		end
		else
		begin
			MoveWindow(But5^.HWindow, 291, -1, 74, 26, False);
			InvalidateRect(But5^.HWindow, nil, True);
		end;
	end;
end;

procedure TMenuWindow.ResetMenus;
{*** Used to reset the show state of a menu after it's been displayed ***}
begin
	if not ShowMenu1 then ShowMenu1 := True;
	if not ShowMenu2 then ShowMenu2 := True;
	if not ShowMenu3 then ShowMenu3 := True;
	if not ShowMenu4 then ShowMenu4 := True;
	if not ShowMenu5 then ShowMenu5 := True;
end;

procedure TMenuWindow.WMKeyUp (var Msg: TMessage);
{*** Everytime the enter key if pressed the menu state is reset. ***}
begin
	case Msg.wParam of
		13: ResetMenus;
	else
		TMWCCWindow.DefWndProc(Msg);
	end;
end;

procedure TMenuWindow.WMMouseMove (var Msg: TMessage);
{*** Everytime the mouse moves if a menu's state has changed it's reset. ***}
begin
	ResetMenus;
	TMWCCWindow.DefWndProc(Msg);
end;

procedure TMenuWindow.WMHotKey (var Msg: TMessage);
{*** These are the menu button hot keys. These are 1 to 4 and H ***}
begin
	case Msg.wParam of
		49:	IDMBut1(Msg);
		50:	IDMBut2(Msg);
		51:	IDMBut3(Msg);
		52: IDMBut4(Msg);
		72: IDMBut5(Msg);
	end;
	ResetMenus;
end;

procedure TMenuWindow.IDMBut1 (var Msg: TMessage);
{*** Popup Menu 1

		This creates and displays the popup menu. The showmenu states for all menus
		are reset if there've changed. This goes toward making the menus appear to
		function like a single menu bar does.

***}
begin
	if ShowMenu1 then
	begin
		Menu1 := CreatePopupMenu;
		AppendMenu(Menu1, 0, idm_Item1, 'Menu Item &A');
		AppendMenu(Menu1, 0, idm_Item2, 'Menu Item &B');
		AppendMenu(Menu1, 0, idm_Item3, 'Menu Item &C');
		AppendMenu(Menu1, 0, idm_Item4, 'Menu Item &D');
		MenuPt.X := -1;
		MenuPt.Y := 24;
		ClientToScreen(HWindow, MenuPt);
		TrackPopupMenu(Menu1, 0, MenuPt.X, MenuPt.Y, 0, HWindow, nil);
		ResetMenus;
		ShowMenu1 := False;
	end
	else
		ResetMenus;
end;

procedure TMenuWindow.IDMBut2 (var Msg: TMessage);
{*** Popup Menu 2 ***}
begin
	if ShowMenu2 then
	begin
		Menu2 := CreatePopupMenu;
		AppendMenu(Menu2, 0, idm_Item1, 'Menu Item &A');
		AppendMenu(Menu2, 0, idm_Item2, 'Menu Item &B');
		AppendMenu(Menu2, 0, idm_Item3, 'Menu Item &C');
		AppendMenu(Menu2, 0, idm_Item4, 'Menu Item &D');
		MenuPt.X := 72;
		MenuPt.Y := 24;
		ClientToScreen(HWindow, MenuPt);
		TrackPopupMenu(Menu2, 0, MenuPt.X, MenuPt.Y, 0, HWindow, nil);
		ResetMenus;
		ShowMenu2 := False;
	end
	else
		ResetMenus;
end;

procedure TMenuWindow.IDMBut3(var Msg: TMessage);
{*** Popup Menu 3 ***}
begin
	if ShowMenu3 = True then
	begin
		Menu3 := CreatePopupMenu;
		AppendMenu(Menu3, 0, idm_Item1, 'Menu Item &A');
		AppendMenu(Menu3, 0, idm_Item2, 'Menu Item &B');
		AppendMenu(Menu3, 0, idm_Item3, 'Menu Item &C');
		AppendMenu(Menu3, 0, idm_Item4, 'Menu Item &D');
		MenuPt.X := 145;
		MenuPt.Y := 24;
		ClientToScreen(HWindow, MenuPt);
		TrackPopupMenu(Menu3, 0, MenuPt.X, MenuPt.Y, 0, HWindow, nil);
		ResetMenus;
		ShowMenu3 := False;
	end
	else
		ResetMenus;
end;

procedure TMenuWindow.IDMBut4(var Msg: TMessage);
{*** Popup Menu 4 ***}
begin
	if ShowMenu4 = True then
	begin
		Menu4 := CreatePopupMenu;
		AppendMenu(Menu4, 0, idm_Item1, 'Menu Item &A');
		AppendMenu(Menu4, 0, idm_Item2, 'Menu Item &B');
		AppendMenu(Menu4, 0, idm_Item3, 'Menu Item &C');
		AppendMenu(Menu4, 0, idm_Item4, 'Menu Item &D');
		MenuPt.X := 218;
		MenuPt.Y := 24;
		ClientToScreen(HWindow, MenuPt);
		TrackPopupMenu(Menu4, 0, MenuPt.X, MenuPt.Y, 0, HWindow, nil);
		ResetMenus;
		ShowMenu4 := False;
	end
	else
		ResetMenus;
end;

procedure TMenuWindow.IDMBut5(var Msg: TMessage);
{*** Popup Menu 5 ***}
begin
	if ShowMenu5 = True then
	begin
		Menu5 := CreatePopupMenu;
		AppendMenu(Menu5, 0, idm_About, 'About WinMenu');
		MenuPt.X := CRect.Right-1;
		MenuPt.Y := 24;
		ClientToScreen(HWindow, MenuPt);
		TrackPopupMenu(Menu5, tpm_RightAlign, MenuPt.X, MenuPt.Y, 0, HWindow, nil);
		ResetMenus;
		ShowMenu5 := False;
	end
	else
		ResetMenus;
end;

procedure TMenuWindow.IDMItem1(var Msg: TMessage);
{***

	The menu items are used to display an assortment of message boxes.
	The SFXMsgBox and MWCCMsgBox functions work in exactly the same way,
	and have the same fields as the Windows API Message box function. There are
	only two differences.

	1. SFXMsgBox and MWCCMsgBox take a PWindowsObject pointer (usualy @Self) instead
		 of a window handle. This imposes one minor limitation. These message boxes can't be used
		 as stand alone message boxes (eg as in constructors or with a nil field). A nil field
		 exits the function without displaying anything.

	2. The MWCCMsgBox function takes one extra field after ATextType (the buttons and icons). It
		 takes the name of the bitmap you want used as the background brush - BWCCBmp, MWCCBmp
		 or nil);

	PS. These message boxes are TWindow objects not dialog boxes.

***}
begin
	SFXMsgBox(@Self, 'You have selected menu item A',
									 'Information', mb_RetryCancel or mb_IconExclamation);
end;

procedure TMenuWindow.IDMItem2(var Msg: TMessage);
begin
	MWCCMsgBox(@Self, 'You have selected menu item B', 'Information',
										 mb_OkCancel or mb_IconInformation, 'BWCC');
end;

procedure TMenuWindow.IDMItem3(var Msg: TMessage);
begin
	MWCCMsgBox(@Self, 'You have selected menu item C', 'Information',
										 mb_AbortRetryIgnore or mb_IconQuestion, 'MWCC');
end;

procedure TMenuWindow.IDMItem4(var Msg: TMessage);
begin
	MWCCMsgBox(@Self, 'You have selected menu item D. Its the last menu item.', 'Information',
										 mb_YesNoCancel or mb_IconHand, nil);
end;

{********** TAboutDialog **********}

constructor TAboutDialog.Init(AParent: PWindowsObject; AName, ABmp: PChar);
{***

	This initializes two recessed TMWCCStatic objects and the BWCC style
	Ok Button' (id 1) in MWCC.dll.

***}
begin
	TMWCCDialog.Init(AParent, AName, ABmp);
	ST1 := New(PMWCCStatic, InitResource(@Self, idw_Stat1, 0, ctl_Recessed));
	if GetSystemMetrics(sm_CYSize) = 26 then
		OkBut := New(PMWCCBmpButton, Init(@Self, id_Ok, 158, 184, False, 1, ctl_Flush))
	else
		OkBut := New(PMWCCBmpButton, Init(@Self, id_Ok, 116, 144, False, 1, ctl_Flush));
end;

procedure TAboutDialog.SetUpWindow;
begin
	TMWCCDialog.SetUpWindow;
	{*** Centres the About dialog over the Task List window ***}
	CenterOverClient(Parent^.HWindow, HWindow);
end;

procedure TAboutDialog.WMDrawItem(var Msg:tMessage);
{*** Draws the Ok Button ***}
begin
	with PDrawItemStruct(Msg.lParam)^ do
    case CtlType of
      odt_Button:
        case CtlID of
					id_Ok : OkBut^.DrawItem(Msg);
				end;
    end;
end;

{********** Main program **********}

var
	MenuApp: TMenuApplication;
begin
	MenuApp.Init(AppName);
	MenuApp.Run;
	MenuApp.Done;
end.
