{**********************************************************************}
{*                                                                    *}
{* 		 Microworks Sample Application                           	     	*}
{*                                                                    *}
{*		 for Borland Pascal v7.0 and Turbo Pascal for Windows v1.5   		*}
{*                                                                    *}
{*     Copyright 1992-93 Jeff Franks (Microworks) Sydney, Australia.  *}
{*                                                                    *}
{*		 You are free to use, modify, reproduce and distribute the      *}
{*		 Sample Files (and/or any modified version) in any way you      *}
{*		 find useful.						                                        *}
{*                                                                    *}
{**********************************************************************}

{*** Introduction

	Application    := Basic SpecialFX Window

	Files          := SFXWin.pas

	Units Required := MWCC and MWCC.dll

	Tabs           := 2

	Screen         := 800 * 600

	Date           := June, 1993.

	The TSFXWindow object does not support the use of standard menus (menu bars)
	or TScroller scroll bars (ws_VScroll or ws_HScroll).

	Warning - Don't overide any inherited methods (not listed here) without first consulting
	          the documentation.

***}

program SFXWin;

uses WinTypes, WinProcs, MWCC,
		 {$IFDEF Ver15}
			 WObjects;
		 {$ELSE}
			 Objects, OWindows, ODialogs;
		 {$ENDIF}

const

	AppName : PChar = 'NewSFXWindow';

type

	PNewSFXApplication = ^TNewSFXApplication;
	TNewSFXApplication = object(TApplication)
		procedure InitMainWindow; virtual;
	end;

	PNewSFXWindow = ^TNewSFXWindow;
	TNewSFXWindow = object(TSFXWindow)
		constructor Init(AParent: PWindowsObject; AName: PChar);
		destructor Done; virtual;
		function GetClassName : PChar; virtual;
		procedure GetWindowClass(var AWndClass: TWndClass); virtual;
		procedure SetUpWindow; virtual;
		procedure Paint(PaintDC : hDC; var PS : TPaintStruct); virtual;
	end;

{********** TNewSFXApplication **********}

procedure TNewSFXApplication.InitMainWindow;
begin
	MainWindow := New(PNewSFXWindow, Init(nil, 'SpecialFX Window'));
end;

{********** TNewSFXWindow **********}

constructor TNewSFXWindow.Init(AParent: PWindowsObject; AName: PChar);
begin
	TSFXWindow.Init(AParent, AName);
	Attr.Style := Attr.Style;
	Attr.X := GetSystemMetrics(sm_CXScreen) div 4;
	Attr.Y := GetSystemMetrics(sm_CYScreen) div 4;
	Attr.W := GetSystemMetrics(sm_CXScreen) div 2;
	Attr.H := GetSystemMetrics(sm_CYScreen) div 2;
end;

destructor TNewSFXWindow.Done;
begin
	TSFXWindow.Done;
end;

function TNewSFXWindow.GetClassName;
begin
	GetClassName := AppName;
end;

procedure TNewSFXWindow.GetWindowClass(var AWndClass: TWndClass);
begin
	TSFXWindow.GetWindowClass(AWndClass);
end;

procedure TNewSFXWindow.SetUpWindow;
begin
	TSFXWindow.SetUpWindow;
end;

procedure TNewSFXWindow.Paint(PaintDC : HDC; var PS: TPaintStruct);
begin
end;

{********** Main program **********}

var
	SFXApp: TNewSFXApplication;
begin

	SFXApp.Init(AppName);
	SFXApp.Run;
	SFXApp.Done;
end.
