{**********************************************************************}
{*                                                                    *}
{* 		 Microworks Sample Application                           	     	*}
{*                                                                    *}
{*		 for Borland Pascal v7.0 and Turbo Pascal for Windows v1.5   		*}
{*                                                                    *}
{*     Copyright 1992-93 Jeff Franks (Microworks) Sydney, Australia.  *}
{*                                                                    *}
{*		 You are free to use, modify, reproduce and distribute the      *}
{*		 Sample Files (and/or any modified version) in any way you      *}
{*		 find useful.						                                        *}
{*                                                                    *}
{**********************************************************************}

{*** Introduction

	Application    := Basic SpecialFX DlgWindow

	Files          := SFXDlgW.pas, SFXDlgW.res

	Units Required := MWCC and MWCC.dll

	Tabs           := 2

	Screen         := 800 * 600

	Date           := June, 1993.

	The TSFXDlgWindow object does not support the use of standard menus (menu bars)
	or TScroller scroll bars (ws_VScroll or ws_HScroll).

	Warning - Don't overide any inherited methods (not listed here) without first consulting
	          the documentation.

***}

program SFXDlgW;

{$R SFXDlgW.res}

uses WinTypes, WinProcs, MWCC,
		 {$IFDEF Ver15}
			 WObjects;
		 {$ELSE}
			 Objects, OWindows, ODialogs;
		 {$ENDIF}

const

	AppName : PChar = 'NewSFXDlgWindow';

type

	PNewSFXApplication = ^TNewSFXApplication;
	TNewSFXApplication = object(TApplication)
		procedure InitMainWindow; virtual;
	end;

	PNewSFXDlgWindow = ^TNewSFXDlgWindow;
	TNewSFXDlgWindow = object(TSFXDlgWindow)
		constructor Init(AParent: PWindowsObject; AName: PChar);
		destructor Done; virtual;
		function GetClassName : PChar; virtual;
		procedure GetWindowClass(var AWndClass: TWndClass); virtual;
		procedure SetUpWindow; virtual;
	end;

{********** TNewSFXApplication **********}

procedure TNewSFXApplication.InitMainWindow;
begin
	MainWindow := New(PNewSFXDlgWindow, Init(nil, 'SFXDlgWindow'));
end;

{********** TNewSFXDlgWindow **********}

constructor TNewSFXDlgWindow.Init(AParent: PWindowsObject; AName: PChar);
begin
	TSFXDlgWindow.Init(AParent, AName);
end;

destructor TNewSFXDlgWindow.Done;
begin
	TSFXDlgWindow.Done;
end;

function TNewSFXDlgWindow.GetClassName;
begin
	GetClassName := AppName;
end;

procedure TNewSFXDlgWindow.GetWindowClass(var AWndClass: TWndClass);
begin
	TSFXDlgWindow.GetWindowClass(AWndClass);
end;

procedure TNewSFXDlgWindow.SetUpWindow;
var
	X, Y, W, H: Integer;
begin
	TSFXDlgWindow.SetUpWindow;
	X := GetSystemMetrics(sm_CXScreen) div 4;
	Y := GetSystemMetrics(sm_CYScreen) div 4;
	W := GetSystemMetrics(sm_CXScreen) div 2;
	H := GetSystemMetrics(sm_CYScreen) div 2;
	MoveWindow(HWindow, X, Y, W, H, True);
	SetWindowText(Hwindow, 'SpecialFX DlgWindow');
end;

{********** Main program **********}

var
	SFXApp: TNewSFXApplication;
begin

	SFXApp.Init(AppName);
	SFXApp.Run;
	SFXApp.Done;
end.
