(*
MultipleDialog unit by Guido Schoepp.
CompuServe: 100014,2141
  Internet: gus@rrz.de
		Fido: 2:2456/91.27

Creation Date: 02.05.1994
*)
UNIT MultiDialog;

INTERFACE

uses
	WinTypes, Objects, OWindows, ODialogs;

const
	CWM_SHORTCUT = WM_USER + 102;

type
	PChildDlgWindow = ^TChildDlgWindow;
	TChildDlgWindow = object(TDlgWindow)
		procedure SetupWindow; virtual;
		procedure WMCommand(var msg:TMessage); virtual wm_first + wm_command;
		procedure CWMShortCut(var Msg: TMessage); virtual CWM_SHORTCUT;
	end;

	{
	The width of the tab signal depends on the text but you can set
	a minimum width by setMinTitleWidth.
	The font of the tab signals is the same as the font of the first
	dialog added.
	}
	PMultipleDialogWindow = ^TMultipleDialogWindow;
	TMultipleDialogWindow = object(TWindow)
		minTitleWidth : Integer;
		list : PCollection;
		font : HFont;
		selected : Integer;

		constructor init(aParent:PWindowsObject; aTitle:PChar);
		destructor done; virtual;
		procedure setMinTitleWidth(w : Integer);
	{ Adds child dialogs. This will only work as long as the handle
	  of TMultipleDialogWindow is 0. }
		procedure addDialog(title : PChar; dlg : PChildDlgWindow);

		procedure GetWindowClass(var AWndClass: TWndClass); virtual;
		procedure SetupWindow; virtual;
		procedure Paint(dc: HDC; var PaintInfo: TPaintStruct); virtual;

		procedure WMLButtonDown(var msg: TMessage); virtual wm_First + wm_LButtonDown;
		procedure WMActivate(var msg: TMessage); virtual wm_First + wm_Activate;
		procedure WMCommand(var msg:TMessage); virtual wm_first + wm_command;
		procedure CWMShortCut(var Msg: TMessage); virtual CWM_SHORTCUT;
	end;


IMPLEMENTATION
uses Win31, WinProcs, Strings;
type
	PDlgListElem = ^TDlgListElem;
	TDlgListElem = object(TObject)
		dlg : PChildDlgWindow;
		title : PChar;
		r : TRect;
		shortCut : Word;

		constructor init(_dlg : PChildDlgWindow; _title : PChar; const _rect : TRect);
		destructor done; virtual;
	end;

const
	FilterCount : Word = 0;
	ShortCutUsed: Boolean = FALSE;
var
	nextHook : HHook;

function RWidth(const r : TRect):integer;
begin
	RWidth := abs(r.right - r.left);
end;

function RHeight(const r : TRect):integer;
begin
	RHeight := abs(r.bottom - r.top);
end;

{-------------------------------------------------------------------}

{ Filter dialog messages to use shortcuts for changing dialogs }
function MsgFilter(Code : Integer; wParam : Word; lParam : LongInt) : LongInt; export;

	function IsDialog(H : hWnd) : Boolean;
	var
		Style : LongInt;
	begin
		Style := GetWindowLong(H, gwl_Style);
		IsDialog := (Style and ws_TabStop = 0) or
						(Style and ws_Child = 0) or
						(Style and ws_Caption <> 0);
	end;

	function Notify(Control : hWnd; Msg, lParam : Word):Boolean;
	var
		Parent : hWnd;
	begin
		Notify := FALSE;
		Parent := GetParent(Control);
		while Parent <> 0 do
		begin
			if IsDialog(Parent) then
			begin
				shortCutUsed := FALSE;
				SendMessage(Parent, Msg, GetWindowWord(Control, GWW_ID), lParam);
				Notify := shortCutUsed;
				EXIT;
			end else
			begin
				Control := Parent;
				Parent := GetParent(Control);
			end;
		end;
	end;

var
	msg : TMessage;
begin
	msg := PMessage(lParam)^;
	if Code = MSGF_DIALOGBOX then
		if ((msg.Message = wm_KeyDown) or (msg.Message = wm_sysKeyDown))
			and ((msg.wParam >= ord('A')) and (msg.wParam<=ord('Z'))) then
		begin
			if Notify(msg.Receiver, CWM_SHORTCUT, msg.wParam) then
				EXIT;
		end;
	MsgFilter := CallNextHookEx(nextHook, Code, wParam, lParam);
end;

procedure InstallMsgFilter;
begin
	if FilterCount = 0 then
		NextHook := SetWindowsHookEx(WH_MSGFILTER, MsgFilter, HInstance, 0);
	Inc(FilterCount);
end;

procedure UninstallMsgFilter;
begin
	Dec(FilterCount);
	if FilterCount = 0 then
		UnhookWindowsHookEx(nextHook);
end;

{-------------------------------------------------------------------}

constructor TDlgListElem.init(_dlg : PChildDlgWindow; _title : PChar; const _rect : TRect);
var
	t : String;
	p : Byte;
begin
	if (dlg=NIL) or (_title=NIL) then FAIL;
	if not inherited init then FAIL;
	dlg := _dlg;
	title := StrNew(_title);
	r := _rect;

	t := StrPas(title);
	p:=pos('&',t);
	if p>0 then
		shortCut := ord(t[p+1])
	else
		shortCut := 0;
end;

destructor TDlgListElem.done;
begin
	StrDispose(title);
	inherited done;
end;

{-------------------------------------------------------------------}

procedure TChildDlgWindow.SetupWindow;
var
	s : Longint;
begin
	inherited SetupWindow;
end;

procedure TChildDlgWindow.WMCommand(var msg:TMessage);
begin
end;

procedure TChildDlgWindow.CWMShortCut(var Msg: TMessage);
begin
	if Parent<>NIL then
		SendMessage(Parent^.HWindow, msg.Message, msg.wParam, msg.lParam);
end;

{-------------------------------------------------------------------}

constructor TMultipleDialogWindow.init(AParent: PWindowsObject; ATitle: PChar);
begin
	if not inherited init(AParent, ATitle) then FAIL;
	attr.style := ws_dlgframe or ws_visible or ws_sysmenu;
	attr.exstyle := attr.exstyle or ws_ex_dlgmodalframe;
	new(list, init(10, 10));
	minTitleWidth := 0;
	font := 0;
	selected := 0;
	InstallMsgFilter;
end;

destructor TMultipleDialogWindow.done;
begin
	UnInstallMsgFilter;
	list^.freeAll;
	dispose(list, done);
	list := NIL;
	if font<>0 then DeleteObject(font);
	font := 0;
	inherited done;
end;

procedure TMultipleDialogWindow.GetWindowClass(var AWndClass: TWndClass);
begin
	inherited GetWindowClass(aWndClass);
	AWndClass.hbrBackground	:= GetStockObject(LTGRAY_BRUSH);
end;

procedure TMultipleDialogWindow.setMinTitleWidth(w : Integer);
begin
	minTitleWidth := w;
end;

procedure TMultipleDialogWindow.addDialog(title : PChar; dlg : PChildDlgWindow);
var
	r : TRect;
	el : PDlgListElem;
begin
	if (HWindow<>0) or (dlg=NIL) or (title=NIL) then EXIT;
	SetRectEmpty(r);
	new(el, init(dlg, title, r));
	list^.insert(el);
end;

procedure TMultipleDialogWindow.SetupWindow;
var
	r, tr : TRect;
	i : integer;
	dlg : PChildDlgWindow;
	hFont : THandle;
	logFont : TLogFont;
	el : PDlgListElem;
	dc : HDC;
	s : TSize;
	w : Integer;
begin
	inherited SetupWindow;
	if list^.count>0 then
	begin
		el := PDlgListElem(list^.At(0));
		el^.dlg^.Show(SW_SHOW);
		GetWindowRect(el^.dlg^.HWindow, r);
		SetWindowPos(el^.dlg^.HWindow, 0, 5+2, 30+2, 0, 0, SWP_NOSIZE or SWP_NOZORDER);
		for i:=1 to list^.count-1 do
		begin
			dlg := PDlgListElem(list^.At(i))^.dlg;
			dlg^.Show(SW_HIDE);
			SetWindowPos(dlg^.HWindow, 0, 5+2, 30+2, 0, 0, SWP_NOSIZE or SWP_NOZORDER);
			GetWindowRect(dlg^.HWindow, tr);
			UnionRect(r, r, tr);
		end;
		SetWindowPos(HWindow, 0, 0, 0,
						 rwidth(r) + 24, rheight(r) + GetSystemMetrics(SM_CYCAPTION) + 30 + 2 + 16,
						 SWP_NOMOVE or SWP_NOZORDER);
		SendMessage(PDlgListElem(list^.At(0))^.dlg^.HWindow, WM_ACTIVATE, WA_ACTIVE, 0);


		el := PDlgListElem(list^.At(0));
		hFont := SendMessage(el^.dlg^.hWindow, WM_GETFONT, 0, 0);
		if (hFont<>0) then
		begin
			if (WinProcs.GetObject(hFont, sizeof(logFont), @logFont)>0) then
				font := CreateFontIndirect(logFont);
		end;

		dc := CreateIC('DISPLAY', NIL, NIL, NIL);
		if font<>0 then
			SelectObject(dc, font)
		else
			SelectObject(dc, GetStockObject(SYSTEM_FONT));

		for i:=0 to list^.count-1 do
		begin
			el := PDlgListElem(list^.At(i));
			GetTextExtentPoint(dc, el^.title, strLen(el^.title), s.cx);
			if s.cx>minTitleWidth then
				w := s.cx
			else
				w := minTitleWidth;
			if i<=0 then
				SetRect(r, 5, 5, w, 30)
			else
				SetRect(r, PDlgListElem(list^.at(i-1))^.r.right, 5,
						 PDlgListElem(list^.at(i-1))^.r.right+w, 30);
			el^.r := r;
		end;
		DeleteObject(dc);
	end;
end;

procedure TMultipleDialogWindow.Paint(dc: HDC; var PaintInfo: TPaintStruct);
var
	wr, r : TRect;
	i : Integer;
	el : PDlgListElem;
	grayPen : HPen;

	procedure TabSignal(rect : TRect; active : Boolean);
	var
		x, y, w, h : integer;
	begin
		x := rect.left; y := rect.top;
		w := rwidth(rect); h := rheight(rect);

		SelectObject(dc, GetStockObject(BLACK_PEN));
		moveTo(dc, x, y+h);
		lineTo(dc, x, y+3);
		lineTo(dc, x+3, y);
		lineTo(dc, x+w-3, y);
		lineTo(dc, x+w, y+3);
		lineTo(dc, x+w, y+h);

		if not active then
			EXIT;
		SelectObject(dc, GetStockObject(WHITE_PEN));
		if active then
			moveTo(dc, x+1, y+h)
		else
			moveTo(dc, x+1, y+h-1);
		lineTo(dc, x+1, y+3);
		lineTo(dc, x+3, y+1);
		lineTo(dc, x+w-3, y+1);
		SelectObject(dc, grayPen);
		lineTo(dc, x+w-1, y+3);
		if active then
			lineTo(dc, x+w-1, y+h+1)
		else
			lineTo(dc, x+w-1, y+h);
	end;

begin
	if font<>0 then
		SelectObject(dc, font)
	else
		SelectObject(dc, GetStockObject(SYSTEM_FONT));
	grayPen := CreatePen(PS_SOLID, 1, RGB(192,192,192));
	SetBkMode(dc, TRANSPARENT);
	GetClientRect(HWindow, wr);
	el := PDlgListElem(list^.at(selected));

	SelectObject(dc, GetStockObject(BLACK_PEN));
	moveto(dc, el^.r.right, el^.r.bottom);
	lineTo(dc, rwidth(wr)-5, el^.r.bottom);
	lineTo(dc, rwidth(wr)-5, rheight(wr)-5);
	lineTo(dc, 5, rheight(wr)-5);
	lineTo(dc, 5, el^.r.bottom);
	lineTo(dc, el^.r.left, el^.r.bottom);
	SelectObject(dc, GetStockObject(WHITE_PEN));
	moveto(dc, el^.r.right-1, el^.r.bottom+1);
	lineTo(dc, rwidth(wr)-5, el^.r.bottom+1);
	SelectObject(dc, grayPen);
	moveto(dc, rwidth(wr)-5-1, el^.r.bottom+2);
	lineTo(dc, rwidth(wr)-5-1, rheight(wr)-5-1);
	lineTo(dc, 5+1, rheight(wr)-5-1);
	SelectObject(dc, GetStockObject(WHITE_PEN));
	lineTo(dc, 5+1, el^.r.bottom+1);
	lineTo(dc, el^.r.left+2, el^.r.bottom+1);

	TabSignal(el^.r, TRUE);
	drawText(dc, el^.title, strlen(el^.title), el^.r, DT_CENTER or DT_VCENTER or DT_SINGLELINE);

	for i:=0 to list^.count-1 do
		if (i<>selected) then
		begin
			el := PDlgListElem(list^.at(i));
			moveTo(dc, el^.r.left, el^.r.bottom);
			TabSignal(el^.r, FALSE);
			drawText(dc, el^.title, strlen(el^.title), el^.r, DT_CENTER or DT_VCENTER or DT_SINGLELINE);
		end;
	DeleteObject(grayPen);
end;

procedure TMultipleDialogWindow.WMLButtonDown(var msg: TMessage);
var
	r, dr : TRect;
	p : TPoint;
	i : Integer;
	el : PDlgListElem;
begin
	p := TPoint(msg.lParam);
	for i:=0 to list^.count-1 do
	begin
		el := PDlgListElem(list^.at(i));
		if PtInRect(el^.r, p) then
		begin
			if i<>selected then
			begin
				PDlgListElem(list^.at(selected))^.dlg^.Show(SW_HIDE);
				selected := i;
				InvalidateRect(HWindow, NIL, TRUE);
				el^.dlg^.Show(SW_SHOW);
				SendMessage(el^.dlg^.HWindow, WM_ACTIVATE, WA_ACTIVE, 0);
			end;
			break;
		end;
	end;
end;

procedure TMultipleDialogWindow.WMActivate(var msg: TMessage);
begin
	if (list<>NIL) and (list^.count>0) then
		SendMessage(PDlgListElem(list^.At(selected))^.dlg^.HWindow, WM_ACTIVATE, msg.wParam, msg.lParam)
end;

procedure TMultipleDialogWindow.CWMShortCut(var Msg: TMessage);
var
	i : Integer;
	el : PDlgListElem;
begin
	ShortCutUsed := FALSE;
	for i:=0 to list^.count-1 do
	begin
		el := PDlgListElem(list^.at(i));
		if (msg.lParam = el^.shortCut) then
		begin
			if i<>selected then
			begin
				PDlgListElem(list^.at(selected))^.dlg^.Show(SW_HIDE);
				selected := i;
				InvalidateRect(HWindow, NIL, TRUE);
				el^.dlg^.Show(SW_SHOW);
				SendMessage(el^.dlg^.HWindow, WM_ACTIVATE, WA_ACTIVE, 0);
			end;
			ShortCutUsed := TRUE;
			BREAK;
		end;
	end;
end;

procedure TMultipleDialogWindow.WMCommand(var msg:TMessage);
begin
end;

end.