{$IFDEF ver50}                         (* <<-- change for other vers *)
{$A-,B-,D-,E-,F-,I-,L-,N-,O-,R-,S-,V+}   (* must delete line for TP4 *)
{$ELSE}
{$R-,S-,I-,D+,T+,F-,V+,B-,N-,L+ }
{$ENDIF}

UNIT errmsgs;
(* allows proper explanation of run-time errors *)

(* ver 1.10 - Added Turbo 5 specific error messages *)
(* ver 1.20 - More messages - covers 5.5 ??         *)

INTERFACE

  FUNCTION version(print : boolean) : integer;
  (* Show version number, optionally display *)

IMPLEMENTATION

  CONST
    ver       = 120;
    copyrite  = ' Copyright (c) 1989 by C.B. Falconer';
    errxx     : string[13] = 'Unknown error';
    err001    : string[25] = 'Invalid DOS function code';
    err002    : string[14] = 'File not found';
    err003    : string[14] = 'Path not found';
    err004    : string[19] = 'Too many open files';
    err005    : string[18] = 'File access denied';
    err006    : string[19] = 'Invalid file handle';
    err008    : string[17] = 'Not enough memory';
{}  err010    : string[19] = 'Invalid environment';
{}  err011    : string[14] = 'Invalid format';
    err012    : string[24] = 'Invalid file access code';
    err015    : string[20] = 'Invalid drive number';
{}  err016    : string[31] = 'Cannot remove current directory';
    err017    : string[27] = 'Cannot rename across drives';
{}  err018    : string[13] = 'No more files';
{}  err048    : string[15] = 'Program aborted';
    err100    : string[15] = 'Disk read error';
    err101    : string[16] = 'Disk write error';
    err102    : string[17] = 'File not assigned';
    err103    : string[13] = 'File not open';
    err104    : string[23] = 'File not open for input';
    err105    : string[24] = 'File not open for output';
    err106    : string[22] = 'Invalid numeric format';
    err150    : string[20] = 'Disk write protected';
    err151    : string[12] = 'Unknown unit';
    err152    : string[15] = 'Drive not ready';
    err153    : string[15] = 'Unknown command';
    err154    : string[14] = 'Data CRC error';
    err155    : string[24] = 'Bad drv rq structure lgh';
    err156    : string[15] = 'Disk seek error';
    err157    : string[18] = 'Unknown media type';
    err158    : string[16] = 'Sector not found';
    err159    : string[20] = 'Printer out of paper';
    err160    : string[18] = 'Device write fault';
    err161    : string[17] = 'Device read fault';
    err162    : string[16] = 'Hardware failure';
    err200    : string[16] = 'Division by zero';
    err201    : string[17] = 'Range check error';
    err202    : string[14] = 'Stack overflow';
    err203    : string[13] = 'Heap overflow';
    err204    : string[25] = 'Invalid pointer operation';
    err205    : string[23] = 'Floating point overflow';
    err206    : string[24] = 'Floating point underflow';         (*TP5*)
    err207    : string[32] = 'Invalid floating point operation'; (*TP5*)
    err208    : string[29] = 'Overlay manager not installed';    (*TP5*)
    err209    : string[23] = 'Overlay file read error';          (*TP5*)

  VAR
    saverrproc : pointer;
    s          : pointer;    (* to string *)

  (* 1---------------1 *)
{$f+}
  PROCEDURE errprint;

    BEGIN (* errprint *)
    exitproc := saverrproc; s := addr(errxx); (* default *)
    IF longint(erroraddr) <> 0 THEN BEGIN
      CASE exitcode OF
1:      s := addr(err001);
2:      s := addr(err002);
3:      s := addr(err003);
4:      s := addr(err004);
5:      s := addr(err005);
6:      s := addr(err006);
8:      s := addr(err008);
10:     s := addr(err010);
11:     s := addr(err011);
12:     s := addr(err012);
15:     s := addr(err015);
16:     s := addr(err016);
17:     s := addr(err017);
18:     s := addr(err018);
48:     s := addr(err048);
100:    s := addr(err100);
101:    s := addr(err101);
102:    s := addr(err102);
103:    s := addr(err103);
104:    s := addr(err104);
105:    s := addr(err105);
106:    s := addr(err106);
150:    s := addr(err150);
151:    s := addr(err151);
152:    s := addr(err152);
153:    s := addr(err153);
154:    s := addr(err154);
155:    s := addr(err155);
156:    s := addr(err156);
157:    s := addr(err157);
158:    s := addr(err158);
159:    s := addr(err159);
160:    s := addr(err160);
161:    s := addr(err161);
162:    s := addr(err162);
200:    s := addr(err200);
201:    s := addr(err201);
202:    s := addr(err202);
203:    s := addr(err203);
204:    s := addr(err204);
205:    s := addr(err205);
206:    s := addr(err206);
207:    s := addr(err207);
208:    s := addr(err208);
209:    s := addr(err209);
   (* OTHERWISE uses the default errxx *)
        END; (* case *)
      writeln(string(s^)); END;
    END; (* errprint *)

  (* 1---------------1 *)

  FUNCTION version(print : boolean) : integer;
  (* Show version number, optionally display *)

    BEGIN (* version *)
    version := ver;
    IF print THEN BEGIN
      write('ERRMSGS  module Version ', ver DIV 100 : 1, '.');
      IF ver MOD 100 < 10 THEN write('0');
      writeln(ver MOD 100, '.', copyrite); END;
    END; (* version *)

  (* 1---------------1 *)

  BEGIN (* errmsgs initialization routine *)
  saverrproc := exitproc; exitproc := addr(errprint);
  IF version(false) <> ver THEN halt;
  END. (* errmsgs *)
u