biosdat	equ	040h;		segment for bios data
ticker	equ	06ch;		offset of tick counter, 3 bytes
; we also reference the overflow byte at 070h implicitly

; We cannot define a 'segment at' because the TP linkage barfs

code	segment word
public	initc
public	clk

assume	cs : code
;
; Reprogram the timer to operate in mode 2.  This will cause
; the interrupt to be a 1 uS pulse, and MAY cause some machines
; to ignore the interrupt.  Each invocation will probably lose 
; about 10 uSecs of system time, depending on CPU clock rate.
; This should be negligible compared to actual clock accuracy.
initc	proc	near
	mov	ax,biosdat
	mov	es,ax
	mov	di,ticker
	mov	al,es:[di]
initc1:	cmp	al,es:[di];	To avoid fouling the time of day
	jz	initc1;		wait for a clock tick, synchronize
	cli;			If interrupts weren't on we never got here
	mov	al,034h;	timer 0, mode 2, 2 byte rd/wrt, binary
	out	043h,al;	reprogram it.  This will lose a few uS
	xor	al,al
	out	040h,al;	set the register 0
	out	040h,al;	MUST write both
	sti;			re-arm interrupts
	ret
initc	endp

; FUNCTION clock : real;     (* The time unit is hours *)
; The value returned is 128 larger than 'hours after midnight'.  By
; not making any correction here we avoid doing any floating point
; arithmetic, and make capturing the clock a fast operation.  The
; fundamental 'hours' unit reflects the actual clock operation, so
; that accuracy is dependant only on the timebase oscillator.
;
; This code is highly dependant on the 6 byte TP real format.  It 
; will not mix with programs that have redeclared a real to be one
; of the 8087 formats.  The clock resolution is about 0.85 uS.
;
; Since the clock overflow bit is set at midnight, and reset by a 
; bios time enquiry, performing any other time accesses can cause
; erroneous results for times straddling midnight.  This can be 
; detected by the fact that the clock value became smaller, and
; the later value should be increased by 24.  After two occurances
; of midnight all bets are off.
clk	proc	near
	push	ds
	mov	ax,biosdat
	mov	ds,ax
	mov	di,ticker;	monitor occurence of timer ticks.
clk1:	mov	si,di;		which can cause peculiar results
	mov	ch,[di]
	mov	al,0
	pushf
	cli
	out	043h,al;	access timer 0
	in	al,040h;	get lsb
	mov	ah,al
	in	al,040h;	get msb
	popf;			restore interrupt enable setting
	not	ax;		timer counts down.
	mov	bl,al
	lodsb
	mov	bh,al
	lodsb
	mov	dl,al
	lodsb
	mov	dh,al
	inc	si
	inc	si;		point to timer overflow
	test	byte ptr [si],0ffh
	jz	clk2;		no overflow
	add	dh,24;		else add 24 hours
clk2:	cmp	ch,[di];	check no interrupt snuck in
	jnz	clk1;		if so repeat, get consistent values
	mov	al,088h;	set binary point
	pop	ds
	ret
clk	endp

code	ends
	end
x