UNIT MOUSEG;


{ MOUSEG.TPU: BY JEFF EWING JAN 1992  REV 2.0 SEPT 92
  THIS UNIT PROVIDES A LIBRARY OF MOUSE CALLS FOR YOU TO USE.  
  TO USE THIS UNIT JUST ADD THIS TO YOUR PROGRAM DECLARATION:  

  USES MOUSEG;                                                 

  PROGRAM SUBMITTED BY : JEFFREY EWING AKA VISION SOFTWARE.   
  VERSION 2.1 REVISED 19 JUN 92 REVISED 3 SEPT 92              }





INTERFACE

VAR


(* GLOBAL VARIABLES FOR PROCEDURES AND FUNCTIONS TO PASS TO MOUSE *)

RAX,

RBX,

RCX,

RDX   : WORD;


(* THESE ARE THE VARIABLES FOR THE USER TO USE IN PROGRAM          *)

(* TO MANIPULATE THE MOUSE                                         *)

Presses,X,Y     :    WORD;            { MOUSE X/Y COORDINATES }

LM,RM,MM:    BOOLEAN;         { MOUSE BUTTON STATUS   }






PROCEDURE MOUSE (VAR M1,M2,M3,M4:WORD);

PROCEDURE MOUSENOW (VAR LB,RB,MB:BOOLEAN; VAR XMOUSE,YMOUSE:WORD);

PROCEDURE MOUSESHOW;

PROCEDURE MOUSEHIDE;

PROCEDURE MOUSEINCHES(HMOUSEINCHES,VMOUSEINCHES:WORD);

PROCEDURE PRESSLEFT(PRESSES,XMOUSE,YMOUSE:WORD);

PROCEDURE PRESSRIGHT(PRESSES,XMOUSE,YMOUSE:WORD);

PROCEDURE RELEASELEFT(PRESSES,XMOUSE,YMOUSE:WORD);

PROCEDURE RELEASERIGHT(PRESSES,XMOUSE,YMOUSE:WORD);

PROCEDURE MOUSERANGE (X1,Y1,X2,Y2:WORD);

PROCEDURE MOUSEMICKEY (VAR MHORIZ,MVERT: INTEGER);

PROCEDURE MOUSEPUT (X,Y:WORD);

PROCEDURE MOUSEWARP(THRESHOLD:WORD);

PROCEDURE MOUSESETGCURSOR(CURSORSTRING:STRING);

PROCEDURE CURSOFF;

PROCEDURE CURSON;


FUNCTION  MOUSEINIT: BOOLEAN;

FUNCTION  MOUSEX: WORD;

FUNCTION  MOUSEY: WORD;






IMPLEMENTATION


(**************************  PROCEDURE MOUSE  *******************************)

PROCEDURE MOUSE(VAR M1,M2,M3,M4:WORD);   (* PROCEDURE DECLARATION   *)



(* THIS IS THE MAIN MOUSE ROUTINE. ITS CALLED FROM ALL THE OF THE  *)

(* OTHER MOUSE PROCEDURES. REFER TO IBM TECHNICAL REFRENCE FOR ANY *)

(* FURTHER INFORMATION CONCERNING CALLS TO A MICROSOFT COMPATIBLE  *)

(* [aka IBM] MOUSE.                                                *)


VAR

MF,

MC,

MC2,

MC3: WORD;



BEGIN  (* MOUSE *)

  MF:=M1;

  MC:=M2;

  MC2:=M3;

  MC3:=M4;

  ASM

    MOV AX,MF        (* MOUSE FUNCTION NUMBER GOES HERE *)

    MOV BX,MC        (* MOUSE DATA GOES HERE            *)

    MOV CX,MC2        (* AND HERE...                     *)

    MOV DX,MC3        (* AND HERE...                     *)

    INT $33          (* CALL MOUSE INTERRUPT HANDLER    *)

    MOV MF,AX        (* DATA IS RETURNED HERE:          *)

    MOV MC,BX        (* AND HERE...                     *)

    MOV MC2,CX        (* AND HERE...                     *)

    MOV MC3,DX        (* AND HERE...                     *)

  END;

  (* PUT THE NEW INFO BACK IN THE VARIABLES *)

  M1:=MF;

  M2:=MC;

  M3:=MC2;

  M4:=MC3;

END;   (* MOUSE *)

(**************************  END PROCEDURE MOUSE  ***************************)



(**************************  PROCEDURE MOUSENOW  ****************************)

PROCEDURE MOUSENOW(VAR LB,RB,MB: BOOLEAN; VAR XMOUSE,YMOUSE:WORD);  (* PROCEDURE DECLARATION *)



(* THIS PROCEDURE RETURN THE CURRENT MOUSE LOCATION *)

(* AND STATUS OF 3 BUTTONS (BOOLEAN) TRUE IF PUSHED *)



BEGIN  (* MOUSENOW *)

 RAX:=3;               (* MOUSE FUNCTION 3 *)

 RBX:=0;

 RCX:=XMOUSE;

 RDX:=YMOUSE;

 MOUSE(RAX,RBX,RCX,RDX);

 LB:=((RBX = 1) OR (RBX = 3) OR (RBX = 5) OR (RBX = 7));

 RB:=((RBX = 2) OR (RBX = 3) OR (RBX = 6) OR (RBX = 7));

 MB:=((RBX = 4) OR (RBX = 5) OR (RBX = 6) OR (RBX = 7));


 XMOUSE:= RCX;           (* UPDATE X/Y VARS WITH MOUSE POSITION *)

 YMOUSE:= RDX;

END;   (* MOUSENOW *)

(**************************  END PROCEDURE MOUSENOW  ************************)



(**************************  PROCEDURE MOUSESHOW  ***************************)

PROCEDURE MOUSESHOW; (* PROCEDURE DECLARATION *)



(* THIS PROCEDURE TURNS THE MOUSE CURSOR ON   *)




BEGIN  (* MOUSESHOW *)

  RAX:=1;

  RBX:=0;

  RCX:=0;

  RDX:=0;

  MOUSE(RAX,RBX,RCX,RDX);   (* MOUSE FUNCTION 1 *)

END;   (* MOUSESHOW *)

(**************************  END PROCEDURE MOUSESHOW  ***********************)



(**************************  PROCEDURE MOUSEHIDE  ***************************)

PROCEDURE MOUSEHIDE; (* PROCEDURE DECLARATION *)



(* THIS PROCEDURE TURNS THE MOUSE CURSOR OFF  *)



BEGIN  (* MOUSEHIDE *)

  RAX:=2;

  RBX:=0;

  RCX:=0;

  RDX:=0;

  MOUSE (RAX,RBX,RCX,RDX);   (* MOUSE FUNCTION 2 *)

END;   (*MOUSEHIDE *)

(**************************  END PROCEDURE MOUSEHIDE  ***********************)

(*************************  pROCEDURE MOUSEINCHES  *************************)

PROCEDURE MOUSEINCHES(HMOUSEINCHES,VMOUSEINCHES:WORD);


BEGIN  (* MOUSEINCHES *)

  RAX:=15;

  RBX:=0;

  IF HMOUSEINCHES > 100 THEN HMOUSEINCHES:=100;

  IF VMOUSEINCHES > 100 THEN VMOUSEINCHES:=100;

  RCX:=HMOUSEINCHES * 5 DIV 2;

  RDX:=VMOUSEINCHES * 8;

  MOUSE (RAX,RBX,RCX,RDX);


END;   (* MOUSEINCHES *)

(*************************  END PROCEDURE MOUSEINCHES  **********************)

(*************************  PROCEDURE PRESSLEFT        **********************)

PROCEDURE PRESSLEFT(PRESSES,XMOUSE,YMOUSE:WORD);

BEGIN  (*PRESSLEFT *)

  RAX:=5;

  RBX:=0;

  RCX:=0;

  RDX:=0;

  MOUSE(RAX,RBX,RCX,RDX);

  PRESSES:=RBX;

  XMOUSE:=RCX;

  YMOUSE:=RDX;


END;   (* PRESSLEFT *)

(*************************  END PROCEDURE PRESSLEFT    **********************)


(*************************  PROCEDURE PRESSRIGHT       **********************)

PROCEDURE PRESSRIGHT(PRESSES,XMOUSE,YMOUSE:WORD);

BEGIN  (* PRESSRIGHT *)

  RAX:=5;

  RBX:=1;

  RCX:=0;

  RDX:=0;

  MOUSE(RAX,RBX,RCX,RDX);

  PRESSES:=RBX;

  XMOUSE:=RCX;

  YMOUSE:=RDX;


END;   (* PRESSLEFT *)


(*************************  ENDPROCEDURE PRESSRIGHT    **********************)


(*************************  PROCEDURE RELEASELEFT      **********************)

PROCEDURE RELEASELEFT(PRESSES,XMOUSE,YMOUSE:WORD);

BEGIN  (*RELEASELEFT *)

  RAX:=6;

  RBX:=0;

  RCX:=0;

  RDX:=0;

  MOUSE(RAX,RBX,RCX,RDX);

  PRESSES:=RBX;

  XMOUSE:=RCX;

  YMOUSE:=RDX;


END;   (* RELEASELEFT *)

(*************************  END PROCEDURE RELEASELEFT  **********************)


(*************************  PROCEDURE RELEASERIGHT     **********************)

PROCEDURE RELEASERIGHT(PRESSES,XMOUSE,YMOUSE:WORD);

BEGIN  (* RELEASERIGHT *)

  RAX:=6;

  RBX:=1;

  RCX:=0;

  RDX:=0;

  MOUSE(RAX,RBX,RCX,RDX);

  PRESSES:=RBX;

  XMOUSE:=RCX;

  YMOUSE:=RDX;


END;   (* RELEASELEFT *)


(*************************  ENDPROCEDURE PRESSRIGHT    **********************)



(**************************  PROCEDURE MOUSERANGE  **************************)

PROCEDURE MOUSERANGE(X1,Y1,X2,Y2:WORD);     (* PROCEDURE DECLARATION   *)



(* THIS PROCEDURE DEFINES A WINDOW FOR THE MOUSE CURSOR TO OPERATE IN. *)

(* X1,Y1 ARE COORDINATES FOR UPPER LEFT OF WINDOW. X2,Y2 ARE THE LOWER *)

(* RIGHT COORDINATES OF THE MOUSE WINDOW.                              *)



BEGIN  (* MOUSERANGE *)

  RAX:=7;

  RBX:=0;

  RCX:=X1;

  RDX:=X2;

  MOUSE(RAX,RBX,RCX,RDX);   (* PASS THE TWO X COORDINATES *)


  RAX:=8;

  RBX:=0;

  RCX:=Y1;

  RDX:=Y2;

  MOUSE(RAX,RBX,RCX,RDX);   (* PASS THE TWO Y COORDINATES *)


END;   (* MOUSERANGE *)

(**************************  END PROCEDURE MOUSERANGE  **********************)



(**************************  PROCEDURE MOUSESOFT  ***************************)

PROCEDURE MOUSESOFT(SCREENMASK,CURSORMASK:WORD); (* PROCEDURE DECLARATION   *)


(*  THIS SUB REDEFINES THE TEXT CURSOR FOR THE MOUSE                        *)

(*  FOR EXAMPLE YOU CAN CHANGE THE CURSOR COLOR, AND CHARACTER(S) DISPLAYED *)

(*  UNDER THE CURSOR AS WELL AS THE CURSOR ITSELF.                          *)


BEGIN  (* MOUSESOFT *)

 RAX:=10;

 RBX:=0;

 RCX:=SCREENMASK;

 RDX:=CURSORMASK;

 MOUSE(RAX,RBX,RCX,RDX);

END;   (* MOUSESOFT *)

(**************************  END PROCEDURE MOUSESOFT  ***********************)



(**************************  PROCEDURE MOUSEMICKEY  *************************)

PROCEDURE MOUSEMICKEY(VAR MHORIZ,MVERT: INTEGER); (* PROCEDURE DECLARATION   *)


(*  THIS PROCEDURE RETURNS "MICKEYS" OR RELATIVE MOTION COUNTS SINCE LAST   *)

(*  TO THIS ROUTINE. IF MOUSE HAS NOT BEEN MOVED SINCE LAST CALL, ZEROS     *)

(*  ARE RETURNED.                                                           *)


BEGIN  (* MOUSEMICKEY *)

  RAX:=11;       (* MOUSE FUNCTION 11                         *)

  RBX:=0;

  RCX:=MHORIZ;

  RDX:=MVERT;


  MOUSE(RAX,RBX,RCX,RDX);


  MVERT:=RCX;

  MHORIZ:=RDX;


  IF MVERT > 62000 THEN   MVERT:= -1 * (MVERT  - 65535);

  IF MHORIZ > 62000 THEN MHORIZ:= -1 * (MHORIZ - 65535);




END;   (* MOUSEMICKEY *)

(**************************  END PROCEDURE MOUSEMICKEY  *********************)



(**************************  PROCEDURE MOUSEPUT  ****************************)

PROCEDURE MOUSEPUT(X,Y:WORD); (* PROCEDURE DECLARATION   *)


(* THIS PROCEDURE "PUTS" THE MOUSE CURSOR AT THE X/Y COORDINATES            *)


BEGIN  (* MOUSEPUT *)

  RAX:=4;      (* MOUSE FUNCTION 4                          *)

  RBX:=0;

  RCX:=X;      (* HORIZONTAL POSITION TO PLACE MOUSE CURSOR *)

  RDX:=Y;      (* VERTICAL   POSITION TO PLACE MOUSE CURSOR *)

  MOUSE (RAX,RBX,RCX,RDX);

END;   (* MOUSEPUT *)

(**************************  END PROCEDURE MOUSEPUT *************************)



(**************************  PROCEDURE MOUSEWARP  ***************************)

PROCEDURE MOUSEWARP(THRESHOLD:WORD); (* PROCEDURE DECLARATION   *)


(* THIS PROCEDURE SETS THE DOUBLE SPEED THRESHOLD FOR THE MOUSE IN UNITS    *)

(* OF MICKEYS PER SECOND. THE DEFAULT SETTING IS 64 MICKEYS PER SECOND      *)

(* WHEN THE MOUSE IS MOVED FASTER THAN THE THRESHOLD VALUE, THE CURSOR      *)

(* MOTION VALUE IS DOUBLED. tHIS MAKES THE CURSOR ZIP ACROSS THE SCREEN     *)

(* DURING FAST MOUSE MOVES.                                                 *)


BEGIN  (* MOUSEWARP *)

  RAX:=19;

  RBX:=0;

  RCX:=0;

  RDX:=THRESHOLD;

  MOUSE(RAX,RBX,RCX,RDX);

END;   (* MOUSEWARP *)

(**************************  END PROCEDURE MOUSEWARP  ***********************)



(**************************  PROCEDURE MOUSESETGCURSOR  *********************)

PROCEDURE MOUSESETGCURSOR(CURSORSTRING:STRING); (* PROCEDURE DECLARATION    *)

VAR

TEMP: STRING;   (* COPY OF CURSOR STRING *)

XHOT,           (*  X HOT SPOT LOCATION  *)

YHOT: WORD;     (*  X HOT SPOT LOCATION  *)


BEGIN  (* MOUSESETGCURSOR *)

  TEMP:= CURSORSTRING;

  XHOT:= ORD(TEMP[1]);

  YHOT:= ORD(TEMP[2]);

  RAX:=9;

  RBX:=XHOT;

  RCX:=YHOT;

  RDX:=OFS(TEMP[1]);

  ASM

    MOV AX,RAX

    MOV BX,RBX

    MOV CX,RCX

    MOV DX,RDX

    INT $33

  END;


END;   (* MOUSESETGCURSOR *)

(**************************  END PROCEDURE MOUSESETGCURSOR  *****************)


(**************************  PROCEDURE CURSOFF  *****************************)

PROCEDURE CURSOFF; (* PROCEDURE DECLARATION            *)


(* THIS PROCEDURE SHUTS OFF THE FAMILIAR FLASHING TEXT *)

(* CURSOR. THERE ARE NO PARAMETERS REQUIRED.           *)



BEGIN  (* CURSOFF *)

 ASM

   MOV AX,256

   MOV CX,256

   INT $10

 END;

END;   (* CURSOFF *)

(**************************  END PROCEDURE CURSOFF  *************************)



(**************************  PROCEDURE CURSON  ******************************)

PROCEDURE CURSON; (* PROCEDURE DECLARATION                                  *)

(* THIS PROCEDURE TURNS THE FAMILIAR TEXT CURSOR ON.                        *)

(* THIS PROCEDURES WORKS HAND IN HAND WITH CURSOFF                          *)


BEGIN  (* CURSON *)

  ASM

    MOV CX,1543

    MOV AX,$100

    INT $10

  END;


END;   (* CURSON *)

(**************************  END PROCEDURE CURSON ***************************)



(**************************  FUNCTION MOUSEINIT *****************************)

FUNCTION MOUSEINIT: BOOLEAN; (* FUNCTION DECLARATION                        *)


(* THIS FUNCTION CHECKS IF THERE IS A MOUSE DRIVER PRESENT                  *)

(* IF NOT THEN RAX RETURNS A 0. THIS FUNCTION RETURNS FALSE                 *)

(* IF NO MOUSE IS FOUND.                                                    *)



BEGIN  (* MOUSEINIT*)


 RAX:=0;

 RBX:=0;

 RCX:=0;

 RDX:=0;

 MOUSE(RAX,RBX,RCX,RDX);

   IF RAX=0 THEN

      MOUSEINIT:=FALSE

   ELSE

      MOUSEINIT:=TRUE;


      
END;   (* MOUSEINIT *)

(**************************  END FUNCTION MOUSEINIT *************************)



(**************************  FUNCTION MOUSEX  *******************************)

FUNCTION MOUSEX:WORD;     (* FUNCTION DECLARATION                           *)


(* THIS FUNCTION RETURNS THE CURRENT X-COORDINATE OF MOUSE LOCATION         *)


BEGIN  (* MOUSEX *)

  RAX:=3;    (* MOUSE FUNCTION 3 {MOUSENOW } *)

  RBX:=0;    (* DUMMY VARS TO PASS           *)

  RCX:=0;

  RDX:=0;

  MOUSE(RAX,RBX,RCX,RDX);

  MOUSEX:=RCX;

END;   (* MOUSEX *)

(**************************  END FUNCTION MOUSEX  ***************************)



(**************************  FUNCTION MOUSEY  *******************************)

FUNCTION MOUSEY:WORD;     (* FUNCTION DECLARATION                           *)


(* THIS FUNCTION RETURNS THE CURRENT Y-COORDINATE OF MOUSE LOCATION         *)


BEGIN  (* MOUSEY *)

  RAX:=3;    (* MOUSE FUNCTION 3 {MOUSENOW } *)

  RBX:=0;    (* DUMMY VARS TO PASS           *)

  RCX:=0;

  RDX:=0;

  MOUSE(RAX,RBX,RCX,RDX);

  MOUSEY:=RDX;

END;    (* MOUSEY *)

(**************************  END FUNCTION MOUSEY  ***************************)



{ THIS FRAGMENT OF CODE REQUIRED FOR TURBO 6.0 }

BEGIN

(* INITILIZE MOUSE VARIABLES *)

  X:=0;

  Y:=0;

  LM:=FALSE;

  MM:=FALSE;

  RM:=FALSE;


(* INITILIZE GLOBAL MOUSE PROCEDURE VARIABLES *)

  RAX:=0;

  RBX:=0;

  RCX:=0;

  RDX:=0;
  Presses:=0;

END.

