
{a program to show the three possible eye styles on the screen}
{Written by Michael Day as of 4 September 1989}
{released to the public domain by the author}
{10 Sept 89 - Fixed Herc Graphics mode mouse}
{20 March 93 - adjusted absolute addressing for protected mode operation}

program Ogle;
uses crt,graph,mouse,eyes;

{const Seg0040 = $40;}  {<-- if you are using V6 TP or lower, uncomment this}

var SysClk : ^word; {absolute $40:$6C;}
    EyeData : array[0..10] of EyeDataRec;
    EyeSize : integer;
    MaxEye : integer;

    i,gr,gd:integer;
    OldClock:word;

begin
   SysClk := ptr(Seg0040,$6C);
 {  BackgroundMouse(true); }
   gd := 0;  gr := 0;    {start up the graphics}
   InitGraph(gd,gr,'');
   i := GraphResult;
   if GraphResult <> GrOK then
   begin
     Writeln('GraphError:',GrOK);
     Halt(1);
   end;

   if gd = HercMono then  {if Herc, enable herc mouse}
     SetHercMouse(0);

   MaxEye := 2;          {init the eyes}
   EyeSize := 10;

   if (gd = EGA) or (gd = VGA) then
   begin
     SetFillStyle(CloseDotFill,blue);  {init the screen}
     Bar(0,0,GetMaxX,GetMaxY);
     MakeEyes(EyeData[0],(GetMaxX div 3),GetMaxY div 3,
               EyeSize,2,white,brown,lightblue);
     MakeEyes(EyeData[1],((GetMaxX div 3)*2),GetMaxY div 3,
               EyeSize*2,1,black,white,yellow);
     MakeEyes(EyeData[2],(GetMaxX div 2),(GetMaxY div 3)*2,
               EyeSize*3,0,red,green,black);
   end
   else
   begin
     SetFillStyle(CloseDotFill,white);  {init the screen}
     Bar(0,0,GetMaxX,GetMaxY);
     MakeEyes(EyeData[0],(GetMaxX div 3),GetMaxY div 3,
               EyeSize,2,white,black,black);
     MakeEyes(EyeData[1],((GetMaxX div 3)*2),GetMaxY div 3,
               EyeSize*2,1,black,white,white);
     MakeEyes(EyeData[2],(GetMaxX div 2),(GetMaxY div 3)*2,
               EyeSize*3,0,black,white,white);
   end;

   
   setcolor(white);           {show which eyes are which}
   Outtextxy(EyeData[0].Lecx-EyeData[0].Exr,
              EyeData[0].Lecy+EyeData[0].Eyr+4,' Log2');
   Outtextxy(EyeData[1].Lecx-EyeData[1].Exr,
              EyeData[1].Lecy+EyeData[1].Eyr+4,'   Scaled');
   Outtextxy(EyeData[2].Lecx,
              EyeData[2].Lecy+EyeData[2].Eyr+4,'  Clipped');

   InitMouse;                       {startup the mouse}
   ShowMouse;
   i := 0;
   while not keypressed do              {Do it until a key is pressed}
   begin
     if (OldClock <> SysClk^) then     {only update on clock change}
     begin                              {this minimizes flicker}
       ReadMouse;
       OldClock := SysClk^;
       LookAt(EyeData[i],GetMx(MouseX),GetMy(MouseY)); {update the eyes}
       inc(i);
       if i > MaxEye then i := 0;       {rotate through all the eyes}
     end;
   end;
   HideMouse;
   CloseGraph;   {all done, go home}
end.

