
{ a program to test a graphics based mouse }
{ written by Michael Day as of 20 Mar 1993 }
{ this program is released to the public domain }

program GmTest;
uses crt,Graph,Mouse;

{const Seg0040 = $40;} {<-- uncomment this if you are using TP6 or lower}

type string80 = string[80];
var gm,gd,i:integer;
    R,X,Y:integer;
    MaxLen : integer;
    Done:boolean;
    OmouseX,OmouseY:integer;
    OldClk : word;
    SysClk : ^word; {absolute $40:$6C;}
    ch : char;
    S : string[80];

const
   KeyHome = #199;
   KeyEnd  = #207;
   KeyPgUp = #201;
   KeyPgDo = #209;
   KeyArUp = #200;
   KeyArDo = #208;
   KeyArLft = #203;
   KeyArRgt  = #205;
   KeyA = 'A';
   KeyC = 'C';
   KeyL = 'L';
   KeyR = 'R';
   KeyS = 'S';
   KeyD = 'D';
   KeyH = 'H';
   KeyG = 'G';
   KeyRet = #13;

{convert an integer to a string}
function fstr(I:integer):string80;
var temp:string80;
begin
  str(i,temp);
  fstr := temp;
end;

{show the current mouse status}
procedure ShowPosition;
begin
   if not(MouseCondo) then HideMouse;
{   HideMouseArea(PutMx(0),PutMy((GetMaxY-10)-16), }  {alternate hide for}
{                 PutMx(GetMaxX),PutMy(GetMaxY));  }  {non-EGA screens}

   S := 'X:'+fstr(GetMx(MouseX))+
       ' Y:'+fstr(GetMy(MouseY))+
       ' CrtMode:'+fstr(CrtMode^)+
       ' MouseType:'+fstr(MouseType)+
       ' Cur:'+fstr(M.MouseGShape);
   if ((length(S)+5)*TextWidth('X')) > MaxLen then
   begin
     MaxLen := (length(S)+5)*TextWidth('X');
     Rectangle(0,GetMaxY-(TextHeight('X')+4),MaxLen,GetMaxY);
   end;
   SetFillStyle(SolidFill,black);
   Bar(1,GetMaxY-(TextHeight('X')+4)+1,MaxLen-1,GetMaxY-1);
   SetColor(MouseColor);
   OutTextXY(4,GetMaxY-9,S);
   if not(MouseCondo) then ShowMouse;
end;

begin
   Done := false;
   SysClk := ptr(Seg0040,$6C);

   gd := 0;        {<- you can force a display type here}
   gm := 0;
   InitGraph(gd,gm,'');      {init the graphics display}
   if gd = HercMono then     {if Herc display, set Herc mouse page to 0}
     SetHercMouse(0);
   setcolor(red);
   rectangle(0,0,GetMaxX,GetMaxY);
   SetColor(GetMaxColor);
   MaxLen := 1;
   for i := 1 to 50 do        {put some circles on the screen}
   begin                                {to make it look busy}
     R := random(40)+10;
     X := random(GetMaxX);
     Y := random(GetMaxY);
     Circle(X,Y,R);
   end;

   UseSimMouse := true;    {<-- uncomment this to use mouse emulation}

   MouseColor := white;
   InitMouse;

 {  MouseInstalled := false;}  {<-- uncomment to disable existing mouse}

{   BackGroundMouse(true); }    {<-- uncomment to hook mouse to clock ISR }

   SetMouseArea(PutMx(0),PutMy(0),PutMx(GetMaxX),PutMy(GetMaxY));
   SetMousePosition(PutMx(GetMaxX shr 1),PutMy(GetMaxY shr 1));
   ShowMouse;
   while not(Done) do
   begin                    {we can also use the keyboard to move the mouse}
     if KeyPressed then
     begin
       ch := upcase(ReadKey);
       if ch = #0 then
         ch := char(ord(ReadKey) or $80);
       case ch of
         KeyHome : begin SetMousePosition(PutMx(0),MouseY); end;
         KeyEnd  : begin SetMousePosition(PutMx(GetMaxX),MouseY); end;
         KeyPgUp : begin SetMousePosition(MouseX,PutMy(0)); end;
         KeyPgDo : begin SetMousePosition(MouseX,PutMy(GetMaxY)); end;
         KeyArUp : begin SetMousePosition(MouseX,PutMy(GetMy(MouseY)-1)); end;
         KeyArDo : begin SetMousePosition(MouseX,PutMy(GetMy(MouseY)+1)); end;
         KeyArLft : begin SetMousePosition(PutMx(GetMx(MouseX)-1),MouseY); end;
         KeyArRgt : begin SetMousePosition(PutMx(GetMx(MouseX)+1),MouseY); end;
         KeyC : begin MouseGraphicCursor(MouseClockCursor); End;
         KeyL : begin MouseClicked := true; MouseClickButton := 1; end;
         KeyR : begin MouseClicked := true; MouseClickButton := 2; end;
         KeyS : begin if not(SaveMouse) then outtext(' Save Error '); end;
         KeyD : begin if not(RestoreMouse) then outtext(' Restore Error '); end;
         KeyH : begin HideMouse; end;
         KeyG : begin ShowMouse; end;
         KeyA : begin HideMousearea(GetMaxX shr 2,GetMaxY shr 2,
                                    GetMaxX shr 1,GetMaxY shr 1);
                      rectangle((GetMaxX shr 2)-1,(GetMaxY shr 2)-1,
                                (GetMaxX shr 1)+1,(GetMaxY shr 1)+1); end;
         KeyRet : begin end;
       else
         if ch < #33 then Done := true;
       end;
     end;

     if not(MouseHooked) then ReadMouse;  {if polled mode, poll the mouse}
     if MouseClick then                      {was a mouse button clicked?}
     begin
       if MouseClickButton = MouseLeftButton then    {left button clicked}
       begin                                           {so do a floodfill}
         if not(MouseCondo) then HideMouse;         {at the current mouse}
         SetFillStyle(solidfill,MouseColor);             {cursor position}
         FloodFill(GetMx(MouseX),GetMy(MouseY),GetMaxColor);
         ShowPosition;
         if not(MouseCondo) then ShowMouse;
       end;
       if MouseClickButton = MouseRightButton then    {right button pressed}
       begin                                         {so change mouse shape}
         inc(MouseColor);                                {and working color}
         if MouseColor > GetMaxColor then MouseColor := 1;
         if M.MouseGShape = MouseClockCursor then
           M.MouseGShape := 0
         else
           inc(M.MouseGShape);
         if (M.MouseGShape > MaxMouseGraphShape) then
           M.MouseGShape := MouseClockCursor;
         MouseGraphicCursor(M.MouseGShape);
         ShowPosition;
         if not(MouseCondo) then ShowMouse;
       end;
     end;

     {if nothing else is happening, periodically update the mouse status}
     if (OldClk <> SysClk^) and
        ((MouseX <> OMouseX) or (MouseY <> OMouseY)) then
     begin
       OMouseX := MouseX;
       OMouseY := MouseY;
       OldClk := SysClk^;
       ShowPosition;
     end;
   end;
   HideMouse;               {hide the mouse before we exit}
   CloseGraph;              {then turn off the graphics mode}
end.

