unit MoreFont;
INTERFACE
uses
    Graph,Crt;
var
   GError,ItalicFont,LargeFont,RomanFont,ScriptFont,
   SimplexFont,BoldFont: integer;

function InstallFont(FontName: string): integer;
procedure LoadFonts;

IMPLEMENTATION
function InstallFont(FontName: string): integer;
var
   FontNumber: integer;
begin
     FontNumber := InstallUserFont(FontName);
     if FontNumber < 0 then
     begin
       writeln('Font Error - ',GraphErrorMsg(GError));
       halt(1);
     end else InstallFont := FontNumber;
end;

procedure LoadFonts;
begin
     ItalicFont := InstallFont('TSCR.CHR');
     LargeFont  := InstallFont('EURO.CHR');
     RomanFont  := InstallFont('LCOM.CHR');
     ScriptFont := InstallFont('SCRI.CHR');
     SimplexFont:= InstallFont('SIMP.CHR');
     BoldFont   := InstallFont('BOLD.CHR');
end;

begin
     LoadFonts;
end.