Unit MkFile;
{$I MKB.Def}

Interface

{$IFDEF WINDOWS}
Uses WinDos;
{$ELSE}
Uses Dos;
{$ENDIF}

Const
  fmReadOnly = 0;          {FileMode constants}
  fmWriteOnly = 1;
  fmReadWrite = 2;
  fmDenyAll = 16;
  fmDenyWrite = 32;
  fmDenyRead = 48;
  fmDenyNone = 64;
  fmNoInherit = 128;


Const
  Tries: Word = 150;
  TryDelay: Word = 100;


{$IFDEF WINDOWS}
Type
  PathStr = String[128];
  DirStr = String[128];
  NameStr = String[13];
  ExtStr = String[4];
{$ENDIF}


Type FindRec = Record
  {$IFDEF WINDOWS}
  SR: TSearchRec;
  TStr: Array[0..180] of Char;
  {$ELSE}
  SR: SearchRec;
  {$ENDIF}
  Dir: DirStr;
  Name: NameStr;
  Ext: ExtStr;
  DError: Word;
  End;


Type FindObj = Object
  FI: ^FindRec;
  Procedure Init; {Initialize}
  Procedure Done; {Done}
  Procedure FFirst(FN: String); {Find first}
  Procedure FNext;
  Function  Found: Boolean; {File was found}
  Function  GetName: String; {Get Filename}
  Function  GetFullPath: String; {Get filename with path}
  Function  GetDate: LongInt; {Get file date}
  Function  GetSize: LongInt; {Get file size}
  End;


Type TFileRec = Record
  MsgBuffer: Array[1..1024] of Char;
  BufferPtr: Word;
  BufferChars: Word;
  BufferStart: LongInt;
  BufferFile: File;
  StringPtr: LongInt;
  CurrentStr: String;
  StringFound: Boolean;
  Error: Word;
  End;


Type TFile = Object
  TF: ^TFileRec;
  Procedure Init;
  Procedure Done;
  Function  GetString:String;          {Get string from file}
  Function  OpenTextFile(FilePath: String): Boolean;  {Open file}
  Function  CloseTextFile: Boolean;    {Close file}
  Function  GetChar: Char;             {Internal use}
  Procedure BufferRead;                {Internal use}
  Function  StringFound: Boolean;      {Was a string found}
  Function  SeekTextFile(SeekPos: LongInt): Boolean; {Seek to position}
  Function  GetTextPos: LongInt;       {Get text file position}
  Function  Restart: Boolean;          {Reset to start of file}
  End;



Var
  FileError: Word;


Function  FileExist(FName: String): Boolean;
Function  SizeFile(FName: String): LongInt;
Function  FindPath(FileName: String): String;
Function  LongLo(InNum: LongInt): Word;
Function  LongHi(InNum: LongInt): Word;
Function  LockFile(Var F; LockStart: LongInt; LockLength: LongInt): Word;
Function  UnLockFile(Var F; LockStart: LongInt; LockLength: LongInt): Word;
Function  shAssign(Var F: File; FName: String): Boolean;
Function  shLock(Var F; LockStart,LockLength: LongInt): Word;
Procedure FlushFile(Var F); {Dupe file handle, close dupe handle}
Function  shReset(Var F: File; RecSize: Word): Boolean;
Function  shRead(Var F: File; Var Rec; ReadSize: Word; Var NumRead: Word): Boolean;
Function  shWrite(Var F: File; Var Rec; ReadSize: Word): Boolean;
Function  shOpenFile(Var F: File; PathName: String): Boolean;
Function  shMakeFile(Var F: File; PathName: String): Boolean;
Procedure shCloseFile(Var F: File);
Function  shSeekFile(Var F: File; FPos: LongInt): Boolean;
Function  shFindFile(Pathname: String; Var Name: String; Var Size, Time: LongInt): Boolean;
Procedure shSetFTime(Var F: File; Time: LongInt);
Function  GetCurrentPath: String;
Procedure CleanDir(FileDir: String);
{$IFDEF WINDOWS}
Function  GetEnv(Str: String): String;
Function  FExpand(Str: String): String;
Procedure FSplit(Path: String; Var Dir: String; Var Name: String; Var Ext: String);
{$ENDIF}
Function  IsDevice(FilePath: String): Boolean;
Function  LoadFilePos(FN: String; Var Rec; FS: Word; FPos: LongInt): Word;
Function  LoadFile(FN: String; Var Rec; FS: Word): Word;
Function  SaveFilePos(FN: String; Var Rec; FS: Word; FPos: LongInt): Word;
Function  SaveFile(FN: String; Var Rec; FS: Word): Word;
Function  ExtendFile(FN: String; ToSize: LongInt): Word;


Implementation

{$IFDEF WINDOWS}
Uses Strings, MKWCrt;
{$ELSE}
Uses
  {$IFDEF OPRO}
  OpCrt;
  {$ELSE}
  Crt;
  {$ENDIF}
{$ENDIF}



{$IFDEF WINDOWS}
Function GetEnv(Str: String): String;
  Var
    NStr: Array[0..128] of Char;
    PStr: PChar;

  Begin
  StrPCopy(NStr, Str);
  PStr := GetEnvVar(NStr);
  If PStr = nil Then
    GetEnv := ''
  Else
    GetEnv := StrPas(PStr);
  End;
{$ENDIF}

{$IFDEF WINDOWS}
Function FExpand(Str: String): String;
  Var
    IStr: Array[0..128] of Char;
    OStr: Array[0..128] of Char;

  Begin
  StrPCopy(IStr, Str);
  FileExpand(OStr, IStr);
  FExpand := StrPas(OStr);
  End;
{$ENDIF}

{$IFDEF WINDOWS}
Procedure FSplit(Path: String; Var Dir: String; Var Name: String; Var Ext: String);
  Var
    FPath: Array[0..129] of Char;
    TD: Array[0..129] of Char;
    TN: Array[0..14] of Char;
    TE: Array[0..5] of Char;

  Begin
  StrPCopy(FPath, Path);
  FileSplit(FPath, TD, TN, TE);
  Dir := StrPas(TD);
  Name := StrPas(TN);
  Ext := StrPas(TE);
  End;
{$ENDIF}


Procedure FindObj.Init;
  Begin
  New(FI);
  FI^.DError := 1;
  End;


Procedure FindObj.Done;
  Begin
  Dispose(FI);
  End;


Procedure FindObj.FFirst(FN: String);
  Begin
  FN := FExpand(FN);
  FSplit(FN, FI^.Dir, FI^.Name, FI^.Ext);
  {$IFDEF WINDOWS}
  StrPCopy(FI^.TStr, FN);
  FindFirst(FI^.TStr, faReadOnly + faArchive, FI^.SR);
  {$ELSE}
  FindFirst(FN, Archive + ReadOnly, FI^.SR);
  {$ENDIF}
  FI^.DError := DosError;
  End;


Function  FindObj.GetName: String;
  Begin
  If Found Then
    Begin
    {$IFDEF WINDOWS}
    GetName := StrPas(FI^.SR.Name)
    {$ELSE}
    GetName := FI^.SR.Name
    {$ENDIF}
    End
  Else
    GetName := '';
  End;


Function FindObj.GetFullPath: String;
  Begin
  GetFullPath := FI^.Dir + GetName;
  End;


Function  FindObj.GetSize: LongInt;
  Begin
  If Found Then
    GetSize := FI^.SR.Size
  Else
    GetSize := 0;
  End;


Function  FindObj.GetDate: LongInt;
  Begin
  If Found Then
    GetDate := FI^.SR.Time
  Else
    GetDate := 0;
  End;


Procedure FindObj.FNext;
  Begin
  FindNext(FI^.SR);
  FI^.DError := DosError;
  End;


Function FindObj.Found: Boolean;
  Begin
  Found := (FI^.DError = 0);
  End;


Function shAssign(Var F: File; FName: String): Boolean;
  Begin
  Assign(F, FName);
  FileError := IoResult;
  shAssign := (FileError = 0);
  End;



Function shRead(Var F: File; Var Rec; ReadSize: Word; Var NumRead: Word): Boolean;
  Var
    Count: Word;
    Code: Word;

  Begin
  Count := Tries;
  Code := 5;
  While ((Count > 0) and (Code = 5)) Do
    Begin
    BlockRead(F,Rec,ReadSize,NumRead);
    Code := IoResult;
    End;
  FileError := Code;
  ShRead := (Code = 0);
  End;


Function shWrite(Var F: File; Var Rec; ReadSize: Word): Boolean;
  Var
    Count: Word;
    Code: Word;

  Begin
  Count := Tries;
  Code := 5;
  While ((Count > 0) and (Code = 5)) Do
    Begin
    BlockWrite(F,Rec,ReadSize);
    Code := IoResult;
    End;
  FileError := Code;
  shWrite := (Code = 0);
  End;


Procedure CleanDir(FileDir: String);
  Var
    {$IFDEF WINDOWS}
      SR: TSearchRec;
      TStr: Array[0..128] of Char;
    {$ELSE}
      SR: SearchRec;
    {$ENDIF}
    F: File;

  Begin
  {$IFDEF WINDOWS}
  StrPCopy(TStr, FileDir);
  StrCat(TStr,'*.*');
  FindFirst(TStr, faReadOnly + faArchive, SR);
  {$ELSE}
  FindFirst(FileDir + '*.*', ReadOnly + Archive, SR);
  {$ENDIF}
  While DosError = 0 Do
    Begin
    {$IFDEF WINDOWS}
    If Not shAssign(F, FileDir + StrPas(SR.Name)) Then;
    {$ELSE}
    If Not shAssign(F, FileDir + SR.Name) Then;
    {$ENDIF}
    Erase(F);
    If IoResult <> 0 Then;
    FindNext(SR);
    End;
  End;



{$IFDEF WINDOWS}
Function GetCurrentPath: String;
  Var
    Path: Array[0..128] of Char;
    CName: Array[0..13] of Char;
    CExt: Array[0..4] of Char;
    TStr: Array[0..128] of Char;

  Begin
  FileExpand('*.*', TStr);
  FileSplit(TStr, Path, CName, CExt);
  GetCurrentPath := StrPas(Path);
  End;
{$ELSE}
Function GetCurrentPath: String;
  Var
    CName: NameStr;
    Path: DirStr;
    CExt: ExtStr;

  Begin
  FSplit(FExpand('*.*'),Path,CName,CExt);
  GetCurrentPath := Path;
  End;
{$ENDIF}


Function shLock(Var F; LockStart,LockLength: LongInt): Word;
  Var
    Count: Word;
    Code: Word;

  Begin
  Count := Tries;
  Code := $21;
  While ((Count > 0) and (Code = $21)) Do
    Begin
    Code := LockFile(F,LockStart,LockLength);
    Dec(Count);
    If Code = $21 Then
      Delay(TryDelay);
    End;
  If Code = 1 Then
    Code := 0;
  shLock := Code;
  End;



Function shReset(Var F: File; RecSize: Word): Boolean;
  Var
    Count: Word;
    Code: Word;

  Begin
  Count := Tries;
  Code := 5;
  While ((Count > 0) and (Code = 5)) Do
    Begin
    Reset(F,RecSize);
    Code := IoResult;
    End;
  FileError := Code;
  ShReset := (Code = 0);
  End;


Procedure FlushFile(Var F); {Dupe file handle, close dupe handle}
  Var
    {$IFDEF WINDOWS}
    Regs: TRegisters;
    {$ELSE}
    Regs: Registers;
    {$ENDIF}
    Handle: Word Absolute F;

  Begin
  Regs.Ah := $45;
  Regs.Bx := Handle;
  MsDos(Regs);
  If  (Regs.Flags and 1) = 0 Then
    Begin
    Regs.Bx := Regs.Ax;
    Regs.Ah := $3e;
    MsDos(Regs);
    End;
  End;


Function LockFile(Var F; LockStart: LongInt; LockLength: LongInt): Word;
  Var
    {$IFDEF WINDOWS}
    Regs: TRegisters;
    {$ELSE}
    Regs: Registers;
    {$ENDIF}
    Handle: Word Absolute F;

  Begin
  Regs.Ah := $5c;
  Regs.Al := $00;
  Regs.Bx := Handle;
  Regs.Cx := LongHi(LockStart);
  Regs.Dx := LongLo(LockStart);
  Regs.Si := LongHi(LockLength);
  Regs.Di := LongLo(LockLength);
  MsDos(Regs);
  If ((Regs.Flags and 1) = 0) Then
    LockFile := 0                 {00h = success           }
  Else
    LockFile := Regs.Ax           {01h = share not loaded  }
                                  {06h = invalid handle    }
                                  {21h = lock violation    }
                                  {24h = share buffer full }
  End;


Function UnLockFile(Var F; LockStart: LongInt; LockLength: LongInt): Word;
  Var
    {$IFDEF WINDOWS}
    Regs: TRegisters;
    {$ELSE}
    Regs: Registers;
    {$ENDIF}
    Handle: Word Absolute F;
    Code: Word;

  Begin
  Regs.Ah := $5c;
  Regs.Al := $01;
  Regs.Bx := Handle;
  Regs.Cx := LongHi(LockStart);
  Regs.Dx := LongLo(LockStart);
  Regs.Si := LongHi(LockLength);
  Regs.Di := LongLo(LockLength);
  MsDos(Regs);
  If ((Regs.Flags and 1) = 0) Then
    UnLockFile := 0               {00h = success           }
  Else
    Begin
    Code := Regs.Ax;              {01h = share not loaded  }
    If Code = 1 Then              {06h = invalid handle    }
      Code := 0;                  {21h = lock violation    }
    UnLockFile := Code            {24h = share buffer full }
    End;
  End;


Function LongLo(InNum: LongInt): Word;
  Begin
  LongLo := InNum and $FFFF;
  End;


Function LongHi(InNum: LongInt): Word;
  Begin
  LongHi := InNum Shr 16;
  End;


Function SizeFile(FName: String): LongInt;
  Var
    {$IFDEF WINDOWS}
    SR: TSearchRec;
    TStr: Array[0..128] of Char;
    {$ELSE}
    SR: SearchRec;
    {$ENDIF}

  Begin
  {$IFDEF WINDOWS}
  StrPCopy(TStr, FName);
  FindFirst(TStr, faAnyFile, SR);
  {$ELSE}
  FindFirst(FName, AnyFile, SR);
  {$ENDIF}
  If DosError = 0 Then
    SizeFile := SR.Size
  Else
    SizeFile := -1;
  End;


Function FileExist(FName: String): Boolean;
  Var
    {$IFDEF WINDOWS}
    SR: TSearchRec;
    TStr: Array[0..128] of Char;
    {$ELSE}
    SR: SearchRec;
    {$ENDIF}

  Begin
  {$IFDEF WINDOWS}
  StrPCopy(TStr, FName);
  FindFirst(TStr, faReadOnly + faHidden + faArchive, SR);
  {$ELSE}
  FindFirst(FName, ReadOnly + Hidden + Archive, SR);
  {$ENDIF}
  If DosError = 0 Then
    FileExist := True
  Else
    FileExist := False;
  End;


{$IFDEF WINDOWS}
Function FindPath(FileName: String): String;
  Var
    TStr: Array[0..128] of Char;
    NStr: Array[0..14] of Char;

  Begin
  If FileExist(FileName) Then
    Begin
    FileExpand(TStr, StrPCopy(NStr,FileName));
    FindPath := StrPas(TStr);
    End
  Else
    Begin
    FileSearch(TStr, StrPCopy(NStr, FileName), GetEnvVar('Path'));
    FileExpand(TStr, TStr);
    FindPath := StrPas(TStr);
    End;
  End;
{$ELSE}
Function FindPath(FileName: String):String;
  Begin
  If FileExist(FileName) Then
    FindPath := FExpand(FileName)
  Else
    FindPath := FExpand(FSearch(FileName,GetEnv('PATH')));
  End;
{$ENDIF}


Procedure TFile.BufferRead;
  Begin
  TF^.BufferStart := FilePos(TF^.BufferFile);
  if Not shRead (TF^.BufferFile,TF^.MsgBuffer,SizeOf(TF^.MsgBuffer),TF^.BufferChars) Then
    TF^.BufferChars := 0;
  TF^.BufferPtr := 1;
  End;


Function TFile.GetChar: Char;
  Begin
  If TF^.BufferChars > 0 Then
    GetChar := TF^.MsgBuffer[TF^.BufferPtr]
  Else
    GetChar := #0;
  Inc(TF^.BufferPtr);
  If TF^.BufferPtr > TF^.BufferChars Then
    BufferRead;
  End;


Function TFile.GetString: String;

  Var
    TempStr: String;
    GDone: Boolean;
    Ch: Char;

  Begin
    If TF^.MsgBuffer[TF^.BufferPtr] = #10 Then
      Ch := GetChar;
    TF^.StringPtr := TF^.BufferPtr + TF^.BufferStart - 1;
    TempStr := '';
    GDone := False;
    TF^.StringFound := False;
    While Not GDone Do
      Begin
      Ch := GetChar;
      Case Ch Of
        #0:  If TF^.BufferChars = 0 Then
               GDone := True
             Else
               Begin
               Inc(TempStr[0]);
               TempStr[Ord(TempStr[0])] := Ch;
               TF^.StringFound := True;
               If Length(TempStr) = 255 Then
                 GDone := True;
               End;
        #10:;
        #26:;
        #13: Begin
             GDone := True;
             TF^.StringFound := True;
             End;
        Else
          Begin
            Inc(TempStr[0]);
            TempStr[Ord(TempStr[0])] := Ch;
            TF^.StringFound := True;
            If Length(TempStr) = 255 Then
              GDone := True;
          End;
        End;
      End;
    GetString := TempStr;
  End;


Function TFile.OpenTextFile(FilePath: String): Boolean;
  Begin
  If Not shAssign(TF^.BufferFile, FilePath) Then;
  FileMode := fmReadOnly + fmDenyNone;
  If Not shReset(TF^.BufferFile,1) Then
    OpenTextFile := False
  Else
    Begin
    BufferRead;
    If TF^.BufferChars > 0 Then
      TF^.StringFound := True
    Else
      TF^.StringFound := False;
    OpenTextFile := True;
    End;
  End;


Function TFile.SeekTextFile(SeekPos: LongInt): Boolean;
  Begin
  TF^.Error := 0;
  Seek(TF^.BufferFile, SeekPos);
  TF^.Error := IoResult;
  BufferRead;
  SeekTextFile := (TF^.Error = 0);
  End;


Function TFile.GetTextPos: LongInt;       {Get text file position}
  Begin
  GetTextPos := TF^.BufferStart + TF^.BufferPtr - 1;
  End;


Function TFile.Restart: Boolean;
  Begin
  Restart := SeekTextFile(0);
  End;


Function TFile.CloseTextFile: Boolean;
  Begin
  Close(TF^.BufferFile);
  CloseTextFile := (IoResult = 0);
  End;


Procedure TFile.Init;
  Begin
  New(TF);
  End;


Procedure TFile.Done;
  Begin
  Close(TF^.BufferFile);
  If IoResult <> 0 Then;
  Dispose(TF);
  End;


Function TFile.StringFound: Boolean;
  Begin
  StringFound := TF^.StringFound;
  End;


Function  shOpenFile(Var F: File; PathName: String): Boolean;
  Begin
  Assign(f,pathname);
  FileMode := fmReadWrite + fmDenyNone;
  shOpenFile := shReset(f,1);
  End;


Function  shMakeFile(Var F: File; PathName: String): Boolean;
  Begin
  Assign(f,pathname);
  ReWrite(f,1);
  shMakeFile := (IOresult = 0);
  END;


Procedure shCloseFile(Var F: File);
  Begin
  Close(F);
  If (IOresult <> 0) Then;
  End;


Function  shSeekFile(Var F: File; FPos: LongInt): Boolean;
  Begin
  Seek(F,FPos);
  shSeekFile := (IOresult = 0);
  End;


Function  shFindFile(Pathname: String; Var Name: String; Var Size, Time: LongInt): Boolean;
  Var
    {$IFDEF WINDOWS}
      SR: TSearchRec;
      PStr: Array[0..128] of Char;
    {$ELSE}
      SR: SearchRec;
   {$ENDIF}

  Begin
  {$IFDEF WINDOWS}
  StrPCopy(PStr, PathName);
  FindFirst(PStr, faArchive, SR);
  {$ELSE}
  FindFirst(PathName, Archive, SR);
  {$ENDIF}
  If (DosError = 0) Then
    Begin
    shFindFile := True;
    {$IFDEF WINDOWS}
    Name := StrPas(SR.Name);
    {$ELSE}
    Name := Sr.Name;
    {$ENDIF}
    Size := Sr.Size;
    Time := Sr.Time;
    End
  Else
    Begin
    shFindFile := False;
    End;
  End;


Procedure shSetFTime(Var F: File; Time: LongInt);
  Begin
  SetFTime(F, Time);
  If (IOresult <> 0) Then;
  End;



Function IsDevice(FilePath: String): Boolean;
  Var
    F: File;
    Handle: Word Absolute F;
    {$IFDEF WINDOWS}
    Regs: TRegisters;
    {$ELSE}
    Regs: Registers;
    {$ENDIF}

  Begin
  Assign(F, FilePath);
  Reset(F);
  If IoResult <> 0 Then
    IsDevice := False
  Else
    Begin
    Regs.ah := $44;
    Regs.al := 0;
    Regs.bx := Handle;
    Intr($21, Regs);
    IsDevice := ((Regs.Dx and 128) <> 0);
    End;
  Close(F);
  If IoResult <> 0 THen;
  End;


Function LoadFile(FN: String; Var Rec; FS: Word): Word;
  Begin
  LoadFile := LoadFilePos(FN, Rec, FS, 0);
  End;


Function LoadFilePos(FN: String; Var Rec; FS: Word; FPos: LongInt): Word;
  Var
    F: File;
    Error: Word;
    NumRead: Word;

  Begin
  Error := 0;
  If Not FileExist(FN) Then
    Error := 8888;
  If Error = 0 Then
    Begin
    If Not shAssign(F, FN) Then
      Error := FileError;
    End;
  FileMode := fmReadOnly + fmDenyNone;
  If Not shReset(F,1) Then
    Error := FileError;
  If Error = 0 Then
    Begin
    Seek(F, FPos);
    Error := IoResult;
    End;
  If Error = 0 Then
    If Not shRead(F, Rec, FS, NumRead) Then
      Error := FileError;
  If Error = 0 Then
    Begin
    Close(F);
    Error := IoResult;
    End;
  LoadFilePos := Error;
  End;


Function SaveFile(FN: String; Var Rec; FS: Word): Word;
   Begin
   SaveFile := SaveFilePos(FN, Rec, FS, 0);
   End;



Function SaveFilePos(FN: String; Var Rec; FS: Word; FPos: LongInt): Word;
  Var
    F: File;
    Error: Word;

  Begin
  Error := 0;
  If Not shAssign(F, FN) Then
    Error := FileError;
  FileMode := fmReadWrite + fmDenyNone;
  If FileExist(FN) Then
    Begin
    If Not shReset(F,1) Then
      Error := FileError;
    End
  Else
    Begin
    ReWrite(F,1);
    Error := IoResult;
    End;
  If Error = 0 Then
    Begin
    Seek(F, FPos);
    Error := IoResult;
    End;
  If Error = 0 Then
    If Not shWrite(F, Rec, FS) Then
      Error := FileError;
  If Error = 0 Then
    Begin
    Close(F);
    Error := IoResult;
    End;
  SaveFilePos := Error;
  End;


Function ExtendFile(FN: String; ToSize: LongInt): Word;
{Pads file with nulls to specified size}
  Type
    FillType = Array[1..8000] of Byte;

  Var
    F: File;
    Error: Word;
    FillRec: ^FillType;

  Begin
  New(FillRec);
  FillChar(FillRec^, SizeOf(FillRec^), 0);
  Error := 0;
  If Not shAssign(F, FN) Then
    Error := FileError;
  FileMode := fmReadWrite + fmDenyNone;
  If FileExist(FN) Then
    Begin
    If Not shReset(F,1) Then
      Error := FileError;
    End
  Else
    Begin
    ReWrite(F,1);
    Error := IoResult;
    End;
  If Error = 0 Then
    Begin
    Seek(F, FileSize(F));
    Error := IoResult;
    End;
  If Error = 0 Then
    Begin
    While ((FileSize(F) < (ToSize - SizeOf(FillRec^))) and (Error = 0)) Do
    If Not shWrite(F, FillRec^, SizeOf(FillRec^)) Then
      Error := FileError;
    End;
  If ((Error = 0) and (FileSize(F) < ToSize)) Then
    Begin
    If Not shWrite(F, FillRec^, ToSize - FileSize(F)) Then
      Error := FileError;
    End;
  If Error = 0 Then
    Begin
    Close(F);
    Error := IoResult;
    End;
  Dispose(FillRec);
  ExtendFile := Error;
  End;


End.
