program testdlg;

{$R MSCROLL.RES}

uses
  DIALOG1,  WinTypes, WinProcs, WinDos,
  {$ifdef VER70}
  Objects, OWindows, ODialogs, Strings, OStdDlgs, OStdWnds;
  {$else}
  WObjects, Strings, StdDlgs, StdWnds;
  {$endif}

const
  cm_Dialog = 102;

type
  TMyApp = object(TApplication)
    procedure InitInstance; virtual;
    procedure InitMainWindow; virtual;
  end;

  PMyWindow = ^TMyWindow;
  TMyWindow = object(TWindow)
    constructor Init(ATitle : PChar);
    destructor Done; virtual;
    Procedure cmDialog(var Msg : TMessage); virtual cm_First + cm_Dialog;
  end;

{-------TMyWindow.Init}
constructor TMyWindow.Init(ATitle : PChar);

  var
    AMenu : hMenu;

  begin
    tWindow.Init(Nil, ATitle);

    AMenu := CreateMenu;     {make a menu}
    AppendMenu(AMenu, mf_String, cm_Exit, 'E&xit');
    AppendMenu(AMenu, mf_String, cm_Dialog, '&Dialog');

    with Attr do
      begin
        Style := ws_OverlappedWindow;
        Menu := AMenu;
      end;
  end;

{----------------TMyWindow.Done}
destructor tMyWindow.Done;
  begin
    tWindow.Done;
  end;

{-----------------TMyWindow.cmDialog}
procedure tMyWindow.cmDialog(var Msg : TMessage);

  var
    Dlg : PDIALOG1;

  begin
    Dlg := New(PDIALOG1, Init(@Self));
    if Application^.ExecDialog(Dlg) = idOK then
        begin
          {Do something with results}
        end;
  end;

{------TMyApp.InitMainWindow}
procedure TMyApp.InitMainWindow;
  begin
    MainWindow := New(PMyWindow, Init('Test The Dialog'));
  end;

{------TMyApp.InitInstance}
procedure TMyApp.InitInstance;
  begin
    TApplication.InitInstance;
    hAccTable := 0;
  end;

var
  App : TMyApp;
  Lib : tHandle;
  Lb  : tHandle;

begin
  Lib := LoadLibrary('microscr.dll');
  App.Init('MyWindow');
  App.Run;
  App.Done;
  FreeLibrary(Lib);
end.
