{$N+}
PROGRAM Quick;
USES    MathLib, TrigStuff, TPTimer;
CONST   max = 6;
VAR     r,s,t,w,x,y,z: DOUBLE;
        k,l,m,n: INTEGER;
        nums: floatray;
        start, finis: LONGINT;
        baseline, base, base1, time, time2: REAL;
        i,j,counter: LONGINT;
        outfile: TEXT;
        ch: CHAR;
        
  PROCEDURE WriteIt(base:REAL);
  
    BEGIN
      finis := ReadTimer;
      time2 := ElapsedTime(start,finis)/1000 - base;
      WRITELN(outfile, time2:6:2, time2/time:6:2);
      WRITELN(         time2:6:2, time2/time:6:2);
    END;

  BEGIN
    WRITE('Input number of trials: ');
    READLN(counter);
    Randomize;
    ASSIGN(outfile, 'MATHTIME.DAT');
    REWRITE(outfile);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := 1.0E6*Random;
    END;
    finis := ReadTimer;
    baseline := ElapsedTime(start,finis)/1000;
    WRITELN;
    WRITELN(         '           MATHLIB   SYS  Ratio');
    WRITELN(outfile);
    WRITELN(outfile,         '           MATHLIB   SYS  Ratio');
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := 1.0E6*Random;
      y := MATHLIB.LN(x);
    END;
    finis := ReadTimer;
    time := ElapsedTime(start,finis)/1000 - baseline;
    WRITE(outfile, 'LN:         ',time:6:2);
    WRITE(         'LN:         ',time:6:2);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := 1.0E6*Random;
      y := SYSTEM.LN(x);
    END;
    WriteIt(baseline);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := 1.0E6*Random;
      y := MATHLIB.LOG(x);
    END;
    finis := ReadTimer;
    time := ElapsedTime(start,finis)/1000 - baseline;
    WRITE(outfile, 'LOG:        ',time:6:2);
    WRITE(         'LOG:        ',time:6:2);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := 1.0E6*Random;
      y := TRIGSTUFF.LOG(x);
    END;
    WriteIt(baseline);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -100 + 200*Random;
      y := MATHLIB.Two2TheX(x);
    END;
    finis := ReadTimer;
    time := ElapsedTime(start,finis)/1000 - baseline;
    WRITE(outfile, 'Two2TheX:   ',time:6:2);
    WRITE(         'Two2TheX:   ',time:6:2);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -100 + 200*Random;
      y := TRIGSTUFF.Two2TheX(x);
    END;
    WriteIt(baseline);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -100 + 200*Random;
      y := MATHLIB.EXP(x);
    END;
    finis := ReadTimer;
    time := ElapsedTime(start,finis)/1000 - baseline;
    WRITE(outfile, 'EXP:        ',time:6:2);
    WRITE(         'EXP:        ',time:6:2);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -100 + 200*Random;
      y := SYSTEM.EXP(x);
    END;
    WriteIt(baseline);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -10 + 20*Random;
      y := MATHLIB.Ten2TheX(x);
    END;
    finis := ReadTimer;
    time := ElapsedTime(start,finis)/1000 - baseline;
    WRITE(outfile, 'Ten2TheX:   ',time:6:2);
    WRITE(         'Ten2TheX:   ',time:6:2);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -10 + 20*Random;
      y := TRIGSTUFF.Ten2TheX(x);
    END;
    WriteIt(baseline);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := 10*Random;
      y := -10 + 20*Random;
      s := MATHLIB.Expo(x,y);
    END;
    finis := ReadTimer;
    time := ElapsedTime(start,finis)/1000 - 2*baseline;
    WRITE(outfile, 'Expo:       ',time:6:2);
    WRITE(         'Expo:       ',time:6:2);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := 10*Random;
      y := -10 + 20*Random;
      s := TRIGSTUFF.Expo(x,y);
    END;
    WriteIt(2*baseline);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -1.0E6 + 2.0E6*Random;
      y := MATHLIB.TAN(x);
    END;
    finis := ReadTimer;
    time := ElapsedTime(start,finis)/1000 - baseline;
    WRITE(outfile, 'TAN:        ',time:6:2);
    WRITE(         'TAN:        ',time:6:2);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -1.0E6 + 2.0E6*Random;
      y := TRIGSTUFF.TAN(x);
    END;
    WriteIt(baseline);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -1.0E6 + 2.0E6*Random;
      y := MATHLIB.SIN(x);
    END;
    finis := ReadTimer;
    time := ElapsedTime(start,finis)/1000 - baseline;
    WRITE(outfile, 'SIN:        ',time:6:2);
    WRITE(         'SIN:        ',time:6:2);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -1.0E6 + 2.0E6*Random;
      y := SYSTEM.SIN(x);
    END;
    WriteIt(baseline);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -1.0E6 + 2.0E6*Random;
      y := MATHLIB.COS(x);
    END;
    finis := ReadTimer;
    time := ElapsedTime(start,finis)/1000 - baseline;
    WRITE(outfile, 'COS:        ',time:6:2);
    WRITE(         'COS:        ',time:6:2);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -1.0E6 + 2.0E6*Random;
      y := SYSTEM.COS(x);
    END;
    WriteIt(baseline);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -1.0E6 + 2.0E6*Random;
      MATHLIB.SINCOS(x,y,s);
    END;
    finis := ReadTimer;
    time := ElapsedTime(start,finis)/1000 - baseline;
    WRITE(outfile, 'SINCOS:     ',time:6:2);
    WRITE(         'SINCOS:     ',time:6:2);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -1.0E6 + 2.0E6*Random;
      TRIGSTUFF.SINCOS(x,y,s);
    END;
    WriteIt(baseline);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -100 + 200*Random;
      y := MATHLIB.ARCTAN(x);
    END;
    finis := ReadTimer;
    time := ElapsedTime(start,finis)/1000 - baseline;
    WRITE(outfile, 'ARCTAN:     ',time:6:2);
    WRITE(         'ARCTAN:     ',time:6:2);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -100 + 200*Random;
      y := SYSTEM.ARCTAN(x);
    END;
    WriteIt(baseline);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -100 + 200*Random;
      y := -100 + 200*Random;
      s := MATHLIB.ArcTangent(x,y);
    END;
    finis := ReadTimer;
    time := ElapsedTime(start,finis)/1000 - 2*baseline;
    WRITE(outfile, 'ArcTangent: ',time:6:2);
    WRITE(         'ArcTangent: ',time:6:2);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -100 + 200*Random;
      y := -100 + 200*Random;
      s := TRIGSTUFF.ArcTangent(x,y);
    END;
    WriteIt(2*baseline);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -1.0+2.0*Random;
      y := MATHLIB.ARCSIN(x);
    END;
    finis := ReadTimer;
    time := ElapsedTime(start,finis)/1000 - baseline;
    WRITE(outfile, 'ARCSIN:     ',time:6:2);
    WRITE(         'ARCSIN:     ',time:6:2);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -1.0+2.0*Random;
      y := TRIGSTUFF.ARCSIN(x);
    END;
    WriteIt(baseline);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -1.0+2.0*Random;
      y := MATHLIB.ARCCOS(x);
    END;
    finis := ReadTimer;
    time := ElapsedTime(start,finis)/1000 - baseline;
    WRITE(outfile, 'ARCCOS:     ',time:6:2);
    WRITE(         'ARCCOS:     ',time:6:2);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -1.0+2.0*Random;
      y := TRIGSTUFF.ARCCOS(x);
    END;
    WriteIt(baseline);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -10 + 20*Random;
    END;
    finis := ReadTimer;
    base1 := ElapsedTime(start,finis)/1000;
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -100 + 200*Random;
    END;
    finis := ReadTimer;
    base := ElapsedTime(start,finis)/1000;
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -100 + 200*Random;
      w := MATHLIB.CEIL(x);
    END;
    finis := ReadTimer;
    time := ElapsedTime(start,finis)/1000 - base;
    WRITE(outfile, 'CEIL:       ',time:6:2);
    WRITE(         'CEIL:       ',time:6:2);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -100 + 200*Random;
      z := TRIGSTUFF.CEIL(x);
    END;
    WriteIt(base);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -100 + 200*Random;
    END;
    finis := ReadTimer;
    base := ElapsedTime(start,finis)/1000;
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -100 + 200*Random;
      w := MATHLIB.FLOOR(x);
    END;
    finis := ReadTimer;
    time := ElapsedTime(start,finis)/1000 - base;
    WRITE(outfile, 'FLOOR:      ',time:6:2);
    WRITE(         'FLOOR:      ',time:6:2);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -100 + 200*Random;
      z := TRIGSTUFF.FLOOR(x);
    END;
    WriteIt(base);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -100 + 200*Random;
      y := -100 + 200*Random;
    END;
    finis := ReadTimer;
    base := ElapsedTime(start,finis)/1000;
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -100 + 200*Random;
      y := -100 + 200*Random;
      w := MATHLIB.FMOD(x,y);
    END;
    finis := ReadTimer;
    time := ElapsedTime(start,finis)/1000 - base;
    WRITE(outfile, 'FMOD:       ',time:6:2);
    WRITE(         'FMOD:       ',time:6:2);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -100 + 200*Random;
      y := -100 + 200*Random;
      z := TRIGSTUFF.FMOD(x,y);
    END;
    WriteIt(base);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -100 + 200*Random;
    END;
    finis := ReadTimer;
    base := ElapsedTime(start,finis)/1000;
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -100 + 200*Random;
      w := MATHLIB.FREXP(x,l);
    END;
    finis := ReadTimer;
    time := ElapsedTime(start,finis)/1000 - base;
    WRITE(outfile, 'FREXP:      ',time:6:2);
    WRITE(         'FREXP:      ',time:6:2);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -100 + 200*Random;
      z := TRIGSTUFF.FREXP(x,k);
    END;
    WriteIt(base);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -100 + 200*Random;
      y := -100 + 200*Random;
    END;
    finis := ReadTimer;
    base := ElapsedTime(start,finis)/1000;
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -100 + 200*Random;
      y := -100 + 200*Random;
      w := MATHLIB.HYPOT(x,y);
    END;
    finis := ReadTimer;
    time := ElapsedTime(start,finis)/1000 - base;
    WRITE(outfile, 'HYPOT:      ',time:6:2);
    WRITE(         'HYPOT:      ',time:6:2);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -100 + 200*Random;
      y := -100 + 200*Random;
      z := TRIGSTUFF.HYPOT(x,y);
    END;
    WriteIt(base);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -100 + 200*Random;
      k := TRUNC(-100 + 200*Random);
    END;
    finis := ReadTimer;
    base := ElapsedTime(start,finis)/1000;
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -100 + 200*Random;
      k := TRUNC(-100 + 200*Random);
      w := MATHLIB.LDEXP(x,k);
    END;
    finis := ReadTimer;
    time := ElapsedTime(start,finis)/1000 - base;
    WRITE(outfile, 'LDEXP:      ',time:6:2);
    WRITE(         'LDEXP:      ',time:6:2);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -100 + 200*Random;
      k := TRUNC(-100 + 200*Random);
      z := TRIGSTUFF.LDEXP(x,k);
    END;
    WriteIt(base);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -100 + 200*Random;
    END;
    finis := ReadTimer;
    base := ElapsedTime(start,finis)/1000;
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -100 + 200*Random;
      w := MATHLIB.MODF(x,r);
    END;
    finis := ReadTimer;
    time := ElapsedTime(start,finis)/1000 - base;
    WRITE(outfile, 'MODF:       ',time:6:2);
    WRITE(         'MODF:       ',time:6:2);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -100 + 200*Random;
      z := TRIGSTUFF.MODF(x,y);
    END;
    WriteIt(base);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      FOR j := 0 TO max DO nums[j] := 0.2*Random+2*j*Random;
      x := -100 + 200*Random;
    END;
    finis := ReadTimer;
    base := ElapsedTime(start,finis)/1000;
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      FOR j := 0 TO max DO nums[j] := 0.2*Random+2*j*Random;
      x := -100 + 200*Random;
      w := MATHLIB.POLY(x,max,nums);
    END;
    finis := ReadTimer;
    time := ElapsedTime(start,finis)/1000 - base;
    WRITE(outfile, 'POLY:       ',time:6:2);
    WRITE(         'POLY:       ',time:6:2);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      FOR j := 0 TO max DO nums[j] := 0.2*Random+2*j*Random;
      x := -100 + 200*Random;
      z := TRIGSTUFF.POLY(x,max,nums[0]);
    END;
    WriteIt(base);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -10 + 20*Random;
      y := MATHLIB.COSH(x);
    END;
    finis := ReadTimer;
    time := ElapsedTime(start,finis)/1000 - base1;
    WRITE(outfile, 'COSH:       ',time:6:2);
    WRITE(         'COSH:       ',time:6:2);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -10 + 20*Random;
      y := TRIGSTUFF.COSH(x);
    END;
    WriteIt(base1);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -10 + 20*Random;
      y := MATHLIB.SINH(x);
    END;
    finis := ReadTimer;
    time := ElapsedTime(start,finis)/1000 - base1;
    WRITE(outfile, 'SINH:       ',time:6:2);
    WRITE(         'SINH:       ',time:6:2);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -10 + 20*Random;
      y := TRIGSTUFF.SINH(x);
    END;
    WriteIt(base1);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -10 + 20*Random;
      y := MATHLIB.TANH(x);
    END;
    finis := ReadTimer;
    time := ElapsedTime(start,finis)/1000 - base1;
    WRITE(outfile, 'TANH:       ',time:6:2);
    WRITE(         'TANH:       ',time:6:2);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -10 + 20*Random;
      y := TRIGSTUFF.TANH(x);
    END;
    WriteIt(base1);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := 1 + 19*Random;
      y := MATHLIB.ACOSH(x);
    END;
    finis := ReadTimer;
    time := ElapsedTime(start,finis)/1000 - base1;
    WRITE(outfile, 'ACOSH:      ',time:6:2);
    WRITE(         'ACOSH:      ',time:6:2);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := 1 + 19*Random;
      y := TRIGSTUFF.ACOSH(x);
    END;
    WriteIt(base1);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -10 + 20*Random;
      y := MATHLIB.ASINH(x);
    END;
    finis := ReadTimer;
    time := ElapsedTime(start,finis)/1000 - base1;
    WRITE(outfile, 'ASINH:      ',time:6:2);
    WRITE(         'ASINH:      ',time:6:2);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := -10 + 20*Random;
      y := TRIGSTUFF.ASINH(x);
    END;
    WriteIt(base1);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := Random;
      y := MATHLIB.ATANH(x);
    END;
    finis := ReadTimer;
    time := ElapsedTime(start,finis)/1000 - base1;
    WRITE(outfile, 'ATANH:      ',time:6:2);
    WRITE(         'ATANH:      ',time:6:2);
    start := ReadTimer;
    FOR i := 0 TO counter DO BEGIN
      x := Random;
      y := TRIGSTUFF.ATANH(x);
    END;
    WriteIt(base1);
    CLOSE(outfile);
  END.