program ManipTxt;
{********************************************************************}
{ This program demonstrates some functions that manipulate strings.  }
{ The program was created to manipulate 'G' code files that are      }
{ created for CNC machines.  CNC = Computer Numerical Control.       }
{                                                                    }
{ These 'G' code files are text files on a computer or CNC that      }
{ control the axis movements of the machine.                         }
{                                                                    }
{ Some people like to have spaces between the 'Words' of a 'G' coded }
{ file in order to conserve disk space while others use a space      }
{ between the words for better reading ability.                      }
{                                                                    }
{ This program has the ability to insert a space between each letter }
{ and number of a text file under certain conditions.  The string    }
{ must not start with a '(' or a ':' or a '%'.  If the string does   }
{ start with these characters then they will be written to the       }
{ destination file as is.  The same conditions hold true if the user }
{ decides to remove spaces from a file.                              }
{                                                                    }
{ This code could have been shortened and functions could have been  }
{ put together but to show the seperate functions was a better idea  }
{ for clarity sake.                                                  }
{                                                                    }
{ Author         : Allan J. Bremer    (Mr. Machinist Program)        }
{ Compuserve id  : 73113,2206                                        }
{********************************************************************}

Uses Crt;
var
   Line_Current                      : String;
   Source_File,Dest_File             : Text;
   Source, Dest                      : String;
   SourceOpened,DestExist            : Boolean;
   Spaces                            : Char;
   Skip                              : Boolean;

procedure OpenFiles;  { Does all the File init stuff }
begin
       SourceOpened := True;
       DestExist := False;
       Assign(Source_File,Source);
       {$I-} Reset(Source_File); {$I+}
       if (IOResult = 0) then
         Begin
           Assign(Dest_File,Dest);
           {$I-} ReWrite(Dest_File); {$I+}
           if (IOResult <> 0) Then Rewrite(Dest_File);
         end else
         begin
           ClrScr;
           Writeln('Unable to open source file, may not exist!');
           Halt;
         end
end;

function IsAlpha(Ch: Char): Boolean;  { Checks for letters in string }
begin
  if (Ch in ['A'..'z']) then
    IsAlpha := True
  else
    IsAlpha := False;
end;

function IsSpace(Ch: Char): Boolean;  { Checks for spaces in string }
begin
  if (Ch in [' ']) then
    IsSpace := True
  else
    IsSpace := False;
end;

function SpaceBeforeChars(S: String): String;  { Puts in a space between }
var i  : Integer;                              { letters and numbers or  }
begin                                          { takes all spaces out of }
  i := 1;                                      { a string.               }
  if Spaces = 'y' then
  begin
    repeat
      if (IsAlpha(S[i]))and(i<>1) then
      begin
        Insert(' ',S,i);
        Inc(i);
      end;
      Inc(i);
    until i > Length(S);
    SpaceBeforeChars := S;
  end else
  begin
    repeat
      if (IsSpace(S[i])) and (i<>1) then
      begin
        Delete(S,i,1);
        Inc(i);
      end;
      Inc(i);
    until i > Length(S);
    SpaceBeforeChars := S;
  end;
end;

begin
  ClrScr;
  Write('Source File  : '); Readln(Source);  { Get source file name         }
  Writeln;
  Write('Destination  : '); Readln(Dest);    { Get destination file name    }
  Writeln;
  Write('Spaces? (y/n): '); Readln(Spaces);  { Small letter 'y' means put   }
  Writeln;                                   { spaces between letters and   }
  OpenFiles;                                 { numbers, anything else means }
  Skip := False;                             { remove all spaces in string. }
  If (SourceOpened) and (DestExist = False) Then
    Begin
      Repeat
        Readln(Source_File,Line_Current);
        if(Pos('(',Line_Current)=1)or(Pos(':',Line_Current)=1)or
        (Pos('%',Line_Current)=1) then Skip:=True;
        if not Skip then Line_Current := SpaceBeforeChars(Line_Current);
        Writeln(Dest_File,Line_Current);
        Skip := False;
      Until Eof(Source_File);
      Close(Source_File);
      Close(Dest_File);
    end;
end.
