Program LZHPeek;          { copr. 1990, Dave Williams }
                          { based on code in Basil Copeland's AZD }
Uses                      { compiled with Turbo Pascal 5.5 }
  DOS, dave;

{$M 16384,0,0}            { limit to 16k of memory }

(*
v1.01 09/20/90  fixed pathname problem
*)

const
  name  = ' LZHPeek v1.01 - View inside LZH files.  Copr. Dave Williams, 1990';
  bbsad = '       Courtesy of:  The Courts of Chaos BBS, (501)985-0059';
{ bbsad = '      Specially written for:  The Cat House BBS, (501)376-6909';}

(*--------------------------------------------------------------------------*)
(*                          General Declarations                            *)
(*--------------------------------------------------------------------------*)

                                (* The type az_shortrec is used for holding *)
                                (* only as much header information we are   *)
                                (* interested in displaying.  We could, of  *)
                                (* course, construct the displays directly  *)
                                (* from the arc and zip header structures,  *)
                                (* but these routines were written with     *)
                                (* other uses in mind which call for doing  *)
                                (* it this way.                             *)
Type
  az_shortrec =  Record
                   filename  : String[12];
                   size_o    : LongInt;
                   size_c    : LongInt;
                   datestr   : String[8];
                   timestr   : String[8];
                 End;

Var
  az_array        : Array[0..99] Of az_shortrec;
  az_file         : File;
  az_pos,timedate : LongInt;
  bytes_read,i,j  : Integer;
  filename        : String[120];
  timedate_w      : Array[1..2] Of Word Absolute timedate;
  dt              : DateTime;
  format_error    : Boolean;
  total_azsize_o,
  total_azsize_c  : LongInt;

Type
   fnametype = Array[1..13] Of Char;

Var
  File_Name : fnametype;       (* File name of entry in LZH file  *)

(*----------------------------------------------------------------------*)
(*        Record Structure for LZH files (still pretty tenative)        *)
(*----------------------------------------------------------------------*)

Type
  lzhrec =
    Record
      reclen          : Byte;
      unknown1        : Byte;
      id              : Word;       {we have five bytes here, which }
      unknown2        : Word;       {yield the string '-lh1-'       }
      unknown3        : Byte;       {                               }
      size_c          : LongInt;
      size_o          : LongInt;
      time            : Word;
      date            : Word;
      attr            : Word;       {maybe two fields here          }
      filename_length : Byte;
    End;

                                 (*The filename comes at the end of   *)
                                 (*this record, and is of variable    *)
                                 (*length.  It is then followed by    *)
                                 (*the CRC.  This implementation does *)
                                 (*not try and get the CRC.           *)

Var
  lzhheader : lzhrec;

(*------------------------------------------------------------------------*)
(*                        Miscellaneous Routines                          *)
(*------------------------------------------------------------------------*)

Function withzeros(a_number : Integer) : String;
Var                       {reformats date and time fields  }
  wz : String ;           {as two-byte strings with zeroes }
Begin
  Str(a_number : 2, wz) ;
  If wz[1] = ' ' Then wz[1] := '0' ;
  If wz[2] = ' ' Then wz[2] := '0' ;
  withzeros := wz ;
End;


Procedure convert_az_datetime;
Begin
  unpacktime(timedate,dt);
  az_array[j].timestr := withzeros(dt.hour)+':'
                       + withzeros(dt.min)+':'
                       + withzeros(dt.sec);
  az_array[j].datestr := withzeros(dt.month)+'/'
                       + withzeros(dt.day)+'/'
                       + withzeros(dt.year-1900);
End;

Procedure display_az_array;
Begin
  WriteLn;
  WriteLn(name);
  WriteLn(bbsad);
  WriteLn;
  WriteLn('Contents of: ',filename);
  WriteLn;
  WriteLn('  Filename     Length     Size      Date      Time');
  WriteLn('------------  --------  --------  --------  --------');

    For i := 0 To j - 2 Do

      WriteLn(dnstring(az_array[i].filename):12,'  ',
              az_array[i].size_o:8,'  ',
              az_array[i].size_c:8,'  ',
              az_array[i].datestr:8,'  ',
              az_array[i].timestr:8);

     For i := 0 To j - 2 Do

       Begin
         total_azsize_o := total_azsize_o + az_array[i].size_o;
         total_azsize_c := total_azsize_c + az_array[i].size_c;
       end;

   WriteLn('------------  --------  --------  --------  --------');
   WriteLn('total bytes:  ',total_azsize_o:8,'  ',total_azsize_c:8);
   WriteLn;

End;


Procedure init_az;
Begin
  Reset(az_file, 1);
  az_pos := 0;
  j := 0;
  format_error := False;
  total_azsize_o := 0;
  total_azsize_c := 0;
End;


Procedure next_header;
Begin
  Seek(az_file, az_pos);
  j := j + 1;
End;


Procedure usage;
Begin
  WriteLn(name);
  WriteLn(bbsad);
  WriteLn;
  WriteLn('syntax: LZHPeek [filename]');
  WriteLn(' where: [filename] = filename.LZH');
End;

(*------------------------------------------------------------------------*)
(*                         Procedure LzhScan                              *)
(*------------------------------------------------------------------------*)

                                      (*This is the routine that scans an *)
                                      (*LZH file and constructs the array *)
                                      (*for displaying the contents.      *)

Procedure lzhscan;
Begin
  init_az;
  Repeat
    BlockRead(az_file,lzhheader, sizeof(lzhheader), bytes_read);

                                   {I'm sure that when published specs   }
                                   {are available, we can make some more }
                                   {sense out of the "id" field.         }
    If lzhheader.id <> $6c2d
      Then format_error := True;

    FillChar(file_name, SizeOf(file_name), 32);

                                  {like in a zip file, we read the file  }
                                  {name in after the header structure.   }
                                  {this leaves out the crc, which oddly  }
                                  {comes after the filename.  if we want }
                                  {the crc, we'll have to read in another}
                                  {word.                                 }

    BlockRead(az_file, file_name, lzhheader.filename_length, bytes_read);

    timedate_w[1] := lzhheader.time;
    timedate_w[2] := lzhheader.date;
    convert_az_datetime;

    az_array[j].filename := file_name;

    az_array[j].size_o := lzhheader.size_o;
    az_array[j].size_c := lzhheader.size_c;

                                       {here we jump to the next header. }
                                       {the extra 2 bytes takes account  }
                                       {of the crc field which our       }
                                       {record skips over.               }

    az_pos:=az_pos+lzhheader.size_c
          +SizeOf(lzhheader) +lzhheader.filename_length+2;

    next_header;

  Until (lzhheader.reclen = 0)
    Or (format_error);

End;

(*-----------------------------------------------------------------------*)
(*                              Main Program                             *)
(*-----------------------------------------------------------------------*)
Var
  break_status : Boolean;

Begin
  GetCBreak(break_status);
  SetCBreak(True);

  If ParamCount > 0 Then

    Begin
      filename := ParamStr(1);
      Assign(az_file, ParamStr(1));
 
        Begin
          lzhscan;
          display_az_array;
        End;

      close(az_file);
    End

  Else usage;

SetCBreak(break_status)

End.
