{ LockTest - Lock4 test program by Richard Sadowsky }
{$I-} { <<<====== Very Important! }
program LockTest;

uses Lock4; { Use file locking routines }

var
  UnTypedFile  : File;
  TextFile : Text;
  Error : Word;
  S : String;
  FPos,Flen : LongInt;

begin
  FPos := 0;
  FLen := 30000;               { arbitrarily large number }
  WriteLn('DOS version ',DOS_Major,'.',DOS_Minor);
  Assign(UnTypedFile,'Lock4.Pas');       { Open Lock4.pas as untyped file }
  Reset(UnTypedFile,1);
  if IOResult <> 0 then begin
    WriteLn('Can not open LOCK4.PAS');
    Halt
  end;
  Error := LockFile(GetHandle(UnTypedFile),FPos,FLen);
                                                { Lock the entire file }
  WriteLn('Record locked, ErrorCode = ',Error); {show error code }
  assign(TextFile,'Lock4.Pas'); { now, let's open the file again, this time }
  Reset(TextFile);              { as a text file }
  ReadLn(TextFile,S);           { Try to read it }
  Error := IOResult;
  WriteLn('Attemp to read while locked, ErrorCode = ',Error); { show Error }
  Error := RetryFile(GetHandle(UnTypedFile),2,10);
  WriteLn('Retries set to 10, ErrorCode = ',Error);
  ReadLn(TextFile,S);           { Try to read it again}
  Error := IOResult;
  WriteLn('Attemp to read while locked, ErrorCode = ',Error); { show Error }
  Error := UnLockFile(GetHandle(UnTypedFile),FPos,FLen); { now unlock it }
  WriteLn('Record unlocked, ErrorCode = ',Error);
  ReadLn(TextFile,S);           { and try again }
  Error := IOResult;      { bet it worked!}
  WriteLn('Attemp to read after Unlock, ErrorCode = ',Error);
  Close(TextFile); {Close em up}
  Close(UnTypedFile);
end.
