{********************************************************************}
{* Lock4 - DOS 3 Record Locking for Turbo Pascal 4.0                *}
{* versin 1.0 11/16/87                                              *}
{* by Richard Sadowsky 74017,1670                                   *}
{* Released to the public domain                                    *}
{********************************************************************}
{$I-} { It is required to turn off abort on I/O error with $I- }
Unit Lock4;

Interface

uses DOS;

var
  DOS_Major,DOS_Minor : Word; { These words hold the DOS version   }
                              { They are initialized automatically }
                              { Whenever you include Lock4 in the  }
                              { list of units your program Uses    }

function HiLong(Long : LongInt) : Word;
{ This inline directive is similar to Turbo's Hi() function, except }
{ it returns the high word of a LongInt                             }
Inline(
  $5A/       {pop      dx    ; low word of long}
  $58);      {pop      ax    ; hi word of long}

function LowLong(Long : LongInt) : Word;
{ This inline directive is similar to Turbo's Lo() function, except }
{ it returns the Low word of a LongInt                              }
Inline(
  $5A/       {pop      dx    ; low word of long}
  $58/       {pop      ax    ; hi word of long}
  $89/$D0);  {mov      ax,dx ; return lo word as function result in Ax}

function GetHandle(var F : File) : Word;

function DosVer(var Minor : Word) : Word;

function LockFile(Handle : Word; FilePosition,FileLength : LongInt) : Word;

function UnLockFile(Handle : Word; FilePosition,FileLength : LongInt) : Word;

function RetryFile(Handle,Wait,Retry : Word) : Word;

implementation

function GetHandle(var F : File) : Word;
{ This function returns a file handle from any Turbo Pascal File type }
var
  Handle : Word absolute F;

begin
  GetHandle := Handle;
end;

function DosVer(var Minor : Word) : Word;
{ This function returns the DOS major version as it's result, and }
{ the minor version as a var parameter }
var
  Reg : Registers;

begin
  with Reg do begin
    Ax := $3000;
    MsDos(Reg);
    DosVer := Al;
    Minor  := Ah;
  end;
end;

function LockFile(Handle : Word; FilePosition,FileLength : LongInt) : Word;
{ This function uses DOS call 5Ch to lock all or part of a file.  }
{ The DOS error code is returned as the result.  The file takes a }
{ word for the file handle, followed by two LongInts, representing}
{ the file position (or offset), and the size in bytes to lock    }
{ starting at said offset. Make sure you Unlock any locks before  }
{ closing the file.  An error code of 1 means invalid DOS version.}
{ It may also mean that SHARE hasn't been run .                   }
{ See DOS Technical Reference or (Duncan's Advanced MS-DOS) for   }
{ info on error codes. }
var
  Reg : Registers;
  H,L,Minor : Word;

begin
  if DOS_Major < 3 then begin
    LockFile := 1;
    Exit;
  end;
  with Reg do begin
    Ax := $5C00; {DOS call 5Ch}
    Bx := Handle;
    Cx := HiLong(FilePosition);
    Dx := LowLong(FilePosition);
    Si := HiLong(FileLength);
    Di := LowLong(FileLength);
    MsDos(Reg);
    if ((Flags and 1) <> 0) then
      LockFile := Ax
    else
      LockFile := 0;
  end;
end;

function UnLockFile(Handle : Word; FilePosition,FileLength : LongInt) : Word;
{ Similar to LockFile, except uses DOS call 5Ch sunfunction 1  }
{ You must ensure that the offset and FileLength are identical }
{ to the ones used to lock the file                            }
var
  Reg : Registers;
  H,L,Minor : Word;

begin
  if DOS_Major < 3 then begin
    UnLockFile := 1;
    Exit;
  end;
  with Reg do begin
    Ax := $5C01; {DOS call 5Ch, subfunction 1}
    Bx := Handle;
    Cx := HiLong(FilePosition);
    Dx := LowLong(FilePosition);
    Si := HiLong(FileLength);
    Di := LowLong(FileLength);
    MsDos(Reg);
    if ((Flags and 1) <> 0) then
      UnLockFile := Ax
    else
      UnLockFile := 0;
  end;
end;

function RetryFile(Handle,Wait,Retry : Word) : Word;
{ This function sets the number of times DOS will retry before returning }
{ an i/o error.  It also sets the time dalay between retries.            }
var
  Reg : Registers;

begin
  if DOS_Major < 3 then begin
    RetryFile := 1;
    Exit;
  end;
  with Reg do begin
    Ax := $440B;
    Bx := Handle;
    Cx := Wait;
    Dx := Retry;
    MsDos(Reg);
    if ((Flags and 1) <> 0) then
      RetryFile := Ax
    else
      RetryFile := 0;
  end;
end;

begin { initialization code }
  DOS_Major := DosVer(DOS_Minor)
end.