unit jmstring ;
interface
uses dos, crt ;

const
   space = ' ' ;
   radixPoint = '.' ;

type
   charSet        = set of Char ;

var
   UpperAlphas,
   LowerAlphas,
   Alphas,
   reals,
   Numerics       : charSet ;

function compact    (s:string):string ;
function toUpper    (s:string):string ;
function toLower    (s:string):string ;
function isType     (s:string;c:charset):boolean ;

implementation

function compact (s:string):string ;
(* --------------------------------- *)
(* removes multiple spaces from s    *)
(* --------------------------------- *)
var l,i : byte ;
begin
   for i := 1 to length (s) do
      while ((s[i]=space) and (s[i+1]=space)) do
         delete (s,i+1,1) ;
   compact := s
end ; (* function compact *)

function toUpper (s:string):string ;
(* --------------------------------- *)
(* converts alphas in s to uppercase *)
(* --------------------------------- *)
var l,i : byte ;
begin
   l := length (s) ;
   for i := 1 to l do
      s[i]:=upCase(s[i]) ;
   toUpper := s
end ; (* function toUpper *)

function toLower (s:string):string ;
(* --------------------------------- *)
(* converts alphas in s to lowercase *)
(* --------------------------------- *)
var l,i : byte ;
begin
   l := length (s) ;
   for i := 1 to l do
      if (s[i] in upperAlphas) then s[i]:=chr(ord(s[i])+32) ;
   toLower := s
end ; (* function toLower *)

function isType (s:string;c:charset):boolean ;
(* --------------------------------- *)
(* returns true if all of s is in c  *)
(* --------------------------------- *)
var temp : boolean ;
    l,i  : byte ;
begin
   l := length (s) ;
   temp := true ;
   for i := 1 to l do
      temp := temp and (s[i] in c) ;
   isType := temp
end ; (* function isType *)

begin
   upperAlphas := ['A'..'Z'] ;
   lowerAlphas := ['a'..'z'] ;
   numerics    := ['0'..'9'] ;
   reals       := numerics + [radixPoint] ;
   Alphas      := upperAlphas + lowerAlphas
end.

