UNIT EditObj; {  Object_Line_Editor  }

INTERFACE

USES Crt, KeyBd;

TYPE
  LineEdit = OBJECT
    Pos, XPos, YPos : Integer;
    EdLine : String;
    PROCEDURE InitEdit( X, Y: Integer; LineIn: String );
    FUNCTION  GetLine: String;
  END;

VAR
   Kbd: KeyBoard;   {<<<========== Global definition of OBJECT}

{***************************************************************}
                        IMPLEMENTATION
{***************************************************************}

{-------------------------------------------------
- Name   : InitEdit                              -
- Purpose: Set up editor, display line onscreen  -
-------------------------------------------------}

PROCEDURE LineEdit.InitEdit;
  BEGIN
    EdLine := LineIn;
    Pos  := Ord( LineIn[0] ) + 1;
    XPos := X;
    YPos := Y;
    GotoXY( X, Y );
    Write( LineIn );
  END;

{-------------------------------------------------
- Name   : GetLine                               -
- Purpose: Process keying from user              -
-          Maximum 80 characters accepted        -
-------------------------------------------------}

FUNCTION  LineEdit.GetLine;
  VAR
    KeyFlags : Byte;
    Ch: Char;
    FunctKey, Finish: Boolean;
  BEGIN
    Finish := FALSE;
    REPEAT
      IF Kbd.GetKey( KeyFlags, FunctKey, Ch ) THEN BEGIN
        IF FunctKey THEN
          CASE Ch OF
{ HOME   }  #$47: Pos := 1;
{ END    }  #$4F: Pos := Ord( EdLine[0] ) + 1;
{ RIGHT  }  #$4D: BEGIN
                    IF Pos < 80 THEN Inc( Pos );
                    IF Pos > Ord( EdLine[0] ) THEN
                      Insert( ' ', EdLine, Pos );
                    END;
{ LEFT   }  #$4B: IF Pos > 1  THEN Dec( Pos );
{ DELETE }  #$53: IF Pos <= Ord( EdLine[0] ) THEN
                     Delete( EdLine, Pos, 1 );
            END {CASE Ch}
          ELSE {IF}
            CASE Ch OF
{ BS }        #$08: IF Pos > 1 THEN BEGIN
                      Delete( EdLine, Pos-1, 1 );
                      Dec( Pos );
                      END;
{ ENTER }     #$0D: Finish := TRUE;
              ELSE BEGIN
                IF( ( KeyFlags AND $80 ) <> $80 )
                   THEN Insert( Ch, EdLine, Pos )
                   ELSE EdLine[Pos] := Ch;
                IF Pos > Ord( EdLine[0] ) THEN
                   EdLine[0] := Chr( Pos );
                IF Pos < 80 THEN Inc( Pos );
                END     {CASE CH ELSE}
              END;    {CASE Ch}
        GotoXY( XPos, YPos );
        Write( EdLine, ' ' );
        GotoXY( XPos+Pos-1, YPos );
        END;  {IF Kbd.GetKey}
      UNTIL Finish;
      GetLine := EdLine;
    END;

END.
