PROGRAM TestWrit; {$R-}

{***************************************************************
**   PROGRAM: TestWrit.PAS                                    **
**   PURPOSE: Write records to dBASE III+/IV DBF files        **
****************************************************************}

{-------------------------------------------------
- Define variables                               -
-------------------------------------------------}


USES Crt, WriteDBF;

VAR
   DFile      : DbfFile;
   ActionHdr  : Byte;
   ActionFile : Boolean;
   Response   : Char;
   ActionRec  : Boolean;
   BufferPtr  : CharPtr;
   RereadHdr  : Byte;

PROCEDURE Beep;
  BEGIN
    Sound(1000);Delay(500);NoSound
  END;

{-------------------------------------------------
-          Main program                          -
-------------------------------------------------}

BEGIN
  ClrScr;
  DFile := DbfOpen('PLANETS.DBF');
  WriteLn;
  ActionHdr := DbfReadHdr(DFile);
  CASE ActionHdr OF
  1 : BEGIN
        Beep;
        WriteLn('Not a dBASE III+ or IV file.')
      END;
  3 : BEGIN
        Beep;
        WriteLn('Error reading dBASE file.')
      END
  ELSE BEGIN
    DbfDispHdr(DFile);
    Pause;
    ActionFile := DbfReadStru(DFile);
    CASE ActionFile OF
    TRUE : BEGIN
      ClrScr;

      REPEAT

        Write('Append record to file (Y/N)? ');
        ReadLn(Response);

        IF UpCase(Response) = 'Y' THEN BEGIN

          BufferPtr := DbfInputRec(DFile);

          IF BufferPtr <> NIL THEN BEGIN
            DbfWriteRec(-1,DFile,BufferPtr);
            RereadHdr := DbfReadHdr(DFile);
            DbfDispHdr(DFile);
            Pause
            END
        END
        UNTIL UpCase(Response) <> 'Y'

      END;
    FALSE : BEGIN
      Beep;
      WriteLn('Field information error')
      END
    END    {Case ActionFile}
  END;     {Case ActionHdr}
  ActionFile := DbfClose(DFile);
  END
END.
