PROGRAM LL_Demo;

USES LinkList;

{ Turbo Pascal Linked List Object Example }

TYPE

  DataValuePtr = ^DataValue;

  DataValue = OBJECT (NodeValue)
    Value : Real;
    CONSTRUCTOR Init (A_Value : Real);
    FUNCTION TheValue : Real;
  END;

  DataList = OBJECT (NodeList)
    FUNCTION CurrentValue (Ptr : NodePtr) : Real;
    PROCEDURE SetCurrentValue (Ptr : NodePtr; Value : Real);
  END;

VAR
    Itr : NodePtr;
    TestLink : DataList;

{------ Unique methods to create for your linked list type -----}

CONSTRUCTOR DataValue.Init (A_Value : Real);
BEGIN
    Value := A_Value;
END;

FUNCTION DataValue.TheValue : Real;
BEGIN
  TheValue := Value;
END;

FUNCTION DataList.CurrentValue (Ptr : NodePtr) : Real;
BEGIN
  CurrentValue := DataValuePtr (Ptr^.Retrieve)^.TheValue;
END;

PROCEDURE DataList.SetCurrentValue (Ptr : NodePtr; Value : Real);
BEGIN
  DataValuePtr (Ptr^.Retrieve)^.Value := Value;
END;


BEGIN
  TestLink.Init;        {Create the list then add 5 values to it}

  TestLink.Add (New (DataValuePtr, Init (1.0)));
  TestLink.Add (New (DataValuePtr, Init (2.0)));
  TestLink.Add (New (DataValuePtr, Init (3.0)));
  TestLink.Add (New (DataValuePtr, Init (4.0)));
  TestLink.Add (New (DataValuePtr, Init (5.0)));

  TestLink.StartIterator (Itr);      {Display the list on screen}
  WHILE NOT TestLink.AtEndOfList (Itr) DO BEGIN
    Write (TestLink.CurrentValue (Itr) : 5 : 1);
    TestLink.NextValue (Itr);
    END;
  WriteLn;

  TestLink.StartIterator (Itr);  {Change some values in the list}
  TestLink.SetCurrentValue (Itr, 0.0);
  TestLink.NextValue (Itr);
  TestLink.SetCurrentValue (Itr, -1.0);

  TestLink.StartIterator (Itr);       {Redisplay the list values}
  WHILE NOT TestLink.AtEndOfList (Itr) DO BEGIN
    Write (TestLink.CurrentValue (Itr) : 5 : 1);
    TestLink.NextValue (Itr);
  END;
  WriteLn;
  ReadLn;
END.
