UNIT LinkList;

{-------------------------------------------------
- Name   : LinkList                              -
- Purpose: Generic linked list object            -
-------------------------------------------------}

{***************************************************************}
                          INTERFACE
{***************************************************************}

TYPE

    { Generic Linked List Handler Definition }

  NodeValuePtr = ^NodeValue;

  NodeValue = OBJECT
    CONSTRUCTOR Init;
    DESTRUCTOR  Done; VIRTUAL;
  END;

  NodePtr = ^Node;
  Node = RECORD
    Retrieve : NodeValuePtr;
    Next     : NodePtr;
  END;


    { Specific Linked List Handler Definition }

  NodeListPtr = ^NodeList;

  NodeList = OBJECT
    Items : NodePtr;
    CONSTRUCTOR Init;
    DESTRUCTOR Done; VIRTUAL;
    PROCEDURE Add (A_Value : NodeValuePtr);

    (* Iterator Functions *)

    PROCEDURE StartIterator (VAR Ptr : NodePtr);
    PROCEDURE NextValue (VAR Ptr : NodePtr);
    FUNCTION AtEndOfList (Ptr : NodePtr) : Boolean;
  END;

{***************************************************************}
                         IMPLEMENTATION
{***************************************************************}


CONSTRUCTOR NodeValue.Init;
BEGIN
END;

DESTRUCTOR NodeValue.Done;
BEGIN
END;

CONSTRUCTOR NodeList.Init;
BEGIN
  Items := NIL;
END;

DESTRUCTOR NodeList.Done;
    VAR
         Temp : NodePtr;
BEGIN
    WHILE Items <> NIL DO
    BEGIN
         Temp := Items;
         IF Temp^.Retrieve <> NIL THEN
              Dispose (Temp^.Retrieve, Done);
         Items := Items^.Next;
         Dispose (Temp);
    END;
END;

PROCEDURE NodeList.Add (A_Value : NodeValuePtr);
    VAR
         Cell : NodePtr;
         Temp : NodePtr;
BEGIN
    (* Go TO the END OF the linked list. *)
    Cell := Items;
    IF Cell <> NIL THEN
         WHILE Cell^.Next <> NIL DO
              Cell := Cell^.Next;

    New (Temp);
    Temp^.Retrieve := A_Value;
    Temp^.Next := NIL;
    IF Items = NIL
    THEN
         Items := Temp
    ELSE
         Cell^.Next := Temp;
END;

PROCEDURE NodeList.StartIterator (VAR Ptr : NodePtr);
BEGIN
    Ptr := Items;
END;

PROCEDURE NodeList.NextValue (VAR Ptr : NodePtr);
BEGIN
    IF Ptr <> NIL THEN
    Ptr := Ptr^.Next;
END;

FUNCTION NodeList.AtEndOfList (Ptr : NodePtr) : Boolean;
BEGIN
  AtEndOfList := (Ptr = NIL);
END;

END.
