UNIT FCUnit;

INTERFACE

USES Crt;

TYPE
  Action  = (Input, Output);
  DataBlk = ARRAY[1..512] OF Byte;
  FileObj = OBJECT
    Fp : FILE;
    CONSTRUCTOR OpenFile(FileName: String; FileAction: Action);
    PROCEDURE ReadBlock(VAR Fb: DataBlk; VAR Size: Integer);
    PROCEDURE WriteBlock(Fb: DataBlk;	Size: Integer);
    DESTRUCTOR CloseFile;
  END;

IMPLEMENTATION

CONSTRUCTOR FileObj.OpenFile;
BEGIN
  Assign(Fp, FileName);
  CASE FileAction OF
    Input: BEGIN
      {$I-}Reset(Fp, 1);{$I+}
      IF IOResult <> 0 THEN BEGIN
        WriteLn(FileName, ' not found!');
	     Halt(1);
	     END;
      WriteLn(FileName,' opened for read ... ');
      END;
    Output: BEGIN
      Rewrite(Fp, 1);
      WriteLn(FileName,' opened for write ... ');
      END;
    END; {CASE}
END;

DESTRUCTOR FileObj.CloseFile;
BEGIN
   Close(Fp);
   WriteLn('File closed ...');
END;

PROCEDURE FileObj.ReadBlock;
BEGIN
   BlockRead(Fp, Fb, SizeOf(Fb), Size);
   WriteLn('Reading ', Size, ' bytes ... ');
END;

PROCEDURE FileObj.WriteBlock;
BEGIN
   BlockWrite(Fp, Fb, Size);
   WriteLn('Writing ', Size, ' bytes ... ');
END;

END.
