PROGRAM EnDeCryp;

USES Crt,FCUnit,Printer;

TYPE
  Code = (Encrypt,Decrypt);
  XlateType = ARRAY[0..255] OF Byte;
  EncryptObj = OBJECT(FileObj)
    XlateTable : XlateType;
    PROCEDURE SetCoding(CodeAction: Code);
    PROCEDURE EncryptDecryptBlock(VAR Fb: DataBlk; Size:Integer);
    END;

CONST
  EncryptedMarker : String[4] = #199+#182+#182+#199;

PROCEDURE EncryptObj.SetCoding;

VAR
  Size,Ctr  : Integer;
  IdBytes   : String[4];
  TempTable : XlateType;
  R         : Byte;

BEGIN
  CASE CodeAction OF
    Encrypt : BEGIN
      Randomize; {Causes program to create a new table each time}
      Ctr := 0;                       {No table entries made yet}
      FillChar(TempTable,SizeOf(TempTable),0); {Initialize table}
      WHILE Ctr < 256 DO BEGIN                 {Fill table      }
        R := Random(256);                      {Get new number  }
        IF (TempTable[R] <> 1) THEN BEGIN      {Already set?    }
          TempTable[R] := 1;                   {Set to filled   }
          XlateTable[Ctr] := R;                {Store Rnd number}
          Inc(Ctr)                             {One more down   }
          END {IF}
        END;   {WHILE}
      BlockWrite(Fp, EncryptedMarker, SizeOf(EncryptedMarker));
      BlockWrite(Fp, XlateTable, SizeOf(XlateTable))
      END;    {Encrypt}

    Decrypt : BEGIN
      BlockRead(Fp, IdBytes, SizeOf(IdBytes), Size);  {Make sure}
      IF (Size <> SizeOf(IdBytes)) OR         {file is encrypted}
         (IdBytes <> EncryptedMarker) THEN BEGIN
        WriteLn('File not encrypted');        {before decrypting}
        Halt(1)
        END;

      BlockRead(Fp,XlateTable,SizeOf(XlateTable),Size); {Get all}
      IF Size <> SizeOf(XlateTable) THEN BEGIN         {of table}
        WriteLn('Bad or short encryption table found');
        Halt(2)
        END;

      FOR Ctr := 0 TO 255 DO          {Load array for decoding}
        TempTable[XlateTable[Ctr]] := Ctr;
      Move(TempTable[0],XlateTable[0],SizeOf(TempTable));
      END
    END
  END;

{---------------------------------------------------------------}

PROCEDURE EncryptObj.EncryptDecryptBlock;
VAR
  I : Integer;
BEGIN
  FOR I := 1 TO Size DO
    Fb[I] := XlateTable[Fb[I]]
  END;

{---------------------------------------------------------------}

VAR
   InFile, OutFile : EncryptObj;
   Data            : DataBlk;
   Size            : Integer;
   Option          : String[1];

BEGIN
  ClrScr;
  IF ParamCount <> 3 then begin
    WriteLn('EDC format --------------------------');
    WriteLn;
    WriteLn('   EDC {E|D} FileNameIn FileNameOut');
    WriteLn('          Decrypt ');
    WriteLn('         Encrypt ');
    Writeln;
    halt(1)
    end;

  IF ParamStr(2) = ParamStr(3) then begin
    WriteLn('Input and output filenames must be different.');
    Halt(1)
    end;

  Option := ParamStr(1);
  Option := UpCase(Option[1]);

  CASE Option[1] OF
    'E' : BEGIN
          InFile.OpenFile(ParamStr(2), Input);
          OutFile.OpenFile(ParamStr(3), Output);
          OutFile.SetCoding(Encrypt)
          END;
    'D' : BEGIN
          InFile.OpenFile(ParamStr(2), Input);
          InFile.SetCoding(Decrypt);
          OutFile.OpenFile(ParamStr(3), Output)
          END;
    ELSE BEGIN
      WriteLn('1st parameter must be an E or D character');
      WriteLn;
      Halt(1)
      end
   END;

   REPEAT
     InFile.ReadBlock(Data, Size);
     IF Option = 'E' THEN
       OutFile.EncryptDecryptBlock(Data,Size)
     ELSE
       InFile.EncryptDecryptBlock(Data, Size);
     OutFile.WriteBlock(Data, Size)
   UNTIL Size <> SizeOf(DataBlk);

   InFile.CloseFile;
   OutFile.CloseFile;
END.
